<?php
/**
 * AnalyticsQueryPredicate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsQueryPredicate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsQueryPredicate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsQueryPredicate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'dimension' => 'string',
        'property_type' => 'string',
        'property' => 'string',
        'metric' => 'string',
        'operator' => 'string',
        'value' => 'string',
        'range' => '\PureCloudSDK\NumericRange'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'dimension' => 'dimension',
        'property_type' => 'propertyType',
        'property' => 'property',
        'metric' => 'metric',
        'operator' => 'operator',
        'value' => 'value',
        'range' => 'range'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'dimension' => 'setDimension',
        'property_type' => 'setPropertyType',
        'property' => 'setProperty',
        'metric' => 'setMetric',
        'operator' => 'setOperator',
        'value' => 'setValue',
        'range' => 'setRange'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'dimension' => 'getDimension',
        'property_type' => 'getPropertyType',
        'property' => 'getProperty',
        'metric' => 'getMetric',
        'operator' => 'getOperator',
        'value' => 'getValue',
        'range' => 'getRange'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_DIMENSION = 'dimension';
    const TYPE_PROPERTY = 'property';
    const TYPE_METRIC = 'metric';
    const DIMENSION_CONVERSATION_ID = 'conversationId';
    const DIMENSION_SESSION_ID = 'sessionId';
    const DIMENSION_MEDIA_TYPE = 'mediaType';
    const DIMENSION_QUEUE_ID = 'queueId';
    const DIMENSION_USER_ID = 'userId';
    const DIMENSION_PARTICIPANT_ID = 'participantId';
    const DIMENSION_PARTICIPANT_NAME = 'participantName';
    const DIMENSION_DIRECTION = 'direction';
    const DIMENSION_WRAP_UP_CODE = 'wrapUpCode';
    const DIMENSION_WRAP_UP_NOTE = 'wrapUpNote';
    const DIMENSION_INTERACTION_TYPE = 'interactionType';
    const DIMENSION_REQUESTED_ROUTING_SKILL_ID = 'requestedRoutingSkillId';
    const DIMENSION_REQUESTED_LANGUAGE_ID = 'requestedLanguageId';
    const DIMENSION_PURPOSE = 'purpose';
    const DIMENSION_PARTICIPANT_TYPE = 'participantType';
    const DIMENSION_SEGMENT_TYPE = 'segmentType';
    const DIMENSION_DISCONNECT_TYPE = 'disconnectType';
    const DIMENSION_ERROR_CODE = 'errorCode';
    const DIMENSION_CONVERSATION_END = 'conversationEnd';
    const DIMENSION_EXTERNAL_CONTACT_ID = 'externalContactId';
    const DIMENSION_EXTERNAL_ORGANIZATION_ID = 'externalOrganizationId';
    const DIMENSION_STATION_ID = 'stationId';
    const DIMENSION_EDGE_ID = 'edgeId';
    const DIMENSION_DNIS = 'dnis';
    const DIMENSION_ANI = 'ani';
    const DIMENSION_OUTBOUND_CAMPAIGN_ID = 'outboundCampaignId';
    const DIMENSION_OUTBOUND_CONTACT_ID = 'outboundContactId';
    const DIMENSION_OUTBOUND_CONTACT_LIST_ID = 'outboundContactListId';
    const DIMENSION_MONITORED_PARTICIPANT_ID = 'monitoredParticipantId';
    const DIMENSION_SOURCE_SESSION_ID = 'sourceSessionId';
    const DIMENSION_DESTINATION_SESSION_ID = 'destinationSessionId';
    const DIMENSION_SOURCE_CONVERSATION_ID = 'sourceConversationId';
    const DIMENSION_DESTINATION_CONVERSATION_ID = 'destinationConversationId';
    const DIMENSION_REMOTE_NAME_DISPLAYABLE = 'remoteNameDisplayable';
    const DIMENSION_SIP_RESPONSE_CODE = 'sipResponseCode';
    const DIMENSION_Q850_RESPONSE_CODE = 'q850ResponseCode';
    const DIMENSION_CONFERENCE = 'conference';
    const DIMENSION_GROUP_ID = 'groupId';
    const DIMENSION_ROOM_ID = 'roomId';
    const DIMENSION_ADDRESS_FROM = 'addressFrom';
    const DIMENSION_ADDRESS_TO = 'addressTo';
    const DIMENSION_SUBJECT = 'subject';
    const DIMENSION_PEER_ID = 'peerId';
    const DIMENSION_SCRIPT_ID = 'scriptId';
    const DIMENSION_EVALUATION_ID = 'evaluationId';
    const DIMENSION_EVALUATOR_ID = 'evaluatorId';
    const DIMENSION_CONTEXT_ID = 'contextId';
    const DIMENSION_FORM_ID = 'formId';
    const DIMENSION_FORM_NAME = 'formName';
    const DIMENSION_EVENT_TIME = 'eventTime';
    const DIMENSION_SYSTEM_PRESENCE = 'systemPresence';
    const DIMENSION_ORGANIZATION_PRESENCE_ID = 'organizationPresenceId';
    const DIMENSION_ROUTING_STATUS = 'routingStatus';
    const PROPERTY_TYPE_BOOL = 'bool';
    const PROPERTY_TYPE_INTEGER = 'integer';
    const PROPERTY_TYPE_REAL = 'real';
    const PROPERTY_TYPE_DATE = 'date';
    const PROPERTY_TYPE_STRING = 'string';
    const PROPERTY_TYPE_UUID = 'uuid';
    const METRIC_T_SEGMENT_DURATION = 'tSegmentDuration';
    const METRIC_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    const METRIC_O_TOTAL_SCORE = 'oTotalScore';
    const METRIC_N_EVALUATIONS = 'nEvaluations';
    const METRIC_T_ABANDON = 'tAbandon';
    const METRIC_T_IVR = 'tIvr';
    const METRIC_T_ANSWERED = 'tAnswered';
    const METRIC_T_ACD = 'tAcd';
    const METRIC_T_TALK = 'tTalk';
    const METRIC_T_HELD = 'tHeld';
    const METRIC_T_TALK_COMPLETE = 'tTalkComplete';
    const METRIC_T_HELD_COMPLETE = 'tHeldComplete';
    const METRIC_T_ACW = 'tAcw';
    const METRIC_T_HANDLE = 'tHandle';
    const METRIC_T_WAIT = 'tWait';
    const METRIC_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    const METRIC_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    const METRIC_T_SYSTEM_PRESENCE = 'tSystemPresence';
    const METRIC_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    const METRIC_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    const METRIC_N_OFFERED = 'nOffered';
    const METRIC_N_OVER_SLA = 'nOverSla';
    const METRIC_N_TRANSFERRED = 'nTransferred';
    const METRIC_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    const METRIC_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    const METRIC_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    const METRIC_N_ERROR = 'nError';
    const METRIC_O_SERVICE_TARGET = 'oServiceTarget';
    const METRIC_O_SERVICE_LEVEL = 'oServiceLevel';
    const METRIC_T_ACTIVE = 'tActive';
    const METRIC_T_INACTIVE = 'tInactive';
    const METRIC_O_ACTIVE_USERS = 'oActiveUsers';
    const METRIC_O_MEMBER_USERS = 'oMemberUsers';
    const METRIC_O_ACTIVE_QUEUES = 'oActiveQueues';
    const METRIC_O_MEMBER_QUEUES = 'oMemberQueues';
    const METRIC_O_INTERACTING = 'oInteracting';
    const METRIC_O_WAITING = 'oWaiting';
    const METRIC_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    const METRIC_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    const OPERATOR_MATCHES = 'matches';
    const OPERATOR_EXISTS = 'exists';
    const OPERATOR_NOT_EXISTS = 'notExists';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_DIMENSION,
            self::TYPE_PROPERTY,
            self::TYPE_METRIC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDimensionAllowableValues()
    {
        return [
            self::DIMENSION_CONVERSATION_ID,
            self::DIMENSION_SESSION_ID,
            self::DIMENSION_MEDIA_TYPE,
            self::DIMENSION_QUEUE_ID,
            self::DIMENSION_USER_ID,
            self::DIMENSION_PARTICIPANT_ID,
            self::DIMENSION_PARTICIPANT_NAME,
            self::DIMENSION_DIRECTION,
            self::DIMENSION_WRAP_UP_CODE,
            self::DIMENSION_WRAP_UP_NOTE,
            self::DIMENSION_INTERACTION_TYPE,
            self::DIMENSION_REQUESTED_ROUTING_SKILL_ID,
            self::DIMENSION_REQUESTED_LANGUAGE_ID,
            self::DIMENSION_PURPOSE,
            self::DIMENSION_PARTICIPANT_TYPE,
            self::DIMENSION_SEGMENT_TYPE,
            self::DIMENSION_DISCONNECT_TYPE,
            self::DIMENSION_ERROR_CODE,
            self::DIMENSION_CONVERSATION_END,
            self::DIMENSION_EXTERNAL_CONTACT_ID,
            self::DIMENSION_EXTERNAL_ORGANIZATION_ID,
            self::DIMENSION_STATION_ID,
            self::DIMENSION_EDGE_ID,
            self::DIMENSION_DNIS,
            self::DIMENSION_ANI,
            self::DIMENSION_OUTBOUND_CAMPAIGN_ID,
            self::DIMENSION_OUTBOUND_CONTACT_ID,
            self::DIMENSION_OUTBOUND_CONTACT_LIST_ID,
            self::DIMENSION_MONITORED_PARTICIPANT_ID,
            self::DIMENSION_SOURCE_SESSION_ID,
            self::DIMENSION_DESTINATION_SESSION_ID,
            self::DIMENSION_SOURCE_CONVERSATION_ID,
            self::DIMENSION_DESTINATION_CONVERSATION_ID,
            self::DIMENSION_REMOTE_NAME_DISPLAYABLE,
            self::DIMENSION_SIP_RESPONSE_CODE,
            self::DIMENSION_Q850_RESPONSE_CODE,
            self::DIMENSION_CONFERENCE,
            self::DIMENSION_GROUP_ID,
            self::DIMENSION_ROOM_ID,
            self::DIMENSION_ADDRESS_FROM,
            self::DIMENSION_ADDRESS_TO,
            self::DIMENSION_SUBJECT,
            self::DIMENSION_PEER_ID,
            self::DIMENSION_SCRIPT_ID,
            self::DIMENSION_EVALUATION_ID,
            self::DIMENSION_EVALUATOR_ID,
            self::DIMENSION_CONTEXT_ID,
            self::DIMENSION_FORM_ID,
            self::DIMENSION_FORM_NAME,
            self::DIMENSION_EVENT_TIME,
            self::DIMENSION_SYSTEM_PRESENCE,
            self::DIMENSION_ORGANIZATION_PRESENCE_ID,
            self::DIMENSION_ROUTING_STATUS,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPropertyTypeAllowableValues()
    {
        return [
            self::PROPERTY_TYPE_BOOL,
            self::PROPERTY_TYPE_INTEGER,
            self::PROPERTY_TYPE_REAL,
            self::PROPERTY_TYPE_DATE,
            self::PROPERTY_TYPE_STRING,
            self::PROPERTY_TYPE_UUID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_SEGMENT_DURATION,
            self::METRIC_O_TOTAL_CRITICAL_SCORE,
            self::METRIC_O_TOTAL_SCORE,
            self::METRIC_N_EVALUATIONS,
            self::METRIC_T_ABANDON,
            self::METRIC_T_IVR,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_ACD,
            self::METRIC_T_TALK,
            self::METRIC_T_HELD,
            self::METRIC_T_TALK_COMPLETE,
            self::METRIC_T_HELD_COMPLETE,
            self::METRIC_T_ACW,
            self::METRIC_T_HANDLE,
            self::METRIC_T_WAIT,
            self::METRIC_T_AGENT_ROUTING_STATUS,
            self::METRIC_T_ORGANIZATION_PRESENCE,
            self::METRIC_T_SYSTEM_PRESENCE,
            self::METRIC_T_USER_RESPONSE_TIME,
            self::METRIC_T_AGENT_RESPONSE_TIME,
            self::METRIC_N_OFFERED,
            self::METRIC_N_OVER_SLA,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_N_OUTBOUND_ATTEMPTED,
            self::METRIC_N_OUTBOUND_CONNECTED,
            self::METRIC_N_OUTBOUND_ABANDONED,
            self::METRIC_N_ERROR,
            self::METRIC_O_SERVICE_TARGET,
            self::METRIC_O_SERVICE_LEVEL,
            self::METRIC_T_ACTIVE,
            self::METRIC_T_INACTIVE,
            self::METRIC_O_ACTIVE_USERS,
            self::METRIC_O_MEMBER_USERS,
            self::METRIC_O_ACTIVE_QUEUES,
            self::METRIC_O_MEMBER_QUEUES,
            self::METRIC_O_INTERACTING,
            self::METRIC_O_WAITING,
            self::METRIC_O_ON_QUEUE_USERS,
            self::METRIC_O_OFF_QUEUE_USERS,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_MATCHES,
            self::OPERATOR_EXISTS,
            self::OPERATOR_NOT_EXISTS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['dimension'] = isset($data['dimension']) ? $data['dimension'] : null;
        $this->container['property_type'] = isset($data['property_type']) ? $data['property_type'] : null;
        $this->container['property'] = isset($data['property']) ? $data['property'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['range'] = isset($data['range']) ? $data['range'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("conversationId", "sessionId", "mediaType", "queueId", "userId", "participantId", "participantName", "direction", "wrapUpCode", "wrapUpNote", "interactionType", "requestedRoutingSkillId", "requestedLanguageId", "purpose", "participantType", "segmentType", "disconnectType", "errorCode", "conversationEnd", "externalContactId", "externalOrganizationId", "stationId", "edgeId", "dnis", "ani", "outboundCampaignId", "outboundContactId", "outboundContactListId", "monitoredParticipantId", "sourceSessionId", "destinationSessionId", "sourceConversationId", "destinationConversationId", "remoteNameDisplayable", "sipResponseCode", "q850ResponseCode", "conference", "groupId", "roomId", "addressFrom", "addressTo", "subject", "peerId", "scriptId", "evaluationId", "evaluatorId", "contextId", "formId", "formName", "eventTime", "systemPresence", "organizationPresenceId", "routingStatus");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dimension', must be one of #{allowed_values}.";
        }

        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['property_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'property_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("tSegmentDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "nOffered", "nOverSla", "nTransferred", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("conversationId", "sessionId", "mediaType", "queueId", "userId", "participantId", "participantName", "direction", "wrapUpCode", "wrapUpNote", "interactionType", "requestedRoutingSkillId", "requestedLanguageId", "purpose", "participantType", "segmentType", "disconnectType", "errorCode", "conversationEnd", "externalContactId", "externalOrganizationId", "stationId", "edgeId", "dnis", "ani", "outboundCampaignId", "outboundContactId", "outboundContactListId", "monitoredParticipantId", "sourceSessionId", "destinationSessionId", "sourceConversationId", "destinationConversationId", "remoteNameDisplayable", "sipResponseCode", "q850ResponseCode", "conference", "groupId", "roomId", "addressFrom", "addressTo", "subject", "peerId", "scriptId", "evaluationId", "evaluatorId", "contextId", "formId", "formName", "eventTime", "systemPresence", "organizationPresenceId", "routingStatus");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("bool", "integer", "real", "date", "string", "uuid");
        if (!in_array($this->container['property_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("tSegmentDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "nOffered", "nOverSla", "nTransferred", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Optional type, can usually be inferred
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('dimension', 'property', 'metric');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'dimension', 'property', 'metric'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets dimension
     * @return string
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     * @param string $dimension Left hand side for dimension predicates
     * @return $this
     */
    public function setDimension($dimension)
    {
        $allowed_values = array('conversationId', 'sessionId', 'mediaType', 'queueId', 'userId', 'participantId', 'participantName', 'direction', 'wrapUpCode', 'wrapUpNote', 'interactionType', 'requestedRoutingSkillId', 'requestedLanguageId', 'purpose', 'participantType', 'segmentType', 'disconnectType', 'errorCode', 'conversationEnd', 'externalContactId', 'externalOrganizationId', 'stationId', 'edgeId', 'dnis', 'ani', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'monitoredParticipantId', 'sourceSessionId', 'destinationSessionId', 'sourceConversationId', 'destinationConversationId', 'remoteNameDisplayable', 'sipResponseCode', 'q850ResponseCode', 'conference', 'groupId', 'roomId', 'addressFrom', 'addressTo', 'subject', 'peerId', 'scriptId', 'evaluationId', 'evaluatorId', 'contextId', 'formId', 'formName', 'eventTime', 'systemPresence', 'organizationPresenceId', 'routingStatus');
        if (!in_array($dimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dimension', must be one of 'conversationId', 'sessionId', 'mediaType', 'queueId', 'userId', 'participantId', 'participantName', 'direction', 'wrapUpCode', 'wrapUpNote', 'interactionType', 'requestedRoutingSkillId', 'requestedLanguageId', 'purpose', 'participantType', 'segmentType', 'disconnectType', 'errorCode', 'conversationEnd', 'externalContactId', 'externalOrganizationId', 'stationId', 'edgeId', 'dnis', 'ani', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'monitoredParticipantId', 'sourceSessionId', 'destinationSessionId', 'sourceConversationId', 'destinationConversationId', 'remoteNameDisplayable', 'sipResponseCode', 'q850ResponseCode', 'conference', 'groupId', 'roomId', 'addressFrom', 'addressTo', 'subject', 'peerId', 'scriptId', 'evaluationId', 'evaluatorId', 'contextId', 'formId', 'formName', 'eventTime', 'systemPresence', 'organizationPresenceId', 'routingStatus'");
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets property_type
     * @return string
     */
    public function getPropertyType()
    {
        return $this->container['property_type'];
    }

    /**
     * Sets property_type
     * @param string $property_type Left hand side for property predicates
     * @return $this
     */
    public function setPropertyType($property_type)
    {
        $allowed_values = array('bool', 'integer', 'real', 'date', 'string', 'uuid');
        if (!in_array($property_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'property_type', must be one of 'bool', 'integer', 'real', 'date', 'string', 'uuid'");
        }
        $this->container['property_type'] = $property_type;

        return $this;
    }

    /**
     * Gets property
     * @return string
     */
    public function getProperty()
    {
        return $this->container['property'];
    }

    /**
     * Sets property
     * @param string $property Left hand side for property predicates
     * @return $this
     */
    public function setProperty($property)
    {
        $this->container['property'] = $property;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric Left hand side for metric predicates
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tSegmentDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'nOffered', 'nOverSla', 'nTransferred', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tSegmentDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'nOffered', 'nOverSla', 'nTransferred', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator Optional operator, default is matches
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('matches', 'exists', 'notExists');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'matches', 'exists', 'notExists'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value Right hand side for dimension, property, or metric predicates
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets range
     * @return \PureCloudSDK\NumericRange
     */
    public function getRange()
    {
        return $this->container['range'];
    }

    /**
     * Sets range
     * @param \PureCloudSDK\NumericRange $range Right hand side for property or metric predicates
     * @return $this
     */
    public function setRange($range)
    {
        $this->container['range'] = $range;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


