<?php
/**
 * AnalyticsSession
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsSession Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsSession implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsSession';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'media_type' => 'string',
        'session_id' => 'string',
        'address_other' => 'string',
        'address_self' => 'string',
        'ani' => 'string',
        'direction' => 'string',
        'dnis' => 'string',
        'outbound_campaign_id' => 'string',
        'outbound_contact_id' => 'string',
        'outbound_contact_list_id' => 'string',
        'disposition_analyzer' => 'string',
        'disposition_name' => 'string',
        'edge_id' => 'string',
        'remote_name_displayable' => 'string',
        'room_id' => 'string',
        'monitored_session_id' => 'string',
        'monitored_participant_id' => 'string',
        'callback_user_name' => 'string',
        'callback_numbers' => 'string[]',
        'callback_scheduled_time' => '\DateTime',
        'script_id' => 'string',
        'skip_enabled' => 'bool',
        'timeout_seconds' => 'int',
        'segments' => '\PureCloudSDK\AnalyticsConversationSegment[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'media_type' => 'mediaType',
        'session_id' => 'sessionId',
        'address_other' => 'addressOther',
        'address_self' => 'addressSelf',
        'ani' => 'ani',
        'direction' => 'direction',
        'dnis' => 'dnis',
        'outbound_campaign_id' => 'outboundCampaignId',
        'outbound_contact_id' => 'outboundContactId',
        'outbound_contact_list_id' => 'outboundContactListId',
        'disposition_analyzer' => 'dispositionAnalyzer',
        'disposition_name' => 'dispositionName',
        'edge_id' => 'edgeId',
        'remote_name_displayable' => 'remoteNameDisplayable',
        'room_id' => 'roomId',
        'monitored_session_id' => 'monitoredSessionId',
        'monitored_participant_id' => 'monitoredParticipantId',
        'callback_user_name' => 'callbackUserName',
        'callback_numbers' => 'callbackNumbers',
        'callback_scheduled_time' => 'callbackScheduledTime',
        'script_id' => 'scriptId',
        'skip_enabled' => 'skipEnabled',
        'timeout_seconds' => 'timeoutSeconds',
        'segments' => 'segments'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'media_type' => 'setMediaType',
        'session_id' => 'setSessionId',
        'address_other' => 'setAddressOther',
        'address_self' => 'setAddressSelf',
        'ani' => 'setAni',
        'direction' => 'setDirection',
        'dnis' => 'setDnis',
        'outbound_campaign_id' => 'setOutboundCampaignId',
        'outbound_contact_id' => 'setOutboundContactId',
        'outbound_contact_list_id' => 'setOutboundContactListId',
        'disposition_analyzer' => 'setDispositionAnalyzer',
        'disposition_name' => 'setDispositionName',
        'edge_id' => 'setEdgeId',
        'remote_name_displayable' => 'setRemoteNameDisplayable',
        'room_id' => 'setRoomId',
        'monitored_session_id' => 'setMonitoredSessionId',
        'monitored_participant_id' => 'setMonitoredParticipantId',
        'callback_user_name' => 'setCallbackUserName',
        'callback_numbers' => 'setCallbackNumbers',
        'callback_scheduled_time' => 'setCallbackScheduledTime',
        'script_id' => 'setScriptId',
        'skip_enabled' => 'setSkipEnabled',
        'timeout_seconds' => 'setTimeoutSeconds',
        'segments' => 'setSegments'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'media_type' => 'getMediaType',
        'session_id' => 'getSessionId',
        'address_other' => 'getAddressOther',
        'address_self' => 'getAddressSelf',
        'ani' => 'getAni',
        'direction' => 'getDirection',
        'dnis' => 'getDnis',
        'outbound_campaign_id' => 'getOutboundCampaignId',
        'outbound_contact_id' => 'getOutboundContactId',
        'outbound_contact_list_id' => 'getOutboundContactListId',
        'disposition_analyzer' => 'getDispositionAnalyzer',
        'disposition_name' => 'getDispositionName',
        'edge_id' => 'getEdgeId',
        'remote_name_displayable' => 'getRemoteNameDisplayable',
        'room_id' => 'getRoomId',
        'monitored_session_id' => 'getMonitoredSessionId',
        'monitored_participant_id' => 'getMonitoredParticipantId',
        'callback_user_name' => 'getCallbackUserName',
        'callback_numbers' => 'getCallbackNumbers',
        'callback_scheduled_time' => 'getCallbackScheduledTime',
        'script_id' => 'getScriptId',
        'skip_enabled' => 'getSkipEnabled',
        'timeout_seconds' => 'getTimeoutSeconds',
        'segments' => 'getSegments'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const MEDIA_TYPE_VOICE = 'voice';
    const MEDIA_TYPE_CHAT = 'chat';
    const MEDIA_TYPE_EMAIL = 'email';
    const MEDIA_TYPE_CALLBACK = 'callback';
    const MEDIA_TYPE_COBROWSE = 'cobrowse';
    const MEDIA_TYPE_VIDEO = 'video';
    const MEDIA_TYPE_SCREENSHARE = 'screenshare';
    const DIRECTION_INBOUND = 'inbound';
    const DIRECTION_OUTBOUND = 'outbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_CALLBACK,
            self::MEDIA_TYPE_COBROWSE,
            self::MEDIA_TYPE_VIDEO,
            self::MEDIA_TYPE_SCREENSHARE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['media_type'] = isset($data['media_type']) ? $data['media_type'] : null;
        $this->container['session_id'] = isset($data['session_id']) ? $data['session_id'] : null;
        $this->container['address_other'] = isset($data['address_other']) ? $data['address_other'] : null;
        $this->container['address_self'] = isset($data['address_self']) ? $data['address_self'] : null;
        $this->container['ani'] = isset($data['ani']) ? $data['ani'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['dnis'] = isset($data['dnis']) ? $data['dnis'] : null;
        $this->container['outbound_campaign_id'] = isset($data['outbound_campaign_id']) ? $data['outbound_campaign_id'] : null;
        $this->container['outbound_contact_id'] = isset($data['outbound_contact_id']) ? $data['outbound_contact_id'] : null;
        $this->container['outbound_contact_list_id'] = isset($data['outbound_contact_list_id']) ? $data['outbound_contact_list_id'] : null;
        $this->container['disposition_analyzer'] = isset($data['disposition_analyzer']) ? $data['disposition_analyzer'] : null;
        $this->container['disposition_name'] = isset($data['disposition_name']) ? $data['disposition_name'] : null;
        $this->container['edge_id'] = isset($data['edge_id']) ? $data['edge_id'] : null;
        $this->container['remote_name_displayable'] = isset($data['remote_name_displayable']) ? $data['remote_name_displayable'] : null;
        $this->container['room_id'] = isset($data['room_id']) ? $data['room_id'] : null;
        $this->container['monitored_session_id'] = isset($data['monitored_session_id']) ? $data['monitored_session_id'] : null;
        $this->container['monitored_participant_id'] = isset($data['monitored_participant_id']) ? $data['monitored_participant_id'] : null;
        $this->container['callback_user_name'] = isset($data['callback_user_name']) ? $data['callback_user_name'] : null;
        $this->container['callback_numbers'] = isset($data['callback_numbers']) ? $data['callback_numbers'] : null;
        $this->container['callback_scheduled_time'] = isset($data['callback_scheduled_time']) ? $data['callback_scheduled_time'] : null;
        $this->container['script_id'] = isset($data['script_id']) ? $data['script_id'] : null;
        $this->container['skip_enabled'] = isset($data['skip_enabled']) ? $data['skip_enabled'] : false;
        $this->container['timeout_seconds'] = isset($data['timeout_seconds']) ? $data['timeout_seconds'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("voice", "chat", "email", "callback", "cobrowse", "video", "screenshare");
        if (!in_array($this->container['media_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'media_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("voice", "chat", "email", "callback", "cobrowse", "video", "screenshare");
        if (!in_array($this->container['media_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets media_type
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['media_type'];
    }

    /**
     * Sets media_type
     * @param string $media_type
     * @return $this
     */
    public function setMediaType($media_type)
    {
        $allowed_values = array('voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare');
        if (!in_array($media_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'media_type', must be one of 'voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare'");
        }
        $this->container['media_type'] = $media_type;

        return $this;
    }

    /**
     * Gets session_id
     * @return string
     */
    public function getSessionId()
    {
        return $this->container['session_id'];
    }

    /**
     * Sets session_id
     * @param string $session_id
     * @return $this
     */
    public function setSessionId($session_id)
    {
        $this->container['session_id'] = $session_id;

        return $this;
    }

    /**
     * Gets address_other
     * @return string
     */
    public function getAddressOther()
    {
        return $this->container['address_other'];
    }

    /**
     * Sets address_other
     * @param string $address_other
     * @return $this
     */
    public function setAddressOther($address_other)
    {
        $this->container['address_other'] = $address_other;

        return $this;
    }

    /**
     * Gets address_self
     * @return string
     */
    public function getAddressSelf()
    {
        return $this->container['address_self'];
    }

    /**
     * Sets address_self
     * @param string $address_self
     * @return $this
     */
    public function setAddressSelf($address_self)
    {
        $this->container['address_self'] = $address_self;

        return $this;
    }

    /**
     * Gets ani
     * @return string
     */
    public function getAni()
    {
        return $this->container['ani'];
    }

    /**
     * Sets ani
     * @param string $ani
     * @return $this
     */
    public function setAni($ani)
    {
        $this->container['ani'] = $ani;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets dnis
     * @return string
     */
    public function getDnis()
    {
        return $this->container['dnis'];
    }

    /**
     * Sets dnis
     * @param string $dnis
     * @return $this
     */
    public function setDnis($dnis)
    {
        $this->container['dnis'] = $dnis;

        return $this;
    }

    /**
     * Gets outbound_campaign_id
     * @return string
     */
    public function getOutboundCampaignId()
    {
        return $this->container['outbound_campaign_id'];
    }

    /**
     * Sets outbound_campaign_id
     * @param string $outbound_campaign_id
     * @return $this
     */
    public function setOutboundCampaignId($outbound_campaign_id)
    {
        $this->container['outbound_campaign_id'] = $outbound_campaign_id;

        return $this;
    }

    /**
     * Gets outbound_contact_id
     * @return string
     */
    public function getOutboundContactId()
    {
        return $this->container['outbound_contact_id'];
    }

    /**
     * Sets outbound_contact_id
     * @param string $outbound_contact_id
     * @return $this
     */
    public function setOutboundContactId($outbound_contact_id)
    {
        $this->container['outbound_contact_id'] = $outbound_contact_id;

        return $this;
    }

    /**
     * Gets outbound_contact_list_id
     * @return string
     */
    public function getOutboundContactListId()
    {
        return $this->container['outbound_contact_list_id'];
    }

    /**
     * Sets outbound_contact_list_id
     * @param string $outbound_contact_list_id
     * @return $this
     */
    public function setOutboundContactListId($outbound_contact_list_id)
    {
        $this->container['outbound_contact_list_id'] = $outbound_contact_list_id;

        return $this;
    }

    /**
     * Gets disposition_analyzer
     * @return string
     */
    public function getDispositionAnalyzer()
    {
        return $this->container['disposition_analyzer'];
    }

    /**
     * Sets disposition_analyzer
     * @param string $disposition_analyzer
     * @return $this
     */
    public function setDispositionAnalyzer($disposition_analyzer)
    {
        $this->container['disposition_analyzer'] = $disposition_analyzer;

        return $this;
    }

    /**
     * Gets disposition_name
     * @return string
     */
    public function getDispositionName()
    {
        return $this->container['disposition_name'];
    }

    /**
     * Sets disposition_name
     * @param string $disposition_name
     * @return $this
     */
    public function setDispositionName($disposition_name)
    {
        $this->container['disposition_name'] = $disposition_name;

        return $this;
    }

    /**
     * Gets edge_id
     * @return string
     */
    public function getEdgeId()
    {
        return $this->container['edge_id'];
    }

    /**
     * Sets edge_id
     * @param string $edge_id
     * @return $this
     */
    public function setEdgeId($edge_id)
    {
        $this->container['edge_id'] = $edge_id;

        return $this;
    }

    /**
     * Gets remote_name_displayable
     * @return string
     */
    public function getRemoteNameDisplayable()
    {
        return $this->container['remote_name_displayable'];
    }

    /**
     * Sets remote_name_displayable
     * @param string $remote_name_displayable
     * @return $this
     */
    public function setRemoteNameDisplayable($remote_name_displayable)
    {
        $this->container['remote_name_displayable'] = $remote_name_displayable;

        return $this;
    }

    /**
     * Gets room_id
     * @return string
     */
    public function getRoomId()
    {
        return $this->container['room_id'];
    }

    /**
     * Sets room_id
     * @param string $room_id
     * @return $this
     */
    public function setRoomId($room_id)
    {
        $this->container['room_id'] = $room_id;

        return $this;
    }

    /**
     * Gets monitored_session_id
     * @return string
     */
    public function getMonitoredSessionId()
    {
        return $this->container['monitored_session_id'];
    }

    /**
     * Sets monitored_session_id
     * @param string $monitored_session_id
     * @return $this
     */
    public function setMonitoredSessionId($monitored_session_id)
    {
        $this->container['monitored_session_id'] = $monitored_session_id;

        return $this;
    }

    /**
     * Gets monitored_participant_id
     * @return string
     */
    public function getMonitoredParticipantId()
    {
        return $this->container['monitored_participant_id'];
    }

    /**
     * Sets monitored_participant_id
     * @param string $monitored_participant_id
     * @return $this
     */
    public function setMonitoredParticipantId($monitored_participant_id)
    {
        $this->container['monitored_participant_id'] = $monitored_participant_id;

        return $this;
    }

    /**
     * Gets callback_user_name
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callback_user_name'];
    }

    /**
     * Sets callback_user_name
     * @param string $callback_user_name
     * @return $this
     */
    public function setCallbackUserName($callback_user_name)
    {
        $this->container['callback_user_name'] = $callback_user_name;

        return $this;
    }

    /**
     * Gets callback_numbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callback_numbers'];
    }

    /**
     * Sets callback_numbers
     * @param string[] $callback_numbers
     * @return $this
     */
    public function setCallbackNumbers($callback_numbers)
    {
        $this->container['callback_numbers'] = $callback_numbers;

        return $this;
    }

    /**
     * Gets callback_scheduled_time
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callback_scheduled_time'];
    }

    /**
     * Sets callback_scheduled_time
     * @param \DateTime $callback_scheduled_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallbackScheduledTime($callback_scheduled_time)
    {
        $this->container['callback_scheduled_time'] = $callback_scheduled_time;

        return $this;
    }

    /**
     * Gets script_id
     * @return string
     */
    public function getScriptId()
    {
        return $this->container['script_id'];
    }

    /**
     * Sets script_id
     * @param string $script_id
     * @return $this
     */
    public function setScriptId($script_id)
    {
        $this->container['script_id'] = $script_id;

        return $this;
    }

    /**
     * Gets skip_enabled
     * @return bool
     */
    public function getSkipEnabled()
    {
        return $this->container['skip_enabled'];
    }

    /**
     * Sets skip_enabled
     * @param bool $skip_enabled
     * @return $this
     */
    public function setSkipEnabled($skip_enabled)
    {
        $this->container['skip_enabled'] = $skip_enabled;

        return $this;
    }

    /**
     * Gets timeout_seconds
     * @return int
     */
    public function getTimeoutSeconds()
    {
        return $this->container['timeout_seconds'];
    }

    /**
     * Sets timeout_seconds
     * @param int $timeout_seconds
     * @return $this
     */
    public function setTimeoutSeconds($timeout_seconds)
    {
        $this->container['timeout_seconds'] = $timeout_seconds;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\AnalyticsConversationSegment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\AnalyticsConversationSegment[] $segments
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


