<?php
/**
 * Calibration
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Calibration Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Calibration implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Calibration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'calibrator' => '\PureCloudSDK\User',
        'agent' => '\PureCloudSDK\User',
        'conversation' => '\PureCloudSDK\Conversation',
        'evaluation_form' => '\PureCloudSDK\EvaluationForm',
        'context_id' => 'string',
        'average_score' => 'int',
        'high_score' => 'int',
        'low_score' => 'int',
        'created_date' => '\DateTime',
        'evaluations' => '\PureCloudSDK\Evaluation[]',
        'evaluators' => '\PureCloudSDK\User[]',
        'scoring_index' => '\PureCloudSDK\Evaluation',
        'expert_evaluator' => '\PureCloudSDK\User',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'calibrator' => 'calibrator',
        'agent' => 'agent',
        'conversation' => 'conversation',
        'evaluation_form' => 'evaluationForm',
        'context_id' => 'contextId',
        'average_score' => 'averageScore',
        'high_score' => 'highScore',
        'low_score' => 'lowScore',
        'created_date' => 'createdDate',
        'evaluations' => 'evaluations',
        'evaluators' => 'evaluators',
        'scoring_index' => 'scoringIndex',
        'expert_evaluator' => 'expertEvaluator',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'calibrator' => 'setCalibrator',
        'agent' => 'setAgent',
        'conversation' => 'setConversation',
        'evaluation_form' => 'setEvaluationForm',
        'context_id' => 'setContextId',
        'average_score' => 'setAverageScore',
        'high_score' => 'setHighScore',
        'low_score' => 'setLowScore',
        'created_date' => 'setCreatedDate',
        'evaluations' => 'setEvaluations',
        'evaluators' => 'setEvaluators',
        'scoring_index' => 'setScoringIndex',
        'expert_evaluator' => 'setExpertEvaluator',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'calibrator' => 'getCalibrator',
        'agent' => 'getAgent',
        'conversation' => 'getConversation',
        'evaluation_form' => 'getEvaluationForm',
        'context_id' => 'getContextId',
        'average_score' => 'getAverageScore',
        'high_score' => 'getHighScore',
        'low_score' => 'getLowScore',
        'created_date' => 'getCreatedDate',
        'evaluations' => 'getEvaluations',
        'evaluators' => 'getEvaluators',
        'scoring_index' => 'getScoringIndex',
        'expert_evaluator' => 'getExpertEvaluator',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['calibrator'] = isset($data['calibrator']) ? $data['calibrator'] : null;
        $this->container['agent'] = isset($data['agent']) ? $data['agent'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['evaluation_form'] = isset($data['evaluation_form']) ? $data['evaluation_form'] : null;
        $this->container['context_id'] = isset($data['context_id']) ? $data['context_id'] : null;
        $this->container['average_score'] = isset($data['average_score']) ? $data['average_score'] : null;
        $this->container['high_score'] = isset($data['high_score']) ? $data['high_score'] : null;
        $this->container['low_score'] = isset($data['low_score']) ? $data['low_score'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['evaluations'] = isset($data['evaluations']) ? $data['evaluations'] : null;
        $this->container['evaluators'] = isset($data['evaluators']) ? $data['evaluators'] : null;
        $this->container['scoring_index'] = isset($data['scoring_index']) ? $data['scoring_index'] : null;
        $this->container['expert_evaluator'] = isset($data['expert_evaluator']) ? $data['expert_evaluator'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets calibrator
     * @return \PureCloudSDK\User
     */
    public function getCalibrator()
    {
        return $this->container['calibrator'];
    }

    /**
     * Sets calibrator
     * @param \PureCloudSDK\User $calibrator
     * @return $this
     */
    public function setCalibrator($calibrator)
    {
        $this->container['calibrator'] = $calibrator;

        return $this;
    }

    /**
     * Gets agent
     * @return \PureCloudSDK\User
     */
    public function getAgent()
    {
        return $this->container['agent'];
    }

    /**
     * Sets agent
     * @param \PureCloudSDK\User $agent
     * @return $this
     */
    public function setAgent($agent)
    {
        $this->container['agent'] = $agent;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets evaluation_form
     * @return \PureCloudSDK\EvaluationForm
     */
    public function getEvaluationForm()
    {
        return $this->container['evaluation_form'];
    }

    /**
     * Sets evaluation_form
     * @param \PureCloudSDK\EvaluationForm $evaluation_form
     * @return $this
     */
    public function setEvaluationForm($evaluation_form)
    {
        $this->container['evaluation_form'] = $evaluation_form;

        return $this;
    }

    /**
     * Gets context_id
     * @return string
     */
    public function getContextId()
    {
        return $this->container['context_id'];
    }

    /**
     * Sets context_id
     * @param string $context_id
     * @return $this
     */
    public function setContextId($context_id)
    {
        $this->container['context_id'] = $context_id;

        return $this;
    }

    /**
     * Gets average_score
     * @return int
     */
    public function getAverageScore()
    {
        return $this->container['average_score'];
    }

    /**
     * Sets average_score
     * @param int $average_score
     * @return $this
     */
    public function setAverageScore($average_score)
    {
        $this->container['average_score'] = $average_score;

        return $this;
    }

    /**
     * Gets high_score
     * @return int
     */
    public function getHighScore()
    {
        return $this->container['high_score'];
    }

    /**
     * Sets high_score
     * @param int $high_score
     * @return $this
     */
    public function setHighScore($high_score)
    {
        $this->container['high_score'] = $high_score;

        return $this;
    }

    /**
     * Gets low_score
     * @return int
     */
    public function getLowScore()
    {
        return $this->container['low_score'];
    }

    /**
     * Sets low_score
     * @param int $low_score
     * @return $this
     */
    public function setLowScore($low_score)
    {
        $this->container['low_score'] = $low_score;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets evaluations
     * @return \PureCloudSDK\Evaluation[]
     */
    public function getEvaluations()
    {
        return $this->container['evaluations'];
    }

    /**
     * Sets evaluations
     * @param \PureCloudSDK\Evaluation[] $evaluations
     * @return $this
     */
    public function setEvaluations($evaluations)
    {
        $this->container['evaluations'] = $evaluations;

        return $this;
    }

    /**
     * Gets evaluators
     * @return \PureCloudSDK\User[]
     */
    public function getEvaluators()
    {
        return $this->container['evaluators'];
    }

    /**
     * Sets evaluators
     * @param \PureCloudSDK\User[] $evaluators
     * @return $this
     */
    public function setEvaluators($evaluators)
    {
        $this->container['evaluators'] = $evaluators;

        return $this;
    }

    /**
     * Gets scoring_index
     * @return \PureCloudSDK\Evaluation
     */
    public function getScoringIndex()
    {
        return $this->container['scoring_index'];
    }

    /**
     * Sets scoring_index
     * @param \PureCloudSDK\Evaluation $scoring_index
     * @return $this
     */
    public function setScoringIndex($scoring_index)
    {
        $this->container['scoring_index'] = $scoring_index;

        return $this;
    }

    /**
     * Gets expert_evaluator
     * @return \PureCloudSDK\User
     */
    public function getExpertEvaluator()
    {
        return $this->container['expert_evaluator'];
    }

    /**
     * Sets expert_evaluator
     * @param \PureCloudSDK\User $expert_evaluator
     * @return $this
     */
    public function setExpertEvaluator($expert_evaluator)
    {
        $this->container['expert_evaluator'] = $expert_evaluator;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


