<?php
/**
 * Call
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Call Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Call implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Call';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'id' => 'string',
        'direction' => 'string',
        'recording' => 'bool',
        'recording_state' => 'string',
        'muted' => 'bool',
        'confined' => 'bool',
        'held' => 'bool',
        'recording_id' => 'string',
        'segments' => '\PureCloudSDK\Segment[]',
        'error_info' => '\PureCloudSDK\ErrorBody',
        'disconnect_type' => 'string',
        'start_hold_time' => '\DateTime',
        'document_id' => 'string',
        'connected_time' => '\DateTime',
        'disconnected_time' => '\DateTime',
        'disconnect_reasons' => '\PureCloudSDK\DisconnectReason[]',
        'fax_status' => '\PureCloudSDK\FaxStatus',
        'provider' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'id' => 'id',
        'direction' => 'direction',
        'recording' => 'recording',
        'recording_state' => 'recordingState',
        'muted' => 'muted',
        'confined' => 'confined',
        'held' => 'held',
        'recording_id' => 'recordingId',
        'segments' => 'segments',
        'error_info' => 'errorInfo',
        'disconnect_type' => 'disconnectType',
        'start_hold_time' => 'startHoldTime',
        'document_id' => 'documentId',
        'connected_time' => 'connectedTime',
        'disconnected_time' => 'disconnectedTime',
        'disconnect_reasons' => 'disconnectReasons',
        'fax_status' => 'faxStatus',
        'provider' => 'provider'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'id' => 'setId',
        'direction' => 'setDirection',
        'recording' => 'setRecording',
        'recording_state' => 'setRecordingState',
        'muted' => 'setMuted',
        'confined' => 'setConfined',
        'held' => 'setHeld',
        'recording_id' => 'setRecordingId',
        'segments' => 'setSegments',
        'error_info' => 'setErrorInfo',
        'disconnect_type' => 'setDisconnectType',
        'start_hold_time' => 'setStartHoldTime',
        'document_id' => 'setDocumentId',
        'connected_time' => 'setConnectedTime',
        'disconnected_time' => 'setDisconnectedTime',
        'disconnect_reasons' => 'setDisconnectReasons',
        'fax_status' => 'setFaxStatus',
        'provider' => 'setProvider'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'id' => 'getId',
        'direction' => 'getDirection',
        'recording' => 'getRecording',
        'recording_state' => 'getRecordingState',
        'muted' => 'getMuted',
        'confined' => 'getConfined',
        'held' => 'getHeld',
        'recording_id' => 'getRecordingId',
        'segments' => 'getSegments',
        'error_info' => 'getErrorInfo',
        'disconnect_type' => 'getDisconnectType',
        'start_hold_time' => 'getStartHoldTime',
        'document_id' => 'getDocumentId',
        'connected_time' => 'getConnectedTime',
        'disconnected_time' => 'getDisconnectedTime',
        'disconnect_reasons' => 'getDisconnectReasons',
        'fax_status' => 'getFaxStatus',
        'provider' => 'getProvider'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'ALERTING';
    const STATE_DIALING = 'DIALING';
    const STATE_CONTACTING = 'CONTACTING';
    const STATE_OFFERING = 'OFFERING';
    const STATE_CONNECTED = 'CONNECTED';
    const STATE_DISCONNECTED = 'DISCONNECTED';
    const STATE_TERMINATED = 'TERMINATED';
    const STATE_CONVERTING = 'CONVERTING';
    const STATE_UPLOADING = 'UPLOADING';
    const STATE_TRANSMITTING = 'TRANSMITTING';
    const STATE_NONE = 'NONE';
    const DIRECTION_INBOUND = 'INBOUND';
    const DIRECTION_OUTBOUND = 'OUTBOUND';
    const RECORDING_STATE_NONE = 'NONE';
    const RECORDING_STATE_ACTIVE = 'ACTIVE';
    const RECORDING_STATE_PAUSED = 'PAUSED';
    const DISCONNECT_TYPE_ENDPOINT = 'ENDPOINT';
    const DISCONNECT_TYPE_CLIENT = 'CLIENT';
    const DISCONNECT_TYPE_SYSTEM = 'SYSTEM';
    const DISCONNECT_TYPE_TIMEOUT = 'TIMEOUT';
    const DISCONNECT_TYPE_TRANSFER = 'TRANSFER';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'TRANSFER_CONFERENCE';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'TRANSFER_CONSULT';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'TRANSFER_FORWARD';
    const DISCONNECT_TYPE_TRANSFER_NOANSWER = 'TRANSFER_NOANSWER';
    const DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE = 'TRANSFER_NOTAVAILABLE';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'TRANSPORT_FAILURE';
    const DISCONNECT_TYPE_ERROR = 'ERROR';
    const DISCONNECT_TYPE_PEER = 'PEER';
    const DISCONNECT_TYPE_OTHER = 'OTHER';
    const DISCONNECT_TYPE_SPAM = 'SPAM';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_CONVERTING,
            self::STATE_UPLOADING,
            self::STATE_TRANSMITTING,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRecordingStateAllowableValues()
    {
        return [
            self::RECORDING_STATE_NONE,
            self::RECORDING_STATE_ACTIVE,
            self::RECORDING_STATE_PAUSED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSFER_NOANSWER,
            self::DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['recording'] = isset($data['recording']) ? $data['recording'] : false;
        $this->container['recording_state'] = isset($data['recording_state']) ? $data['recording_state'] : null;
        $this->container['muted'] = isset($data['muted']) ? $data['muted'] : false;
        $this->container['confined'] = isset($data['confined']) ? $data['confined'] : false;
        $this->container['held'] = isset($data['held']) ? $data['held'] : false;
        $this->container['recording_id'] = isset($data['recording_id']) ? $data['recording_id'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
        $this->container['error_info'] = isset($data['error_info']) ? $data['error_info'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['start_hold_time'] = isset($data['start_hold_time']) ? $data['start_hold_time'] : null;
        $this->container['document_id'] = isset($data['document_id']) ? $data['document_id'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['disconnected_time'] = isset($data['disconnected_time']) ? $data['disconnected_time'] : null;
        $this->container['disconnect_reasons'] = isset($data['disconnect_reasons']) ? $data['disconnect_reasons'] : null;
        $this->container['fax_status'] = isset($data['fax_status']) ? $data['fax_status'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "CONVERTING", "UPLOADING", "TRANSMITTING", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NONE", "ACTIVE", "PAUSED");
        if (!in_array($this->container['recording_state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'recording_state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "CONVERTING", "UPLOADING", "TRANSMITTING", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NONE", "ACTIVE", "PAUSED");
        if (!in_array($this->container['recording_state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The connection state of this communication.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'CONVERTING', 'UPLOADING', 'TRANSMITTING', 'NONE');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'CONVERTING', 'UPLOADING', 'TRANSMITTING', 'NONE'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A globally unique identifier for this communication.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The direction of the call
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('INBOUND', 'OUTBOUND');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'INBOUND', 'OUTBOUND'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets recording
     * @return bool
     */
    public function getRecording()
    {
        return $this->container['recording'];
    }

    /**
     * Sets recording
     * @param bool $recording True if this call is being recorded.
     * @return $this
     */
    public function setRecording($recording)
    {
        $this->container['recording'] = $recording;

        return $this;
    }

    /**
     * Gets recording_state
     * @return string
     */
    public function getRecordingState()
    {
        return $this->container['recording_state'];
    }

    /**
     * Sets recording_state
     * @param string $recording_state State of recording on this call.
     * @return $this
     */
    public function setRecordingState($recording_state)
    {
        $allowed_values = array('NONE', 'ACTIVE', 'PAUSED');
        if (!in_array($recording_state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'recording_state', must be one of 'NONE', 'ACTIVE', 'PAUSED'");
        }
        $this->container['recording_state'] = $recording_state;

        return $this;
    }

    /**
     * Gets muted
     * @return bool
     */
    public function getMuted()
    {
        return $this->container['muted'];
    }

    /**
     * Sets muted
     * @param bool $muted True if this call is muted so that remote participants can't hear any audio from this end.
     * @return $this
     */
    public function setMuted($muted)
    {
        $this->container['muted'] = $muted;

        return $this;
    }

    /**
     * Gets confined
     * @return bool
     */
    public function getConfined()
    {
        return $this->container['confined'];
    }

    /**
     * Sets confined
     * @param bool $confined True if this call is held and the person on this side hears hold music.
     * @return $this
     */
    public function setConfined($confined)
    {
        $this->container['confined'] = $confined;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held True if this call is held and the person on this side hears silence.
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets recording_id
     * @return string
     */
    public function getRecordingId()
    {
        return $this->container['recording_id'];
    }

    /**
     * Sets recording_id
     * @param string $recording_id A globally unique identifier for the recording associated with this call.
     * @return $this
     */
    public function setRecordingId($recording_id)
    {
        $this->container['recording_id'] = $recording_id;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\Segment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\Segment[] $segments The time line of the participant's call, divided into activity segments.
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }

    /**
     * Gets error_info
     * @return \PureCloudSDK\ErrorBody
     */
    public function getErrorInfo()
    {
        return $this->container['error_info'];
    }

    /**
     * Sets error_info
     * @param \PureCloudSDK\ErrorBody $error_info
     * @return $this
     */
    public function setErrorInfo($error_info)
    {
        $this->container['error_info'] = $error_info;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets start_hold_time
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['start_hold_time'];
    }

    /**
     * Sets start_hold_time
     * @param \DateTime $start_hold_time The timestamp the call was placed on hold in the cloud clock if the call is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartHoldTime($start_hold_time)
    {
        $this->container['start_hold_time'] = $start_hold_time;

        return $this;
    }

    /**
     * Gets document_id
     * @return string
     */
    public function getDocumentId()
    {
        return $this->container['document_id'];
    }

    /**
     * Sets document_id
     * @param string $document_id If call is an outbound fax of a document from content management, then this is the id in content management.
     * @return $this
     */
    public function setDocumentId($document_id)
    {
        $this->container['document_id'] = $document_id;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets disconnected_time
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnected_time'];
    }

    /**
     * Sets disconnected_time
     * @param \DateTime $disconnected_time The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDisconnectedTime($disconnected_time)
    {
        $this->container['disconnected_time'] = $disconnected_time;

        return $this;
    }

    /**
     * Gets disconnect_reasons
     * @return \PureCloudSDK\DisconnectReason[]
     */
    public function getDisconnectReasons()
    {
        return $this->container['disconnect_reasons'];
    }

    /**
     * Sets disconnect_reasons
     * @param \PureCloudSDK\DisconnectReason[] $disconnect_reasons List of reasons that this call was disconnected. This will be set once the call disconnects.
     * @return $this
     */
    public function setDisconnectReasons($disconnect_reasons)
    {
        $this->container['disconnect_reasons'] = $disconnect_reasons;

        return $this;
    }

    /**
     * Gets fax_status
     * @return \PureCloudSDK\FaxStatus
     */
    public function getFaxStatus()
    {
        return $this->container['fax_status'];
    }

    /**
     * Sets fax_status
     * @param \PureCloudSDK\FaxStatus $fax_status Extra information on fax transmission.
     * @return $this
     */
    public function setFaxStatus($fax_status)
    {
        $this->container['fax_status'] = $fax_status;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the call.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


