<?php
/**
 * CallbackMediaParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CallbackMediaParticipant Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CallbackMediaParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CallbackMediaParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'address' => 'string',
        'start_time' => '\DateTime',
        'connected_time' => '\DateTime',
        'end_time' => '\DateTime',
        'start_hold_time' => '\DateTime',
        'purpose' => 'string',
        'state' => 'string',
        'direction' => 'string',
        'disconnect_type' => 'string',
        'held' => 'bool',
        'wrapup_required' => 'bool',
        'wrapup_prompt' => 'string',
        'user' => '\PureCloudSDK\UriReference',
        'queue' => '\PureCloudSDK\UriReference',
        'attributes' => 'map[string,string]',
        'error_info' => '\PureCloudSDK\ErrorBody',
        'script' => '\PureCloudSDK\UriReference',
        'wrapup_timeout_ms' => 'int',
        'wrapup_skipped' => 'bool',
        'provider' => 'string',
        'external_contact' => '\PureCloudSDK\UriReference',
        'external_organization' => '\PureCloudSDK\UriReference',
        'outbound_preview' => '\PureCloudSDK\DialerPreview',
        'callback_numbers' => 'string[]',
        'callback_user_name' => 'string',
        'skip_enabled' => 'bool',
        'timeout_seconds' => 'int',
        'callback_scheduled_time' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'address' => 'address',
        'start_time' => 'startTime',
        'connected_time' => 'connectedTime',
        'end_time' => 'endTime',
        'start_hold_time' => 'startHoldTime',
        'purpose' => 'purpose',
        'state' => 'state',
        'direction' => 'direction',
        'disconnect_type' => 'disconnectType',
        'held' => 'held',
        'wrapup_required' => 'wrapupRequired',
        'wrapup_prompt' => 'wrapupPrompt',
        'user' => 'user',
        'queue' => 'queue',
        'attributes' => 'attributes',
        'error_info' => 'errorInfo',
        'script' => 'script',
        'wrapup_timeout_ms' => 'wrapupTimeoutMs',
        'wrapup_skipped' => 'wrapupSkipped',
        'provider' => 'provider',
        'external_contact' => 'externalContact',
        'external_organization' => 'externalOrganization',
        'outbound_preview' => 'outboundPreview',
        'callback_numbers' => 'callbackNumbers',
        'callback_user_name' => 'callbackUserName',
        'skip_enabled' => 'skipEnabled',
        'timeout_seconds' => 'timeoutSeconds',
        'callback_scheduled_time' => 'callbackScheduledTime'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'address' => 'setAddress',
        'start_time' => 'setStartTime',
        'connected_time' => 'setConnectedTime',
        'end_time' => 'setEndTime',
        'start_hold_time' => 'setStartHoldTime',
        'purpose' => 'setPurpose',
        'state' => 'setState',
        'direction' => 'setDirection',
        'disconnect_type' => 'setDisconnectType',
        'held' => 'setHeld',
        'wrapup_required' => 'setWrapupRequired',
        'wrapup_prompt' => 'setWrapupPrompt',
        'user' => 'setUser',
        'queue' => 'setQueue',
        'attributes' => 'setAttributes',
        'error_info' => 'setErrorInfo',
        'script' => 'setScript',
        'wrapup_timeout_ms' => 'setWrapupTimeoutMs',
        'wrapup_skipped' => 'setWrapupSkipped',
        'provider' => 'setProvider',
        'external_contact' => 'setExternalContact',
        'external_organization' => 'setExternalOrganization',
        'outbound_preview' => 'setOutboundPreview',
        'callback_numbers' => 'setCallbackNumbers',
        'callback_user_name' => 'setCallbackUserName',
        'skip_enabled' => 'setSkipEnabled',
        'timeout_seconds' => 'setTimeoutSeconds',
        'callback_scheduled_time' => 'setCallbackScheduledTime'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'address' => 'getAddress',
        'start_time' => 'getStartTime',
        'connected_time' => 'getConnectedTime',
        'end_time' => 'getEndTime',
        'start_hold_time' => 'getStartHoldTime',
        'purpose' => 'getPurpose',
        'state' => 'getState',
        'direction' => 'getDirection',
        'disconnect_type' => 'getDisconnectType',
        'held' => 'getHeld',
        'wrapup_required' => 'getWrapupRequired',
        'wrapup_prompt' => 'getWrapupPrompt',
        'user' => 'getUser',
        'queue' => 'getQueue',
        'attributes' => 'getAttributes',
        'error_info' => 'getErrorInfo',
        'script' => 'getScript',
        'wrapup_timeout_ms' => 'getWrapupTimeoutMs',
        'wrapup_skipped' => 'getWrapupSkipped',
        'provider' => 'getProvider',
        'external_contact' => 'getExternalContact',
        'external_organization' => 'getExternalOrganization',
        'outbound_preview' => 'getOutboundPreview',
        'callback_numbers' => 'getCallbackNumbers',
        'callback_user_name' => 'getCallbackUserName',
        'skip_enabled' => 'getSkipEnabled',
        'timeout_seconds' => 'getTimeoutSeconds',
        'callback_scheduled_time' => 'getCallbackScheduledTime'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'ALERTING';
    const STATE_DIALING = 'DIALING';
    const STATE_CONTACTING = 'CONTACTING';
    const STATE_OFFERING = 'OFFERING';
    const STATE_CONNECTED = 'CONNECTED';
    const STATE_DISCONNECTED = 'DISCONNECTED';
    const STATE_TERMINATED = 'TERMINATED';
    const STATE_CONVERTING = 'CONVERTING';
    const STATE_UPLOADING = 'UPLOADING';
    const STATE_TRANSMITTING = 'TRANSMITTING';
    const STATE_NONE = 'NONE';
    const DIRECTION_INBOUND = 'INBOUND';
    const DIRECTION_OUTBOUND = 'OUTBOUND';
    const DISCONNECT_TYPE_ENDPOINT = 'ENDPOINT';
    const DISCONNECT_TYPE_CLIENT = 'CLIENT';
    const DISCONNECT_TYPE_SYSTEM = 'SYSTEM';
    const DISCONNECT_TYPE_TRANSFER = 'TRANSFER';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'TRANSFER_CONFERENCE';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'TRANSFER_CONSULT';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'TRANSFER_FORWARD';
    const DISCONNECT_TYPE_TRANSFER_NO_ANSWER = 'TRANSFER_NO_ANSWER';
    const DISCONNECT_TYPE_TRANSFER_NOT_AVAILABLE = 'TRANSFER_NOT_AVAILABLE';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'TRANSPORT_FAILURE';
    const DISCONNECT_TYPE_ERROR = 'ERROR';
    const DISCONNECT_TYPE_PEER = 'PEER';
    const DISCONNECT_TYPE_OTHER = 'OTHER';
    const DISCONNECT_TYPE_SPAM = 'SPAM';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_CONVERTING,
            self::STATE_UPLOADING,
            self::STATE_TRANSMITTING,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSFER_NO_ANSWER,
            self::DISCONNECT_TYPE_TRANSFER_NOT_AVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['start_time'] = isset($data['start_time']) ? $data['start_time'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['end_time'] = isset($data['end_time']) ? $data['end_time'] : null;
        $this->container['start_hold_time'] = isset($data['start_hold_time']) ? $data['start_hold_time'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : false;
        $this->container['wrapup_required'] = isset($data['wrapup_required']) ? $data['wrapup_required'] : false;
        $this->container['wrapup_prompt'] = isset($data['wrapup_prompt']) ? $data['wrapup_prompt'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['error_info'] = isset($data['error_info']) ? $data['error_info'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['wrapup_timeout_ms'] = isset($data['wrapup_timeout_ms']) ? $data['wrapup_timeout_ms'] : null;
        $this->container['wrapup_skipped'] = isset($data['wrapup_skipped']) ? $data['wrapup_skipped'] : false;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['external_contact'] = isset($data['external_contact']) ? $data['external_contact'] : null;
        $this->container['external_organization'] = isset($data['external_organization']) ? $data['external_organization'] : null;
        $this->container['outbound_preview'] = isset($data['outbound_preview']) ? $data['outbound_preview'] : null;
        $this->container['callback_numbers'] = isset($data['callback_numbers']) ? $data['callback_numbers'] : null;
        $this->container['callback_user_name'] = isset($data['callback_user_name']) ? $data['callback_user_name'] : null;
        $this->container['skip_enabled'] = isset($data['skip_enabled']) ? $data['skip_enabled'] : false;
        $this->container['timeout_seconds'] = isset($data['timeout_seconds']) ? $data['timeout_seconds'] : null;
        $this->container['callback_scheduled_time'] = isset($data['callback_scheduled_time']) ? $data['callback_scheduled_time'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "CONVERTING", "UPLOADING", "TRANSMITTING", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NO_ANSWER", "TRANSFER_NOT_AVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "CONVERTING", "UPLOADING", "TRANSMITTING", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NO_ANSWER", "TRANSFER_NOT_AVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The unique participant ID.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The display friendly name of the participant.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address The participant address.
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets start_time
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time
     * @param \DateTime $start_time The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($start_time)
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets end_time
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time
     * @param \DateTime $end_time The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($end_time)
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }

    /**
     * Gets start_hold_time
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['start_hold_time'];
    }

    /**
     * Sets start_hold_time
     * @param \DateTime $start_hold_time The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartHoldTime($start_hold_time)
    {
        $this->container['start_hold_time'] = $start_hold_time;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'CONVERTING', 'UPLOADING', 'TRANSMITTING', 'NONE');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'CONVERTING', 'UPLOADING', 'TRANSMITTING', 'NONE'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The participant's direction.  Values can be: 'inbound' or 'outbound'
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('INBOUND', 'OUTBOUND');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'INBOUND', 'OUTBOUND'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type The reason the participant was disconnected from the conversation.
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('ENDPOINT', 'CLIENT', 'SYSTEM', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NO_ANSWER', 'TRANSFER_NOT_AVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'ENDPOINT', 'CLIENT', 'SYSTEM', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NO_ANSWER', 'TRANSFER_NOT_AVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held Value is true when the participant is on hold.
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets wrapup_required
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapup_required'];
    }

    /**
     * Sets wrapup_required
     * @param bool $wrapup_required Value is true when the participant requires wrap-up.
     * @return $this
     */
    public function setWrapupRequired($wrapup_required)
    {
        $this->container['wrapup_required'] = $wrapup_required;

        return $this;
    }

    /**
     * Gets wrapup_prompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapup_prompt'];
    }

    /**
     * Sets wrapup_prompt
     * @param string $wrapup_prompt The wrap-up prompt indicating the type of wrap-up to be performed.
     * @return $this
     */
    public function setWrapupPrompt($wrapup_prompt)
    {
        $this->container['wrapup_prompt'] = $wrapup_prompt;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\UriReference
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\UriReference $user The PureCloud user for this participant.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue The PureCloud queue for this participant.
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes A list of ad-hoc attributes for the participant.
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets error_info
     * @return \PureCloudSDK\ErrorBody
     */
    public function getErrorInfo()
    {
        return $this->container['error_info'];
    }

    /**
     * Sets error_info
     * @param \PureCloudSDK\ErrorBody $error_info If the conversation ends in error, contains additional error details.
     * @return $this
     */
    public function setErrorInfo($error_info)
    {
        $this->container['error_info'] = $error_info;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\UriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\UriReference $script The Engage script that should be used by this participant.
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets wrapup_timeout_ms
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapup_timeout_ms'];
    }

    /**
     * Sets wrapup_timeout_ms
     * @param int $wrapup_timeout_ms The amount of time the participant has to complete wrap-up.
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapup_timeout_ms)
    {
        $this->container['wrapup_timeout_ms'] = $wrapup_timeout_ms;

        return $this;
    }

    /**
     * Gets wrapup_skipped
     * @return bool
     */
    public function getWrapupSkipped()
    {
        return $this->container['wrapup_skipped'];
    }

    /**
     * Sets wrapup_skipped
     * @param bool $wrapup_skipped Value is true when the participant has skipped wrap-up.
     * @return $this
     */
    public function setWrapupSkipped($wrapup_skipped)
    {
        $this->container['wrapup_skipped'] = $wrapup_skipped;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the communication.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets external_contact
     * @return \PureCloudSDK\UriReference
     */
    public function getExternalContact()
    {
        return $this->container['external_contact'];
    }

    /**
     * Sets external_contact
     * @param \PureCloudSDK\UriReference $external_contact If this participant represents an external contact, then this will be the reference for the external contact.
     * @return $this
     */
    public function setExternalContact($external_contact)
    {
        $this->container['external_contact'] = $external_contact;

        return $this;
    }

    /**
     * Gets external_organization
     * @return \PureCloudSDK\UriReference
     */
    public function getExternalOrganization()
    {
        return $this->container['external_organization'];
    }

    /**
     * Sets external_organization
     * @param \PureCloudSDK\UriReference $external_organization If this participant represents an external org, then this will be the reference for the external org.
     * @return $this
     */
    public function setExternalOrganization($external_organization)
    {
        $this->container['external_organization'] = $external_organization;

        return $this;
    }

    /**
     * Gets outbound_preview
     * @return \PureCloudSDK\DialerPreview
     */
    public function getOutboundPreview()
    {
        return $this->container['outbound_preview'];
    }

    /**
     * Sets outbound_preview
     * @param \PureCloudSDK\DialerPreview $outbound_preview The outbound preview associated with this callback.
     * @return $this
     */
    public function setOutboundPreview($outbound_preview)
    {
        $this->container['outbound_preview'] = $outbound_preview;

        return $this;
    }

    /**
     * Gets callback_numbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callback_numbers'];
    }

    /**
     * Sets callback_numbers
     * @param string[] $callback_numbers The list of phone number to use for this callback.
     * @return $this
     */
    public function setCallbackNumbers($callback_numbers)
    {
        $this->container['callback_numbers'] = $callback_numbers;

        return $this;
    }

    /**
     * Gets callback_user_name
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callback_user_name'];
    }

    /**
     * Sets callback_user_name
     * @param string $callback_user_name The name of the callback target.
     * @return $this
     */
    public function setCallbackUserName($callback_user_name)
    {
        $this->container['callback_user_name'] = $callback_user_name;

        return $this;
    }

    /**
     * Gets skip_enabled
     * @return bool
     */
    public function getSkipEnabled()
    {
        return $this->container['skip_enabled'];
    }

    /**
     * Sets skip_enabled
     * @param bool $skip_enabled If true, the callback can be skipped
     * @return $this
     */
    public function setSkipEnabled($skip_enabled)
    {
        $this->container['skip_enabled'] = $skip_enabled;

        return $this;
    }

    /**
     * Gets timeout_seconds
     * @return int
     */
    public function getTimeoutSeconds()
    {
        return $this->container['timeout_seconds'];
    }

    /**
     * Sets timeout_seconds
     * @param int $timeout_seconds Duration in seconds before the callback will be auto-dialed.
     * @return $this
     */
    public function setTimeoutSeconds($timeout_seconds)
    {
        $this->container['timeout_seconds'] = $timeout_seconds;

        return $this;
    }

    /**
     * Gets callback_scheduled_time
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callback_scheduled_time'];
    }

    /**
     * Sets callback_scheduled_time
     * @param \DateTime $callback_scheduled_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallbackScheduledTime($callback_scheduled_time)
    {
        $this->container['callback_scheduled_time'] = $callback_scheduled_time;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


