<?php
/**
 * Campaign
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Campaign Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Campaign implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Campaign';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'version' => 'int',
        'contact_list' => '\PureCloudSDK\UriReference',
        'queue' => '\PureCloudSDK\UriReference',
        'dialing_mode' => 'string',
        'script' => '\PureCloudSDK\UriReference',
        'edge_group' => '\PureCloudSDK\UriReference',
        'campaign_status' => 'string',
        'phone_columns' => '\PureCloudSDK\PhoneColumn[]',
        'abandon_rate' => 'double',
        'dnc_lists' => '\PureCloudSDK\UriReference[]',
        'callable_time_set' => '\PureCloudSDK\UriReference',
        'call_analysis_response_set' => '\PureCloudSDK\UriReference',
        'errors' => '\PureCloudSDK\RestErrorDetail[]',
        'caller_name' => 'string',
        'caller_address' => 'string',
        'outbound_line_count' => 'int',
        'rule_sets' => '\PureCloudSDK\UriReference[]',
        'skip_preview_disabled' => 'bool',
        'preview_time_out_seconds' => 'int',
        'contact_sort' => '\PureCloudSDK\ContactSort',
        'no_answer_timeout' => 'int',
        'call_analysis_language' => 'string',
        'priority' => 'int',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'version' => 'version',
        'contact_list' => 'contactList',
        'queue' => 'queue',
        'dialing_mode' => 'dialingMode',
        'script' => 'script',
        'edge_group' => 'edgeGroup',
        'campaign_status' => 'campaignStatus',
        'phone_columns' => 'phoneColumns',
        'abandon_rate' => 'abandonRate',
        'dnc_lists' => 'dncLists',
        'callable_time_set' => 'callableTimeSet',
        'call_analysis_response_set' => 'callAnalysisResponseSet',
        'errors' => 'errors',
        'caller_name' => 'callerName',
        'caller_address' => 'callerAddress',
        'outbound_line_count' => 'outboundLineCount',
        'rule_sets' => 'ruleSets',
        'skip_preview_disabled' => 'skipPreviewDisabled',
        'preview_time_out_seconds' => 'previewTimeOutSeconds',
        'contact_sort' => 'contactSort',
        'no_answer_timeout' => 'noAnswerTimeout',
        'call_analysis_language' => 'callAnalysisLanguage',
        'priority' => 'priority',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'version' => 'setVersion',
        'contact_list' => 'setContactList',
        'queue' => 'setQueue',
        'dialing_mode' => 'setDialingMode',
        'script' => 'setScript',
        'edge_group' => 'setEdgeGroup',
        'campaign_status' => 'setCampaignStatus',
        'phone_columns' => 'setPhoneColumns',
        'abandon_rate' => 'setAbandonRate',
        'dnc_lists' => 'setDncLists',
        'callable_time_set' => 'setCallableTimeSet',
        'call_analysis_response_set' => 'setCallAnalysisResponseSet',
        'errors' => 'setErrors',
        'caller_name' => 'setCallerName',
        'caller_address' => 'setCallerAddress',
        'outbound_line_count' => 'setOutboundLineCount',
        'rule_sets' => 'setRuleSets',
        'skip_preview_disabled' => 'setSkipPreviewDisabled',
        'preview_time_out_seconds' => 'setPreviewTimeOutSeconds',
        'contact_sort' => 'setContactSort',
        'no_answer_timeout' => 'setNoAnswerTimeout',
        'call_analysis_language' => 'setCallAnalysisLanguage',
        'priority' => 'setPriority',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'version' => 'getVersion',
        'contact_list' => 'getContactList',
        'queue' => 'getQueue',
        'dialing_mode' => 'getDialingMode',
        'script' => 'getScript',
        'edge_group' => 'getEdgeGroup',
        'campaign_status' => 'getCampaignStatus',
        'phone_columns' => 'getPhoneColumns',
        'abandon_rate' => 'getAbandonRate',
        'dnc_lists' => 'getDncLists',
        'callable_time_set' => 'getCallableTimeSet',
        'call_analysis_response_set' => 'getCallAnalysisResponseSet',
        'errors' => 'getErrors',
        'caller_name' => 'getCallerName',
        'caller_address' => 'getCallerAddress',
        'outbound_line_count' => 'getOutboundLineCount',
        'rule_sets' => 'getRuleSets',
        'skip_preview_disabled' => 'getSkipPreviewDisabled',
        'preview_time_out_seconds' => 'getPreviewTimeOutSeconds',
        'contact_sort' => 'getContactSort',
        'no_answer_timeout' => 'getNoAnswerTimeout',
        'call_analysis_language' => 'getCallAnalysisLanguage',
        'priority' => 'getPriority',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DIALING_MODE_AGENTLESS = 'agentless';
    const DIALING_MODE_PREVIEW = 'preview';
    const DIALING_MODE_POWER = 'power';
    const DIALING_MODE_PREDICTIVE = 'predictive';
    const DIALING_MODE_PROGRESSIVE = 'progressive';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDialingModeAllowableValues()
    {
        return [
            self::DIALING_MODE_AGENTLESS,
            self::DIALING_MODE_PREVIEW,
            self::DIALING_MODE_POWER,
            self::DIALING_MODE_PREDICTIVE,
            self::DIALING_MODE_PROGRESSIVE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['contact_list'] = isset($data['contact_list']) ? $data['contact_list'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['dialing_mode'] = isset($data['dialing_mode']) ? $data['dialing_mode'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['edge_group'] = isset($data['edge_group']) ? $data['edge_group'] : null;
        $this->container['campaign_status'] = isset($data['campaign_status']) ? $data['campaign_status'] : null;
        $this->container['phone_columns'] = isset($data['phone_columns']) ? $data['phone_columns'] : null;
        $this->container['abandon_rate'] = isset($data['abandon_rate']) ? $data['abandon_rate'] : null;
        $this->container['dnc_lists'] = isset($data['dnc_lists']) ? $data['dnc_lists'] : null;
        $this->container['callable_time_set'] = isset($data['callable_time_set']) ? $data['callable_time_set'] : null;
        $this->container['call_analysis_response_set'] = isset($data['call_analysis_response_set']) ? $data['call_analysis_response_set'] : null;
        $this->container['errors'] = isset($data['errors']) ? $data['errors'] : null;
        $this->container['caller_name'] = isset($data['caller_name']) ? $data['caller_name'] : null;
        $this->container['caller_address'] = isset($data['caller_address']) ? $data['caller_address'] : null;
        $this->container['outbound_line_count'] = isset($data['outbound_line_count']) ? $data['outbound_line_count'] : null;
        $this->container['rule_sets'] = isset($data['rule_sets']) ? $data['rule_sets'] : null;
        $this->container['skip_preview_disabled'] = isset($data['skip_preview_disabled']) ? $data['skip_preview_disabled'] : false;
        $this->container['preview_time_out_seconds'] = isset($data['preview_time_out_seconds']) ? $data['preview_time_out_seconds'] : null;
        $this->container['contact_sort'] = isset($data['contact_sort']) ? $data['contact_sort'] : null;
        $this->container['no_answer_timeout'] = isset($data['no_answer_timeout']) ? $data['no_answer_timeout'] : null;
        $this->container['call_analysis_language'] = isset($data['call_analysis_language']) ? $data['call_analysis_language'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['contact_list'] === null) {
            $invalid_properties[] = "'contact_list' can't be null";
        }
        if ($this->container['queue'] === null) {
            $invalid_properties[] = "'queue' can't be null";
        }
        if ($this->container['dialing_mode'] === null) {
            $invalid_properties[] = "'dialing_mode' can't be null";
        }
        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive");
        if (!in_array($this->container['dialing_mode'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dialing_mode', must be one of #{allowed_values}.";
        }

        if ($this->container['script'] === null) {
            $invalid_properties[] = "'script' can't be null";
        }
        if ($this->container['edge_group'] === null) {
            $invalid_properties[] = "'edge_group' can't be null";
        }
        if ($this->container['campaign_status'] === null) {
            $invalid_properties[] = "'campaign_status' can't be null";
        }
        if ($this->container['phone_columns'] === null) {
            $invalid_properties[] = "'phone_columns' can't be null";
        }
        if ($this->container['call_analysis_response_set'] === null) {
            $invalid_properties[] = "'call_analysis_response_set' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['contact_list'] === null) {
            return false;
        }
        if ($this->container['queue'] === null) {
            return false;
        }
        if ($this->container['dialing_mode'] === null) {
            return false;
        }
        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive");
        if (!in_array($this->container['dialing_mode'], $allowed_values)) {
            return false;
        }
        if ($this->container['script'] === null) {
            return false;
        }
        if ($this->container['edge_group'] === null) {
            return false;
        }
        if ($this->container['campaign_status'] === null) {
            return false;
        }
        if ($this->container['phone_columns'] === null) {
            return false;
        }
        if ($this->container['call_analysis_response_set'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets contact_list
     * @return \PureCloudSDK\UriReference
     */
    public function getContactList()
    {
        return $this->container['contact_list'];
    }

    /**
     * Sets contact_list
     * @param \PureCloudSDK\UriReference $contact_list identifier of the contact list for the campaign
     * @return $this
     */
    public function setContactList($contact_list)
    {
        $this->container['contact_list'] = $contact_list;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue identifier of the agent assignment queue, required for all dialing modes other than agentless
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets dialing_mode
     * @return string
     */
    public function getDialingMode()
    {
        return $this->container['dialing_mode'];
    }

    /**
     * Sets dialing_mode
     * @param string $dialing_mode dialing mode of the campaign
     * @return $this
     */
    public function setDialingMode($dialing_mode)
    {
        $allowed_values = array('agentless', 'preview', 'power', 'predictive', 'progressive');
        if (!in_array($dialing_mode, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dialing_mode', must be one of 'agentless', 'preview', 'power', 'predictive', 'progressive'");
        }
        $this->container['dialing_mode'] = $dialing_mode;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\UriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\UriReference $script identifier of the campaign script, required for all dialing modes other than agentless
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets edge_group
     * @return \PureCloudSDK\UriReference
     */
    public function getEdgeGroup()
    {
        return $this->container['edge_group'];
    }

    /**
     * Sets edge_group
     * @param \PureCloudSDK\UriReference $edge_group identifier of the edge group, required for all dialing modes other than preview
     * @return $this
     */
    public function setEdgeGroup($edge_group)
    {
        $this->container['edge_group'] = $edge_group;

        return $this;
    }

    /**
     * Gets campaign_status
     * @return string
     */
    public function getCampaignStatus()
    {
        return $this->container['campaign_status'];
    }

    /**
     * Sets campaign_status
     * @param string $campaign_status status of the campaign; can be set to 'on' or 'off'
     * @return $this
     */
    public function setCampaignStatus($campaign_status)
    {
        $this->container['campaign_status'] = $campaign_status;

        return $this;
    }

    /**
     * Gets phone_columns
     * @return \PureCloudSDK\PhoneColumn[]
     */
    public function getPhoneColumns()
    {
        return $this->container['phone_columns'];
    }

    /**
     * Sets phone_columns
     * @param \PureCloudSDK\PhoneColumn[] $phone_columns the contact list phone columns to be called for the campaign
     * @return $this
     */
    public function setPhoneColumns($phone_columns)
    {
        $this->container['phone_columns'] = $phone_columns;

        return $this;
    }

    /**
     * Gets abandon_rate
     * @return double
     */
    public function getAbandonRate()
    {
        return $this->container['abandon_rate'];
    }

    /**
     * Sets abandon_rate
     * @param double $abandon_rate the targeted abandon rate percentage
     * @return $this
     */
    public function setAbandonRate($abandon_rate)
    {
        $this->container['abandon_rate'] = $abandon_rate;

        return $this;
    }

    /**
     * Gets dnc_lists
     * @return \PureCloudSDK\UriReference[]
     */
    public function getDncLists()
    {
        return $this->container['dnc_lists'];
    }

    /**
     * Sets dnc_lists
     * @param \PureCloudSDK\UriReference[] $dnc_lists identifiers of the do not call lists
     * @return $this
     */
    public function setDncLists($dnc_lists)
    {
        $this->container['dnc_lists'] = $dnc_lists;

        return $this;
    }

    /**
     * Gets callable_time_set
     * @return \PureCloudSDK\UriReference
     */
    public function getCallableTimeSet()
    {
        return $this->container['callable_time_set'];
    }

    /**
     * Sets callable_time_set
     * @param \PureCloudSDK\UriReference $callable_time_set the identifier of the callable time set
     * @return $this
     */
    public function setCallableTimeSet($callable_time_set)
    {
        $this->container['callable_time_set'] = $callable_time_set;

        return $this;
    }

    /**
     * Gets call_analysis_response_set
     * @return \PureCloudSDK\UriReference
     */
    public function getCallAnalysisResponseSet()
    {
        return $this->container['call_analysis_response_set'];
    }

    /**
     * Sets call_analysis_response_set
     * @param \PureCloudSDK\UriReference $call_analysis_response_set the identifier of the call analysis response set, required for all dialing modes other than preview
     * @return $this
     */
    public function setCallAnalysisResponseSet($call_analysis_response_set)
    {
        $this->container['call_analysis_response_set'] = $call_analysis_response_set;

        return $this;
    }

    /**
     * Gets errors
     * @return \PureCloudSDK\RestErrorDetail[]
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     * @param \PureCloudSDK\RestErrorDetail[] $errors a list of current error conditions associated with the campaign
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets caller_name
     * @return string
     */
    public function getCallerName()
    {
        return $this->container['caller_name'];
    }

    /**
     * Sets caller_name
     * @param string $caller_name caller id name to be displayed on the outbound call
     * @return $this
     */
    public function setCallerName($caller_name)
    {
        $this->container['caller_name'] = $caller_name;

        return $this;
    }

    /**
     * Gets caller_address
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['caller_address'];
    }

    /**
     * Sets caller_address
     * @param string $caller_address caller id phone number to be displayed on the outbound call
     * @return $this
     */
    public function setCallerAddress($caller_address)
    {
        $this->container['caller_address'] = $caller_address;

        return $this;
    }

    /**
     * Gets outbound_line_count
     * @return int
     */
    public function getOutboundLineCount()
    {
        return $this->container['outbound_line_count'];
    }

    /**
     * Sets outbound_line_count
     * @param int $outbound_line_count for agentless campaigns, the number of outbound lines to be concurrently dialed
     * @return $this
     */
    public function setOutboundLineCount($outbound_line_count)
    {
        $this->container['outbound_line_count'] = $outbound_line_count;

        return $this;
    }

    /**
     * Gets rule_sets
     * @return \PureCloudSDK\UriReference[]
     */
    public function getRuleSets()
    {
        return $this->container['rule_sets'];
    }

    /**
     * Sets rule_sets
     * @param \PureCloudSDK\UriReference[] $rule_sets identifiers of the rule sets
     * @return $this
     */
    public function setRuleSets($rule_sets)
    {
        $this->container['rule_sets'] = $rule_sets;

        return $this;
    }

    /**
     * Gets skip_preview_disabled
     * @return bool
     */
    public function getSkipPreviewDisabled()
    {
        return $this->container['skip_preview_disabled'];
    }

    /**
     * Sets skip_preview_disabled
     * @param bool $skip_preview_disabled for preview campaigns, indicator of whether the agent can skip a preview without placing a call
     * @return $this
     */
    public function setSkipPreviewDisabled($skip_preview_disabled)
    {
        $this->container['skip_preview_disabled'] = $skip_preview_disabled;

        return $this;
    }

    /**
     * Gets preview_time_out_seconds
     * @return int
     */
    public function getPreviewTimeOutSeconds()
    {
        return $this->container['preview_time_out_seconds'];
    }

    /**
     * Sets preview_time_out_seconds
     * @param int $preview_time_out_seconds for preview campaigns, number of seconds before a call will be automatically placed. A value of 0 indicates no automatic placement of calls
     * @return $this
     */
    public function setPreviewTimeOutSeconds($preview_time_out_seconds)
    {
        $this->container['preview_time_out_seconds'] = $preview_time_out_seconds;

        return $this;
    }

    /**
     * Gets contact_sort
     * @return \PureCloudSDK\ContactSort
     */
    public function getContactSort()
    {
        return $this->container['contact_sort'];
    }

    /**
     * Sets contact_sort
     * @param \PureCloudSDK\ContactSort $contact_sort information determining the order in which the contacts will be dialed
     * @return $this
     */
    public function setContactSort($contact_sort)
    {
        $this->container['contact_sort'] = $contact_sort;

        return $this;
    }

    /**
     * Gets no_answer_timeout
     * @return int
     */
    public function getNoAnswerTimeout()
    {
        return $this->container['no_answer_timeout'];
    }

    /**
     * Sets no_answer_timeout
     * @param int $no_answer_timeout for non-preview campaigns, how long to wait before dispositioning as 'no-answer', default 30 seconds
     * @return $this
     */
    public function setNoAnswerTimeout($no_answer_timeout)
    {
        $this->container['no_answer_timeout'] = $no_answer_timeout;

        return $this;
    }

    /**
     * Gets call_analysis_language
     * @return string
     */
    public function getCallAnalysisLanguage()
    {
        return $this->container['call_analysis_language'];
    }

    /**
     * Sets call_analysis_language
     * @param string $call_analysis_language The language the edge will use to analyse the call
     * @return $this
     */
    public function setCallAnalysisLanguage($call_analysis_language)
    {
        $this->container['call_analysis_language'] = $call_analysis_language;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority of this campaign relative to other campaigns
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


