<?php
/**
 * CampaignDiagnostics
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignDiagnostics Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignDiagnostics implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignDiagnostics';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'callable_contacts' => '\PureCloudSDK\CallableContactsDiagnostic',
        'queue_utilization_diagnostic' => '\PureCloudSDK\QueueUtilizationDiagnostic',
        'rule_set_diagnostics' => '\PureCloudSDK\RuleSetDiagnostic[]',
        'outstanding_interactions_count' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'callable_contacts' => 'callableContacts',
        'queue_utilization_diagnostic' => 'queueUtilizationDiagnostic',
        'rule_set_diagnostics' => 'ruleSetDiagnostics',
        'outstanding_interactions_count' => 'outstandingInteractionsCount'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'callable_contacts' => 'setCallableContacts',
        'queue_utilization_diagnostic' => 'setQueueUtilizationDiagnostic',
        'rule_set_diagnostics' => 'setRuleSetDiagnostics',
        'outstanding_interactions_count' => 'setOutstandingInteractionsCount'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'callable_contacts' => 'getCallableContacts',
        'queue_utilization_diagnostic' => 'getQueueUtilizationDiagnostic',
        'rule_set_diagnostics' => 'getRuleSetDiagnostics',
        'outstanding_interactions_count' => 'getOutstandingInteractionsCount'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['callable_contacts'] = isset($data['callable_contacts']) ? $data['callable_contacts'] : null;
        $this->container['queue_utilization_diagnostic'] = isset($data['queue_utilization_diagnostic']) ? $data['queue_utilization_diagnostic'] : null;
        $this->container['rule_set_diagnostics'] = isset($data['rule_set_diagnostics']) ? $data['rule_set_diagnostics'] : null;
        $this->container['outstanding_interactions_count'] = isset($data['outstanding_interactions_count']) ? $data['outstanding_interactions_count'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets callable_contacts
     * @return \PureCloudSDK\CallableContactsDiagnostic
     */
    public function getCallableContacts()
    {
        return $this->container['callable_contacts'];
    }

    /**
     * Sets callable_contacts
     * @param \PureCloudSDK\CallableContactsDiagnostic $callable_contacts Campaign properties that can impact which contacts are callable
     * @return $this
     */
    public function setCallableContacts($callable_contacts)
    {
        $this->container['callable_contacts'] = $callable_contacts;

        return $this;
    }

    /**
     * Gets queue_utilization_diagnostic
     * @return \PureCloudSDK\QueueUtilizationDiagnostic
     */
    public function getQueueUtilizationDiagnostic()
    {
        return $this->container['queue_utilization_diagnostic'];
    }

    /**
     * Sets queue_utilization_diagnostic
     * @param \PureCloudSDK\QueueUtilizationDiagnostic $queue_utilization_diagnostic Information regarding the campaign's queue
     * @return $this
     */
    public function setQueueUtilizationDiagnostic($queue_utilization_diagnostic)
    {
        $this->container['queue_utilization_diagnostic'] = $queue_utilization_diagnostic;

        return $this;
    }

    /**
     * Gets rule_set_diagnostics
     * @return \PureCloudSDK\RuleSetDiagnostic[]
     */
    public function getRuleSetDiagnostics()
    {
        return $this->container['rule_set_diagnostics'];
    }

    /**
     * Sets rule_set_diagnostics
     * @param \PureCloudSDK\RuleSetDiagnostic[] $rule_set_diagnostics Information regarding the campaign's rule sets
     * @return $this
     */
    public function setRuleSetDiagnostics($rule_set_diagnostics)
    {
        $this->container['rule_set_diagnostics'] = $rule_set_diagnostics;

        return $this;
    }

    /**
     * Gets outstanding_interactions_count
     * @return int
     */
    public function getOutstandingInteractionsCount()
    {
        return $this->container['outstanding_interactions_count'];
    }

    /**
     * Sets outstanding_interactions_count
     * @param int $outstanding_interactions_count Current number of outstanding interactions on the campaign
     * @return $this
     */
    public function setOutstandingInteractionsCount($outstanding_interactions_count)
    {
        $this->container['outstanding_interactions_count'] = $outstanding_interactions_count;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


