<?php
/**
 * CampaignInteraction
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignInteraction Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignInteraction implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignInteraction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'campaign' => '\PureCloudSDK\UriReference',
        'agent' => '\PureCloudSDK\UriReference',
        'contact' => '\PureCloudSDK\UriReference',
        'destination_address' => 'string',
        'active_preview_call' => 'bool',
        'last_active_preview_wrapup_time' => '\DateTime',
        'creation_time' => '\DateTime',
        'call_placed_time' => '\DateTime',
        'call_routed_time' => '\DateTime',
        'preview_connected_time' => '\DateTime',
        'queue' => '\PureCloudSDK\UriReference',
        'script' => '\PureCloudSDK\UriReference',
        'disposition' => 'string',
        'caller_name' => 'string',
        'caller_address' => 'string',
        'preview_pop_delivered_time' => '\DateTime',
        'conversation' => '\PureCloudSDK\Conversation',
        'dialer_system_participant_id' => 'string',
        'dialing_mode' => 'string',
        'skills' => '\PureCloudSDK\UriReference[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'campaign' => 'campaign',
        'agent' => 'agent',
        'contact' => 'contact',
        'destination_address' => 'destinationAddress',
        'active_preview_call' => 'activePreviewCall',
        'last_active_preview_wrapup_time' => 'lastActivePreviewWrapupTime',
        'creation_time' => 'creationTime',
        'call_placed_time' => 'callPlacedTime',
        'call_routed_time' => 'callRoutedTime',
        'preview_connected_time' => 'previewConnectedTime',
        'queue' => 'queue',
        'script' => 'script',
        'disposition' => 'disposition',
        'caller_name' => 'callerName',
        'caller_address' => 'callerAddress',
        'preview_pop_delivered_time' => 'previewPopDeliveredTime',
        'conversation' => 'conversation',
        'dialer_system_participant_id' => 'dialerSystemParticipantId',
        'dialing_mode' => 'dialingMode',
        'skills' => 'skills'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'campaign' => 'setCampaign',
        'agent' => 'setAgent',
        'contact' => 'setContact',
        'destination_address' => 'setDestinationAddress',
        'active_preview_call' => 'setActivePreviewCall',
        'last_active_preview_wrapup_time' => 'setLastActivePreviewWrapupTime',
        'creation_time' => 'setCreationTime',
        'call_placed_time' => 'setCallPlacedTime',
        'call_routed_time' => 'setCallRoutedTime',
        'preview_connected_time' => 'setPreviewConnectedTime',
        'queue' => 'setQueue',
        'script' => 'setScript',
        'disposition' => 'setDisposition',
        'caller_name' => 'setCallerName',
        'caller_address' => 'setCallerAddress',
        'preview_pop_delivered_time' => 'setPreviewPopDeliveredTime',
        'conversation' => 'setConversation',
        'dialer_system_participant_id' => 'setDialerSystemParticipantId',
        'dialing_mode' => 'setDialingMode',
        'skills' => 'setSkills'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'campaign' => 'getCampaign',
        'agent' => 'getAgent',
        'contact' => 'getContact',
        'destination_address' => 'getDestinationAddress',
        'active_preview_call' => 'getActivePreviewCall',
        'last_active_preview_wrapup_time' => 'getLastActivePreviewWrapupTime',
        'creation_time' => 'getCreationTime',
        'call_placed_time' => 'getCallPlacedTime',
        'call_routed_time' => 'getCallRoutedTime',
        'preview_connected_time' => 'getPreviewConnectedTime',
        'queue' => 'getQueue',
        'script' => 'getScript',
        'disposition' => 'getDisposition',
        'caller_name' => 'getCallerName',
        'caller_address' => 'getCallerAddress',
        'preview_pop_delivered_time' => 'getPreviewPopDeliveredTime',
        'conversation' => 'getConversation',
        'dialer_system_participant_id' => 'getDialerSystemParticipantId',
        'dialing_mode' => 'getDialingMode',
        'skills' => 'getSkills'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DISPOSITION_DISCONNECT = 'DISCONNECT';
    const DISPOSITION_LIVE_VOICE = 'LIVE_VOICE';
    const DISPOSITION_BUSY = 'BUSY';
    const DISPOSITION_MACHINE = 'MACHINE';
    const DISPOSITION_NO_ANSWER = 'NO_ANSWER';
    const DISPOSITION_SIT_CALLABLE = 'SIT_CALLABLE';
    const DISPOSITION_SIT_UNCALLABLE = 'SIT_UNCALLABLE';
    const DISPOSITION_FAX = 'FAX';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDispositionAllowableValues()
    {
        return [
            self::DISPOSITION_DISCONNECT,
            self::DISPOSITION_LIVE_VOICE,
            self::DISPOSITION_BUSY,
            self::DISPOSITION_MACHINE,
            self::DISPOSITION_NO_ANSWER,
            self::DISPOSITION_SIT_CALLABLE,
            self::DISPOSITION_SIT_UNCALLABLE,
            self::DISPOSITION_FAX,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['campaign'] = isset($data['campaign']) ? $data['campaign'] : null;
        $this->container['agent'] = isset($data['agent']) ? $data['agent'] : null;
        $this->container['contact'] = isset($data['contact']) ? $data['contact'] : null;
        $this->container['destination_address'] = isset($data['destination_address']) ? $data['destination_address'] : null;
        $this->container['active_preview_call'] = isset($data['active_preview_call']) ? $data['active_preview_call'] : false;
        $this->container['last_active_preview_wrapup_time'] = isset($data['last_active_preview_wrapup_time']) ? $data['last_active_preview_wrapup_time'] : null;
        $this->container['creation_time'] = isset($data['creation_time']) ? $data['creation_time'] : null;
        $this->container['call_placed_time'] = isset($data['call_placed_time']) ? $data['call_placed_time'] : null;
        $this->container['call_routed_time'] = isset($data['call_routed_time']) ? $data['call_routed_time'] : null;
        $this->container['preview_connected_time'] = isset($data['preview_connected_time']) ? $data['preview_connected_time'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['disposition'] = isset($data['disposition']) ? $data['disposition'] : null;
        $this->container['caller_name'] = isset($data['caller_name']) ? $data['caller_name'] : null;
        $this->container['caller_address'] = isset($data['caller_address']) ? $data['caller_address'] : null;
        $this->container['preview_pop_delivered_time'] = isset($data['preview_pop_delivered_time']) ? $data['preview_pop_delivered_time'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['dialer_system_participant_id'] = isset($data['dialer_system_participant_id']) ? $data['dialer_system_participant_id'] : null;
        $this->container['dialing_mode'] = isset($data['dialing_mode']) ? $data['dialing_mode'] : null;
        $this->container['skills'] = isset($data['skills']) ? $data['skills'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("DISCONNECT", "LIVE_VOICE", "BUSY", "MACHINE", "NO_ANSWER", "SIT_CALLABLE", "SIT_UNCALLABLE", "FAX");
        if (!in_array($this->container['disposition'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disposition', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("DISCONNECT", "LIVE_VOICE", "BUSY", "MACHINE", "NO_ANSWER", "SIT_CALLABLE", "SIT_UNCALLABLE", "FAX");
        if (!in_array($this->container['disposition'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets campaign
     * @return \PureCloudSDK\UriReference
     */
    public function getCampaign()
    {
        return $this->container['campaign'];
    }

    /**
     * Sets campaign
     * @param \PureCloudSDK\UriReference $campaign
     * @return $this
     */
    public function setCampaign($campaign)
    {
        $this->container['campaign'] = $campaign;

        return $this;
    }

    /**
     * Gets agent
     * @return \PureCloudSDK\UriReference
     */
    public function getAgent()
    {
        return $this->container['agent'];
    }

    /**
     * Sets agent
     * @param \PureCloudSDK\UriReference $agent
     * @return $this
     */
    public function setAgent($agent)
    {
        $this->container['agent'] = $agent;

        return $this;
    }

    /**
     * Gets contact
     * @return \PureCloudSDK\UriReference
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     * @param \PureCloudSDK\UriReference $contact
     * @return $this
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets destination_address
     * @return string
     */
    public function getDestinationAddress()
    {
        return $this->container['destination_address'];
    }

    /**
     * Sets destination_address
     * @param string $destination_address
     * @return $this
     */
    public function setDestinationAddress($destination_address)
    {
        $this->container['destination_address'] = $destination_address;

        return $this;
    }

    /**
     * Gets active_preview_call
     * @return bool
     */
    public function getActivePreviewCall()
    {
        return $this->container['active_preview_call'];
    }

    /**
     * Sets active_preview_call
     * @param bool $active_preview_call Boolean value if there is an active preview call on the interaction
     * @return $this
     */
    public function setActivePreviewCall($active_preview_call)
    {
        $this->container['active_preview_call'] = $active_preview_call;

        return $this;
    }

    /**
     * Gets last_active_preview_wrapup_time
     * @return \DateTime
     */
    public function getLastActivePreviewWrapupTime()
    {
        return $this->container['last_active_preview_wrapup_time'];
    }

    /**
     * Sets last_active_preview_wrapup_time
     * @param \DateTime $last_active_preview_wrapup_time The time when the last preview of the interaction was wrapped up. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLastActivePreviewWrapupTime($last_active_preview_wrapup_time)
    {
        $this->container['last_active_preview_wrapup_time'] = $last_active_preview_wrapup_time;

        return $this;
    }

    /**
     * Gets creation_time
     * @return \DateTime
     */
    public function getCreationTime()
    {
        return $this->container['creation_time'];
    }

    /**
     * Sets creation_time
     * @param \DateTime $creation_time The time when dialer created the interaction. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreationTime($creation_time)
    {
        $this->container['creation_time'] = $creation_time;

        return $this;
    }

    /**
     * Gets call_placed_time
     * @return \DateTime
     */
    public function getCallPlacedTime()
    {
        return $this->container['call_placed_time'];
    }

    /**
     * Sets call_placed_time
     * @param \DateTime $call_placed_time The time when the agent or system places the call. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallPlacedTime($call_placed_time)
    {
        $this->container['call_placed_time'] = $call_placed_time;

        return $this;
    }

    /**
     * Gets call_routed_time
     * @return \DateTime
     */
    public function getCallRoutedTime()
    {
        return $this->container['call_routed_time'];
    }

    /**
     * Sets call_routed_time
     * @param \DateTime $call_routed_time The time when the agent was connected to the call. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallRoutedTime($call_routed_time)
    {
        $this->container['call_routed_time'] = $call_routed_time;

        return $this;
    }

    /**
     * Gets preview_connected_time
     * @return \DateTime
     */
    public function getPreviewConnectedTime()
    {
        return $this->container['preview_connected_time'];
    }

    /**
     * Sets preview_connected_time
     * @param \DateTime $preview_connected_time The time when the customer and routing participant are connected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setPreviewConnectedTime($preview_connected_time)
    {
        $this->container['preview_connected_time'] = $preview_connected_time;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\UriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\UriReference $script
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets disposition
     * @return string
     */
    public function getDisposition()
    {
        return $this->container['disposition'];
    }

    /**
     * Sets disposition
     * @param string $disposition Describes what happened with call analysis for instance: disposition.classification.callable.person, disposition.classification.callable.noanswer
     * @return $this
     */
    public function setDisposition($disposition)
    {
        $allowed_values = array('DISCONNECT', 'LIVE_VOICE', 'BUSY', 'MACHINE', 'NO_ANSWER', 'SIT_CALLABLE', 'SIT_UNCALLABLE', 'FAX');
        if (!in_array($disposition, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disposition', must be one of 'DISCONNECT', 'LIVE_VOICE', 'BUSY', 'MACHINE', 'NO_ANSWER', 'SIT_CALLABLE', 'SIT_UNCALLABLE', 'FAX'");
        }
        $this->container['disposition'] = $disposition;

        return $this;
    }

    /**
     * Gets caller_name
     * @return string
     */
    public function getCallerName()
    {
        return $this->container['caller_name'];
    }

    /**
     * Sets caller_name
     * @param string $caller_name
     * @return $this
     */
    public function setCallerName($caller_name)
    {
        $this->container['caller_name'] = $caller_name;

        return $this;
    }

    /**
     * Gets caller_address
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['caller_address'];
    }

    /**
     * Sets caller_address
     * @param string $caller_address
     * @return $this
     */
    public function setCallerAddress($caller_address)
    {
        $this->container['caller_address'] = $caller_address;

        return $this;
    }

    /**
     * Gets preview_pop_delivered_time
     * @return \DateTime
     */
    public function getPreviewPopDeliveredTime()
    {
        return $this->container['preview_pop_delivered_time'];
    }

    /**
     * Sets preview_pop_delivered_time
     * @param \DateTime $preview_pop_delivered_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setPreviewPopDeliveredTime($preview_pop_delivered_time)
    {
        $this->container['preview_pop_delivered_time'] = $preview_pop_delivered_time;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets dialer_system_participant_id
     * @return string
     */
    public function getDialerSystemParticipantId()
    {
        return $this->container['dialer_system_participant_id'];
    }

    /**
     * Sets dialer_system_participant_id
     * @param string $dialer_system_participant_id conversation participant id that is the dialer system participant to monitor the call from dialer perspective
     * @return $this
     */
    public function setDialerSystemParticipantId($dialer_system_participant_id)
    {
        $this->container['dialer_system_participant_id'] = $dialer_system_participant_id;

        return $this;
    }

    /**
     * Gets dialing_mode
     * @return string
     */
    public function getDialingMode()
    {
        return $this->container['dialing_mode'];
    }

    /**
     * Sets dialing_mode
     * @param string $dialing_mode
     * @return $this
     */
    public function setDialingMode($dialing_mode)
    {
        $this->container['dialing_mode'] = $dialing_mode;

        return $this;
    }

    /**
     * Gets skills
     * @return \PureCloudSDK\UriReference[]
     */
    public function getSkills()
    {
        return $this->container['skills'];
    }

    /**
     * Sets skills
     * @param \PureCloudSDK\UriReference[] $skills Any skills that are attached to the call for routing
     * @return $this
     */
    public function setSkills($skills)
    {
        $this->container['skills'] = $skills;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


