<?php
/**
 * CampaignProgress
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignProgress Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignProgress implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignProgress';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'campaign' => '\PureCloudSDK\UriReference',
        'contact_list' => '\PureCloudSDK\UriReference',
        'number_of_contacts_called' => 'int',
        'total_number_of_contacts' => 'int',
        'percentage' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'campaign' => 'campaign',
        'contact_list' => 'contactList',
        'number_of_contacts_called' => 'numberOfContactsCalled',
        'total_number_of_contacts' => 'totalNumberOfContacts',
        'percentage' => 'percentage'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'campaign' => 'setCampaign',
        'contact_list' => 'setContactList',
        'number_of_contacts_called' => 'setNumberOfContactsCalled',
        'total_number_of_contacts' => 'setTotalNumberOfContacts',
        'percentage' => 'setPercentage'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'campaign' => 'getCampaign',
        'contact_list' => 'getContactList',
        'number_of_contacts_called' => 'getNumberOfContactsCalled',
        'total_number_of_contacts' => 'getTotalNumberOfContacts',
        'percentage' => 'getPercentage'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['campaign'] = isset($data['campaign']) ? $data['campaign'] : null;
        $this->container['contact_list'] = isset($data['contact_list']) ? $data['contact_list'] : null;
        $this->container['number_of_contacts_called'] = isset($data['number_of_contacts_called']) ? $data['number_of_contacts_called'] : null;
        $this->container['total_number_of_contacts'] = isset($data['total_number_of_contacts']) ? $data['total_number_of_contacts'] : null;
        $this->container['percentage'] = isset($data['percentage']) ? $data['percentage'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['campaign'] === null) {
            $invalid_properties[] = "'campaign' can't be null";
        }
        if ($this->container['contact_list'] === null) {
            $invalid_properties[] = "'contact_list' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['campaign'] === null) {
            return false;
        }
        if ($this->container['contact_list'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets campaign
     * @return \PureCloudSDK\UriReference
     */
    public function getCampaign()
    {
        return $this->container['campaign'];
    }

    /**
     * Sets campaign
     * @param \PureCloudSDK\UriReference $campaign Identifier of the campaign
     * @return $this
     */
    public function setCampaign($campaign)
    {
        $this->container['campaign'] = $campaign;

        return $this;
    }

    /**
     * Gets contact_list
     * @return \PureCloudSDK\UriReference
     */
    public function getContactList()
    {
        return $this->container['contact_list'];
    }

    /**
     * Sets contact_list
     * @param \PureCloudSDK\UriReference $contact_list Identifier of the contact list
     * @return $this
     */
    public function setContactList($contact_list)
    {
        $this->container['contact_list'] = $contact_list;

        return $this;
    }

    /**
     * Gets number_of_contacts_called
     * @return int
     */
    public function getNumberOfContactsCalled()
    {
        return $this->container['number_of_contacts_called'];
    }

    /**
     * Sets number_of_contacts_called
     * @param int $number_of_contacts_called Number of contacts processed during the campaign
     * @return $this
     */
    public function setNumberOfContactsCalled($number_of_contacts_called)
    {
        $this->container['number_of_contacts_called'] = $number_of_contacts_called;

        return $this;
    }

    /**
     * Gets total_number_of_contacts
     * @return int
     */
    public function getTotalNumberOfContacts()
    {
        return $this->container['total_number_of_contacts'];
    }

    /**
     * Sets total_number_of_contacts
     * @param int $total_number_of_contacts Total number of contacts in the campaign
     * @return $this
     */
    public function setTotalNumberOfContacts($total_number_of_contacts)
    {
        $this->container['total_number_of_contacts'] = $total_number_of_contacts;

        return $this;
    }

    /**
     * Gets percentage
     * @return int
     */
    public function getPercentage()
    {
        return $this->container['percentage'];
    }

    /**
     * Sets percentage
     * @param int $percentage Percentage of contacts processed during the campaign
     * @return $this
     */
    public function setPercentage($percentage)
    {
        $this->container['percentage'] = $percentage;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


