<?php
/**
 * CampaignStats
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignStats Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignStats implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignStats';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'contact_rate' => '\PureCloudSDK\ConnectRate',
        'idle_agents' => 'int',
        'adjusted_calls_per_agent' => 'double',
        'outstanding_calls' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'contact_rate' => 'contactRate',
        'idle_agents' => 'idleAgents',
        'adjusted_calls_per_agent' => 'adjustedCallsPerAgent',
        'outstanding_calls' => 'outstandingCalls'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'contact_rate' => 'setContactRate',
        'idle_agents' => 'setIdleAgents',
        'adjusted_calls_per_agent' => 'setAdjustedCallsPerAgent',
        'outstanding_calls' => 'setOutstandingCalls'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'contact_rate' => 'getContactRate',
        'idle_agents' => 'getIdleAgents',
        'adjusted_calls_per_agent' => 'getAdjustedCallsPerAgent',
        'outstanding_calls' => 'getOutstandingCalls'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['contact_rate'] = isset($data['contact_rate']) ? $data['contact_rate'] : null;
        $this->container['idle_agents'] = isset($data['idle_agents']) ? $data['idle_agents'] : null;
        $this->container['adjusted_calls_per_agent'] = isset($data['adjusted_calls_per_agent']) ? $data['adjusted_calls_per_agent'] : null;
        $this->container['outstanding_calls'] = isset($data['outstanding_calls']) ? $data['outstanding_calls'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets contact_rate
     * @return \PureCloudSDK\ConnectRate
     */
    public function getContactRate()
    {
        return $this->container['contact_rate'];
    }

    /**
     * Sets contact_rate
     * @param \PureCloudSDK\ConnectRate $contact_rate Information regarding the campaign's connect rate
     * @return $this
     */
    public function setContactRate($contact_rate)
    {
        $this->container['contact_rate'] = $contact_rate;

        return $this;
    }

    /**
     * Gets idle_agents
     * @return int
     */
    public function getIdleAgents()
    {
        return $this->container['idle_agents'];
    }

    /**
     * Sets idle_agents
     * @param int $idle_agents Number of available agents not currently being utilized
     * @return $this
     */
    public function setIdleAgents($idle_agents)
    {
        $this->container['idle_agents'] = $idle_agents;

        return $this;
    }

    /**
     * Gets adjusted_calls_per_agent
     * @return double
     */
    public function getAdjustedCallsPerAgent()
    {
        return $this->container['adjusted_calls_per_agent'];
    }

    /**
     * Sets adjusted_calls_per_agent
     * @param double $adjusted_calls_per_agent Calls per agent adjusted by pace
     * @return $this
     */
    public function setAdjustedCallsPerAgent($adjusted_calls_per_agent)
    {
        $this->container['adjusted_calls_per_agent'] = $adjusted_calls_per_agent;

        return $this;
    }

    /**
     * Gets outstanding_calls
     * @return int
     */
    public function getOutstandingCalls()
    {
        return $this->container['outstanding_calls'];
    }

    /**
     * Sets outstanding_calls
     * @param int $outstanding_calls Number of campaign calls currently ongoing
     * @return $this
     */
    public function setOutstandingCalls($outstanding_calls)
    {
        $this->container['outstanding_calls'] = $outstanding_calls;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


