<?php
/**
 * Cobrowsesession
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Cobrowsesession Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Cobrowsesession implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Cobrowsesession';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'id' => 'string',
        'disconnect_type' => 'string',
        'self' => '\PureCloudSDK\Address',
        'cobrowse_session_id' => 'string',
        'cobrowse_role' => 'string',
        'controlling' => 'string[]',
        'viewer_url' => 'string',
        'provider_event_time' => '\DateTime',
        'connected_time' => '\DateTime',
        'disconnected_time' => '\DateTime',
        'provider' => 'string',
        'segments' => '\PureCloudSDK\Segment[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'id' => 'id',
        'disconnect_type' => 'disconnectType',
        'self' => 'self',
        'cobrowse_session_id' => 'cobrowseSessionId',
        'cobrowse_role' => 'cobrowseRole',
        'controlling' => 'controlling',
        'viewer_url' => 'viewerUrl',
        'provider_event_time' => 'providerEventTime',
        'connected_time' => 'connectedTime',
        'disconnected_time' => 'disconnectedTime',
        'provider' => 'provider',
        'segments' => 'segments'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'id' => 'setId',
        'disconnect_type' => 'setDisconnectType',
        'self' => 'setSelf',
        'cobrowse_session_id' => 'setCobrowseSessionId',
        'cobrowse_role' => 'setCobrowseRole',
        'controlling' => 'setControlling',
        'viewer_url' => 'setViewerUrl',
        'provider_event_time' => 'setProviderEventTime',
        'connected_time' => 'setConnectedTime',
        'disconnected_time' => 'setDisconnectedTime',
        'provider' => 'setProvider',
        'segments' => 'setSegments'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'id' => 'getId',
        'disconnect_type' => 'getDisconnectType',
        'self' => 'getSelf',
        'cobrowse_session_id' => 'getCobrowseSessionId',
        'cobrowse_role' => 'getCobrowseRole',
        'controlling' => 'getControlling',
        'viewer_url' => 'getViewerUrl',
        'provider_event_time' => 'getProviderEventTime',
        'connected_time' => 'getConnectedTime',
        'disconnected_time' => 'getDisconnectedTime',
        'provider' => 'getProvider',
        'segments' => 'getSegments'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'ALERTING';
    const STATE_DIALING = 'DIALING';
    const STATE_CONTACTING = 'CONTACTING';
    const STATE_OFFERING = 'OFFERING';
    const STATE_CONNECTED = 'CONNECTED';
    const STATE_DISCONNECTED = 'DISCONNECTED';
    const STATE_TERMINATED = 'TERMINATED';
    const STATE_SCHEDULED = 'SCHEDULED';
    const STATE_NONE = 'NONE';
    const DISCONNECT_TYPE_ENDPOINT = 'ENDPOINT';
    const DISCONNECT_TYPE_CLIENT = 'CLIENT';
    const DISCONNECT_TYPE_SYSTEM = 'SYSTEM';
    const DISCONNECT_TYPE_TIMEOUT = 'TIMEOUT';
    const DISCONNECT_TYPE_TRANSFER = 'TRANSFER';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'TRANSFER_CONFERENCE';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'TRANSFER_CONSULT';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'TRANSFER_FORWARD';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'TRANSPORT_FAILURE';
    const DISCONNECT_TYPE_ERROR = 'ERROR';
    const DISCONNECT_TYPE_PEER = 'PEER';
    const DISCONNECT_TYPE_OTHER = 'OTHER';
    const DISCONNECT_TYPE_SPAM = 'SPAM';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_SCHEDULED,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['self'] = isset($data['self']) ? $data['self'] : null;
        $this->container['cobrowse_session_id'] = isset($data['cobrowse_session_id']) ? $data['cobrowse_session_id'] : null;
        $this->container['cobrowse_role'] = isset($data['cobrowse_role']) ? $data['cobrowse_role'] : null;
        $this->container['controlling'] = isset($data['controlling']) ? $data['controlling'] : null;
        $this->container['viewer_url'] = isset($data['viewer_url']) ? $data['viewer_url'] : null;
        $this->container['provider_event_time'] = isset($data['provider_event_time']) ? $data['provider_event_time'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['disconnected_time'] = isset($data['disconnected_time']) ? $data['disconnected_time'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "SCHEDULED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "SCHEDULED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The connection state of this communication.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'SCHEDULED', 'NONE');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'SCHEDULED', 'NONE'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A globally unique identifier for this communication.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets self
     * @return \PureCloudSDK\Address
     */
    public function getSelf()
    {
        return $this->container['self'];
    }

    /**
     * Sets self
     * @param \PureCloudSDK\Address $self Address and name data for a call endpoint.
     * @return $this
     */
    public function setSelf($self)
    {
        $this->container['self'] = $self;

        return $this;
    }

    /**
     * Gets cobrowse_session_id
     * @return string
     */
    public function getCobrowseSessionId()
    {
        return $this->container['cobrowse_session_id'];
    }

    /**
     * Sets cobrowse_session_id
     * @param string $cobrowse_session_id The co-browse session ID.
     * @return $this
     */
    public function setCobrowseSessionId($cobrowse_session_id)
    {
        $this->container['cobrowse_session_id'] = $cobrowse_session_id;

        return $this;
    }

    /**
     * Gets cobrowse_role
     * @return string
     */
    public function getCobrowseRole()
    {
        return $this->container['cobrowse_role'];
    }

    /**
     * Sets cobrowse_role
     * @param string $cobrowse_role This value identifies the role of the co-browse client within the co-browse session (a client is a sharer or a viewer).
     * @return $this
     */
    public function setCobrowseRole($cobrowse_role)
    {
        $this->container['cobrowse_role'] = $cobrowse_role;

        return $this;
    }

    /**
     * Gets controlling
     * @return string[]
     */
    public function getControlling()
    {
        return $this->container['controlling'];
    }

    /**
     * Sets controlling
     * @param string[] $controlling ID of co-browse participants for which this client has been granted control (list is empty if this client cannot control any shared pages).
     * @return $this
     */
    public function setControlling($controlling)
    {
        $this->container['controlling'] = $controlling;

        return $this;
    }

    /**
     * Gets viewer_url
     * @return string
     */
    public function getViewerUrl()
    {
        return $this->container['viewer_url'];
    }

    /**
     * Sets viewer_url
     * @param string $viewer_url The URL that can be used to open co-browse session in web browser.
     * @return $this
     */
    public function setViewerUrl($viewer_url)
    {
        $this->container['viewer_url'] = $viewer_url;

        return $this;
    }

    /**
     * Gets provider_event_time
     * @return \DateTime
     */
    public function getProviderEventTime()
    {
        return $this->container['provider_event_time'];
    }

    /**
     * Sets provider_event_time
     * @param \DateTime $provider_event_time The time when the provider event which triggered this conversation update happened in the corrected provider clock (milliseconds since 1970-01-01 00:00:00 UTC). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setProviderEventTime($provider_event_time)
    {
        $this->container['provider_event_time'] = $provider_event_time;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets disconnected_time
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnected_time'];
    }

    /**
     * Sets disconnected_time
     * @param \DateTime $disconnected_time The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDisconnectedTime($disconnected_time)
    {
        $this->container['disconnected_time'] = $disconnected_time;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the co-browse session.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\Segment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\Segment[] $segments The time line of the participant's call, divided into activity segments.
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


