<?php
/**
 * CommandStatus
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CommandStatus Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CommandStatus implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CommandStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'expiration' => '\DateTime',
        'user_id' => 'string',
        'status_code' => 'string',
        'command_type' => 'string',
        'document' => '\PureCloudSDK\Document',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'expiration' => 'expiration',
        'user_id' => 'userId',
        'status_code' => 'statusCode',
        'command_type' => 'commandType',
        'document' => 'document',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'expiration' => 'setExpiration',
        'user_id' => 'setUserId',
        'status_code' => 'setStatusCode',
        'command_type' => 'setCommandType',
        'document' => 'setDocument',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'expiration' => 'getExpiration',
        'user_id' => 'getUserId',
        'status_code' => 'getStatusCode',
        'command_type' => 'getCommandType',
        'document' => 'getDocument',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_CODE_INPROGRESS = 'INPROGRESS';
    const STATUS_CODE_COMPLETE = 'COMPLETE';
    const STATUS_CODE_ERROR = 'ERROR';
    const STATUS_CODE_CANCELING = 'CANCELING';
    const STATUS_CODE_CANCELED = 'CANCELED';
    const COMMAND_TYPE_UPLOAD = 'UPLOAD';
    const COMMAND_TYPE_COPYDOCUMENT = 'COPYDOCUMENT';
    const COMMAND_TYPE_MOVEDOCUMENT = 'MOVEDOCUMENT';
    const COMMAND_TYPE_DELETEWORKSPACE = 'DELETEWORKSPACE';
    const COMMAND_TYPE_DELETEDOCUMENT = 'DELETEDOCUMENT';
    const COMMAND_TYPE_DELETETAG = 'DELETETAG';
    const COMMAND_TYPE_UPDATETAG = 'UPDATETAG';
    const COMMAND_TYPE_REINDEX = 'REINDEX';
    const COMMAND_TYPE_CLEANUP = 'CLEANUP';
    const COMMAND_TYPE_REPLACEDOCUMENT = 'REPLACEDOCUMENT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusCodeAllowableValues()
    {
        return [
            self::STATUS_CODE_INPROGRESS,
            self::STATUS_CODE_COMPLETE,
            self::STATUS_CODE_ERROR,
            self::STATUS_CODE_CANCELING,
            self::STATUS_CODE_CANCELED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCommandTypeAllowableValues()
    {
        return [
            self::COMMAND_TYPE_UPLOAD,
            self::COMMAND_TYPE_COPYDOCUMENT,
            self::COMMAND_TYPE_MOVEDOCUMENT,
            self::COMMAND_TYPE_DELETEWORKSPACE,
            self::COMMAND_TYPE_DELETEDOCUMENT,
            self::COMMAND_TYPE_DELETETAG,
            self::COMMAND_TYPE_UPDATETAG,
            self::COMMAND_TYPE_REINDEX,
            self::COMMAND_TYPE_CLEANUP,
            self::COMMAND_TYPE_REPLACEDOCUMENT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['expiration'] = isset($data['expiration']) ? $data['expiration'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
        $this->container['status_code'] = isset($data['status_code']) ? $data['status_code'] : null;
        $this->container['command_type'] = isset($data['command_type']) ? $data['command_type'] : null;
        $this->container['document'] = isset($data['document']) ? $data['document'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("INPROGRESS", "COMPLETE", "ERROR", "CANCELING", "CANCELED");
        if (!in_array($this->container['status_code'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status_code', must be one of #{allowed_values}.";
        }

        $allowed_values = array("UPLOAD", "COPYDOCUMENT", "MOVEDOCUMENT", "DELETEWORKSPACE", "DELETEDOCUMENT", "DELETETAG", "UPDATETAG", "REINDEX", "CLEANUP", "REPLACEDOCUMENT");
        if (!in_array($this->container['command_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'command_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("INPROGRESS", "COMPLETE", "ERROR", "CANCELING", "CANCELED");
        if (!in_array($this->container['status_code'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("UPLOAD", "COPYDOCUMENT", "MOVEDOCUMENT", "DELETEWORKSPACE", "DELETEDOCUMENT", "DELETETAG", "UPDATETAG", "REINDEX", "CLEANUP", "REPLACEDOCUMENT");
        if (!in_array($this->container['command_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets expiration
     * @return \DateTime
     */
    public function getExpiration()
    {
        return $this->container['expiration'];
    }

    /**
     * Sets expiration
     * @param \DateTime $expiration Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExpiration($expiration)
    {
        $this->container['expiration'] = $expiration;

        return $this;
    }

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     * @param string $user_id
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets status_code
     * @return string
     */
    public function getStatusCode()
    {
        return $this->container['status_code'];
    }

    /**
     * Sets status_code
     * @param string $status_code
     * @return $this
     */
    public function setStatusCode($status_code)
    {
        $allowed_values = array('INPROGRESS', 'COMPLETE', 'ERROR', 'CANCELING', 'CANCELED');
        if (!in_array($status_code, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status_code', must be one of 'INPROGRESS', 'COMPLETE', 'ERROR', 'CANCELING', 'CANCELED'");
        }
        $this->container['status_code'] = $status_code;

        return $this;
    }

    /**
     * Gets command_type
     * @return string
     */
    public function getCommandType()
    {
        return $this->container['command_type'];
    }

    /**
     * Sets command_type
     * @param string $command_type
     * @return $this
     */
    public function setCommandType($command_type)
    {
        $allowed_values = array('UPLOAD', 'COPYDOCUMENT', 'MOVEDOCUMENT', 'DELETEWORKSPACE', 'DELETEDOCUMENT', 'DELETETAG', 'UPDATETAG', 'REINDEX', 'CLEANUP', 'REPLACEDOCUMENT');
        if (!in_array($command_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'command_type', must be one of 'UPLOAD', 'COPYDOCUMENT', 'MOVEDOCUMENT', 'DELETEWORKSPACE', 'DELETEDOCUMENT', 'DELETETAG', 'UPDATETAG', 'REINDEX', 'CLEANUP', 'REPLACEDOCUMENT'");
        }
        $this->container['command_type'] = $command_type;

        return $this;
    }

    /**
     * Gets document
     * @return \PureCloudSDK\Document
     */
    public function getDocument()
    {
        return $this->container['document'];
    }

    /**
     * Sets document
     * @param \PureCloudSDK\Document $document
     * @return $this
     */
    public function setDocument($document)
    {
        $this->container['document'] = $document;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


