<?php
/**
 * Condition
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Condition Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Condition implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Condition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'inverted' => 'bool',
        'attribute_name' => 'string',
        'value' => 'string',
        'value_type' => 'string',
        'operator' => 'string',
        'codes' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'inverted' => 'inverted',
        'attribute_name' => 'attributeName',
        'value' => 'value',
        'value_type' => 'valueType',
        'operator' => 'operator',
        'codes' => 'codes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'inverted' => 'setInverted',
        'attribute_name' => 'setAttributeName',
        'value' => 'setValue',
        'value_type' => 'setValueType',
        'operator' => 'setOperator',
        'codes' => 'setCodes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'inverted' => 'getInverted',
        'attribute_name' => 'getAttributeName',
        'value' => 'getValue',
        'value_type' => 'getValueType',
        'operator' => 'getOperator',
        'codes' => 'getCodes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_WRAPUP_CONDITION = 'wrapupCondition';
    const TYPE_CONTACT_ATTRIBUTE_CONDITION = 'contactAttributeCondition';
    const TYPE_PHONE_NUMBER_CONDITION = 'phoneNumberCondition';
    const TYPE_PHONE_NUMBER_TYPE_CONDITION = 'phoneNumberTypeCondition';
    const TYPE_CALL_ANALYSIS_CONDITION = 'callAnalysisCondition';
    const VALUE_TYPE_STRING = 'STRING';
    const VALUE_TYPE_NUMERIC = 'NUMERIC';
    const VALUE_TYPE_DATETIME = 'DATETIME';
    const VALUE_TYPE_PERIOD = 'PERIOD';
    const OPERATOR_EQUALS = 'EQUALS';
    const OPERATOR_LESS_THAN = 'LESS_THAN';
    const OPERATOR_LESS_THAN_EQUALS = 'LESS_THAN_EQUALS';
    const OPERATOR_GREATER_THAN = 'GREATER_THAN';
    const OPERATOR_GREATER_THAN_EQUALS = 'GREATER_THAN_EQUALS';
    const OPERATOR_CONTAINS = 'CONTAINS';
    const OPERATOR_BEGINS_WITH = 'BEGINS_WITH';
    const OPERATOR_ENDS_WITH = 'ENDS_WITH';
    const OPERATOR_BEFORE = 'BEFORE';
    const OPERATOR_AFTER = 'AFTER';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_WRAPUP_CONDITION,
            self::TYPE_CONTACT_ATTRIBUTE_CONDITION,
            self::TYPE_PHONE_NUMBER_CONDITION,
            self::TYPE_PHONE_NUMBER_TYPE_CONDITION,
            self::TYPE_CALL_ANALYSIS_CONDITION,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getValueTypeAllowableValues()
    {
        return [
            self::VALUE_TYPE_STRING,
            self::VALUE_TYPE_NUMERIC,
            self::VALUE_TYPE_DATETIME,
            self::VALUE_TYPE_PERIOD,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_EQUALS,
            self::OPERATOR_LESS_THAN,
            self::OPERATOR_LESS_THAN_EQUALS,
            self::OPERATOR_GREATER_THAN,
            self::OPERATOR_GREATER_THAN_EQUALS,
            self::OPERATOR_CONTAINS,
            self::OPERATOR_BEGINS_WITH,
            self::OPERATOR_ENDS_WITH,
            self::OPERATOR_BEFORE,
            self::OPERATOR_AFTER,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['inverted'] = isset($data['inverted']) ? $data['inverted'] : false;
        $this->container['attribute_name'] = isset($data['attribute_name']) ? $data['attribute_name'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['value_type'] = isset($data['value_type']) ? $data['value_type'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['codes'] = isset($data['codes']) ? $data['codes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("wrapupCondition", "contactAttributeCondition", "phoneNumberCondition", "phoneNumberTypeCondition", "callAnalysisCondition");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("STRING", "NUMERIC", "DATETIME", "PERIOD");
        if (!in_array($this->container['value_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'value_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("EQUALS", "LESS_THAN", "LESS_THAN_EQUALS", "GREATER_THAN", "GREATER_THAN_EQUALS", "CONTAINS", "BEGINS_WITH", "ENDS_WITH", "BEFORE", "AFTER");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("wrapupCondition", "contactAttributeCondition", "phoneNumberCondition", "phoneNumberTypeCondition", "callAnalysisCondition");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("STRING", "NUMERIC", "DATETIME", "PERIOD");
        if (!in_array($this->container['value_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("EQUALS", "LESS_THAN", "LESS_THAN_EQUALS", "GREATER_THAN", "GREATER_THAN_EQUALS", "CONTAINS", "BEGINS_WITH", "ENDS_WITH", "BEFORE", "AFTER");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of the condition
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('wrapupCondition', 'contactAttributeCondition', 'phoneNumberCondition', 'phoneNumberTypeCondition', 'callAnalysisCondition');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'wrapupCondition', 'contactAttributeCondition', 'phoneNumberCondition', 'phoneNumberTypeCondition', 'callAnalysisCondition'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets inverted
     * @return bool
     */
    public function getInverted()
    {
        return $this->container['inverted'];
    }

    /**
     * Sets inverted
     * @param bool $inverted Indicates whether to evaluate for the opposite of the stated condition; default is false
     * @return $this
     */
    public function setInverted($inverted)
    {
        $this->container['inverted'] = $inverted;

        return $this;
    }

    /**
     * Gets attribute_name
     * @return string
     */
    public function getAttributeName()
    {
        return $this->container['attribute_name'];
    }

    /**
     * Sets attribute_name
     * @param string $attribute_name An attribute name associated with the condition (applies only to certain rule conditions)
     * @return $this
     */
    public function setAttributeName($attribute_name)
    {
        $this->container['attribute_name'] = $attribute_name;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value A value associated with the condition
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets value_type
     * @return string
     */
    public function getValueType()
    {
        return $this->container['value_type'];
    }

    /**
     * Sets value_type
     * @param string $value_type Determines the type of the value associated with the condition
     * @return $this
     */
    public function setValueType($value_type)
    {
        $allowed_values = array('STRING', 'NUMERIC', 'DATETIME', 'PERIOD');
        if (!in_array($value_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'value_type', must be one of 'STRING', 'NUMERIC', 'DATETIME', 'PERIOD'");
        }
        $this->container['value_type'] = $value_type;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator An operation type for condition evaluation
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('EQUALS', 'LESS_THAN', 'LESS_THAN_EQUALS', 'GREATER_THAN', 'GREATER_THAN_EQUALS', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'EQUALS', 'LESS_THAN', 'LESS_THAN_EQUALS', 'GREATER_THAN', 'GREATER_THAN_EQUALS', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets codes
     * @return string[]
     */
    public function getCodes()
    {
        return $this->container['codes'];
    }

    /**
     * Sets codes
     * @param string[] $codes List of wrap-up code identifiers (used only in conditions of type 'wrapupCondition')
     * @return $this
     */
    public function setCodes($codes)
    {
        $this->container['codes'] = $codes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


