<?php
/**
 * ConversationNotificationCallbacks
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ConversationNotificationCallbacks Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationNotificationCallbacks implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationNotification_callbacks';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'id' => 'string',
        'direction' => 'string',
        'held' => 'bool',
        'disconnect_type' => 'string',
        'start_hold_time' => '\DateTime',
        'dialer_preview' => '\PureCloudSDK\ConversationNotificationDialerPreview',
        'callback_numbers' => 'string[]',
        'callback_user_name' => 'string',
        'script_id' => 'string',
        'skip_enabled' => 'bool',
        'provider' => 'string',
        'timeout_seconds' => 'int',
        'connected_time' => '\DateTime',
        'disconnected_time' => '\DateTime',
        'callback_scheduled_time' => '\DateTime',
        'additional_properties' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'id' => 'id',
        'direction' => 'direction',
        'held' => 'held',
        'disconnect_type' => 'disconnectType',
        'start_hold_time' => 'startHoldTime',
        'dialer_preview' => 'dialerPreview',
        'callback_numbers' => 'callbackNumbers',
        'callback_user_name' => 'callbackUserName',
        'script_id' => 'scriptId',
        'skip_enabled' => 'skipEnabled',
        'provider' => 'provider',
        'timeout_seconds' => 'timeoutSeconds',
        'connected_time' => 'connectedTime',
        'disconnected_time' => 'disconnectedTime',
        'callback_scheduled_time' => 'callbackScheduledTime',
        'additional_properties' => 'additionalProperties'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'id' => 'setId',
        'direction' => 'setDirection',
        'held' => 'setHeld',
        'disconnect_type' => 'setDisconnectType',
        'start_hold_time' => 'setStartHoldTime',
        'dialer_preview' => 'setDialerPreview',
        'callback_numbers' => 'setCallbackNumbers',
        'callback_user_name' => 'setCallbackUserName',
        'script_id' => 'setScriptId',
        'skip_enabled' => 'setSkipEnabled',
        'provider' => 'setProvider',
        'timeout_seconds' => 'setTimeoutSeconds',
        'connected_time' => 'setConnectedTime',
        'disconnected_time' => 'setDisconnectedTime',
        'callback_scheduled_time' => 'setCallbackScheduledTime',
        'additional_properties' => 'setAdditionalProperties'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'id' => 'getId',
        'direction' => 'getDirection',
        'held' => 'getHeld',
        'disconnect_type' => 'getDisconnectType',
        'start_hold_time' => 'getStartHoldTime',
        'dialer_preview' => 'getDialerPreview',
        'callback_numbers' => 'getCallbackNumbers',
        'callback_user_name' => 'getCallbackUserName',
        'script_id' => 'getScriptId',
        'skip_enabled' => 'getSkipEnabled',
        'provider' => 'getProvider',
        'timeout_seconds' => 'getTimeoutSeconds',
        'connected_time' => 'getConnectedTime',
        'disconnected_time' => 'getDisconnectedTime',
        'callback_scheduled_time' => 'getCallbackScheduledTime',
        'additional_properties' => 'getAdditionalProperties'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'ALERTING';
    const STATE_DIALING = 'DIALING';
    const STATE_CONTACTING = 'CONTACTING';
    const STATE_OFFERING = 'OFFERING';
    const STATE_CONNECTED = 'CONNECTED';
    const STATE_DISCONNECTED = 'DISCONNECTED';
    const STATE_TERMINATED = 'TERMINATED';
    const STATE_SCHEDULED = 'SCHEDULED';
    const STATE_NONE = 'NONE';
    const DIRECTION_INBOUND = 'INBOUND';
    const DIRECTION_OUTBOUND = 'OUTBOUND';
    const DISCONNECT_TYPE_ENDPOINT = 'ENDPOINT';
    const DISCONNECT_TYPE_CLIENT = 'CLIENT';
    const DISCONNECT_TYPE_SYSTEM = 'SYSTEM';
    const DISCONNECT_TYPE_TIMEOUT = 'TIMEOUT';
    const DISCONNECT_TYPE_TRANSFER = 'TRANSFER';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'TRANSFER_CONFERENCE';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'TRANSFER_CONSULT';
    const DISCONNECT_TYPE_TRANSFER_NOANSWER = 'TRANSFER_NOANSWER';
    const DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE = 'TRANSFER_NOTAVAILABLE';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'TRANSFER_FORWARD';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'TRANSPORT_FAILURE';
    const DISCONNECT_TYPE_ERROR = 'ERROR';
    const DISCONNECT_TYPE_PEER = 'PEER';
    const DISCONNECT_TYPE_OTHER = 'OTHER';
    const DISCONNECT_TYPE_SPAM = 'SPAM';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_SCHEDULED,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_NOANSWER,
            self::DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['start_hold_time'] = isset($data['start_hold_time']) ? $data['start_hold_time'] : null;
        $this->container['dialer_preview'] = isset($data['dialer_preview']) ? $data['dialer_preview'] : null;
        $this->container['callback_numbers'] = isset($data['callback_numbers']) ? $data['callback_numbers'] : null;
        $this->container['callback_user_name'] = isset($data['callback_user_name']) ? $data['callback_user_name'] : null;
        $this->container['script_id'] = isset($data['script_id']) ? $data['script_id'] : null;
        $this->container['skip_enabled'] = isset($data['skip_enabled']) ? $data['skip_enabled'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['timeout_seconds'] = isset($data['timeout_seconds']) ? $data['timeout_seconds'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['disconnected_time'] = isset($data['disconnected_time']) ? $data['disconnected_time'] : null;
        $this->container['callback_scheduled_time'] = isset($data['callback_scheduled_time']) ? $data['callback_scheduled_time'] : null;
        $this->container['additional_properties'] = isset($data['additional_properties']) ? $data['additional_properties'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "SCHEDULED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSFER_FORWARD", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "SCHEDULED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSFER_FORWARD", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'SCHEDULED', 'NONE');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'SCHEDULED', 'NONE'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('INBOUND', 'OUTBOUND');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'INBOUND', 'OUTBOUND'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSFER_FORWARD', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSFER_FORWARD', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets start_hold_time
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['start_hold_time'];
    }

    /**
     * Sets start_hold_time
     * @param \DateTime $start_hold_time
     * @return $this
     */
    public function setStartHoldTime($start_hold_time)
    {
        $this->container['start_hold_time'] = $start_hold_time;

        return $this;
    }

    /**
     * Gets dialer_preview
     * @return \PureCloudSDK\ConversationNotificationDialerPreview
     */
    public function getDialerPreview()
    {
        return $this->container['dialer_preview'];
    }

    /**
     * Sets dialer_preview
     * @param \PureCloudSDK\ConversationNotificationDialerPreview $dialer_preview
     * @return $this
     */
    public function setDialerPreview($dialer_preview)
    {
        $this->container['dialer_preview'] = $dialer_preview;

        return $this;
    }

    /**
     * Gets callback_numbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callback_numbers'];
    }

    /**
     * Sets callback_numbers
     * @param string[] $callback_numbers
     * @return $this
     */
    public function setCallbackNumbers($callback_numbers)
    {
        $this->container['callback_numbers'] = $callback_numbers;

        return $this;
    }

    /**
     * Gets callback_user_name
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callback_user_name'];
    }

    /**
     * Sets callback_user_name
     * @param string $callback_user_name
     * @return $this
     */
    public function setCallbackUserName($callback_user_name)
    {
        $this->container['callback_user_name'] = $callback_user_name;

        return $this;
    }

    /**
     * Gets script_id
     * @return string
     */
    public function getScriptId()
    {
        return $this->container['script_id'];
    }

    /**
     * Sets script_id
     * @param string $script_id
     * @return $this
     */
    public function setScriptId($script_id)
    {
        $this->container['script_id'] = $script_id;

        return $this;
    }

    /**
     * Gets skip_enabled
     * @return bool
     */
    public function getSkipEnabled()
    {
        return $this->container['skip_enabled'];
    }

    /**
     * Sets skip_enabled
     * @param bool $skip_enabled
     * @return $this
     */
    public function setSkipEnabled($skip_enabled)
    {
        $this->container['skip_enabled'] = $skip_enabled;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets timeout_seconds
     * @return int
     */
    public function getTimeoutSeconds()
    {
        return $this->container['timeout_seconds'];
    }

    /**
     * Sets timeout_seconds
     * @param int $timeout_seconds
     * @return $this
     */
    public function setTimeoutSeconds($timeout_seconds)
    {
        $this->container['timeout_seconds'] = $timeout_seconds;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets disconnected_time
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnected_time'];
    }

    /**
     * Sets disconnected_time
     * @param \DateTime $disconnected_time
     * @return $this
     */
    public function setDisconnectedTime($disconnected_time)
    {
        $this->container['disconnected_time'] = $disconnected_time;

        return $this;
    }

    /**
     * Gets callback_scheduled_time
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callback_scheduled_time'];
    }

    /**
     * Sets callback_scheduled_time
     * @param \DateTime $callback_scheduled_time
     * @return $this
     */
    public function setCallbackScheduledTime($callback_scheduled_time)
    {
        $this->container['callback_scheduled_time'] = $callback_scheduled_time;

        return $this;
    }

    /**
     * Gets additional_properties
     * @return object
     */
    public function getAdditionalProperties()
    {
        return $this->container['additional_properties'];
    }

    /**
     * Sets additional_properties
     * @param object $additional_properties
     * @return $this
     */
    public function setAdditionalProperties($additional_properties)
    {
        $this->container['additional_properties'] = $additional_properties;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


