<?php
/**
 * ConversationNotificationParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ConversationNotificationParticipant Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationNotificationParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationNotificationParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'connected_time' => '\DateTime',
        'end_time' => '\DateTime',
        'user_id' => 'string',
        'external_contact_id' => 'string',
        'external_organization_id' => 'string',
        'name' => 'string',
        'queue_id' => 'string',
        'group_id' => 'string',
        'purpose' => 'string',
        'consult_participant_id' => 'string',
        'address' => 'string',
        'wrapup_required' => 'bool',
        'wrapup_expected' => 'bool',
        'wrapup_prompt' => 'string',
        'wrapup_timeout_ms' => 'int',
        'wrapup' => '\PureCloudSDK\ConversationNotificationWrapup',
        'monitored_participant_id' => 'string',
        'attributes' => 'map[string,string]',
        'calls' => '\PureCloudSDK\ConversationNotificationCalls[]',
        'callbacks' => '\PureCloudSDK\ConversationNotificationCallbacks[]',
        'chats' => '\PureCloudSDK\ConversationNotificationChats[]',
        'cobrowsesessions' => '\PureCloudSDK\ConversationNotificationCobrowsesessions[]',
        'emails' => '\PureCloudSDK\ConversationNotificationEmails[]',
        'screen_shares' => '\PureCloudSDK\ConversationNotificationScreenShares[]',
        'social_expressions' => '\PureCloudSDK\ConversationNotificationSocialExpressions[]',
        'videos' => '\PureCloudSDK\ConversationNotificationVideos[]',
        'additional_properties' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'connected_time' => 'connectedTime',
        'end_time' => 'endTime',
        'user_id' => 'userId',
        'external_contact_id' => 'externalContactId',
        'external_organization_id' => 'externalOrganizationId',
        'name' => 'name',
        'queue_id' => 'queueId',
        'group_id' => 'groupId',
        'purpose' => 'purpose',
        'consult_participant_id' => 'consultParticipantId',
        'address' => 'address',
        'wrapup_required' => 'wrapupRequired',
        'wrapup_expected' => 'wrapupExpected',
        'wrapup_prompt' => 'wrapupPrompt',
        'wrapup_timeout_ms' => 'wrapupTimeoutMs',
        'wrapup' => 'wrapup',
        'monitored_participant_id' => 'monitoredParticipantId',
        'attributes' => 'attributes',
        'calls' => 'calls',
        'callbacks' => 'callbacks',
        'chats' => 'chats',
        'cobrowsesessions' => 'cobrowsesessions',
        'emails' => 'emails',
        'screen_shares' => 'screenShares',
        'social_expressions' => 'socialExpressions',
        'videos' => 'videos',
        'additional_properties' => 'additionalProperties'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'connected_time' => 'setConnectedTime',
        'end_time' => 'setEndTime',
        'user_id' => 'setUserId',
        'external_contact_id' => 'setExternalContactId',
        'external_organization_id' => 'setExternalOrganizationId',
        'name' => 'setName',
        'queue_id' => 'setQueueId',
        'group_id' => 'setGroupId',
        'purpose' => 'setPurpose',
        'consult_participant_id' => 'setConsultParticipantId',
        'address' => 'setAddress',
        'wrapup_required' => 'setWrapupRequired',
        'wrapup_expected' => 'setWrapupExpected',
        'wrapup_prompt' => 'setWrapupPrompt',
        'wrapup_timeout_ms' => 'setWrapupTimeoutMs',
        'wrapup' => 'setWrapup',
        'monitored_participant_id' => 'setMonitoredParticipantId',
        'attributes' => 'setAttributes',
        'calls' => 'setCalls',
        'callbacks' => 'setCallbacks',
        'chats' => 'setChats',
        'cobrowsesessions' => 'setCobrowsesessions',
        'emails' => 'setEmails',
        'screen_shares' => 'setScreenShares',
        'social_expressions' => 'setSocialExpressions',
        'videos' => 'setVideos',
        'additional_properties' => 'setAdditionalProperties'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'connected_time' => 'getConnectedTime',
        'end_time' => 'getEndTime',
        'user_id' => 'getUserId',
        'external_contact_id' => 'getExternalContactId',
        'external_organization_id' => 'getExternalOrganizationId',
        'name' => 'getName',
        'queue_id' => 'getQueueId',
        'group_id' => 'getGroupId',
        'purpose' => 'getPurpose',
        'consult_participant_id' => 'getConsultParticipantId',
        'address' => 'getAddress',
        'wrapup_required' => 'getWrapupRequired',
        'wrapup_expected' => 'getWrapupExpected',
        'wrapup_prompt' => 'getWrapupPrompt',
        'wrapup_timeout_ms' => 'getWrapupTimeoutMs',
        'wrapup' => 'getWrapup',
        'monitored_participant_id' => 'getMonitoredParticipantId',
        'attributes' => 'getAttributes',
        'calls' => 'getCalls',
        'callbacks' => 'getCallbacks',
        'chats' => 'getChats',
        'cobrowsesessions' => 'getCobrowsesessions',
        'emails' => 'getEmails',
        'screen_shares' => 'getScreenShares',
        'social_expressions' => 'getSocialExpressions',
        'videos' => 'getVideos',
        'additional_properties' => 'getAdditionalProperties'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['end_time'] = isset($data['end_time']) ? $data['end_time'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
        $this->container['external_contact_id'] = isset($data['external_contact_id']) ? $data['external_contact_id'] : null;
        $this->container['external_organization_id'] = isset($data['external_organization_id']) ? $data['external_organization_id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['queue_id'] = isset($data['queue_id']) ? $data['queue_id'] : null;
        $this->container['group_id'] = isset($data['group_id']) ? $data['group_id'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['consult_participant_id'] = isset($data['consult_participant_id']) ? $data['consult_participant_id'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['wrapup_required'] = isset($data['wrapup_required']) ? $data['wrapup_required'] : null;
        $this->container['wrapup_expected'] = isset($data['wrapup_expected']) ? $data['wrapup_expected'] : null;
        $this->container['wrapup_prompt'] = isset($data['wrapup_prompt']) ? $data['wrapup_prompt'] : null;
        $this->container['wrapup_timeout_ms'] = isset($data['wrapup_timeout_ms']) ? $data['wrapup_timeout_ms'] : null;
        $this->container['wrapup'] = isset($data['wrapup']) ? $data['wrapup'] : null;
        $this->container['monitored_participant_id'] = isset($data['monitored_participant_id']) ? $data['monitored_participant_id'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['calls'] = isset($data['calls']) ? $data['calls'] : null;
        $this->container['callbacks'] = isset($data['callbacks']) ? $data['callbacks'] : null;
        $this->container['chats'] = isset($data['chats']) ? $data['chats'] : null;
        $this->container['cobrowsesessions'] = isset($data['cobrowsesessions']) ? $data['cobrowsesessions'] : null;
        $this->container['emails'] = isset($data['emails']) ? $data['emails'] : null;
        $this->container['screen_shares'] = isset($data['screen_shares']) ? $data['screen_shares'] : null;
        $this->container['social_expressions'] = isset($data['social_expressions']) ? $data['social_expressions'] : null;
        $this->container['videos'] = isset($data['videos']) ? $data['videos'] : null;
        $this->container['additional_properties'] = isset($data['additional_properties']) ? $data['additional_properties'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets end_time
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time
     * @param \DateTime $end_time
     * @return $this
     */
    public function setEndTime($end_time)
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }

    /**
     * Gets user_id
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     * @param string $user_id
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets external_contact_id
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['external_contact_id'];
    }

    /**
     * Sets external_contact_id
     * @param string $external_contact_id
     * @return $this
     */
    public function setExternalContactId($external_contact_id)
    {
        $this->container['external_contact_id'] = $external_contact_id;

        return $this;
    }

    /**
     * Gets external_organization_id
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['external_organization_id'];
    }

    /**
     * Sets external_organization_id
     * @param string $external_organization_id
     * @return $this
     */
    public function setExternalOrganizationId($external_organization_id)
    {
        $this->container['external_organization_id'] = $external_organization_id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets queue_id
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queue_id'];
    }

    /**
     * Sets queue_id
     * @param string $queue_id
     * @return $this
     */
    public function setQueueId($queue_id)
    {
        $this->container['queue_id'] = $queue_id;

        return $this;
    }

    /**
     * Gets group_id
     * @return string
     */
    public function getGroupId()
    {
        return $this->container['group_id'];
    }

    /**
     * Sets group_id
     * @param string $group_id
     * @return $this
     */
    public function setGroupId($group_id)
    {
        $this->container['group_id'] = $group_id;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets consult_participant_id
     * @return string
     */
    public function getConsultParticipantId()
    {
        return $this->container['consult_participant_id'];
    }

    /**
     * Sets consult_participant_id
     * @param string $consult_participant_id
     * @return $this
     */
    public function setConsultParticipantId($consult_participant_id)
    {
        $this->container['consult_participant_id'] = $consult_participant_id;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets wrapup_required
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapup_required'];
    }

    /**
     * Sets wrapup_required
     * @param bool $wrapup_required
     * @return $this
     */
    public function setWrapupRequired($wrapup_required)
    {
        $this->container['wrapup_required'] = $wrapup_required;

        return $this;
    }

    /**
     * Gets wrapup_expected
     * @return bool
     */
    public function getWrapupExpected()
    {
        return $this->container['wrapup_expected'];
    }

    /**
     * Sets wrapup_expected
     * @param bool $wrapup_expected
     * @return $this
     */
    public function setWrapupExpected($wrapup_expected)
    {
        $this->container['wrapup_expected'] = $wrapup_expected;

        return $this;
    }

    /**
     * Gets wrapup_prompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapup_prompt'];
    }

    /**
     * Sets wrapup_prompt
     * @param string $wrapup_prompt
     * @return $this
     */
    public function setWrapupPrompt($wrapup_prompt)
    {
        $this->container['wrapup_prompt'] = $wrapup_prompt;

        return $this;
    }

    /**
     * Gets wrapup_timeout_ms
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapup_timeout_ms'];
    }

    /**
     * Sets wrapup_timeout_ms
     * @param int $wrapup_timeout_ms
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapup_timeout_ms)
    {
        $this->container['wrapup_timeout_ms'] = $wrapup_timeout_ms;

        return $this;
    }

    /**
     * Gets wrapup
     * @return \PureCloudSDK\ConversationNotificationWrapup
     */
    public function getWrapup()
    {
        return $this->container['wrapup'];
    }

    /**
     * Sets wrapup
     * @param \PureCloudSDK\ConversationNotificationWrapup $wrapup
     * @return $this
     */
    public function setWrapup($wrapup)
    {
        $this->container['wrapup'] = $wrapup;

        return $this;
    }

    /**
     * Gets monitored_participant_id
     * @return string
     */
    public function getMonitoredParticipantId()
    {
        return $this->container['monitored_participant_id'];
    }

    /**
     * Sets monitored_participant_id
     * @param string $monitored_participant_id
     * @return $this
     */
    public function setMonitoredParticipantId($monitored_participant_id)
    {
        $this->container['monitored_participant_id'] = $monitored_participant_id;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets calls
     * @return \PureCloudSDK\ConversationNotificationCalls[]
     */
    public function getCalls()
    {
        return $this->container['calls'];
    }

    /**
     * Sets calls
     * @param \PureCloudSDK\ConversationNotificationCalls[] $calls
     * @return $this
     */
    public function setCalls($calls)
    {
        $this->container['calls'] = $calls;

        return $this;
    }

    /**
     * Gets callbacks
     * @return \PureCloudSDK\ConversationNotificationCallbacks[]
     */
    public function getCallbacks()
    {
        return $this->container['callbacks'];
    }

    /**
     * Sets callbacks
     * @param \PureCloudSDK\ConversationNotificationCallbacks[] $callbacks
     * @return $this
     */
    public function setCallbacks($callbacks)
    {
        $this->container['callbacks'] = $callbacks;

        return $this;
    }

    /**
     * Gets chats
     * @return \PureCloudSDK\ConversationNotificationChats[]
     */
    public function getChats()
    {
        return $this->container['chats'];
    }

    /**
     * Sets chats
     * @param \PureCloudSDK\ConversationNotificationChats[] $chats
     * @return $this
     */
    public function setChats($chats)
    {
        $this->container['chats'] = $chats;

        return $this;
    }

    /**
     * Gets cobrowsesessions
     * @return \PureCloudSDK\ConversationNotificationCobrowsesessions[]
     */
    public function getCobrowsesessions()
    {
        return $this->container['cobrowsesessions'];
    }

    /**
     * Sets cobrowsesessions
     * @param \PureCloudSDK\ConversationNotificationCobrowsesessions[] $cobrowsesessions
     * @return $this
     */
    public function setCobrowsesessions($cobrowsesessions)
    {
        $this->container['cobrowsesessions'] = $cobrowsesessions;

        return $this;
    }

    /**
     * Gets emails
     * @return \PureCloudSDK\ConversationNotificationEmails[]
     */
    public function getEmails()
    {
        return $this->container['emails'];
    }

    /**
     * Sets emails
     * @param \PureCloudSDK\ConversationNotificationEmails[] $emails
     * @return $this
     */
    public function setEmails($emails)
    {
        $this->container['emails'] = $emails;

        return $this;
    }

    /**
     * Gets screen_shares
     * @return \PureCloudSDK\ConversationNotificationScreenShares[]
     */
    public function getScreenShares()
    {
        return $this->container['screen_shares'];
    }

    /**
     * Sets screen_shares
     * @param \PureCloudSDK\ConversationNotificationScreenShares[] $screen_shares
     * @return $this
     */
    public function setScreenShares($screen_shares)
    {
        $this->container['screen_shares'] = $screen_shares;

        return $this;
    }

    /**
     * Gets social_expressions
     * @return \PureCloudSDK\ConversationNotificationSocialExpressions[]
     */
    public function getSocialExpressions()
    {
        return $this->container['social_expressions'];
    }

    /**
     * Sets social_expressions
     * @param \PureCloudSDK\ConversationNotificationSocialExpressions[] $social_expressions
     * @return $this
     */
    public function setSocialExpressions($social_expressions)
    {
        $this->container['social_expressions'] = $social_expressions;

        return $this;
    }

    /**
     * Gets videos
     * @return \PureCloudSDK\ConversationNotificationVideos[]
     */
    public function getVideos()
    {
        return $this->container['videos'];
    }

    /**
     * Sets videos
     * @param \PureCloudSDK\ConversationNotificationVideos[] $videos
     * @return $this
     */
    public function setVideos($videos)
    {
        $this->container['videos'] = $videos;

        return $this;
    }

    /**
     * Gets additional_properties
     * @return object
     */
    public function getAdditionalProperties()
    {
        return $this->container['additional_properties'];
    }

    /**
     * Sets additional_properties
     * @param object $additional_properties
     * @return $this
     */
    public function setAdditionalProperties($additional_properties)
    {
        $this->container['additional_properties'] = $additional_properties;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


