<?php
/**
 * ConversationNotificationVideos
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ConversationNotificationVideos Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationNotificationVideos implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationNotification_videos';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'self' => '\PureCloudSDK\ConversationNotificationAddress',
        'id' => 'string',
        'context' => 'string',
        'audio_muted' => 'bool',
        'video_muted' => 'bool',
        'sharing_screen' => 'bool',
        'provider' => 'string',
        'disconnect_type' => 'string',
        'connected_time' => '\DateTime',
        'disconnected_time' => '\DateTime',
        'additional_properties' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'self' => 'self',
        'id' => 'id',
        'context' => 'context',
        'audio_muted' => 'audioMuted',
        'video_muted' => 'videoMuted',
        'sharing_screen' => 'sharingScreen',
        'provider' => 'provider',
        'disconnect_type' => 'disconnectType',
        'connected_time' => 'connectedTime',
        'disconnected_time' => 'disconnectedTime',
        'additional_properties' => 'additionalProperties'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'self' => 'setSelf',
        'id' => 'setId',
        'context' => 'setContext',
        'audio_muted' => 'setAudioMuted',
        'video_muted' => 'setVideoMuted',
        'sharing_screen' => 'setSharingScreen',
        'provider' => 'setProvider',
        'disconnect_type' => 'setDisconnectType',
        'connected_time' => 'setConnectedTime',
        'disconnected_time' => 'setDisconnectedTime',
        'additional_properties' => 'setAdditionalProperties'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'self' => 'getSelf',
        'id' => 'getId',
        'context' => 'getContext',
        'audio_muted' => 'getAudioMuted',
        'video_muted' => 'getVideoMuted',
        'sharing_screen' => 'getSharingScreen',
        'provider' => 'getProvider',
        'disconnect_type' => 'getDisconnectType',
        'connected_time' => 'getConnectedTime',
        'disconnected_time' => 'getDisconnectedTime',
        'additional_properties' => 'getAdditionalProperties'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'ALERTING';
    const STATE_DIALING = 'DIALING';
    const STATE_CONTACTING = 'CONTACTING';
    const STATE_OFFERING = 'OFFERING';
    const STATE_CONNECTED = 'CONNECTED';
    const STATE_DISCONNECTED = 'DISCONNECTED';
    const STATE_TERMINATED = 'TERMINATED';
    const STATE_NONE = 'NONE';
    const DISCONNECT_TYPE_ENDPOINT = 'ENDPOINT';
    const DISCONNECT_TYPE_CLIENT = 'CLIENT';
    const DISCONNECT_TYPE_SYSTEM = 'SYSTEM';
    const DISCONNECT_TYPE_TIMEOUT = 'TIMEOUT';
    const DISCONNECT_TYPE_TRANSFER = 'TRANSFER';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'TRANSFER_CONFERENCE';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'TRANSFER_CONSULT';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'TRANSFER_FORWARD';
    const DISCONNECT_TYPE_TRANSFER_NOANSWER = 'TRANSFER_NOANSWER';
    const DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE = 'TRANSFER_NOTAVAILABLE';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'TRANSPORT_FAILURE';
    const DISCONNECT_TYPE_ERROR = 'ERROR';
    const DISCONNECT_TYPE_PEER = 'PEER';
    const DISCONNECT_TYPE_OTHER = 'OTHER';
    const DISCONNECT_TYPE_SPAM = 'SPAM';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSFER_NOANSWER,
            self::DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['self'] = isset($data['self']) ? $data['self'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['context'] = isset($data['context']) ? $data['context'] : null;
        $this->container['audio_muted'] = isset($data['audio_muted']) ? $data['audio_muted'] : null;
        $this->container['video_muted'] = isset($data['video_muted']) ? $data['video_muted'] : null;
        $this->container['sharing_screen'] = isset($data['sharing_screen']) ? $data['sharing_screen'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['disconnected_time'] = isset($data['disconnected_time']) ? $data['disconnected_time'] : null;
        $this->container['additional_properties'] = isset($data['additional_properties']) ? $data['additional_properties'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'NONE');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'ALERTING', 'DIALING', 'CONTACTING', 'OFFERING', 'CONNECTED', 'DISCONNECTED', 'TERMINATED', 'NONE'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets self
     * @return \PureCloudSDK\ConversationNotificationAddress
     */
    public function getSelf()
    {
        return $this->container['self'];
    }

    /**
     * Sets self
     * @param \PureCloudSDK\ConversationNotificationAddress $self
     * @return $this
     */
    public function setSelf($self)
    {
        $this->container['self'] = $self;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets context
     * @return string
     */
    public function getContext()
    {
        return $this->container['context'];
    }

    /**
     * Sets context
     * @param string $context
     * @return $this
     */
    public function setContext($context)
    {
        $this->container['context'] = $context;

        return $this;
    }

    /**
     * Gets audio_muted
     * @return bool
     */
    public function getAudioMuted()
    {
        return $this->container['audio_muted'];
    }

    /**
     * Sets audio_muted
     * @param bool $audio_muted
     * @return $this
     */
    public function setAudioMuted($audio_muted)
    {
        $this->container['audio_muted'] = $audio_muted;

        return $this;
    }

    /**
     * Gets video_muted
     * @return bool
     */
    public function getVideoMuted()
    {
        return $this->container['video_muted'];
    }

    /**
     * Sets video_muted
     * @param bool $video_muted
     * @return $this
     */
    public function setVideoMuted($video_muted)
    {
        $this->container['video_muted'] = $video_muted;

        return $this;
    }

    /**
     * Gets sharing_screen
     * @return bool
     */
    public function getSharingScreen()
    {
        return $this->container['sharing_screen'];
    }

    /**
     * Sets sharing_screen
     * @param bool $sharing_screen
     * @return $this
     */
    public function setSharingScreen($sharing_screen)
    {
        $this->container['sharing_screen'] = $sharing_screen;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets disconnected_time
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnected_time'];
    }

    /**
     * Sets disconnected_time
     * @param \DateTime $disconnected_time
     * @return $this
     */
    public function setDisconnectedTime($disconnected_time)
    {
        $this->container['disconnected_time'] = $disconnected_time;

        return $this;
    }

    /**
     * Gets additional_properties
     * @return object
     */
    public function getAdditionalProperties()
    {
        return $this->container['additional_properties'];
    }

    /**
     * Sets additional_properties
     * @param object $additional_properties
     * @return $this
     */
    public function setAdditionalProperties($additional_properties)
    {
        $this->container['additional_properties'] = $additional_properties;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


