<?php
/**
 * ConversationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ConversationQuery Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'conversation_filters' => '\PureCloudSDK\AnalyticsQueryFilter[]',
        'evaluation_filters' => '\PureCloudSDK\AnalyticsQueryFilter[]',
        'segment_filters' => '\PureCloudSDK\AnalyticsQueryFilter[]',
        'aggregations' => '\PureCloudSDK\AnalyticsQueryAggregation[]',
        'paging' => '\PureCloudSDK\PagingSpec',
        'order' => 'string',
        'order_by' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'conversation_filters' => 'conversationFilters',
        'evaluation_filters' => 'evaluationFilters',
        'segment_filters' => 'segmentFilters',
        'aggregations' => 'aggregations',
        'paging' => 'paging',
        'order' => 'order',
        'order_by' => 'orderBy'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'conversation_filters' => 'setConversationFilters',
        'evaluation_filters' => 'setEvaluationFilters',
        'segment_filters' => 'setSegmentFilters',
        'aggregations' => 'setAggregations',
        'paging' => 'setPaging',
        'order' => 'setOrder',
        'order_by' => 'setOrderBy'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'conversation_filters' => 'getConversationFilters',
        'evaluation_filters' => 'getEvaluationFilters',
        'segment_filters' => 'getSegmentFilters',
        'aggregations' => 'getAggregations',
        'paging' => 'getPaging',
        'order' => 'getOrder',
        'order_by' => 'getOrderBy'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ORDER_ASC = 'asc';
    const ORDER_DESC = 'desc';
    const ORDER_BY_CONVERSATION_START = 'conversationStart';
    const ORDER_BY_SEGMENT_START = 'segmentStart';
    const ORDER_BY_SEGMENT_END = 'segmentEnd';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOrderAllowableValues()
    {
        return [
            self::ORDER_ASC,
            self::ORDER_DESC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOrderByAllowableValues()
    {
        return [
            self::ORDER_BY_CONVERSATION_START,
            self::ORDER_BY_SEGMENT_START,
            self::ORDER_BY_SEGMENT_END,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['conversation_filters'] = isset($data['conversation_filters']) ? $data['conversation_filters'] : null;
        $this->container['evaluation_filters'] = isset($data['evaluation_filters']) ? $data['evaluation_filters'] : null;
        $this->container['segment_filters'] = isset($data['segment_filters']) ? $data['segment_filters'] : null;
        $this->container['aggregations'] = isset($data['aggregations']) ? $data['aggregations'] : null;
        $this->container['paging'] = isset($data['paging']) ? $data['paging'] : null;
        $this->container['order'] = isset($data['order']) ? $data['order'] : null;
        $this->container['order_by'] = isset($data['order_by']) ? $data['order_by'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("asc", "desc");
        if (!in_array($this->container['order'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'order', must be one of #{allowed_values}.";
        }

        $allowed_values = array("conversationStart", "segmentStart", "segmentEnd");
        if (!in_array($this->container['order_by'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'order_by', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("asc", "desc");
        if (!in_array($this->container['order'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("conversationStart", "segmentStart", "segmentEnd");
        if (!in_array($this->container['order_by'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Specifies the date and time range of data being queried. Conversations MUST have started within this time range to potentially be included within the result set. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets conversation_filters
     * @return \PureCloudSDK\AnalyticsQueryFilter[]
     */
    public function getConversationFilters()
    {
        return $this->container['conversation_filters'];
    }

    /**
     * Sets conversation_filters
     * @param \PureCloudSDK\AnalyticsQueryFilter[] $conversation_filters Filters that target conversation-level data
     * @return $this
     */
    public function setConversationFilters($conversation_filters)
    {
        $this->container['conversation_filters'] = $conversation_filters;

        return $this;
    }

    /**
     * Gets evaluation_filters
     * @return \PureCloudSDK\AnalyticsQueryFilter[]
     */
    public function getEvaluationFilters()
    {
        return $this->container['evaluation_filters'];
    }

    /**
     * Sets evaluation_filters
     * @param \PureCloudSDK\AnalyticsQueryFilter[] $evaluation_filters Filters that target quality management evaluation-level data
     * @return $this
     */
    public function setEvaluationFilters($evaluation_filters)
    {
        $this->container['evaluation_filters'] = $evaluation_filters;

        return $this;
    }

    /**
     * Gets segment_filters
     * @return \PureCloudSDK\AnalyticsQueryFilter[]
     */
    public function getSegmentFilters()
    {
        return $this->container['segment_filters'];
    }

    /**
     * Sets segment_filters
     * @param \PureCloudSDK\AnalyticsQueryFilter[] $segment_filters Filters that target individual segments within a conversation
     * @return $this
     */
    public function setSegmentFilters($segment_filters)
    {
        $this->container['segment_filters'] = $segment_filters;

        return $this;
    }

    /**
     * Gets aggregations
     * @return \PureCloudSDK\AnalyticsQueryAggregation[]
     */
    public function getAggregations()
    {
        return $this->container['aggregations'];
    }

    /**
     * Sets aggregations
     * @param \PureCloudSDK\AnalyticsQueryAggregation[] $aggregations Include faceted search and aggregate roll-ups describing your search results. This does not function as a filter, but rather, summary data about the data matching your filters
     * @return $this
     */
    public function setAggregations($aggregations)
    {
        $this->container['aggregations'] = $aggregations;

        return $this;
    }

    /**
     * Gets paging
     * @return \PureCloudSDK\PagingSpec
     */
    public function getPaging()
    {
        return $this->container['paging'];
    }

    /**
     * Sets paging
     * @param \PureCloudSDK\PagingSpec $paging Page size and number to control iterating through large result sets. Default page size is 25
     * @return $this
     */
    public function setPaging($paging)
    {
        $this->container['paging'] = $paging;

        return $this;
    }

    /**
     * Gets order
     * @return string
     */
    public function getOrder()
    {
        return $this->container['order'];
    }

    /**
     * Sets order
     * @param string $order Sort the result set in ascending/descending order. Default is ascending
     * @return $this
     */
    public function setOrder($order)
    {
        $allowed_values = array('asc', 'desc');
        if (!in_array($order, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'order', must be one of 'asc', 'desc'");
        }
        $this->container['order'] = $order;

        return $this;
    }

    /**
     * Gets order_by
     * @return string
     */
    public function getOrderBy()
    {
        return $this->container['order_by'];
    }

    /**
     * Sets order_by
     * @param string $order_by Specify which data element within the result set to use for sorting. The options  to use as a basis for sorting the results: conversationStart, segmentStart, and segmentEnd. If not specified, the default is conversationStart
     * @return $this
     */
    public function setOrderBy($order_by)
    {
        $allowed_values = array('conversationStart', 'segmentStart', 'segmentEnd');
        if (!in_array($order_by, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'order_by', must be one of 'conversationStart', 'segmentStart', 'segmentEnd'");
        }
        $this->container['order_by'] = $order_by;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


