<?php
/**
 * ConversationsApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \PureCloudSDK\Configuration;
use \PureCloudSDK\ApiClient;
use \PureCloudSDK\ApiException;
use \PureCloudSDK\ObjectSerializer;

/**
 * ConversationsApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ConversationsApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.com');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return ConversationsApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteCallsCallIdParticipantsParticipantIdConsult
     *
     * Cancel the transfer
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @return string
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteCallsCallIdParticipantsParticipantIdConsult($call_id, $participant_id)
    {
        list($response) = $this->deleteCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($call_id, $participant_id);
        return $response;
    }

    /**
     * Operation deleteCallsCallIdParticipantsParticipantIdConsultWithHttpInfo
     *
     * Cancel the transfer
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($call_id, $participant_id)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling deleteCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling deleteCallsCallIdParticipantsParticipantIdConsult');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/consult";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode
     *
     * Delete a code used to add a communication to this participant
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param string $add_communication_code addCommunicationCode (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversation_id, $participant_id, $add_communication_code)
    {
        list($response) = $this->deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcodeWithHttpInfo($conversation_id, $participant_id, $add_communication_code);
        return $response;
    }

    /**
     * Operation deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcodeWithHttpInfo
     *
     * Delete a code used to add a communication to this participant
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param string $add_communication_code addCommunicationCode (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcodeWithHttpInfo($conversation_id, $participant_id, $add_communication_code)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode');
        }
        // verify the required parameter 'add_communication_code' is set
        if ($add_communication_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $add_communication_code when calling deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // path params
        if ($add_communication_code !== null) {
            $resourcePath = str_replace(
                "{" . "addCommunicationCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($add_communication_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId
     *
     * Delete attachment from draft
     *
     * @param string $email_id emailId (required)
     * @param string $attachment_id attachmentId (required)
     * @return string
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId($email_id, $attachment_id)
    {
        list($response) = $this->deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentIdWithHttpInfo($email_id, $attachment_id);
        return $response;
    }

    /**
     * Operation deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentIdWithHttpInfo
     *
     * Delete attachment from draft
     *
     * @param string $email_id emailId (required)
     * @param string $attachment_id attachmentId (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentIdWithHttpInfo($email_id, $attachment_id)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId');
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $attachment_id when calling deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = str_replace(
                "{" . "attachmentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($attachment_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacks
     *
     * Get callback conversations
     *
     * @return \PureCloudSDK\CallbackConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacks()
    {
        list($response) = $this->getCallbacksWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCallbacksWithHttpInfo
     *
     * Get callback conversations
     *
     * @return Array of \PureCloudSDK\CallbackConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallbackConversationEntityListing',
                '/api/v2/conversations/callbacks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallbackConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallbackConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacksCallbackId
     *
     * Get callback conversation
     *
     * @param string $callback_id callbackId (required)
     * @return \PureCloudSDK\CallbackConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackId($callback_id)
    {
        list($response) = $this->getCallbacksCallbackIdWithHttpInfo($callback_id);
        return $response;
    }

    /**
     * Operation getCallbacksCallbackIdWithHttpInfo
     *
     * Get callback conversation
     *
     * @param string $callback_id callbackId (required)
     * @return Array of \PureCloudSDK\CallbackConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdWithHttpInfo($callback_id)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling getCallbacksCallbackId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallbackConversation',
                '/api/v2/conversations/callbacks/{callbackId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallbackConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallbackConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapup($callback_id, $participant_id, $provisional = null)
    {
        list($response) = $this->getCallbacksCallbackIdParticipantsParticipantIdWrapupWithHttpInfo($callback_id, $participant_id, $provisional);
        return $response;
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapupWithHttpInfo($callback_id, $participant_id, $provisional = null)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling getCallbacksCallbackIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getCallbacksCallbackIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes($callback_id, $participant_id)
    {
        list($response) = $this->getCallbacksCallbackIdParticipantsParticipantIdWrapupcodesWithHttpInfo($callback_id, $participant_id);
        return $response;
    }

    /**
     * Operation getCallbacksCallbackIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallbacksCallbackIdParticipantsParticipantIdWrapupcodesWithHttpInfo($callback_id, $participant_id)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCalls
     *
     * Get recent conversations
     *
     * @return \PureCloudSDK\CallConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCalls()
    {
        list($response) = $this->getCallsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCallsWithHttpInfo
     *
     * Get recent conversations
     *
     * @return Array of \PureCloudSDK\CallConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallConversationEntityListing',
                '/api/v2/conversations/calls'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsCallId
     *
     * Get call conversation
     *
     * @param string $call_id callId (required)
     * @return \PureCloudSDK\CallConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallId($call_id)
    {
        list($response) = $this->getCallsCallIdWithHttpInfo($call_id);
        return $response;
    }

    /**
     * Operation getCallsCallIdWithHttpInfo
     *
     * Get call conversation
     *
     * @param string $call_id callId (required)
     * @return Array of \PureCloudSDK\CallConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdWithHttpInfo($call_id)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling getCallsCallId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallConversation',
                '/api/v2/conversations/calls/{callId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapup($call_id, $participant_id, $provisional = null)
    {
        list($response) = $this->getCallsCallIdParticipantsParticipantIdWrapupWithHttpInfo($call_id, $participant_id, $provisional);
        return $response;
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapupWithHttpInfo($call_id, $participant_id, $provisional = null)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling getCallsCallIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getCallsCallIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapupcodes($call_id, $participant_id)
    {
        list($response) = $this->getCallsCallIdParticipantsParticipantIdWrapupcodesWithHttpInfo($call_id, $participant_id);
        return $response;
    }

    /**
     * Operation getCallsCallIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsCallIdParticipantsParticipantIdWrapupcodesWithHttpInfo($call_id, $participant_id)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling getCallsCallIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getCallsCallIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsHistory
     *
     * Get call history
     *
     * @param int $page_size Page size (optional, default to 25)
     * @param int $page_number Page number (optional, default to 1)
     * @param string $interval Interval string; format is ISO-8601. Separate start and end times with forward slash &#39;/&#39; (optional)
     * @return \PureCloudSDK\CallConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsHistory($page_size = null, $page_number = null, $interval = null)
    {
        list($response) = $this->getCallsHistoryWithHttpInfo($page_size, $page_number, $interval);
        return $response;
    }

    /**
     * Operation getCallsHistoryWithHttpInfo
     *
     * Get call history
     *
     * @param int $page_size Page size (optional, default to 25)
     * @param int $page_number Page number (optional, default to 1)
     * @param string $interval Interval string; format is ISO-8601. Separate start and end times with forward slash &#39;/&#39; (optional)
     * @return Array of \PureCloudSDK\CallConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsHistoryWithHttpInfo($page_size = null, $page_number = null, $interval = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/history";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($page_size !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($page_size);
        }
        // query params
        if ($page_number !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($page_number);
        }
        // query params
        if ($interval !== null) {
            $queryParams['interval'] = $this->apiClient->getSerializer()->toQueryValue($interval);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CallConversationEntityListing',
                '/api/v2/conversations/calls/history'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CallConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CallConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCallsMaximumconferenceparties
     *
     * Get the maximum number of participants that this user can have on a conference
     *
     * @return \PureCloudSDK\MaxParticipants
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsMaximumconferenceparties()
    {
        list($response) = $this->getCallsMaximumconferencepartiesWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCallsMaximumconferencepartiesWithHttpInfo
     *
     * Get the maximum number of participants that this user can have on a conference
     *
     * @return Array of \PureCloudSDK\MaxParticipants, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCallsMaximumconferencepartiesWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/maximumconferenceparties";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\MaxParticipants',
                '/api/v2/conversations/calls/maximumconferenceparties'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\MaxParticipants', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\MaxParticipants', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChats
     *
     * Get recent chat conversations
     *
     * @return \PureCloudSDK\ChatConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChats()
    {
        list($response) = $this->getChatsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getChatsWithHttpInfo
     *
     * Get recent chat conversations
     *
     * @return Array of \PureCloudSDK\ChatConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ChatConversationEntityListing',
                '/api/v2/conversations/chats'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ChatConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ChatConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChatsChatId
     *
     * Get chat conversation
     *
     * @param string $chat_id chatId (required)
     * @return \PureCloudSDK\ChatConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatId($chat_id)
    {
        list($response) = $this->getChatsChatIdWithHttpInfo($chat_id);
        return $response;
    }

    /**
     * Operation getChatsChatIdWithHttpInfo
     *
     * Get chat conversation
     *
     * @param string $chat_id chatId (required)
     * @return Array of \PureCloudSDK\ChatConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdWithHttpInfo($chat_id)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling getChatsChatId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ChatConversation',
                '/api/v2/conversations/chats/{chatId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ChatConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ChatConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapup($chat_id, $participant_id, $provisional = null)
    {
        list($response) = $this->getChatsChatIdParticipantsParticipantIdWrapupWithHttpInfo($chat_id, $participant_id, $provisional);
        return $response;
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapupWithHttpInfo($chat_id, $participant_id, $provisional = null)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling getChatsChatIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getChatsChatIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapupcodes($chat_id, $participant_id)
    {
        list($response) = $this->getChatsChatIdParticipantsParticipantIdWrapupcodesWithHttpInfo($chat_id, $participant_id);
        return $response;
    }

    /**
     * Operation getChatsChatIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getChatsChatIdParticipantsParticipantIdWrapupcodesWithHttpInfo($chat_id, $participant_id)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling getChatsChatIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getChatsChatIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessions
     *
     * Get recent cobrowse conversations
     *
     * @return \PureCloudSDK\CobrowseConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessions()
    {
        list($response) = $this->getCobrowsesessionsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getCobrowsesessionsWithHttpInfo
     *
     * Get recent cobrowse conversations
     *
     * @return Array of \PureCloudSDK\CobrowseConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CobrowseConversationEntityListing',
                '/api/v2/conversations/cobrowsesessions'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CobrowseConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CobrowseConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessionsCobrowseId
     *
     * Get cobrowse conversation
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @return \PureCloudSDK\CobrowseConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseId($cobrowse_id)
    {
        list($response) = $this->getCobrowsesessionsCobrowseIdWithHttpInfo($cobrowse_id);
        return $response;
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdWithHttpInfo
     *
     * Get cobrowse conversation
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @return Array of \PureCloudSDK\CobrowseConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdWithHttpInfo($cobrowse_id)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling getCobrowsesessionsCobrowseId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CobrowseConversation',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CobrowseConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CobrowseConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup($cobrowse_id, $participant_id, $provisional = null)
    {
        list($response) = $this->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupWithHttpInfo($cobrowse_id, $participant_id, $provisional);
        return $response;
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupWithHttpInfo($cobrowse_id, $participant_id, $provisional = null)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes($cobrowse_id, $participant_id)
    {
        list($response) = $this->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodesWithHttpInfo($cobrowse_id, $participant_id);
        return $response;
    }

    /**
     * Operation getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodesWithHttpInfo($cobrowse_id, $participant_id)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationId
     *
     * Get conversation
     *
     * @param string $conversation_id conversation ID (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationId($conversation_id)
    {
        list($response) = $this->getConversationIdWithHttpInfo($conversation_id);
        return $response;
    }

    /**
     * Operation getConversationIdWithHttpInfo
     *
     * Get conversation
     *
     * @param string $conversation_id conversation ID (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdWithHttpInfo($conversation_id)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling getConversationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/{conversationId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\WrapupCode
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapup($conversation_id, $participant_id, $provisional = null)
    {
        list($response) = $this->getConversationIdParticipantsParticipantIdWrapupWithHttpInfo($conversation_id, $participant_id, $provisional);
        return $response;
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\WrapupCode, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapupWithHttpInfo($conversation_id, $participant_id, $provisional = null)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling getConversationIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getConversationIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode',
                '/api/v2/conversations/{conversationId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapupcodes($conversation_id, $participant_id)
    {
        list($response) = $this->getConversationIdParticipantsParticipantIdWrapupcodesWithHttpInfo($conversation_id, $participant_id);
        return $response;
    }

    /**
     * Operation getConversationIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationIdParticipantsParticipantIdWrapupcodesWithHttpInfo($conversation_id, $participant_id)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling getConversationIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getConversationIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversations
     *
     * Get conversations
     *
     * @param string $communication_type Call or Chat communication filtering (optional)
     * @return \PureCloudSDK\ConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversations($communication_type = null)
    {
        list($response) = $this->getConversationsWithHttpInfo($communication_type);
        return $response;
    }

    /**
     * Operation getConversationsWithHttpInfo
     *
     * Get conversations
     *
     * @param string $communication_type Call or Chat communication filtering (optional)
     * @return Array of \PureCloudSDK\ConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationsWithHttpInfo($communication_type = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($communication_type !== null) {
            $queryParams['communicationType'] = $this->apiClient->getSerializer()->toQueryValue($communication_type);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConversationEntityListing',
                '/api/v2/conversations'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConversationsConversationIdDetails
     *
     * Get a conversation by id
     *
     * @param string $conversation_id conversationId (required)
     * @return \PureCloudSDK\AnalyticsConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationsConversationIdDetails($conversation_id)
    {
        list($response) = $this->getConversationsConversationIdDetailsWithHttpInfo($conversation_id);
        return $response;
    }

    /**
     * Operation getConversationsConversationIdDetailsWithHttpInfo
     *
     * Get a conversation by id
     *
     * @param string $conversation_id conversationId (required)
     * @return Array of \PureCloudSDK\AnalyticsConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getConversationsConversationIdDetailsWithHttpInfo($conversation_id)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling getConversationsConversationIdDetails');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/{conversationId}/details";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AnalyticsConversation',
                '/api/v2/analytics/conversations/{conversationId}/details'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AnalyticsConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AnalyticsConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmails
     *
     * Get recent email conversations
     *
     * @return \PureCloudSDK\EmailConversationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmails()
    {
        list($response) = $this->getEmailsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getEmailsWithHttpInfo
     *
     * Get recent email conversations
     *
     * @return Array of \PureCloudSDK\EmailConversationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailConversationEntityListing',
                '/api/v2/conversations/emails'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailConversationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailConversationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailId
     *
     * Get email conversation
     *
     * @param string $email_id emailId (required)
     * @return \PureCloudSDK\EmailConversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailId($email_id)
    {
        list($response) = $this->getEmailsEmailIdWithHttpInfo($email_id);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdWithHttpInfo
     *
     * Get email conversation
     *
     * @param string $email_id emailId (required)
     * @return Array of \PureCloudSDK\EmailConversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdWithHttpInfo($email_id)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling getEmailsEmailId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailConversation',
                '/api/v2/conversations/emails/{emailId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailConversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailConversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdMessages
     *
     * Get conversation messages
     *
     * @param string $email_id emailId (required)
     * @return \PureCloudSDK\EmailMessageListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessages($email_id)
    {
        list($response) = $this->getEmailsEmailIdMessagesWithHttpInfo($email_id);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdMessagesWithHttpInfo
     *
     * Get conversation messages
     *
     * @param string $email_id emailId (required)
     * @return Array of \PureCloudSDK\EmailMessageListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesWithHttpInfo($email_id)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling getEmailsEmailIdMessages');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessageListing',
                '/api/v2/conversations/emails/{emailId}/messages'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessageListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessageListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdMessagesDraft
     *
     * Get conversation draft reply
     *
     * @param string $email_id emailId (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesDraft($email_id)
    {
        list($response) = $this->getEmailsEmailIdMessagesDraftWithHttpInfo($email_id);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdMessagesDraftWithHttpInfo
     *
     * Get conversation draft reply
     *
     * @param string $email_id emailId (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesDraftWithHttpInfo($email_id)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling getEmailsEmailIdMessagesDraft');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/draft";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages/draft'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdMessagesMessageId
     *
     * Get conversation message
     *
     * @param string $email_id emailId (required)
     * @param string $message_id messageId (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesMessageId($email_id, $message_id)
    {
        list($response) = $this->getEmailsEmailIdMessagesMessageIdWithHttpInfo($email_id, $message_id);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdMessagesMessageIdWithHttpInfo
     *
     * Get conversation message
     *
     * @param string $email_id emailId (required)
     * @param string $message_id messageId (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdMessagesMessageIdWithHttpInfo($email_id, $message_id)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling getEmailsEmailIdMessagesMessageId');
        }
        // verify the required parameter 'message_id' is set
        if ($message_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $message_id when calling getEmailsEmailIdMessagesMessageId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/{messageId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($message_id !== null) {
            $resourcePath = str_replace(
                "{" . "messageId" . "}",
                $this->apiClient->getSerializer()->toPathValue($message_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages/{messageId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapup
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return \PureCloudSDK\Wrapup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapup($email_id, $participant_id, $provisional = null)
    {
        list($response) = $this->getEmailsEmailIdParticipantsParticipantIdWrapupWithHttpInfo($email_id, $participant_id, $provisional);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapupWithHttpInfo
     *
     * Get the wrap-up for this conversation participant.
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param bool $provisional Indicates if the wrap-up code is provisional. (optional, default to false)
     * @return Array of \PureCloudSDK\Wrapup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapupWithHttpInfo($email_id, $participant_id, $provisional = null)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling getEmailsEmailIdParticipantsParticipantIdWrapup');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getEmailsEmailIdParticipantsParticipantIdWrapup');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($provisional !== null) {
            $queryParams['provisional'] = $this->apiClient->getSerializer()->toQueryValue($provisional);
        }
        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Wrapup',
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Wrapup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Wrapup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapupcodes
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @return \PureCloudSDK\WrapupCode[]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapupcodes($email_id, $participant_id)
    {
        list($response) = $this->getEmailsEmailIdParticipantsParticipantIdWrapupcodesWithHttpInfo($email_id, $participant_id);
        return $response;
    }

    /**
     * Operation getEmailsEmailIdParticipantsParticipantIdWrapupcodesWithHttpInfo
     *
     * Get list of wrapup codes for this conversation participant
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @return Array of \PureCloudSDK\WrapupCode[], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getEmailsEmailIdParticipantsParticipantIdWrapupcodesWithHttpInfo($email_id, $participant_id)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling getEmailsEmailIdParticipantsParticipantIdWrapupcodes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling getEmailsEmailIdParticipantsParticipantIdWrapupcodes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\WrapupCode[]',
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\WrapupCode[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\WrapupCode[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $callback_id callbackId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackId($callback_id, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdWithHttpInfo($callback_id, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $callback_id callbackId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdWithHttpInfo($callback_id, $body)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling patchCallbacksCallbackId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/callbacks/{callbackId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantId($callback_id, $participant_id, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdParticipantsParticipantIdWithHttpInfo($callback_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdWithHttpInfo($callback_id, $participant_id, $body)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling patchCallbacksCallbackIdParticipantsParticipantId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCallbacksCallbackIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdAttributes($callback_id, $participant_id, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdParticipantsParticipantIdAttributesWithHttpInfo($callback_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdAttributesWithHttpInfo($callback_id, $participant_id, $body)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling patchCallbacksCallbackIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCallbacksCallbackIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId($callback_id, $participant_id, $communication_id, $body)
    {
        list($response) = $this->patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($callback_id, $participant_id, $communication_id, $body);
        return $response;
    }

    /**
     * Operation patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($callback_id, $participant_id, $communication_id, $body)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communication_id' is set
        if ($communication_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communication_id when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // path params
        if ($communication_id !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communication_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallId
     *
     * Update a conversation by setting it's recording state, merging in other conversations to create a conference, or disconnecting all of the participants
     *
     * @param string $call_id callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallId($call_id, $body)
    {
        list($response) = $this->patchCallsCallIdWithHttpInfo($call_id, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdWithHttpInfo
     *
     * Update a conversation by setting it's recording state, merging in other conversations to create a conference, or disconnecting all of the participants
     *
     * @param string $call_id callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdWithHttpInfo($call_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling patchCallsCallId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/calls/{callId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantId($call_id, $participant_id, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdWithHttpInfo($call_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdWithHttpInfo($call_id, $participant_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling patchCallsCallIdParticipantsParticipantId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCallsCallIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdAttributes($call_id, $participant_id, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdAttributesWithHttpInfo($call_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdAttributesWithHttpInfo($call_id, $participant_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling patchCallsCallIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCallsCallIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId($call_id, $participant_id, $communication_id, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($call_id, $participant_id, $communication_id, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($call_id, $participant_id, $communication_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communication_id' is set
        if ($communication_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communication_id when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // path params
        if ($communication_id !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communication_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdConsult
     *
     * Change who can speak
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ConsultTransferUpdate $body new speak to (required)
     * @return \PureCloudSDK\ConsultTransferResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdConsult($call_id, $participant_id, $body)
    {
        list($response) = $this->patchCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($call_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchCallsCallIdParticipantsParticipantIdConsultWithHttpInfo
     *
     * Change who can speak
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ConsultTransferUpdate $body new speak to (required)
     * @return Array of \PureCloudSDK\ConsultTransferResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($call_id, $participant_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling patchCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCallsCallIdParticipantsParticipantIdConsult');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/consult";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConsultTransferResponse',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConsultTransferResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConsultTransferResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $chat_id chatId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatId($chat_id, $body)
    {
        list($response) = $this->patchChatsChatIdWithHttpInfo($chat_id, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $chat_id chatId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdWithHttpInfo($chat_id, $body)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling patchChatsChatId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/chats/{chatId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantId($chat_id, $participant_id, $body)
    {
        list($response) = $this->patchChatsChatIdParticipantsParticipantIdWithHttpInfo($chat_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdWithHttpInfo($chat_id, $participant_id, $body)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling patchChatsChatIdParticipantsParticipantId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchChatsChatIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdAttributes($chat_id, $participant_id, $body)
    {
        list($response) = $this->patchChatsChatIdParticipantsParticipantIdAttributesWithHttpInfo($chat_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdAttributesWithHttpInfo($chat_id, $participant_id, $body)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling patchChatsChatIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchChatsChatIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId($chat_id, $participant_id, $communication_id, $body)
    {
        list($response) = $this->patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($chat_id, $participant_id, $communication_id, $body);
        return $response;
    }

    /**
     * Operation patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($chat_id, $participant_id, $communication_id, $body)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communication_id' is set
        if ($communication_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communication_id when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // path params
        if ($communication_id !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communication_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseId($cobrowse_id, $body)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdWithHttpInfo($cobrowse_id, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdWithHttpInfo($cobrowse_id, $body)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling patchCobrowsesessionsCobrowseId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCobrowsesessionsCobrowseId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantId($cobrowse_id, $participant_id, $body = null)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdWithHttpInfo($cobrowse_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdWithHttpInfo($cobrowse_id, $participant_id, $body = null)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes($cobrowse_id, $participant_id, $body = null)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributesWithHttpInfo($cobrowse_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributesWithHttpInfo($cobrowse_id, $participant_id, $body = null)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId($cobrowse_id, $participant_id, $communication_id, $body)
    {
        list($response) = $this->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($cobrowse_id, $participant_id, $communication_id, $body);
        return $response;
    }

    /**
     * Operation patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($cobrowse_id, $participant_id, $communication_id, $body)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communication_id' is set
        if ($communication_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communication_id when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // path params
        if ($communication_id !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communication_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchConversationIdParticipantsParticipantId
     *
     * Update a participant.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantId($conversation_id, $participant_id, $body)
    {
        list($response) = $this->patchConversationIdParticipantsParticipantIdWithHttpInfo($conversation_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchConversationIdParticipantsParticipantIdWithHttpInfo
     *
     * Update a participant.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantIdWithHttpInfo($conversation_id, $participant_id, $body)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling patchConversationIdParticipantsParticipantId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchConversationIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchConversationIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchConversationIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantIdAttributes($conversation_id, $participant_id, $body)
    {
        list($response) = $this->patchConversationIdParticipantsParticipantIdAttributesWithHttpInfo($conversation_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchConversationIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchConversationIdParticipantsParticipantIdAttributesWithHttpInfo($conversation_id, $participant_id, $body)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling patchConversationIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchConversationIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchConversationIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailId
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $email_id emailId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailId($email_id, $body)
    {
        list($response) = $this->patchEmailsEmailIdWithHttpInfo($email_id, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdWithHttpInfo
     *
     * Update a conversation by disconnecting all of the participants
     *
     * @param string $email_id emailId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdWithHttpInfo($email_id, $body)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling patchEmailsEmailId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/emails/{emailId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantId
     *
     * Update conversation participant
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantId($email_id, $participant_id, $body)
    {
        list($response) = $this->patchEmailsEmailIdParticipantsParticipantIdWithHttpInfo($email_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdWithHttpInfo
     *
     * Update conversation participant
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Update request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdWithHttpInfo($email_id, $participant_id, $body)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling patchEmailsEmailIdParticipantsParticipantId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchEmailsEmailIdParticipantsParticipantId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailIdParticipantsParticipantId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdAttributes
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdAttributes($email_id, $participant_id, $body)
    {
        list($response) = $this->patchEmailsEmailIdParticipantsParticipantIdAttributesWithHttpInfo($email_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdAttributesWithHttpInfo
     *
     * Update the attributes on a conversation participant.
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ParticipantAttributes $body Participant attributes (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdAttributesWithHttpInfo($email_id, $participant_id, $body)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling patchEmailsEmailIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchEmailsEmailIdParticipantsParticipantIdAttributes');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailIdParticipantsParticipantIdAttributes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId($email_id, $participant_id, $communication_id, $body)
    {
        list($response) = $this->patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($email_id, $participant_id, $communication_id, $body);
        return $response;
    }

    /**
     * Operation patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo
     *
     * Update conversation participant's communication by disconnecting it.
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param string $communication_id communicationId (required)
     * @param \PureCloudSDK\MediaParticipantRequest $body Participant (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationIdWithHttpInfo($email_id, $participant_id, $communication_id, $body)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'communication_id' is set
        if ($communication_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $communication_id when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // path params
        if ($communication_id !== null) {
            $resourcePath = str_replace(
                "{" . "communicationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($communication_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallbacks
     *
     * Create a Callback
     *
     * @param \PureCloudSDK\CreateCallbackCommand $body Callback (required)
     * @return \PureCloudSDK\CreateCallbackResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacks($body)
    {
        list($response) = $this->postCallbacksWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postCallbacksWithHttpInfo
     *
     * Create a Callback
     *
     * @param \PureCloudSDK\CreateCallbackCommand $body Callback (required)
     * @return Array of \PureCloudSDK\CreateCallbackResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacksWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallbacks');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CreateCallbackResponse',
                '/api/v2/conversations/callbacks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CreateCallbackResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CreateCallbackResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallbacksCallbackIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacksCallbackIdParticipantsParticipantIdReplace($callback_id, $participant_id, $body)
    {
        list($response) = $this->postCallbacksCallbackIdParticipantsParticipantIdReplaceWithHttpInfo($callback_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postCallbacksCallbackIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $callback_id callbackId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallbacksCallbackIdParticipantsParticipantIdReplaceWithHttpInfo($callback_id, $participant_id, $body)
    {
        // verify the required parameter 'callback_id' is set
        if ($callback_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $callback_id when calling postCallbacksCallbackIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postCallbacksCallbackIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallbacksCallbackIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($callback_id !== null) {
            $resourcePath = str_replace(
                "{" . "callbackId" . "}",
                $this->apiClient->getSerializer()->toPathValue($callback_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCalls
     *
     * Create a call conversation
     *
     * @param \PureCloudSDK\CreateCallRequest $body Call request (required)
     * @return \PureCloudSDK\CreateCallResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCalls($body)
    {
        list($response) = $this->postCallsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postCallsWithHttpInfo
     *
     * Create a call conversation
     *
     * @param \PureCloudSDK\CreateCallRequest $body Call request (required)
     * @return Array of \PureCloudSDK\CreateCallResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCalls');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\CreateCallResponse',
                '/api/v2/conversations/calls'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\CreateCallResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\CreateCallResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallId
     *
     * Add a new call to a conversation
     *
     * @param string $call_id callId (required)
     * @param \PureCloudSDK\CallCommand $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallId($call_id, $body)
    {
        list($response) = $this->postCallsCallIdWithHttpInfo($call_id, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdWithHttpInfo
     *
     * Add a new call to a conversation
     *
     * @param string $call_id callId (required)
     * @param \PureCloudSDK\CallCommand $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdWithHttpInfo($call_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling postCallsCallId');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallId');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/calls/{callId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipants
     *
     * Add participants to a conversation
     *
     * @param string $call_id callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return \PureCloudSDK\Conversation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipants($call_id, $body)
    {
        list($response) = $this->postCallsCallIdParticipantsWithHttpInfo($call_id, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsWithHttpInfo
     *
     * Add participants to a conversation
     *
     * @param string $call_id callId (required)
     * @param \PureCloudSDK\Conversation $body Conversation (required)
     * @return Array of \PureCloudSDK\Conversation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsWithHttpInfo($call_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling postCallsCallIdParticipants');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallIdParticipants');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Conversation',
                '/api/v2/conversations/calls/{callId}/participants'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Conversation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Conversation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdConsult
     *
     * Initiate and update consult transfer
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ConsultTransfer $body Destination address &amp; initial speak to (required)
     * @return \PureCloudSDK\ConsultTransferResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdConsult($call_id, $participant_id, $body)
    {
        list($response) = $this->postCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($call_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdConsultWithHttpInfo
     *
     * Initiate and update consult transfer
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\ConsultTransfer $body Destination address &amp; initial speak to (required)
     * @return Array of \PureCloudSDK\ConsultTransferResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdConsultWithHttpInfo($call_id, $participant_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling postCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postCallsCallIdParticipantsParticipantIdConsult');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallIdParticipantsParticipantIdConsult');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/consult";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConsultTransferResponse',
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConsultTransferResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConsultTransferResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdMonitor
     *
     * Listen in on the conversation from the point of view of a given participant.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdMonitor($call_id, $participant_id)
    {
        list($response) = $this->postCallsCallIdParticipantsParticipantIdMonitorWithHttpInfo($call_id, $participant_id);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdMonitorWithHttpInfo
     *
     * Listen in on the conversation from the point of view of a given participant.
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdMonitorWithHttpInfo($call_id, $participant_id)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling postCallsCallIdParticipantsParticipantIdMonitor');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postCallsCallIdParticipantsParticipantIdMonitor');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/monitor";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/monitor'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdReplace($call_id, $participant_id, $body)
    {
        list($response) = $this->postCallsCallIdParticipantsParticipantIdReplaceWithHttpInfo($call_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postCallsCallIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $call_id callId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCallsCallIdParticipantsParticipantIdReplaceWithHttpInfo($call_id, $participant_id, $body)
    {
        // verify the required parameter 'call_id' is set
        if ($call_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $call_id when calling postCallsCallIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postCallsCallIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postCallsCallIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/calls/{callId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($call_id !== null) {
            $resourcePath = str_replace(
                "{" . "callId" . "}",
                $this->apiClient->getSerializer()->toPathValue($call_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/calls/{callId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postChatsChatIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postChatsChatIdParticipantsParticipantIdReplace($chat_id, $participant_id, $body)
    {
        list($response) = $this->postChatsChatIdParticipantsParticipantIdReplaceWithHttpInfo($chat_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postChatsChatIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $chat_id chatId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postChatsChatIdParticipantsParticipantIdReplaceWithHttpInfo($chat_id, $participant_id, $body)
    {
        // verify the required parameter 'chat_id' is set
        if ($chat_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chat_id when calling postChatsChatIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postChatsChatIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postChatsChatIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/chats/{chatId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($chat_id !== null) {
            $resourcePath = str_replace(
                "{" . "chatId" . "}",
                $this->apiClient->getSerializer()->toPathValue($chat_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/chats/{chatId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace($cobrowse_id, $participant_id, $body = null)
    {
        list($response) = $this->postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplaceWithHttpInfo($cobrowse_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $cobrowse_id cobrowseId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplaceWithHttpInfo($cobrowse_id, $participant_id, $body = null)
    {
        // verify the required parameter 'cobrowse_id' is set
        if ($cobrowse_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $cobrowse_id when calling postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($cobrowse_id !== null) {
            $resourcePath = str_replace(
                "{" . "cobrowseId" . "}",
                $this->apiClient->getSerializer()->toPathValue($cobrowse_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdCallbacks
     *
     * Create a new callback for the specified participant on the conversation.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\CreateCallbackCommand $body  (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdCallbacks($conversation_id, $participant_id, $body = null)
    {
        list($response) = $this->postConversationIdParticipantsParticipantIdCallbacksWithHttpInfo($conversation_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdCallbacksWithHttpInfo
     *
     * Create a new callback for the specified participant on the conversation.
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\CreateCallbackCommand $body  (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdCallbacksWithHttpInfo($conversation_id, $participant_id, $body = null)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling postConversationIdParticipantsParticipantIdCallbacks');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postConversationIdParticipantsParticipantIdCallbacks');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/callbacks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/callbacks'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdReplace($conversation_id, $participant_id, $body)
    {
        list($response) = $this->postConversationIdParticipantsParticipantIdReplaceWithHttpInfo($conversation_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postConversationIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $conversation_id conversation ID (required)
     * @param string $participant_id participant ID (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationIdParticipantsParticipantIdReplaceWithHttpInfo($conversation_id, $participant_id, $body)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling postConversationIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postConversationIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/{conversationId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/{conversationId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationsAggregatesQuery
     *
     * Query for conversation aggregates
     *
     * @param \PureCloudSDK\AggregationQuery $body query (required)
     * @return \PureCloudSDK\AggregateQueryResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsAggregatesQuery($body)
    {
        list($response) = $this->postConversationsAggregatesQueryWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postConversationsAggregatesQueryWithHttpInfo
     *
     * Query for conversation aggregates
     *
     * @param \PureCloudSDK\AggregationQuery $body query (required)
     * @return Array of \PureCloudSDK\AggregateQueryResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsAggregatesQueryWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationsAggregatesQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/aggregates/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AggregateQueryResponse',
                '/api/v2/analytics/conversations/aggregates/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AggregateQueryResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AggregateQueryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationsConversationIdDetailsProperties
     *
     * Index conversation properties
     *
     * @param string $conversation_id conversationId (required)
     * @param \PureCloudSDK\PropertyIndexRequest $body request (required)
     * @return \PureCloudSDK\PropertyIndexRequest
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsConversationIdDetailsProperties($conversation_id, $body)
    {
        list($response) = $this->postConversationsConversationIdDetailsPropertiesWithHttpInfo($conversation_id, $body);
        return $response;
    }

    /**
     * Operation postConversationsConversationIdDetailsPropertiesWithHttpInfo
     *
     * Index conversation properties
     *
     * @param string $conversation_id conversationId (required)
     * @param \PureCloudSDK\PropertyIndexRequest $body request (required)
     * @return Array of \PureCloudSDK\PropertyIndexRequest, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsConversationIdDetailsPropertiesWithHttpInfo($conversation_id, $body)
    {
        // verify the required parameter 'conversation_id' is set
        if ($conversation_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $conversation_id when calling postConversationsConversationIdDetailsProperties');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationsConversationIdDetailsProperties');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/{conversationId}/details/properties";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($conversation_id !== null) {
            $resourcePath = str_replace(
                "{" . "conversationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($conversation_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PropertyIndexRequest',
                '/api/v2/analytics/conversations/{conversationId}/details/properties'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PropertyIndexRequest', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PropertyIndexRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postConversationsDetailsQuery
     *
     * Query for conversation details
     *
     * @param \PureCloudSDK\ConversationQuery $body query (required)
     * @return \PureCloudSDK\AnalyticsConversationQueryResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsDetailsQuery($body)
    {
        list($response) = $this->postConversationsDetailsQueryWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postConversationsDetailsQueryWithHttpInfo
     *
     * Query for conversation details
     *
     * @param \PureCloudSDK\ConversationQuery $body query (required)
     * @return Array of \PureCloudSDK\AnalyticsConversationQueryResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postConversationsDetailsQueryWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postConversationsDetailsQuery');
        }
        // parse inputs
        $resourcePath = "/api/v2/analytics/conversations/details/query";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\AnalyticsConversationQueryResponse',
                '/api/v2/analytics/conversations/details/query'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\AnalyticsConversationQueryResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\AnalyticsConversationQueryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postEmailsEmailIdMessages
     *
     * Send an email reply
     *
     * @param string $email_id emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Reply (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdMessages($email_id, $body)
    {
        list($response) = $this->postEmailsEmailIdMessagesWithHttpInfo($email_id, $body);
        return $response;
    }

    /**
     * Operation postEmailsEmailIdMessagesWithHttpInfo
     *
     * Send an email reply
     *
     * @param string $email_id emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Reply (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdMessagesWithHttpInfo($email_id, $body)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling postEmailsEmailIdMessages');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postEmailsEmailIdMessages');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postEmailsEmailIdParticipantsParticipantIdReplace
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdParticipantsParticipantIdReplace($email_id, $participant_id, $body)
    {
        list($response) = $this->postEmailsEmailIdParticipantsParticipantIdReplaceWithHttpInfo($email_id, $participant_id, $body);
        return $response;
    }

    /**
     * Operation postEmailsEmailIdParticipantsParticipantIdReplaceWithHttpInfo
     *
     * Replace this participant with the specified user and/or address
     *
     * @param string $email_id emailId (required)
     * @param string $participant_id participantId (required)
     * @param \PureCloudSDK\TransferRequest $body Transfer request (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postEmailsEmailIdParticipantsParticipantIdReplaceWithHttpInfo($email_id, $participant_id, $body)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling postEmailsEmailIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'participant_id' is set
        if ($participant_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $participant_id when calling postEmailsEmailIdParticipantsParticipantIdReplace');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postEmailsEmailIdParticipantsParticipantIdReplace');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/participants/{participantId}/replace";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // path params
        if ($participant_id !== null) {
            $resourcePath = str_replace(
                "{" . "participantId" . "}",
                $this->apiClient->getSerializer()->toPathValue($participant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/conversations/emails/{emailId}/participants/{participantId}/replace'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFaxes
     *
     * Create Fax Conversation
     *
     * @param \PureCloudSDK\FaxSendRequest $body Fax (required)
     * @return \PureCloudSDK\FaxSendResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFaxes($body)
    {
        list($response) = $this->postFaxesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postFaxesWithHttpInfo
     *
     * Create Fax Conversation
     *
     * @param \PureCloudSDK\FaxSendRequest $body Fax (required)
     * @return Array of \PureCloudSDK\FaxSendResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFaxesWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postFaxes');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/faxes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FaxSendResponse',
                '/api/v2/conversations/faxes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FaxSendResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FaxSendResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putEmailsEmailIdMessagesDraft
     *
     * Update conversation draft reply
     *
     * @param string $email_id emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Draft (required)
     * @return \PureCloudSDK\EmailMessage
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putEmailsEmailIdMessagesDraft($email_id, $body)
    {
        list($response) = $this->putEmailsEmailIdMessagesDraftWithHttpInfo($email_id, $body);
        return $response;
    }

    /**
     * Operation putEmailsEmailIdMessagesDraftWithHttpInfo
     *
     * Update conversation draft reply
     *
     * @param string $email_id emailId (required)
     * @param \PureCloudSDK\EmailMessage $body Draft (required)
     * @return Array of \PureCloudSDK\EmailMessage, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putEmailsEmailIdMessagesDraftWithHttpInfo($email_id, $body)
    {
        // verify the required parameter 'email_id' is set
        if ($email_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email_id when calling putEmailsEmailIdMessagesDraft');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putEmailsEmailIdMessagesDraft');
        }
        // parse inputs
        $resourcePath = "/api/v2/conversations/emails/{emailId}/messages/draft";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($email_id !== null) {
            $resourcePath = str_replace(
                "{" . "emailId" . "}",
                $this->apiClient->getSerializer()->toPathValue($email_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmailMessage',
                '/api/v2/conversations/emails/{emailId}/messages/draft'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmailMessage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmailMessage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
