<?php
/**
 * CreateCallRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateCallRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateCallRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateCallRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'phone_number' => 'string',
        'call_from_queue_id' => 'string',
        'call_queue_id' => 'string',
        'call_user_id' => 'string',
        'priority' => 'int',
        'language_id' => 'string',
        'routing_skills_ids' => 'string[]',
        'conversation_ids' => 'string[]',
        'participants' => '\PureCloudSDK\Destination[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'phone_number' => 'phoneNumber',
        'call_from_queue_id' => 'callFromQueueId',
        'call_queue_id' => 'callQueueId',
        'call_user_id' => 'callUserId',
        'priority' => 'priority',
        'language_id' => 'languageId',
        'routing_skills_ids' => 'routingSkillsIds',
        'conversation_ids' => 'conversationIds',
        'participants' => 'participants'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'phone_number' => 'setPhoneNumber',
        'call_from_queue_id' => 'setCallFromQueueId',
        'call_queue_id' => 'setCallQueueId',
        'call_user_id' => 'setCallUserId',
        'priority' => 'setPriority',
        'language_id' => 'setLanguageId',
        'routing_skills_ids' => 'setRoutingSkillsIds',
        'conversation_ids' => 'setConversationIds',
        'participants' => 'setParticipants'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'phone_number' => 'getPhoneNumber',
        'call_from_queue_id' => 'getCallFromQueueId',
        'call_queue_id' => 'getCallQueueId',
        'call_user_id' => 'getCallUserId',
        'priority' => 'getPriority',
        'language_id' => 'getLanguageId',
        'routing_skills_ids' => 'getRoutingSkillsIds',
        'conversation_ids' => 'getConversationIds',
        'participants' => 'getParticipants'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['phone_number'] = isset($data['phone_number']) ? $data['phone_number'] : null;
        $this->container['call_from_queue_id'] = isset($data['call_from_queue_id']) ? $data['call_from_queue_id'] : null;
        $this->container['call_queue_id'] = isset($data['call_queue_id']) ? $data['call_queue_id'] : null;
        $this->container['call_user_id'] = isset($data['call_user_id']) ? $data['call_user_id'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['language_id'] = isset($data['language_id']) ? $data['language_id'] : null;
        $this->container['routing_skills_ids'] = isset($data['routing_skills_ids']) ? $data['routing_skills_ids'] : null;
        $this->container['conversation_ids'] = isset($data['conversation_ids']) ? $data['conversation_ids'] : null;
        $this->container['participants'] = isset($data['participants']) ? $data['participants'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets phone_number
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number
     * @param string $phone_number The phone number to dial.
     * @return $this
     */
    public function setPhoneNumber($phone_number)
    {
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets call_from_queue_id
     * @return string
     */
    public function getCallFromQueueId()
    {
        return $this->container['call_from_queue_id'];
    }

    /**
     * Sets call_from_queue_id
     * @param string $call_from_queue_id The queue ID to call on behalf of.
     * @return $this
     */
    public function setCallFromQueueId($call_from_queue_id)
    {
        $this->container['call_from_queue_id'] = $call_from_queue_id;

        return $this;
    }

    /**
     * Gets call_queue_id
     * @return string
     */
    public function getCallQueueId()
    {
        return $this->container['call_queue_id'];
    }

    /**
     * Sets call_queue_id
     * @param string $call_queue_id The queue ID to call.
     * @return $this
     */
    public function setCallQueueId($call_queue_id)
    {
        $this->container['call_queue_id'] = $call_queue_id;

        return $this;
    }

    /**
     * Gets call_user_id
     * @return string
     */
    public function getCallUserId()
    {
        return $this->container['call_user_id'];
    }

    /**
     * Sets call_user_id
     * @param string $call_user_id The user ID to call.
     * @return $this
     */
    public function setCallUserId($call_user_id)
    {
        $this->container['call_user_id'] = $call_user_id;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority to assign to this call (if calling a queue).
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets language_id
     * @return string
     */
    public function getLanguageId()
    {
        return $this->container['language_id'];
    }

    /**
     * Sets language_id
     * @param string $language_id The language skill ID to use for routing this call (if calling a queue).
     * @return $this
     */
    public function setLanguageId($language_id)
    {
        $this->container['language_id'] = $language_id;

        return $this;
    }

    /**
     * Gets routing_skills_ids
     * @return string[]
     */
    public function getRoutingSkillsIds()
    {
        return $this->container['routing_skills_ids'];
    }

    /**
     * Sets routing_skills_ids
     * @param string[] $routing_skills_ids The skill ID's to use for routing this call (if calling a queue).
     * @return $this
     */
    public function setRoutingSkillsIds($routing_skills_ids)
    {
        $this->container['routing_skills_ids'] = $routing_skills_ids;

        return $this;
    }

    /**
     * Gets conversation_ids
     * @return string[]
     */
    public function getConversationIds()
    {
        return $this->container['conversation_ids'];
    }

    /**
     * Sets conversation_ids
     * @param string[] $conversation_ids The list of existing call conversations to merge into a new ad-hoc conference.
     * @return $this
     */
    public function setConversationIds($conversation_ids)
    {
        $this->container['conversation_ids'] = $conversation_ids;

        return $this;
    }

    /**
     * Gets participants
     * @return \PureCloudSDK\Destination[]
     */
    public function getParticipants()
    {
        return $this->container['participants'];
    }

    /**
     * Sets participants
     * @param \PureCloudSDK\Destination[] $participants The list of participants to call to create a new ad-hoc conference.
     * @return $this
     */
    public function setParticipants($participants)
    {
        $this->container['participants'] = $participants;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


