<?php
/**
 * CreateCallbackCommand
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateCallbackCommand Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateCallbackCommand implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateCallbackCommand';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'script_id' => 'string',
        'queue_id' => 'string',
        'routing_data' => '\PureCloudSDK\RoutingData',
        'callback_user_name' => 'string',
        'callback_numbers' => 'string[]',
        'callback_scheduled_time' => '\DateTime',
        'country_code' => 'string',
        'is_automated' => 'bool',
        'automated_callback_config_id' => 'string',
        'data' => 'map[string,string]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'script_id' => 'scriptId',
        'queue_id' => 'queueId',
        'routing_data' => 'routingData',
        'callback_user_name' => 'callbackUserName',
        'callback_numbers' => 'callbackNumbers',
        'callback_scheduled_time' => 'callbackScheduledTime',
        'country_code' => 'countryCode',
        'is_automated' => 'isAutomated',
        'automated_callback_config_id' => 'automatedCallbackConfigId',
        'data' => 'data'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'script_id' => 'setScriptId',
        'queue_id' => 'setQueueId',
        'routing_data' => 'setRoutingData',
        'callback_user_name' => 'setCallbackUserName',
        'callback_numbers' => 'setCallbackNumbers',
        'callback_scheduled_time' => 'setCallbackScheduledTime',
        'country_code' => 'setCountryCode',
        'is_automated' => 'setIsAutomated',
        'automated_callback_config_id' => 'setAutomatedCallbackConfigId',
        'data' => 'setData'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'script_id' => 'getScriptId',
        'queue_id' => 'getQueueId',
        'routing_data' => 'getRoutingData',
        'callback_user_name' => 'getCallbackUserName',
        'callback_numbers' => 'getCallbackNumbers',
        'callback_scheduled_time' => 'getCallbackScheduledTime',
        'country_code' => 'getCountryCode',
        'is_automated' => 'getIsAutomated',
        'automated_callback_config_id' => 'getAutomatedCallbackConfigId',
        'data' => 'getData'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['script_id'] = isset($data['script_id']) ? $data['script_id'] : null;
        $this->container['queue_id'] = isset($data['queue_id']) ? $data['queue_id'] : null;
        $this->container['routing_data'] = isset($data['routing_data']) ? $data['routing_data'] : null;
        $this->container['callback_user_name'] = isset($data['callback_user_name']) ? $data['callback_user_name'] : null;
        $this->container['callback_numbers'] = isset($data['callback_numbers']) ? $data['callback_numbers'] : null;
        $this->container['callback_scheduled_time'] = isset($data['callback_scheduled_time']) ? $data['callback_scheduled_time'] : null;
        $this->container['country_code'] = isset($data['country_code']) ? $data['country_code'] : null;
        $this->container['is_automated'] = isset($data['is_automated']) ? $data['is_automated'] : false;
        $this->container['automated_callback_config_id'] = isset($data['automated_callback_config_id']) ? $data['automated_callback_config_id'] : null;
        $this->container['data'] = isset($data['data']) ? $data['data'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['callback_numbers'] === null) {
            $invalid_properties[] = "'callback_numbers' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['callback_numbers'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets script_id
     * @return string
     */
    public function getScriptId()
    {
        return $this->container['script_id'];
    }

    /**
     * Sets script_id
     * @param string $script_id The identifier of the script to be used for the callback
     * @return $this
     */
    public function setScriptId($script_id)
    {
        $this->container['script_id'] = $script_id;

        return $this;
    }

    /**
     * Gets queue_id
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queue_id'];
    }

    /**
     * Sets queue_id
     * @param string $queue_id The identifier of the queue to be used for the callback. Either queueId or routingData is required.
     * @return $this
     */
    public function setQueueId($queue_id)
    {
        $this->container['queue_id'] = $queue_id;

        return $this;
    }

    /**
     * Gets routing_data
     * @return \PureCloudSDK\RoutingData
     */
    public function getRoutingData()
    {
        return $this->container['routing_data'];
    }

    /**
     * Sets routing_data
     * @param \PureCloudSDK\RoutingData $routing_data The routing data to be used for the callback. Either queueId or routingData is required.
     * @return $this
     */
    public function setRoutingData($routing_data)
    {
        $this->container['routing_data'] = $routing_data;

        return $this;
    }

    /**
     * Gets callback_user_name
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callback_user_name'];
    }

    /**
     * Sets callback_user_name
     * @param string $callback_user_name The name of the party to be called back.
     * @return $this
     */
    public function setCallbackUserName($callback_user_name)
    {
        $this->container['callback_user_name'] = $callback_user_name;

        return $this;
    }

    /**
     * Gets callback_numbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callback_numbers'];
    }

    /**
     * Sets callback_numbers
     * @param string[] $callback_numbers A list of phone numbers for the callback.
     * @return $this
     */
    public function setCallbackNumbers($callback_numbers)
    {
        $this->container['callback_numbers'] = $callback_numbers;

        return $this;
    }

    /**
     * Gets callback_scheduled_time
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callback_scheduled_time'];
    }

    /**
     * Sets callback_scheduled_time
     * @param \DateTime $callback_scheduled_time The scheduled date-time for the callback as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallbackScheduledTime($callback_scheduled_time)
    {
        $this->container['callback_scheduled_time'] = $callback_scheduled_time;

        return $this;
    }

    /**
     * Gets country_code
     * @return string
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     * @param string $country_code The country code to be associated with the callback numbers.
     * @return $this
     */
    public function setCountryCode($country_code)
    {
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets is_automated
     * @return bool
     */
    public function getIsAutomated()
    {
        return $this->container['is_automated'];
    }

    /**
     * Sets is_automated
     * @param bool $is_automated Whether or not to automatically place a call for this callback.
     * @return $this
     */
    public function setIsAutomated($is_automated)
    {
        $this->container['is_automated'] = $is_automated;

        return $this;
    }

    /**
     * Gets automated_callback_config_id
     * @return string
     */
    public function getAutomatedCallbackConfigId()
    {
        return $this->container['automated_callback_config_id'];
    }

    /**
     * Sets automated_callback_config_id
     * @param string $automated_callback_config_id The id of the configuration to handle the response (e.g. live voice, machine) from automatically placing a call for a callback.
     * @return $this
     */
    public function setAutomatedCallbackConfigId($automated_callback_config_id)
    {
        $this->container['automated_callback_config_id'] = $automated_callback_config_id;

        return $this;
    }

    /**
     * Gets data
     * @return map[string,string]
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     * @param map[string,string] $data A map of key-value pairs containing additional data that can be associated to the callback. These values will appear in the attributes property on the conversation participant. Example: { \"notes\": \"ready to close the deal!\", \"customerPreferredName\": \"Doc\" }
     * @return $this
     */
    public function setData($data)
    {
        $this->container['data'] = $data;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


