<?php
/**
 * DialerContact
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DialerContact Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DialerContact implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DialerContact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'contact_list_id' => 'string',
        'data' => 'map[string,object]',
        'call_records' => 'map[string,\PureCloudSDK\CallRecord]',
        'callable' => 'bool',
        'phone_number_status' => 'map[string,\PureCloudSDK\PhoneNumberStatus]',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'contact_list_id' => 'contactListId',
        'data' => 'data',
        'call_records' => 'callRecords',
        'callable' => 'callable',
        'phone_number_status' => 'phoneNumberStatus',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'contact_list_id' => 'setContactListId',
        'data' => 'setData',
        'call_records' => 'setCallRecords',
        'callable' => 'setCallable',
        'phone_number_status' => 'setPhoneNumberStatus',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'contact_list_id' => 'getContactListId',
        'data' => 'getData',
        'call_records' => 'getCallRecords',
        'callable' => 'getCallable',
        'phone_number_status' => 'getPhoneNumberStatus',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['contact_list_id'] = isset($data['contact_list_id']) ? $data['contact_list_id'] : null;
        $this->container['data'] = isset($data['data']) ? $data['data'] : null;
        $this->container['call_records'] = isset($data['call_records']) ? $data['call_records'] : null;
        $this->container['callable'] = isset($data['callable']) ? $data['callable'] : false;
        $this->container['phone_number_status'] = isset($data['phone_number_status']) ? $data['phone_number_status'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['contact_list_id'] === null) {
            $invalid_properties[] = "'contact_list_id' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['contact_list_id'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets contact_list_id
     * @return string
     */
    public function getContactListId()
    {
        return $this->container['contact_list_id'];
    }

    /**
     * Sets contact_list_id
     * @param string $contact_list_id Identifier of the contact list containing this contact
     * @return $this
     */
    public function setContactListId($contact_list_id)
    {
        $this->container['contact_list_id'] = $contact_list_id;

        return $this;
    }

    /**
     * Gets data
     * @return map[string,object]
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     * @param map[string,object] $data An ordered map of the contact's data attributes and values
     * @return $this
     */
    public function setData($data)
    {
        $this->container['data'] = $data;

        return $this;
    }

    /**
     * Gets call_records
     * @return map[string,\PureCloudSDK\CallRecord]
     */
    public function getCallRecords()
    {
        return $this->container['call_records'];
    }

    /**
     * Sets call_records
     * @param map[string,\PureCloudSDK\CallRecord] $call_records A map of call records for the contact phone columns
     * @return $this
     */
    public function setCallRecords($call_records)
    {
        $this->container['call_records'] = $call_records;

        return $this;
    }

    /**
     * Gets callable
     * @return bool
     */
    public function getCallable()
    {
        return $this->container['callable'];
    }

    /**
     * Sets callable
     * @param bool $callable false if the contact is not to be called
     * @return $this
     */
    public function setCallable($callable)
    {
        $this->container['callable'] = $callable;

        return $this;
    }

    /**
     * Gets phone_number_status
     * @return map[string,\PureCloudSDK\PhoneNumberStatus]
     */
    public function getPhoneNumberStatus()
    {
        return $this->container['phone_number_status'];
    }

    /**
     * Sets phone_number_status
     * @param map[string,\PureCloudSDK\PhoneNumberStatus] $phone_number_status A map of statuses for the contact phone columns
     * @return $this
     */
    public function setPhoneNumberStatus($phone_number_status)
    {
        $this->container['phone_number_status'] = $phone_number_status;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


