<?php
/**
 * DncList
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DncList Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DncList implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DncList';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'version' => 'int',
        'import_status' => '\PureCloudSDK\ImportStatus',
        'size' => 'int',
        'dnc_source_type' => 'string',
        'login_id' => 'string',
        'dnc_codes' => 'string[]',
        'license_id' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'version' => 'version',
        'import_status' => 'importStatus',
        'size' => 'size',
        'dnc_source_type' => 'dncSourceType',
        'login_id' => 'loginId',
        'dnc_codes' => 'dncCodes',
        'license_id' => 'licenseId',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'version' => 'setVersion',
        'import_status' => 'setImportStatus',
        'size' => 'setSize',
        'dnc_source_type' => 'setDncSourceType',
        'login_id' => 'setLoginId',
        'dnc_codes' => 'setDncCodes',
        'license_id' => 'setLicenseId',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'version' => 'getVersion',
        'import_status' => 'getImportStatus',
        'size' => 'getSize',
        'dnc_source_type' => 'getDncSourceType',
        'login_id' => 'getLoginId',
        'dnc_codes' => 'getDncCodes',
        'license_id' => 'getLicenseId',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DNC_SOURCE_TYPE_RDS = 'RDS';
    const DNC_SOURCE_TYPE_DNC_DOT_COM = 'DNC_DOT_COM';
    const DNC_SOURCE_TYPE_GRYPHON = 'GRYPHON';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDncSourceTypeAllowableValues()
    {
        return [
            self::DNC_SOURCE_TYPE_RDS,
            self::DNC_SOURCE_TYPE_DNC_DOT_COM,
            self::DNC_SOURCE_TYPE_GRYPHON,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['import_status'] = isset($data['import_status']) ? $data['import_status'] : null;
        $this->container['size'] = isset($data['size']) ? $data['size'] : null;
        $this->container['dnc_source_type'] = isset($data['dnc_source_type']) ? $data['dnc_source_type'] : null;
        $this->container['login_id'] = isset($data['login_id']) ? $data['login_id'] : null;
        $this->container['dnc_codes'] = isset($data['dnc_codes']) ? $data['dnc_codes'] : null;
        $this->container['license_id'] = isset($data['license_id']) ? $data['license_id'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("RDS", "DNC_DOT_COM", "GRYPHON");
        if (!in_array($this->container['dnc_source_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dnc_source_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("RDS", "DNC_DOT_COM", "GRYPHON");
        if (!in_array($this->container['dnc_source_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the list.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets import_status
     * @return \PureCloudSDK\ImportStatus
     */
    public function getImportStatus()
    {
        return $this->container['import_status'];
    }

    /**
     * Sets import_status
     * @param \PureCloudSDK\ImportStatus $import_status the status of the import process
     * @return $this
     */
    public function setImportStatus($import_status)
    {
        $this->container['import_status'] = $import_status;

        return $this;
    }

    /**
     * Gets size
     * @return int
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     * @param int $size the number of phone numbers in the do not call list
     * @return $this
     */
    public function setSize($size)
    {
        $this->container['size'] = $size;

        return $this;
    }

    /**
     * Gets dnc_source_type
     * @return string
     */
    public function getDncSourceType()
    {
        return $this->container['dnc_source_type'];
    }

    /**
     * Sets dnc_source_type
     * @param string $dnc_source_type the type of dnc list being created, rds (csv file), gryphon, or dnc.com
     * @return $this
     */
    public function setDncSourceType($dnc_source_type)
    {
        $allowed_values = array('RDS', 'DNC_DOT_COM', 'GRYPHON');
        if (!in_array($dnc_source_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dnc_source_type', must be one of 'RDS', 'DNC_DOT_COM', 'GRYPHON'");
        }
        $this->container['dnc_source_type'] = $dnc_source_type;

        return $this;
    }

    /**
     * Gets login_id
     * @return string
     */
    public function getLoginId()
    {
        return $this->container['login_id'];
    }

    /**
     * Sets login_id
     * @param string $login_id the loginId if the dncSourceType is dnc.com
     * @return $this
     */
    public function setLoginId($login_id)
    {
        $this->container['login_id'] = $login_id;

        return $this;
    }

    /**
     * Gets dnc_codes
     * @return string[]
     */
    public function getDncCodes()
    {
        return $this->container['dnc_codes'];
    }

    /**
     * Sets dnc_codes
     * @param string[] $dnc_codes the list of dnc.com codes to be treated as DNC
     * @return $this
     */
    public function setDncCodes($dnc_codes)
    {
        $this->container['dnc_codes'] = $dnc_codes;

        return $this;
    }

    /**
     * Gets license_id
     * @return string
     */
    public function getLicenseId()
    {
        return $this->container['license_id'];
    }

    /**
     * Sets license_id
     * @param string $license_id the license number if the dncSourceType is gryphon
     * @return $this
     */
    public function setLicenseId($license_id)
    {
        $this->container['license_id'] = $license_id;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


