<?php
/**
 * Document
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Document Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Document implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Document';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'change_number' => 'int',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'date_uploaded' => '\DateTime',
        'content_uri' => 'string',
        'workspace' => '\PureCloudSDK\UriReference',
        'created_by' => '\PureCloudSDK\UriReference',
        'uploaded_by' => '\PureCloudSDK\UriReference',
        'content_type' => 'string',
        'content_length' => 'int',
        'system_type' => 'string',
        'filename' => 'string',
        'page_count' => 'int',
        'read' => 'bool',
        'caller_address' => 'string',
        'receiver_address' => 'string',
        'tags' => 'string[]',
        'tag_values' => '\PureCloudSDK\TagValue[]',
        'attributes' => '\PureCloudSDK\DocumentAttribute[]',
        'thumbnails' => '\PureCloudSDK\DocumentThumbnail[]',
        'upload_status' => '\PureCloudSDK\UriReference',
        'upload_destination_uri' => 'string',
        'upload_method' => 'string',
        'lock_info' => '\PureCloudSDK\LockInfo',
        'acl' => 'string[]',
        'sharing_status' => 'string',
        'sharing_uri' => 'string',
        'download_sharing_uri' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'change_number' => 'changeNumber',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'date_uploaded' => 'dateUploaded',
        'content_uri' => 'contentUri',
        'workspace' => 'workspace',
        'created_by' => 'createdBy',
        'uploaded_by' => 'uploadedBy',
        'content_type' => 'contentType',
        'content_length' => 'contentLength',
        'system_type' => 'systemType',
        'filename' => 'filename',
        'page_count' => 'pageCount',
        'read' => 'read',
        'caller_address' => 'callerAddress',
        'receiver_address' => 'receiverAddress',
        'tags' => 'tags',
        'tag_values' => 'tagValues',
        'attributes' => 'attributes',
        'thumbnails' => 'thumbnails',
        'upload_status' => 'uploadStatus',
        'upload_destination_uri' => 'uploadDestinationUri',
        'upload_method' => 'uploadMethod',
        'lock_info' => 'lockInfo',
        'acl' => 'acl',
        'sharing_status' => 'sharingStatus',
        'sharing_uri' => 'sharingUri',
        'download_sharing_uri' => 'downloadSharingUri',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'change_number' => 'setChangeNumber',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'date_uploaded' => 'setDateUploaded',
        'content_uri' => 'setContentUri',
        'workspace' => 'setWorkspace',
        'created_by' => 'setCreatedBy',
        'uploaded_by' => 'setUploadedBy',
        'content_type' => 'setContentType',
        'content_length' => 'setContentLength',
        'system_type' => 'setSystemType',
        'filename' => 'setFilename',
        'page_count' => 'setPageCount',
        'read' => 'setRead',
        'caller_address' => 'setCallerAddress',
        'receiver_address' => 'setReceiverAddress',
        'tags' => 'setTags',
        'tag_values' => 'setTagValues',
        'attributes' => 'setAttributes',
        'thumbnails' => 'setThumbnails',
        'upload_status' => 'setUploadStatus',
        'upload_destination_uri' => 'setUploadDestinationUri',
        'upload_method' => 'setUploadMethod',
        'lock_info' => 'setLockInfo',
        'acl' => 'setAcl',
        'sharing_status' => 'setSharingStatus',
        'sharing_uri' => 'setSharingUri',
        'download_sharing_uri' => 'setDownloadSharingUri',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'change_number' => 'getChangeNumber',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'date_uploaded' => 'getDateUploaded',
        'content_uri' => 'getContentUri',
        'workspace' => 'getWorkspace',
        'created_by' => 'getCreatedBy',
        'uploaded_by' => 'getUploadedBy',
        'content_type' => 'getContentType',
        'content_length' => 'getContentLength',
        'system_type' => 'getSystemType',
        'filename' => 'getFilename',
        'page_count' => 'getPageCount',
        'read' => 'getRead',
        'caller_address' => 'getCallerAddress',
        'receiver_address' => 'getReceiverAddress',
        'tags' => 'getTags',
        'tag_values' => 'getTagValues',
        'attributes' => 'getAttributes',
        'thumbnails' => 'getThumbnails',
        'upload_status' => 'getUploadStatus',
        'upload_destination_uri' => 'getUploadDestinationUri',
        'upload_method' => 'getUploadMethod',
        'lock_info' => 'getLockInfo',
        'acl' => 'getAcl',
        'sharing_status' => 'getSharingStatus',
        'sharing_uri' => 'getSharingUri',
        'download_sharing_uri' => 'getDownloadSharingUri',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const SYSTEM_TYPE_DOCUMENT = 'DOCUMENT';
    const SYSTEM_TYPE_FAX = 'FAX';
    const SYSTEM_TYPE_RECORDING = 'RECORDING';
    const UPLOAD_METHOD_SINGLE_PUT = 'SINGLE_PUT';
    const UPLOAD_METHOD_MULTIPART_POST = 'MULTIPART_POST';
    const SHARING_STATUS_NONE = 'NONE';
    const SHARING_STATUS_LIMITED = 'LIMITED';
    const SHARING_STATUS_PUBLIC = 'PUBLIC';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSystemTypeAllowableValues()
    {
        return [
            self::SYSTEM_TYPE_DOCUMENT,
            self::SYSTEM_TYPE_FAX,
            self::SYSTEM_TYPE_RECORDING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUploadMethodAllowableValues()
    {
        return [
            self::UPLOAD_METHOD_SINGLE_PUT,
            self::UPLOAD_METHOD_MULTIPART_POST,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSharingStatusAllowableValues()
    {
        return [
            self::SHARING_STATUS_NONE,
            self::SHARING_STATUS_LIMITED,
            self::SHARING_STATUS_PUBLIC,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['change_number'] = isset($data['change_number']) ? $data['change_number'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['date_uploaded'] = isset($data['date_uploaded']) ? $data['date_uploaded'] : null;
        $this->container['content_uri'] = isset($data['content_uri']) ? $data['content_uri'] : null;
        $this->container['workspace'] = isset($data['workspace']) ? $data['workspace'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['uploaded_by'] = isset($data['uploaded_by']) ? $data['uploaded_by'] : null;
        $this->container['content_type'] = isset($data['content_type']) ? $data['content_type'] : null;
        $this->container['content_length'] = isset($data['content_length']) ? $data['content_length'] : null;
        $this->container['system_type'] = isset($data['system_type']) ? $data['system_type'] : null;
        $this->container['filename'] = isset($data['filename']) ? $data['filename'] : null;
        $this->container['page_count'] = isset($data['page_count']) ? $data['page_count'] : null;
        $this->container['read'] = isset($data['read']) ? $data['read'] : false;
        $this->container['caller_address'] = isset($data['caller_address']) ? $data['caller_address'] : null;
        $this->container['receiver_address'] = isset($data['receiver_address']) ? $data['receiver_address'] : null;
        $this->container['tags'] = isset($data['tags']) ? $data['tags'] : null;
        $this->container['tag_values'] = isset($data['tag_values']) ? $data['tag_values'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['thumbnails'] = isset($data['thumbnails']) ? $data['thumbnails'] : null;
        $this->container['upload_status'] = isset($data['upload_status']) ? $data['upload_status'] : null;
        $this->container['upload_destination_uri'] = isset($data['upload_destination_uri']) ? $data['upload_destination_uri'] : null;
        $this->container['upload_method'] = isset($data['upload_method']) ? $data['upload_method'] : null;
        $this->container['lock_info'] = isset($data['lock_info']) ? $data['lock_info'] : null;
        $this->container['acl'] = isset($data['acl']) ? $data['acl'] : null;
        $this->container['sharing_status'] = isset($data['sharing_status']) ? $data['sharing_status'] : null;
        $this->container['sharing_uri'] = isset($data['sharing_uri']) ? $data['sharing_uri'] : null;
        $this->container['download_sharing_uri'] = isset($data['download_sharing_uri']) ? $data['download_sharing_uri'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("DOCUMENT", "FAX", "RECORDING");
        if (!in_array($this->container['system_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'system_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['upload_method'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'upload_method', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NONE", "LIMITED", "PUBLIC");
        if (!in_array($this->container['sharing_status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'sharing_status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("DOCUMENT", "FAX", "RECORDING");
        if (!in_array($this->container['system_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['upload_method'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NONE", "LIMITED", "PUBLIC");
        if (!in_array($this->container['sharing_status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets change_number
     * @return int
     */
    public function getChangeNumber()
    {
        return $this->container['change_number'];
    }

    /**
     * Sets change_number
     * @param int $change_number
     * @return $this
     */
    public function setChangeNumber($change_number)
    {
        $this->container['change_number'] = $change_number;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets date_uploaded
     * @return \DateTime
     */
    public function getDateUploaded()
    {
        return $this->container['date_uploaded'];
    }

    /**
     * Sets date_uploaded
     * @param \DateTime $date_uploaded Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateUploaded($date_uploaded)
    {
        $this->container['date_uploaded'] = $date_uploaded;

        return $this;
    }

    /**
     * Gets content_uri
     * @return string
     */
    public function getContentUri()
    {
        return $this->container['content_uri'];
    }

    /**
     * Sets content_uri
     * @param string $content_uri
     * @return $this
     */
    public function setContentUri($content_uri)
    {
        $this->container['content_uri'] = $content_uri;

        return $this;
    }

    /**
     * Gets workspace
     * @return \PureCloudSDK\UriReference
     */
    public function getWorkspace()
    {
        return $this->container['workspace'];
    }

    /**
     * Sets workspace
     * @param \PureCloudSDK\UriReference $workspace
     * @return $this
     */
    public function setWorkspace($workspace)
    {
        $this->container['workspace'] = $workspace;

        return $this;
    }

    /**
     * Gets created_by
     * @return \PureCloudSDK\UriReference
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param \PureCloudSDK\UriReference $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets uploaded_by
     * @return \PureCloudSDK\UriReference
     */
    public function getUploadedBy()
    {
        return $this->container['uploaded_by'];
    }

    /**
     * Sets uploaded_by
     * @param \PureCloudSDK\UriReference $uploaded_by
     * @return $this
     */
    public function setUploadedBy($uploaded_by)
    {
        $this->container['uploaded_by'] = $uploaded_by;

        return $this;
    }

    /**
     * Gets content_type
     * @return string
     */
    public function getContentType()
    {
        return $this->container['content_type'];
    }

    /**
     * Sets content_type
     * @param string $content_type
     * @return $this
     */
    public function setContentType($content_type)
    {
        $this->container['content_type'] = $content_type;

        return $this;
    }

    /**
     * Gets content_length
     * @return int
     */
    public function getContentLength()
    {
        return $this->container['content_length'];
    }

    /**
     * Sets content_length
     * @param int $content_length
     * @return $this
     */
    public function setContentLength($content_length)
    {
        $this->container['content_length'] = $content_length;

        return $this;
    }

    /**
     * Gets system_type
     * @return string
     */
    public function getSystemType()
    {
        return $this->container['system_type'];
    }

    /**
     * Sets system_type
     * @param string $system_type
     * @return $this
     */
    public function setSystemType($system_type)
    {
        $allowed_values = array('DOCUMENT', 'FAX', 'RECORDING');
        if (!in_array($system_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'system_type', must be one of 'DOCUMENT', 'FAX', 'RECORDING'");
        }
        $this->container['system_type'] = $system_type;

        return $this;
    }

    /**
     * Gets filename
     * @return string
     */
    public function getFilename()
    {
        return $this->container['filename'];
    }

    /**
     * Sets filename
     * @param string $filename
     * @return $this
     */
    public function setFilename($filename)
    {
        $this->container['filename'] = $filename;

        return $this;
    }

    /**
     * Gets page_count
     * @return int
     */
    public function getPageCount()
    {
        return $this->container['page_count'];
    }

    /**
     * Sets page_count
     * @param int $page_count
     * @return $this
     */
    public function setPageCount($page_count)
    {
        $this->container['page_count'] = $page_count;

        return $this;
    }

    /**
     * Gets read
     * @return bool
     */
    public function getRead()
    {
        return $this->container['read'];
    }

    /**
     * Sets read
     * @param bool $read
     * @return $this
     */
    public function setRead($read)
    {
        $this->container['read'] = $read;

        return $this;
    }

    /**
     * Gets caller_address
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['caller_address'];
    }

    /**
     * Sets caller_address
     * @param string $caller_address
     * @return $this
     */
    public function setCallerAddress($caller_address)
    {
        $this->container['caller_address'] = $caller_address;

        return $this;
    }

    /**
     * Gets receiver_address
     * @return string
     */
    public function getReceiverAddress()
    {
        return $this->container['receiver_address'];
    }

    /**
     * Sets receiver_address
     * @param string $receiver_address
     * @return $this
     */
    public function setReceiverAddress($receiver_address)
    {
        $this->container['receiver_address'] = $receiver_address;

        return $this;
    }

    /**
     * Gets tags
     * @return string[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     * @param string[] $tags
     * @return $this
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets tag_values
     * @return \PureCloudSDK\TagValue[]
     */
    public function getTagValues()
    {
        return $this->container['tag_values'];
    }

    /**
     * Sets tag_values
     * @param \PureCloudSDK\TagValue[] $tag_values
     * @return $this
     */
    public function setTagValues($tag_values)
    {
        $this->container['tag_values'] = $tag_values;

        return $this;
    }

    /**
     * Gets attributes
     * @return \PureCloudSDK\DocumentAttribute[]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param \PureCloudSDK\DocumentAttribute[] $attributes
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets thumbnails
     * @return \PureCloudSDK\DocumentThumbnail[]
     */
    public function getThumbnails()
    {
        return $this->container['thumbnails'];
    }

    /**
     * Sets thumbnails
     * @param \PureCloudSDK\DocumentThumbnail[] $thumbnails
     * @return $this
     */
    public function setThumbnails($thumbnails)
    {
        $this->container['thumbnails'] = $thumbnails;

        return $this;
    }

    /**
     * Gets upload_status
     * @return \PureCloudSDK\UriReference
     */
    public function getUploadStatus()
    {
        return $this->container['upload_status'];
    }

    /**
     * Sets upload_status
     * @param \PureCloudSDK\UriReference $upload_status
     * @return $this
     */
    public function setUploadStatus($upload_status)
    {
        $this->container['upload_status'] = $upload_status;

        return $this;
    }

    /**
     * Gets upload_destination_uri
     * @return string
     */
    public function getUploadDestinationUri()
    {
        return $this->container['upload_destination_uri'];
    }

    /**
     * Sets upload_destination_uri
     * @param string $upload_destination_uri
     * @return $this
     */
    public function setUploadDestinationUri($upload_destination_uri)
    {
        $this->container['upload_destination_uri'] = $upload_destination_uri;

        return $this;
    }

    /**
     * Gets upload_method
     * @return string
     */
    public function getUploadMethod()
    {
        return $this->container['upload_method'];
    }

    /**
     * Sets upload_method
     * @param string $upload_method
     * @return $this
     */
    public function setUploadMethod($upload_method)
    {
        $allowed_values = array('SINGLE_PUT', 'MULTIPART_POST');
        if (!in_array($upload_method, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'upload_method', must be one of 'SINGLE_PUT', 'MULTIPART_POST'");
        }
        $this->container['upload_method'] = $upload_method;

        return $this;
    }

    /**
     * Gets lock_info
     * @return \PureCloudSDK\LockInfo
     */
    public function getLockInfo()
    {
        return $this->container['lock_info'];
    }

    /**
     * Sets lock_info
     * @param \PureCloudSDK\LockInfo $lock_info
     * @return $this
     */
    public function setLockInfo($lock_info)
    {
        $this->container['lock_info'] = $lock_info;

        return $this;
    }

    /**
     * Gets acl
     * @return string[]
     */
    public function getAcl()
    {
        return $this->container['acl'];
    }

    /**
     * Sets acl
     * @param string[] $acl A list of permitted action rights for the user making the request
     * @return $this
     */
    public function setAcl($acl)
    {
        $this->container['acl'] = $acl;

        return $this;
    }

    /**
     * Gets sharing_status
     * @return string
     */
    public function getSharingStatus()
    {
        return $this->container['sharing_status'];
    }

    /**
     * Sets sharing_status
     * @param string $sharing_status
     * @return $this
     */
    public function setSharingStatus($sharing_status)
    {
        $allowed_values = array('NONE', 'LIMITED', 'PUBLIC');
        if (!in_array($sharing_status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'sharing_status', must be one of 'NONE', 'LIMITED', 'PUBLIC'");
        }
        $this->container['sharing_status'] = $sharing_status;

        return $this;
    }

    /**
     * Gets sharing_uri
     * @return string
     */
    public function getSharingUri()
    {
        return $this->container['sharing_uri'];
    }

    /**
     * Sets sharing_uri
     * @param string $sharing_uri
     * @return $this
     */
    public function setSharingUri($sharing_uri)
    {
        $this->container['sharing_uri'] = $sharing_uri;

        return $this;
    }

    /**
     * Gets download_sharing_uri
     * @return string
     */
    public function getDownloadSharingUri()
    {
        return $this->container['download_sharing_uri'];
    }

    /**
     * Sets download_sharing_uri
     * @param string $download_sharing_uri
     * @return $this
     */
    public function setDownloadSharingUri($download_sharing_uri)
    {
        $this->container['download_sharing_uri'] = $download_sharing_uri;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


