<?php
/**
 * DocumentUpdate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DocumentUpdate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DocumentUpdate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DocumentUpdate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'change_number' => 'int',
        'name' => 'string',
        'read' => 'bool',
        'add_tags' => 'string[]',
        'remove_tags' => 'string[]',
        'add_tag_ids' => 'string[]',
        'remove_tag_ids' => 'string[]',
        'update_attributes' => '\PureCloudSDK\DocumentAttribute[]',
        'remove_attributes' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'change_number' => 'changeNumber',
        'name' => 'name',
        'read' => 'read',
        'add_tags' => 'addTags',
        'remove_tags' => 'removeTags',
        'add_tag_ids' => 'addTagIds',
        'remove_tag_ids' => 'removeTagIds',
        'update_attributes' => 'updateAttributes',
        'remove_attributes' => 'removeAttributes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'change_number' => 'setChangeNumber',
        'name' => 'setName',
        'read' => 'setRead',
        'add_tags' => 'setAddTags',
        'remove_tags' => 'setRemoveTags',
        'add_tag_ids' => 'setAddTagIds',
        'remove_tag_ids' => 'setRemoveTagIds',
        'update_attributes' => 'setUpdateAttributes',
        'remove_attributes' => 'setRemoveAttributes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'change_number' => 'getChangeNumber',
        'name' => 'getName',
        'read' => 'getRead',
        'add_tags' => 'getAddTags',
        'remove_tags' => 'getRemoveTags',
        'add_tag_ids' => 'getAddTagIds',
        'remove_tag_ids' => 'getRemoveTagIds',
        'update_attributes' => 'getUpdateAttributes',
        'remove_attributes' => 'getRemoveAttributes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['change_number'] = isset($data['change_number']) ? $data['change_number'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['read'] = isset($data['read']) ? $data['read'] : false;
        $this->container['add_tags'] = isset($data['add_tags']) ? $data['add_tags'] : null;
        $this->container['remove_tags'] = isset($data['remove_tags']) ? $data['remove_tags'] : null;
        $this->container['add_tag_ids'] = isset($data['add_tag_ids']) ? $data['add_tag_ids'] : null;
        $this->container['remove_tag_ids'] = isset($data['remove_tag_ids']) ? $data['remove_tag_ids'] : null;
        $this->container['update_attributes'] = isset($data['update_attributes']) ? $data['update_attributes'] : null;
        $this->container['remove_attributes'] = isset($data['remove_attributes']) ? $data['remove_attributes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets change_number
     * @return int
     */
    public function getChangeNumber()
    {
        return $this->container['change_number'];
    }

    /**
     * Sets change_number
     * @param int $change_number
     * @return $this
     */
    public function setChangeNumber($change_number)
    {
        $this->container['change_number'] = $change_number;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the document
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets read
     * @return bool
     */
    public function getRead()
    {
        return $this->container['read'];
    }

    /**
     * Sets read
     * @param bool $read
     * @return $this
     */
    public function setRead($read)
    {
        $this->container['read'] = $read;

        return $this;
    }

    /**
     * Gets add_tags
     * @return string[]
     */
    public function getAddTags()
    {
        return $this->container['add_tags'];
    }

    /**
     * Sets add_tags
     * @param string[] $add_tags
     * @return $this
     */
    public function setAddTags($add_tags)
    {
        $this->container['add_tags'] = $add_tags;

        return $this;
    }

    /**
     * Gets remove_tags
     * @return string[]
     */
    public function getRemoveTags()
    {
        return $this->container['remove_tags'];
    }

    /**
     * Sets remove_tags
     * @param string[] $remove_tags
     * @return $this
     */
    public function setRemoveTags($remove_tags)
    {
        $this->container['remove_tags'] = $remove_tags;

        return $this;
    }

    /**
     * Gets add_tag_ids
     * @return string[]
     */
    public function getAddTagIds()
    {
        return $this->container['add_tag_ids'];
    }

    /**
     * Sets add_tag_ids
     * @param string[] $add_tag_ids
     * @return $this
     */
    public function setAddTagIds($add_tag_ids)
    {
        $this->container['add_tag_ids'] = $add_tag_ids;

        return $this;
    }

    /**
     * Gets remove_tag_ids
     * @return string[]
     */
    public function getRemoveTagIds()
    {
        return $this->container['remove_tag_ids'];
    }

    /**
     * Sets remove_tag_ids
     * @param string[] $remove_tag_ids
     * @return $this
     */
    public function setRemoveTagIds($remove_tag_ids)
    {
        $this->container['remove_tag_ids'] = $remove_tag_ids;

        return $this;
    }

    /**
     * Gets update_attributes
     * @return \PureCloudSDK\DocumentAttribute[]
     */
    public function getUpdateAttributes()
    {
        return $this->container['update_attributes'];
    }

    /**
     * Sets update_attributes
     * @param \PureCloudSDK\DocumentAttribute[] $update_attributes
     * @return $this
     */
    public function setUpdateAttributes($update_attributes)
    {
        $this->container['update_attributes'] = $update_attributes;

        return $this;
    }

    /**
     * Gets remove_attributes
     * @return string[]
     */
    public function getRemoveAttributes()
    {
        return $this->container['remove_attributes'];
    }

    /**
     * Sets remove_attributes
     * @param string[] $remove_attributes
     * @return $this
     */
    public function setRemoveAttributes($remove_attributes)
    {
        $this->container['remove_attributes'] = $remove_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


