<?php
/**
 * DomainEdgeSoftwareUpdateDto
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DomainEdgeSoftwareUpdateDto Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DomainEdgeSoftwareUpdateDto implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DomainEdgeSoftwareUpdateDto';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'version' => '\PureCloudSDK\DomainEdgeSoftwareVersionDto',
        'max_download_rate' => 'int',
        'download_start_time' => '\DateTime',
        'execute_start_time' => '\DateTime',
        'execute_stop_time' => '\DateTime',
        'execute_on_idle' => 'bool',
        'status' => 'string',
        'edge_uri' => 'string',
        'current' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'version' => 'version',
        'max_download_rate' => 'maxDownloadRate',
        'download_start_time' => 'downloadStartTime',
        'execute_start_time' => 'executeStartTime',
        'execute_stop_time' => 'executeStopTime',
        'execute_on_idle' => 'executeOnIdle',
        'status' => 'status',
        'edge_uri' => 'edgeUri',
        'current' => 'current'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'version' => 'setVersion',
        'max_download_rate' => 'setMaxDownloadRate',
        'download_start_time' => 'setDownloadStartTime',
        'execute_start_time' => 'setExecuteStartTime',
        'execute_stop_time' => 'setExecuteStopTime',
        'execute_on_idle' => 'setExecuteOnIdle',
        'status' => 'setStatus',
        'edge_uri' => 'setEdgeUri',
        'current' => 'setCurrent'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'version' => 'getVersion',
        'max_download_rate' => 'getMaxDownloadRate',
        'download_start_time' => 'getDownloadStartTime',
        'execute_start_time' => 'getExecuteStartTime',
        'execute_stop_time' => 'getExecuteStopTime',
        'execute_on_idle' => 'getExecuteOnIdle',
        'status' => 'getStatus',
        'edge_uri' => 'getEdgeUri',
        'current' => 'getCurrent'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_NONE = 'NONE';
    const STATUS_INIT = 'INIT';
    const STATUS_IN_PROGRESS = 'IN_PROGRESS';
    const STATUS_EXPIRED = 'EXPIRED';
    const STATUS_EXCEPTION = 'EXCEPTION';
    const STATUS_ABORTED = 'ABORTED';
    const STATUS_FAILED = 'FAILED';
    const STATUS_SUCCEEDED = 'SUCCEEDED';
    const STATUS_DELETE = 'DELETE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_NONE,
            self::STATUS_INIT,
            self::STATUS_IN_PROGRESS,
            self::STATUS_EXPIRED,
            self::STATUS_EXCEPTION,
            self::STATUS_ABORTED,
            self::STATUS_FAILED,
            self::STATUS_SUCCEEDED,
            self::STATUS_DELETE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['max_download_rate'] = isset($data['max_download_rate']) ? $data['max_download_rate'] : null;
        $this->container['download_start_time'] = isset($data['download_start_time']) ? $data['download_start_time'] : null;
        $this->container['execute_start_time'] = isset($data['execute_start_time']) ? $data['execute_start_time'] : null;
        $this->container['execute_stop_time'] = isset($data['execute_stop_time']) ? $data['execute_stop_time'] : null;
        $this->container['execute_on_idle'] = isset($data['execute_on_idle']) ? $data['execute_on_idle'] : false;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['edge_uri'] = isset($data['edge_uri']) ? $data['edge_uri'] : null;
        $this->container['current'] = isset($data['current']) ? $data['current'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        $allowed_values = array("NONE", "INIT", "IN_PROGRESS", "EXPIRED", "EXCEPTION", "ABORTED", "FAILED", "SUCCEEDED", "DELETE");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['version'] === null) {
            return false;
        }
        $allowed_values = array("NONE", "INIT", "IN_PROGRESS", "EXPIRED", "EXCEPTION", "ABORTED", "FAILED", "SUCCEEDED", "DELETE");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets version
     * @return \PureCloudSDK\DomainEdgeSoftwareVersionDto
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param \PureCloudSDK\DomainEdgeSoftwareVersionDto $version Version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets max_download_rate
     * @return int
     */
    public function getMaxDownloadRate()
    {
        return $this->container['max_download_rate'];
    }

    /**
     * Sets max_download_rate
     * @param int $max_download_rate
     * @return $this
     */
    public function setMaxDownloadRate($max_download_rate)
    {
        $this->container['max_download_rate'] = $max_download_rate;

        return $this;
    }

    /**
     * Gets download_start_time
     * @return \DateTime
     */
    public function getDownloadStartTime()
    {
        return $this->container['download_start_time'];
    }

    /**
     * Sets download_start_time
     * @param \DateTime $download_start_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDownloadStartTime($download_start_time)
    {
        $this->container['download_start_time'] = $download_start_time;

        return $this;
    }

    /**
     * Gets execute_start_time
     * @return \DateTime
     */
    public function getExecuteStartTime()
    {
        return $this->container['execute_start_time'];
    }

    /**
     * Sets execute_start_time
     * @param \DateTime $execute_start_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExecuteStartTime($execute_start_time)
    {
        $this->container['execute_start_time'] = $execute_start_time;

        return $this;
    }

    /**
     * Gets execute_stop_time
     * @return \DateTime
     */
    public function getExecuteStopTime()
    {
        return $this->container['execute_stop_time'];
    }

    /**
     * Sets execute_stop_time
     * @param \DateTime $execute_stop_time Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExecuteStopTime($execute_stop_time)
    {
        $this->container['execute_stop_time'] = $execute_stop_time;

        return $this;
    }

    /**
     * Gets execute_on_idle
     * @return bool
     */
    public function getExecuteOnIdle()
    {
        return $this->container['execute_on_idle'];
    }

    /**
     * Sets execute_on_idle
     * @param bool $execute_on_idle
     * @return $this
     */
    public function setExecuteOnIdle($execute_on_idle)
    {
        $this->container['execute_on_idle'] = $execute_on_idle;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('NONE', 'INIT', 'IN_PROGRESS', 'EXPIRED', 'EXCEPTION', 'ABORTED', 'FAILED', 'SUCCEEDED', 'DELETE');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'NONE', 'INIT', 'IN_PROGRESS', 'EXPIRED', 'EXCEPTION', 'ABORTED', 'FAILED', 'SUCCEEDED', 'DELETE'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets edge_uri
     * @return string
     */
    public function getEdgeUri()
    {
        return $this->container['edge_uri'];
    }

    /**
     * Sets edge_uri
     * @param string $edge_uri
     * @return $this
     */
    public function setEdgeUri($edge_uri)
    {
        $this->container['edge_uri'] = $edge_uri;

        return $this;
    }

    /**
     * Gets current
     * @return bool
     */
    public function getCurrent()
    {
        return $this->container['current'];
    }

    /**
     * Sets current
     * @param bool $current
     * @return $this
     */
    public function setCurrent($current)
    {
        $this->container['current'] = $current;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


