<?php
/**
 * DomainLogicalInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DomainLogicalInterface Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DomainLogicalInterface implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DomainLogicalInterface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'modified_by' => 'string',
        'created_by' => 'string',
        'state' => 'string',
        'modified_by_app' => 'string',
        'created_by_app' => 'string',
        'edge_uri' => 'string',
        'edge_assigned_id' => 'string',
        'friendly_name' => 'string',
        'vlan_tag_id' => 'int',
        'hardware_address' => 'string',
        'physical_adapter_id' => 'string',
        'if_status' => 'string',
        'interface_type' => 'string',
        'routes' => '\PureCloudSDK\DomainNetworkRoute[]',
        'addresses' => '\PureCloudSDK\DomainNetworkAddress[]',
        'ipv4_capabilities' => '\PureCloudSDK\DomainCapabilities',
        'ipv6_capabilities' => '\PureCloudSDK\DomainCapabilities',
        'current_state' => 'string',
        'last_modified_user_id' => 'string',
        'last_modified_correlation_id' => 'string',
        'command_responses' => '\PureCloudSDK\DomainNetworkCommandResponse[]',
        'inherit_phone_trunk_bases_i_pv4' => 'bool',
        'inherit_phone_trunk_bases_i_pv6' => 'bool',
        'use_for_internal_edge_communication' => 'bool',
        'external_trunk_base_assignments' => '\PureCloudSDK\TrunkBaseAssignment[]',
        'phone_trunk_base_assignments' => '\PureCloudSDK\TrunkBaseAssignment[]',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'modified_by' => 'modifiedBy',
        'created_by' => 'createdBy',
        'state' => 'state',
        'modified_by_app' => 'modifiedByApp',
        'created_by_app' => 'createdByApp',
        'edge_uri' => 'edgeUri',
        'edge_assigned_id' => 'edgeAssignedId',
        'friendly_name' => 'friendlyName',
        'vlan_tag_id' => 'vlanTagId',
        'hardware_address' => 'hardwareAddress',
        'physical_adapter_id' => 'physicalAdapterId',
        'if_status' => 'ifStatus',
        'interface_type' => 'interfaceType',
        'routes' => 'routes',
        'addresses' => 'addresses',
        'ipv4_capabilities' => 'ipv4Capabilities',
        'ipv6_capabilities' => 'ipv6Capabilities',
        'current_state' => 'currentState',
        'last_modified_user_id' => 'lastModifiedUserId',
        'last_modified_correlation_id' => 'lastModifiedCorrelationId',
        'command_responses' => 'commandResponses',
        'inherit_phone_trunk_bases_i_pv4' => 'inheritPhoneTrunkBasesIPv4',
        'inherit_phone_trunk_bases_i_pv6' => 'inheritPhoneTrunkBasesIPv6',
        'use_for_internal_edge_communication' => 'useForInternalEdgeCommunication',
        'external_trunk_base_assignments' => 'externalTrunkBaseAssignments',
        'phone_trunk_base_assignments' => 'phoneTrunkBaseAssignments',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'modified_by' => 'setModifiedBy',
        'created_by' => 'setCreatedBy',
        'state' => 'setState',
        'modified_by_app' => 'setModifiedByApp',
        'created_by_app' => 'setCreatedByApp',
        'edge_uri' => 'setEdgeUri',
        'edge_assigned_id' => 'setEdgeAssignedId',
        'friendly_name' => 'setFriendlyName',
        'vlan_tag_id' => 'setVlanTagId',
        'hardware_address' => 'setHardwareAddress',
        'physical_adapter_id' => 'setPhysicalAdapterId',
        'if_status' => 'setIfStatus',
        'interface_type' => 'setInterfaceType',
        'routes' => 'setRoutes',
        'addresses' => 'setAddresses',
        'ipv4_capabilities' => 'setIpv4Capabilities',
        'ipv6_capabilities' => 'setIpv6Capabilities',
        'current_state' => 'setCurrentState',
        'last_modified_user_id' => 'setLastModifiedUserId',
        'last_modified_correlation_id' => 'setLastModifiedCorrelationId',
        'command_responses' => 'setCommandResponses',
        'inherit_phone_trunk_bases_i_pv4' => 'setInheritPhoneTrunkBasesIPv4',
        'inherit_phone_trunk_bases_i_pv6' => 'setInheritPhoneTrunkBasesIPv6',
        'use_for_internal_edge_communication' => 'setUseForInternalEdgeCommunication',
        'external_trunk_base_assignments' => 'setExternalTrunkBaseAssignments',
        'phone_trunk_base_assignments' => 'setPhoneTrunkBaseAssignments',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'modified_by' => 'getModifiedBy',
        'created_by' => 'getCreatedBy',
        'state' => 'getState',
        'modified_by_app' => 'getModifiedByApp',
        'created_by_app' => 'getCreatedByApp',
        'edge_uri' => 'getEdgeUri',
        'edge_assigned_id' => 'getEdgeAssignedId',
        'friendly_name' => 'getFriendlyName',
        'vlan_tag_id' => 'getVlanTagId',
        'hardware_address' => 'getHardwareAddress',
        'physical_adapter_id' => 'getPhysicalAdapterId',
        'if_status' => 'getIfStatus',
        'interface_type' => 'getInterfaceType',
        'routes' => 'getRoutes',
        'addresses' => 'getAddresses',
        'ipv4_capabilities' => 'getIpv4Capabilities',
        'ipv6_capabilities' => 'getIpv6Capabilities',
        'current_state' => 'getCurrentState',
        'last_modified_user_id' => 'getLastModifiedUserId',
        'last_modified_correlation_id' => 'getLastModifiedCorrelationId',
        'command_responses' => 'getCommandResponses',
        'inherit_phone_trunk_bases_i_pv4' => 'getInheritPhoneTrunkBasesIPv4',
        'inherit_phone_trunk_bases_i_pv6' => 'getInheritPhoneTrunkBasesIPv6',
        'use_for_internal_edge_communication' => 'getUseForInternalEdgeCommunication',
        'external_trunk_base_assignments' => 'getExternalTrunkBaseAssignments',
        'phone_trunk_base_assignments' => 'getPhoneTrunkBaseAssignments',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    const INTERFACE_TYPE_DIAGNOSTIC = 'DIAGNOSTIC';
    const INTERFACE_TYPE_SYSTEM = 'SYSTEM';
    const CURRENT_STATE_INIT = 'INIT';
    const CURRENT_STATE_CREATING = 'CREATING';
    const CURRENT_STATE_UPDATING = 'UPDATING';
    const CURRENT_STATE_OK = 'OK';
    const CURRENT_STATE_EXCEPTION = 'EXCEPTION';
    const CURRENT_STATE_DELETING = 'DELETING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getInterfaceTypeAllowableValues()
    {
        return [
            self::INTERFACE_TYPE_DIAGNOSTIC,
            self::INTERFACE_TYPE_SYSTEM,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCurrentStateAllowableValues()
    {
        return [
            self::CURRENT_STATE_INIT,
            self::CURRENT_STATE_CREATING,
            self::CURRENT_STATE_UPDATING,
            self::CURRENT_STATE_OK,
            self::CURRENT_STATE_EXCEPTION,
            self::CURRENT_STATE_DELETING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['modified_by'] = isset($data['modified_by']) ? $data['modified_by'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modified_by_app'] = isset($data['modified_by_app']) ? $data['modified_by_app'] : null;
        $this->container['created_by_app'] = isset($data['created_by_app']) ? $data['created_by_app'] : null;
        $this->container['edge_uri'] = isset($data['edge_uri']) ? $data['edge_uri'] : null;
        $this->container['edge_assigned_id'] = isset($data['edge_assigned_id']) ? $data['edge_assigned_id'] : null;
        $this->container['friendly_name'] = isset($data['friendly_name']) ? $data['friendly_name'] : null;
        $this->container['vlan_tag_id'] = isset($data['vlan_tag_id']) ? $data['vlan_tag_id'] : null;
        $this->container['hardware_address'] = isset($data['hardware_address']) ? $data['hardware_address'] : null;
        $this->container['physical_adapter_id'] = isset($data['physical_adapter_id']) ? $data['physical_adapter_id'] : null;
        $this->container['if_status'] = isset($data['if_status']) ? $data['if_status'] : null;
        $this->container['interface_type'] = isset($data['interface_type']) ? $data['interface_type'] : null;
        $this->container['routes'] = isset($data['routes']) ? $data['routes'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['ipv4_capabilities'] = isset($data['ipv4_capabilities']) ? $data['ipv4_capabilities'] : null;
        $this->container['ipv6_capabilities'] = isset($data['ipv6_capabilities']) ? $data['ipv6_capabilities'] : null;
        $this->container['current_state'] = isset($data['current_state']) ? $data['current_state'] : null;
        $this->container['last_modified_user_id'] = isset($data['last_modified_user_id']) ? $data['last_modified_user_id'] : null;
        $this->container['last_modified_correlation_id'] = isset($data['last_modified_correlation_id']) ? $data['last_modified_correlation_id'] : null;
        $this->container['command_responses'] = isset($data['command_responses']) ? $data['command_responses'] : null;
        $this->container['inherit_phone_trunk_bases_i_pv4'] = isset($data['inherit_phone_trunk_bases_i_pv4']) ? $data['inherit_phone_trunk_bases_i_pv4'] : false;
        $this->container['inherit_phone_trunk_bases_i_pv6'] = isset($data['inherit_phone_trunk_bases_i_pv6']) ? $data['inherit_phone_trunk_bases_i_pv6'] : false;
        $this->container['use_for_internal_edge_communication'] = isset($data['use_for_internal_edge_communication']) ? $data['use_for_internal_edge_communication'] : false;
        $this->container['external_trunk_base_assignments'] = isset($data['external_trunk_base_assignments']) ? $data['external_trunk_base_assignments'] : null;
        $this->container['phone_trunk_base_assignments'] = isset($data['phone_trunk_base_assignments']) ? $data['phone_trunk_base_assignments'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['friendly_name'] === null) {
            $invalid_properties[] = "'friendly_name' can't be null";
        }
        if ($this->container['hardware_address'] === null) {
            $invalid_properties[] = "'hardware_address' can't be null";
        }
        if ($this->container['physical_adapter_id'] === null) {
            $invalid_properties[] = "'physical_adapter_id' can't be null";
        }
        $allowed_values = array("DIAGNOSTIC", "SYSTEM");
        if (!in_array($this->container['interface_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'interface_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("INIT", "CREATING", "UPDATING", "OK", "EXCEPTION", "DELETING");
        if (!in_array($this->container['current_state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'current_state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['friendly_name'] === null) {
            return false;
        }
        if ($this->container['hardware_address'] === null) {
            return false;
        }
        if ($this->container['physical_adapter_id'] === null) {
            return false;
        }
        $allowed_values = array("DIAGNOSTIC", "SYSTEM");
        if (!in_array($this->container['interface_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("INIT", "CREATING", "UPDATING", "OK", "EXCEPTION", "DELETING");
        if (!in_array($this->container['current_state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the entity.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets modified_by
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modified_by'];
    }

    /**
     * Sets modified_by
     * @param string $modified_by
     * @return $this
     */
    public function setModifiedBy($modified_by)
    {
        $this->container['modified_by'] = $modified_by;

        return $this;
    }

    /**
     * Gets created_by
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param string $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modified_by_app
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modified_by_app'];
    }

    /**
     * Sets modified_by_app
     * @param string $modified_by_app
     * @return $this
     */
    public function setModifiedByApp($modified_by_app)
    {
        $this->container['modified_by_app'] = $modified_by_app;

        return $this;
    }

    /**
     * Gets created_by_app
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['created_by_app'];
    }

    /**
     * Sets created_by_app
     * @param string $created_by_app
     * @return $this
     */
    public function setCreatedByApp($created_by_app)
    {
        $this->container['created_by_app'] = $created_by_app;

        return $this;
    }

    /**
     * Gets edge_uri
     * @return string
     */
    public function getEdgeUri()
    {
        return $this->container['edge_uri'];
    }

    /**
     * Sets edge_uri
     * @param string $edge_uri
     * @return $this
     */
    public function setEdgeUri($edge_uri)
    {
        $this->container['edge_uri'] = $edge_uri;

        return $this;
    }

    /**
     * Gets edge_assigned_id
     * @return string
     */
    public function getEdgeAssignedId()
    {
        return $this->container['edge_assigned_id'];
    }

    /**
     * Sets edge_assigned_id
     * @param string $edge_assigned_id
     * @return $this
     */
    public function setEdgeAssignedId($edge_assigned_id)
    {
        $this->container['edge_assigned_id'] = $edge_assigned_id;

        return $this;
    }

    /**
     * Gets friendly_name
     * @return string
     */
    public function getFriendlyName()
    {
        return $this->container['friendly_name'];
    }

    /**
     * Sets friendly_name
     * @param string $friendly_name Friendly Name
     * @return $this
     */
    public function setFriendlyName($friendly_name)
    {
        $this->container['friendly_name'] = $friendly_name;

        return $this;
    }

    /**
     * Gets vlan_tag_id
     * @return int
     */
    public function getVlanTagId()
    {
        return $this->container['vlan_tag_id'];
    }

    /**
     * Sets vlan_tag_id
     * @param int $vlan_tag_id
     * @return $this
     */
    public function setVlanTagId($vlan_tag_id)
    {
        $this->container['vlan_tag_id'] = $vlan_tag_id;

        return $this;
    }

    /**
     * Gets hardware_address
     * @return string
     */
    public function getHardwareAddress()
    {
        return $this->container['hardware_address'];
    }

    /**
     * Sets hardware_address
     * @param string $hardware_address Hardware Address
     * @return $this
     */
    public function setHardwareAddress($hardware_address)
    {
        $this->container['hardware_address'] = $hardware_address;

        return $this;
    }

    /**
     * Gets physical_adapter_id
     * @return string
     */
    public function getPhysicalAdapterId()
    {
        return $this->container['physical_adapter_id'];
    }

    /**
     * Sets physical_adapter_id
     * @param string $physical_adapter_id Physical Adapter Id
     * @return $this
     */
    public function setPhysicalAdapterId($physical_adapter_id)
    {
        $this->container['physical_adapter_id'] = $physical_adapter_id;

        return $this;
    }

    /**
     * Gets if_status
     * @return string
     */
    public function getIfStatus()
    {
        return $this->container['if_status'];
    }

    /**
     * Sets if_status
     * @param string $if_status
     * @return $this
     */
    public function setIfStatus($if_status)
    {
        $this->container['if_status'] = $if_status;

        return $this;
    }

    /**
     * Gets interface_type
     * @return string
     */
    public function getInterfaceType()
    {
        return $this->container['interface_type'];
    }

    /**
     * Sets interface_type
     * @param string $interface_type The type of this network interface.
     * @return $this
     */
    public function setInterfaceType($interface_type)
    {
        $allowed_values = array('DIAGNOSTIC', 'SYSTEM');
        if (!in_array($interface_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'interface_type', must be one of 'DIAGNOSTIC', 'SYSTEM'");
        }
        $this->container['interface_type'] = $interface_type;

        return $this;
    }

    /**
     * Gets routes
     * @return \PureCloudSDK\DomainNetworkRoute[]
     */
    public function getRoutes()
    {
        return $this->container['routes'];
    }

    /**
     * Sets routes
     * @param \PureCloudSDK\DomainNetworkRoute[] $routes The list of routes assigned to this interface.
     * @return $this
     */
    public function setRoutes($routes)
    {
        $this->container['routes'] = $routes;

        return $this;
    }

    /**
     * Gets addresses
     * @return \PureCloudSDK\DomainNetworkAddress[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param \PureCloudSDK\DomainNetworkAddress[] $addresses The list of IP addresses on this interface.  Priority of dns addresses are based on order in the list.
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets ipv4_capabilities
     * @return \PureCloudSDK\DomainCapabilities
     */
    public function getIpv4Capabilities()
    {
        return $this->container['ipv4_capabilities'];
    }

    /**
     * Sets ipv4_capabilities
     * @param \PureCloudSDK\DomainCapabilities $ipv4_capabilities IPv4 interface settings.
     * @return $this
     */
    public function setIpv4Capabilities($ipv4_capabilities)
    {
        $this->container['ipv4_capabilities'] = $ipv4_capabilities;

        return $this;
    }

    /**
     * Gets ipv6_capabilities
     * @return \PureCloudSDK\DomainCapabilities
     */
    public function getIpv6Capabilities()
    {
        return $this->container['ipv6_capabilities'];
    }

    /**
     * Sets ipv6_capabilities
     * @param \PureCloudSDK\DomainCapabilities $ipv6_capabilities IPv6 interface settings.
     * @return $this
     */
    public function setIpv6Capabilities($ipv6_capabilities)
    {
        $this->container['ipv6_capabilities'] = $ipv6_capabilities;

        return $this;
    }

    /**
     * Gets current_state
     * @return string
     */
    public function getCurrentState()
    {
        return $this->container['current_state'];
    }

    /**
     * Sets current_state
     * @param string $current_state
     * @return $this
     */
    public function setCurrentState($current_state)
    {
        $allowed_values = array('INIT', 'CREATING', 'UPDATING', 'OK', 'EXCEPTION', 'DELETING');
        if (!in_array($current_state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'current_state', must be one of 'INIT', 'CREATING', 'UPDATING', 'OK', 'EXCEPTION', 'DELETING'");
        }
        $this->container['current_state'] = $current_state;

        return $this;
    }

    /**
     * Gets last_modified_user_id
     * @return string
     */
    public function getLastModifiedUserId()
    {
        return $this->container['last_modified_user_id'];
    }

    /**
     * Sets last_modified_user_id
     * @param string $last_modified_user_id
     * @return $this
     */
    public function setLastModifiedUserId($last_modified_user_id)
    {
        $this->container['last_modified_user_id'] = $last_modified_user_id;

        return $this;
    }

    /**
     * Gets last_modified_correlation_id
     * @return string
     */
    public function getLastModifiedCorrelationId()
    {
        return $this->container['last_modified_correlation_id'];
    }

    /**
     * Sets last_modified_correlation_id
     * @param string $last_modified_correlation_id
     * @return $this
     */
    public function setLastModifiedCorrelationId($last_modified_correlation_id)
    {
        $this->container['last_modified_correlation_id'] = $last_modified_correlation_id;

        return $this;
    }

    /**
     * Gets command_responses
     * @return \PureCloudSDK\DomainNetworkCommandResponse[]
     */
    public function getCommandResponses()
    {
        return $this->container['command_responses'];
    }

    /**
     * Sets command_responses
     * @param \PureCloudSDK\DomainNetworkCommandResponse[] $command_responses
     * @return $this
     */
    public function setCommandResponses($command_responses)
    {
        $this->container['command_responses'] = $command_responses;

        return $this;
    }

    /**
     * Gets inherit_phone_trunk_bases_i_pv4
     * @return bool
     */
    public function getInheritPhoneTrunkBasesIPv4()
    {
        return $this->container['inherit_phone_trunk_bases_i_pv4'];
    }

    /**
     * Sets inherit_phone_trunk_bases_i_pv4
     * @param bool $inherit_phone_trunk_bases_i_pv4 The IPv4 phone trunk base assignment will be inherited from the Edge Group.
     * @return $this
     */
    public function setInheritPhoneTrunkBasesIPv4($inherit_phone_trunk_bases_i_pv4)
    {
        $this->container['inherit_phone_trunk_bases_i_pv4'] = $inherit_phone_trunk_bases_i_pv4;

        return $this;
    }

    /**
     * Gets inherit_phone_trunk_bases_i_pv6
     * @return bool
     */
    public function getInheritPhoneTrunkBasesIPv6()
    {
        return $this->container['inherit_phone_trunk_bases_i_pv6'];
    }

    /**
     * Sets inherit_phone_trunk_bases_i_pv6
     * @param bool $inherit_phone_trunk_bases_i_pv6 The IPv6 phone trunk base assignment will be inherited from the Edge Group.
     * @return $this
     */
    public function setInheritPhoneTrunkBasesIPv6($inherit_phone_trunk_bases_i_pv6)
    {
        $this->container['inherit_phone_trunk_bases_i_pv6'] = $inherit_phone_trunk_bases_i_pv6;

        return $this;
    }

    /**
     * Gets use_for_internal_edge_communication
     * @return bool
     */
    public function getUseForInternalEdgeCommunication()
    {
        return $this->container['use_for_internal_edge_communication'];
    }

    /**
     * Sets use_for_internal_edge_communication
     * @param bool $use_for_internal_edge_communication This interface will be used for all internal edge-to-edge communication using settings from the edgeTrunkBaseAssignment on the Edge Group.
     * @return $this
     */
    public function setUseForInternalEdgeCommunication($use_for_internal_edge_communication)
    {
        $this->container['use_for_internal_edge_communication'] = $use_for_internal_edge_communication;

        return $this;
    }

    /**
     * Gets external_trunk_base_assignments
     * @return \PureCloudSDK\TrunkBaseAssignment[]
     */
    public function getExternalTrunkBaseAssignments()
    {
        return $this->container['external_trunk_base_assignments'];
    }

    /**
     * Sets external_trunk_base_assignments
     * @param \PureCloudSDK\TrunkBaseAssignment[] $external_trunk_base_assignments External trunk base settings to use for external communication from this interface.
     * @return $this
     */
    public function setExternalTrunkBaseAssignments($external_trunk_base_assignments)
    {
        $this->container['external_trunk_base_assignments'] = $external_trunk_base_assignments;

        return $this;
    }

    /**
     * Gets phone_trunk_base_assignments
     * @return \PureCloudSDK\TrunkBaseAssignment[]
     */
    public function getPhoneTrunkBaseAssignments()
    {
        return $this->container['phone_trunk_base_assignments'];
    }

    /**
     * Sets phone_trunk_base_assignments
     * @param \PureCloudSDK\TrunkBaseAssignment[] $phone_trunk_base_assignments Phone trunk base settings to use for phone communication from this interface.  These settings will be ignored when \"inheritPhoneTrunkBases\" is true.
     * @return $this
     */
    public function setPhoneTrunkBaseAssignments($phone_trunk_base_assignments)
    {
        $this->container['phone_trunk_base_assignments'] = $phone_trunk_base_assignments;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


