<?php
/**
 * Edge
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Edge Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Edge implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Edge';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'modified_by' => 'string',
        'created_by' => 'string',
        'state' => 'string',
        'modified_by_app' => 'string',
        'created_by_app' => 'string',
        'interfaces' => '\PureCloudSDK\EdgeInterface[]',
        'make' => 'string',
        'model' => 'string',
        'api_version' => 'string',
        'software_version' => 'string',
        'software_version_timestamp' => 'string',
        'software_version_platform' => 'string',
        'software_version_configuration' => 'string',
        'full_software_version' => 'string',
        'pairing_id' => 'string',
        'fingerprint' => 'string',
        'fingerprint_hint' => 'string',
        'current_version' => 'string',
        'staged_version' => 'string',
        'patch' => 'string',
        'status_code' => 'string',
        'edge_group' => '\PureCloudSDK\EdgeGroup',
        'site' => '\PureCloudSDK\UriReference',
        'software_status' => '\PureCloudSDK\DomainEdgeSoftwareUpdateDto',
        'online_status' => 'string',
        'serial_number' => 'string',
        'physical_edge' => 'bool',
        'managed' => 'bool',
        'edge_deployment_type' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'modified_by' => 'modifiedBy',
        'created_by' => 'createdBy',
        'state' => 'state',
        'modified_by_app' => 'modifiedByApp',
        'created_by_app' => 'createdByApp',
        'interfaces' => 'interfaces',
        'make' => 'make',
        'model' => 'model',
        'api_version' => 'apiVersion',
        'software_version' => 'softwareVersion',
        'software_version_timestamp' => 'softwareVersionTimestamp',
        'software_version_platform' => 'softwareVersionPlatform',
        'software_version_configuration' => 'softwareVersionConfiguration',
        'full_software_version' => 'fullSoftwareVersion',
        'pairing_id' => 'pairingId',
        'fingerprint' => 'fingerprint',
        'fingerprint_hint' => 'fingerprintHint',
        'current_version' => 'currentVersion',
        'staged_version' => 'stagedVersion',
        'patch' => 'patch',
        'status_code' => 'statusCode',
        'edge_group' => 'edgeGroup',
        'site' => 'site',
        'software_status' => 'softwareStatus',
        'online_status' => 'onlineStatus',
        'serial_number' => 'serialNumber',
        'physical_edge' => 'physicalEdge',
        'managed' => 'managed',
        'edge_deployment_type' => 'edgeDeploymentType',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'modified_by' => 'setModifiedBy',
        'created_by' => 'setCreatedBy',
        'state' => 'setState',
        'modified_by_app' => 'setModifiedByApp',
        'created_by_app' => 'setCreatedByApp',
        'interfaces' => 'setInterfaces',
        'make' => 'setMake',
        'model' => 'setModel',
        'api_version' => 'setApiVersion',
        'software_version' => 'setSoftwareVersion',
        'software_version_timestamp' => 'setSoftwareVersionTimestamp',
        'software_version_platform' => 'setSoftwareVersionPlatform',
        'software_version_configuration' => 'setSoftwareVersionConfiguration',
        'full_software_version' => 'setFullSoftwareVersion',
        'pairing_id' => 'setPairingId',
        'fingerprint' => 'setFingerprint',
        'fingerprint_hint' => 'setFingerprintHint',
        'current_version' => 'setCurrentVersion',
        'staged_version' => 'setStagedVersion',
        'patch' => 'setPatch',
        'status_code' => 'setStatusCode',
        'edge_group' => 'setEdgeGroup',
        'site' => 'setSite',
        'software_status' => 'setSoftwareStatus',
        'online_status' => 'setOnlineStatus',
        'serial_number' => 'setSerialNumber',
        'physical_edge' => 'setPhysicalEdge',
        'managed' => 'setManaged',
        'edge_deployment_type' => 'setEdgeDeploymentType',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'modified_by' => 'getModifiedBy',
        'created_by' => 'getCreatedBy',
        'state' => 'getState',
        'modified_by_app' => 'getModifiedByApp',
        'created_by_app' => 'getCreatedByApp',
        'interfaces' => 'getInterfaces',
        'make' => 'getMake',
        'model' => 'getModel',
        'api_version' => 'getApiVersion',
        'software_version' => 'getSoftwareVersion',
        'software_version_timestamp' => 'getSoftwareVersionTimestamp',
        'software_version_platform' => 'getSoftwareVersionPlatform',
        'software_version_configuration' => 'getSoftwareVersionConfiguration',
        'full_software_version' => 'getFullSoftwareVersion',
        'pairing_id' => 'getPairingId',
        'fingerprint' => 'getFingerprint',
        'fingerprint_hint' => 'getFingerprintHint',
        'current_version' => 'getCurrentVersion',
        'staged_version' => 'getStagedVersion',
        'patch' => 'getPatch',
        'status_code' => 'getStatusCode',
        'edge_group' => 'getEdgeGroup',
        'site' => 'getSite',
        'software_status' => 'getSoftwareStatus',
        'online_status' => 'getOnlineStatus',
        'serial_number' => 'getSerialNumber',
        'physical_edge' => 'getPhysicalEdge',
        'managed' => 'getManaged',
        'edge_deployment_type' => 'getEdgeDeploymentType',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    const STATUS_CODE_NEW = 'NEW';
    const STATUS_CODE_AWAITING_CONNECTION = 'AWAITING_CONNECTION';
    const STATUS_CODE_AWAITING_FINGERPRINT = 'AWAITING_FINGERPRINT';
    const STATUS_CODE_AWAITING_FINGERPRINT_VERIFICATION = 'AWAITING_FINGERPRINT_VERIFICATION';
    const STATUS_CODE_FINGERPRINT_VERIFIED = 'FINGERPRINT_VERIFIED';
    const STATUS_CODE_AWAITING_BOOTSTRAP = 'AWAITING_BOOTSTRAP';
    const STATUS_CODE_ACTIVE = 'ACTIVE';
    const STATUS_CODE_INACTIVE = 'INACTIVE';
    const STATUS_CODE_RMA = 'RMA';
    const STATUS_CODE_UNPAIRING = 'UNPAIRING';
    const STATUS_CODE_UNPAIRED = 'UNPAIRED';
    const ONLINE_STATUS_ONLINE = 'ONLINE';
    const ONLINE_STATUS_OFFLINE = 'OFFLINE';
    const EDGE_DEPLOYMENT_TYPE_HARDWARE = 'HARDWARE';
    const EDGE_DEPLOYMENT_TYPE_LDM = 'LDM';
    const EDGE_DEPLOYMENT_TYPE_CDM = 'CDM';
    const EDGE_DEPLOYMENT_TYPE_INVALID = 'INVALID';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusCodeAllowableValues()
    {
        return [
            self::STATUS_CODE_NEW,
            self::STATUS_CODE_AWAITING_CONNECTION,
            self::STATUS_CODE_AWAITING_FINGERPRINT,
            self::STATUS_CODE_AWAITING_FINGERPRINT_VERIFICATION,
            self::STATUS_CODE_FINGERPRINT_VERIFIED,
            self::STATUS_CODE_AWAITING_BOOTSTRAP,
            self::STATUS_CODE_ACTIVE,
            self::STATUS_CODE_INACTIVE,
            self::STATUS_CODE_RMA,
            self::STATUS_CODE_UNPAIRING,
            self::STATUS_CODE_UNPAIRED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOnlineStatusAllowableValues()
    {
        return [
            self::ONLINE_STATUS_ONLINE,
            self::ONLINE_STATUS_OFFLINE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getEdgeDeploymentTypeAllowableValues()
    {
        return [
            self::EDGE_DEPLOYMENT_TYPE_HARDWARE,
            self::EDGE_DEPLOYMENT_TYPE_LDM,
            self::EDGE_DEPLOYMENT_TYPE_CDM,
            self::EDGE_DEPLOYMENT_TYPE_INVALID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['modified_by'] = isset($data['modified_by']) ? $data['modified_by'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modified_by_app'] = isset($data['modified_by_app']) ? $data['modified_by_app'] : null;
        $this->container['created_by_app'] = isset($data['created_by_app']) ? $data['created_by_app'] : null;
        $this->container['interfaces'] = isset($data['interfaces']) ? $data['interfaces'] : null;
        $this->container['make'] = isset($data['make']) ? $data['make'] : null;
        $this->container['model'] = isset($data['model']) ? $data['model'] : null;
        $this->container['api_version'] = isset($data['api_version']) ? $data['api_version'] : null;
        $this->container['software_version'] = isset($data['software_version']) ? $data['software_version'] : null;
        $this->container['software_version_timestamp'] = isset($data['software_version_timestamp']) ? $data['software_version_timestamp'] : null;
        $this->container['software_version_platform'] = isset($data['software_version_platform']) ? $data['software_version_platform'] : null;
        $this->container['software_version_configuration'] = isset($data['software_version_configuration']) ? $data['software_version_configuration'] : null;
        $this->container['full_software_version'] = isset($data['full_software_version']) ? $data['full_software_version'] : null;
        $this->container['pairing_id'] = isset($data['pairing_id']) ? $data['pairing_id'] : null;
        $this->container['fingerprint'] = isset($data['fingerprint']) ? $data['fingerprint'] : null;
        $this->container['fingerprint_hint'] = isset($data['fingerprint_hint']) ? $data['fingerprint_hint'] : null;
        $this->container['current_version'] = isset($data['current_version']) ? $data['current_version'] : null;
        $this->container['staged_version'] = isset($data['staged_version']) ? $data['staged_version'] : null;
        $this->container['patch'] = isset($data['patch']) ? $data['patch'] : null;
        $this->container['status_code'] = isset($data['status_code']) ? $data['status_code'] : null;
        $this->container['edge_group'] = isset($data['edge_group']) ? $data['edge_group'] : null;
        $this->container['site'] = isset($data['site']) ? $data['site'] : null;
        $this->container['software_status'] = isset($data['software_status']) ? $data['software_status'] : null;
        $this->container['online_status'] = isset($data['online_status']) ? $data['online_status'] : null;
        $this->container['serial_number'] = isset($data['serial_number']) ? $data['serial_number'] : null;
        $this->container['physical_edge'] = isset($data['physical_edge']) ? $data['physical_edge'] : false;
        $this->container['managed'] = isset($data['managed']) ? $data['managed'] : false;
        $this->container['edge_deployment_type'] = isset($data['edge_deployment_type']) ? $data['edge_deployment_type'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NEW", "AWAITING_CONNECTION", "AWAITING_FINGERPRINT", "AWAITING_FINGERPRINT_VERIFICATION", "FINGERPRINT_VERIFIED", "AWAITING_BOOTSTRAP", "ACTIVE", "INACTIVE", "RMA", "UNPAIRING", "UNPAIRED");
        if (!in_array($this->container['status_code'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status_code', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ONLINE", "OFFLINE");
        if (!in_array($this->container['online_status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'online_status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("HARDWARE", "LDM", "CDM", "INVALID");
        if (!in_array($this->container['edge_deployment_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'edge_deployment_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NEW", "AWAITING_CONNECTION", "AWAITING_FINGERPRINT", "AWAITING_FINGERPRINT_VERIFICATION", "FINGERPRINT_VERIFIED", "AWAITING_BOOTSTRAP", "ACTIVE", "INACTIVE", "RMA", "UNPAIRING", "UNPAIRED");
        if (!in_array($this->container['status_code'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ONLINE", "OFFLINE");
        if (!in_array($this->container['online_status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("HARDWARE", "LDM", "CDM", "INVALID");
        if (!in_array($this->container['edge_deployment_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the entity.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets modified_by
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modified_by'];
    }

    /**
     * Sets modified_by
     * @param string $modified_by
     * @return $this
     */
    public function setModifiedBy($modified_by)
    {
        $this->container['modified_by'] = $modified_by;

        return $this;
    }

    /**
     * Gets created_by
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param string $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modified_by_app
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modified_by_app'];
    }

    /**
     * Sets modified_by_app
     * @param string $modified_by_app
     * @return $this
     */
    public function setModifiedByApp($modified_by_app)
    {
        $this->container['modified_by_app'] = $modified_by_app;

        return $this;
    }

    /**
     * Gets created_by_app
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['created_by_app'];
    }

    /**
     * Sets created_by_app
     * @param string $created_by_app
     * @return $this
     */
    public function setCreatedByApp($created_by_app)
    {
        $this->container['created_by_app'] = $created_by_app;

        return $this;
    }

    /**
     * Gets interfaces
     * @return \PureCloudSDK\EdgeInterface[]
     */
    public function getInterfaces()
    {
        return $this->container['interfaces'];
    }

    /**
     * Sets interfaces
     * @param \PureCloudSDK\EdgeInterface[] $interfaces
     * @return $this
     */
    public function setInterfaces($interfaces)
    {
        $this->container['interfaces'] = $interfaces;

        return $this;
    }

    /**
     * Gets make
     * @return string
     */
    public function getMake()
    {
        return $this->container['make'];
    }

    /**
     * Sets make
     * @param string $make
     * @return $this
     */
    public function setMake($make)
    {
        $this->container['make'] = $make;

        return $this;
    }

    /**
     * Gets model
     * @return string
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     * @param string $model
     * @return $this
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }

    /**
     * Gets api_version
     * @return string
     */
    public function getApiVersion()
    {
        return $this->container['api_version'];
    }

    /**
     * Sets api_version
     * @param string $api_version
     * @return $this
     */
    public function setApiVersion($api_version)
    {
        $this->container['api_version'] = $api_version;

        return $this;
    }

    /**
     * Gets software_version
     * @return string
     */
    public function getSoftwareVersion()
    {
        return $this->container['software_version'];
    }

    /**
     * Sets software_version
     * @param string $software_version
     * @return $this
     */
    public function setSoftwareVersion($software_version)
    {
        $this->container['software_version'] = $software_version;

        return $this;
    }

    /**
     * Gets software_version_timestamp
     * @return string
     */
    public function getSoftwareVersionTimestamp()
    {
        return $this->container['software_version_timestamp'];
    }

    /**
     * Sets software_version_timestamp
     * @param string $software_version_timestamp
     * @return $this
     */
    public function setSoftwareVersionTimestamp($software_version_timestamp)
    {
        $this->container['software_version_timestamp'] = $software_version_timestamp;

        return $this;
    }

    /**
     * Gets software_version_platform
     * @return string
     */
    public function getSoftwareVersionPlatform()
    {
        return $this->container['software_version_platform'];
    }

    /**
     * Sets software_version_platform
     * @param string $software_version_platform
     * @return $this
     */
    public function setSoftwareVersionPlatform($software_version_platform)
    {
        $this->container['software_version_platform'] = $software_version_platform;

        return $this;
    }

    /**
     * Gets software_version_configuration
     * @return string
     */
    public function getSoftwareVersionConfiguration()
    {
        return $this->container['software_version_configuration'];
    }

    /**
     * Sets software_version_configuration
     * @param string $software_version_configuration
     * @return $this
     */
    public function setSoftwareVersionConfiguration($software_version_configuration)
    {
        $this->container['software_version_configuration'] = $software_version_configuration;

        return $this;
    }

    /**
     * Gets full_software_version
     * @return string
     */
    public function getFullSoftwareVersion()
    {
        return $this->container['full_software_version'];
    }

    /**
     * Sets full_software_version
     * @param string $full_software_version
     * @return $this
     */
    public function setFullSoftwareVersion($full_software_version)
    {
        $this->container['full_software_version'] = $full_software_version;

        return $this;
    }

    /**
     * Gets pairing_id
     * @return string
     */
    public function getPairingId()
    {
        return $this->container['pairing_id'];
    }

    /**
     * Sets pairing_id
     * @param string $pairing_id The pairing Id for a hardware Edge in the format: 00000-00000-00000-00000-00000. This field is only required when creating an Edge with a deployment type of HARDWARE.
     * @return $this
     */
    public function setPairingId($pairing_id)
    {
        $this->container['pairing_id'] = $pairing_id;

        return $this;
    }

    /**
     * Gets fingerprint
     * @return string
     */
    public function getFingerprint()
    {
        return $this->container['fingerprint'];
    }

    /**
     * Sets fingerprint
     * @param string $fingerprint
     * @return $this
     */
    public function setFingerprint($fingerprint)
    {
        $this->container['fingerprint'] = $fingerprint;

        return $this;
    }

    /**
     * Gets fingerprint_hint
     * @return string
     */
    public function getFingerprintHint()
    {
        return $this->container['fingerprint_hint'];
    }

    /**
     * Sets fingerprint_hint
     * @param string $fingerprint_hint
     * @return $this
     */
    public function setFingerprintHint($fingerprint_hint)
    {
        $this->container['fingerprint_hint'] = $fingerprint_hint;

        return $this;
    }

    /**
     * Gets current_version
     * @return string
     */
    public function getCurrentVersion()
    {
        return $this->container['current_version'];
    }

    /**
     * Sets current_version
     * @param string $current_version
     * @return $this
     */
    public function setCurrentVersion($current_version)
    {
        $this->container['current_version'] = $current_version;

        return $this;
    }

    /**
     * Gets staged_version
     * @return string
     */
    public function getStagedVersion()
    {
        return $this->container['staged_version'];
    }

    /**
     * Sets staged_version
     * @param string $staged_version
     * @return $this
     */
    public function setStagedVersion($staged_version)
    {
        $this->container['staged_version'] = $staged_version;

        return $this;
    }

    /**
     * Gets patch
     * @return string
     */
    public function getPatch()
    {
        return $this->container['patch'];
    }

    /**
     * Sets patch
     * @param string $patch
     * @return $this
     */
    public function setPatch($patch)
    {
        $this->container['patch'] = $patch;

        return $this;
    }

    /**
     * Gets status_code
     * @return string
     */
    public function getStatusCode()
    {
        return $this->container['status_code'];
    }

    /**
     * Sets status_code
     * @param string $status_code
     * @return $this
     */
    public function setStatusCode($status_code)
    {
        $allowed_values = array('NEW', 'AWAITING_CONNECTION', 'AWAITING_FINGERPRINT', 'AWAITING_FINGERPRINT_VERIFICATION', 'FINGERPRINT_VERIFIED', 'AWAITING_BOOTSTRAP', 'ACTIVE', 'INACTIVE', 'RMA', 'UNPAIRING', 'UNPAIRED');
        if (!in_array($status_code, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status_code', must be one of 'NEW', 'AWAITING_CONNECTION', 'AWAITING_FINGERPRINT', 'AWAITING_FINGERPRINT_VERIFICATION', 'FINGERPRINT_VERIFIED', 'AWAITING_BOOTSTRAP', 'ACTIVE', 'INACTIVE', 'RMA', 'UNPAIRING', 'UNPAIRED'");
        }
        $this->container['status_code'] = $status_code;

        return $this;
    }

    /**
     * Gets edge_group
     * @return \PureCloudSDK\EdgeGroup
     */
    public function getEdgeGroup()
    {
        return $this->container['edge_group'];
    }

    /**
     * Sets edge_group
     * @param \PureCloudSDK\EdgeGroup $edge_group
     * @return $this
     */
    public function setEdgeGroup($edge_group)
    {
        $this->container['edge_group'] = $edge_group;

        return $this;
    }

    /**
     * Gets site
     * @return \PureCloudSDK\UriReference
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site
     * @param \PureCloudSDK\UriReference $site
     * @return $this
     */
    public function setSite($site)
    {
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets software_status
     * @return \PureCloudSDK\DomainEdgeSoftwareUpdateDto
     */
    public function getSoftwareStatus()
    {
        return $this->container['software_status'];
    }

    /**
     * Sets software_status
     * @param \PureCloudSDK\DomainEdgeSoftwareUpdateDto $software_status
     * @return $this
     */
    public function setSoftwareStatus($software_status)
    {
        $this->container['software_status'] = $software_status;

        return $this;
    }

    /**
     * Gets online_status
     * @return string
     */
    public function getOnlineStatus()
    {
        return $this->container['online_status'];
    }

    /**
     * Sets online_status
     * @param string $online_status
     * @return $this
     */
    public function setOnlineStatus($online_status)
    {
        $allowed_values = array('ONLINE', 'OFFLINE');
        if (!in_array($online_status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'online_status', must be one of 'ONLINE', 'OFFLINE'");
        }
        $this->container['online_status'] = $online_status;

        return $this;
    }

    /**
     * Gets serial_number
     * @return string
     */
    public function getSerialNumber()
    {
        return $this->container['serial_number'];
    }

    /**
     * Sets serial_number
     * @param string $serial_number
     * @return $this
     */
    public function setSerialNumber($serial_number)
    {
        $this->container['serial_number'] = $serial_number;

        return $this;
    }

    /**
     * Gets physical_edge
     * @return bool
     */
    public function getPhysicalEdge()
    {
        return $this->container['physical_edge'];
    }

    /**
     * Sets physical_edge
     * @param bool $physical_edge
     * @return $this
     */
    public function setPhysicalEdge($physical_edge)
    {
        $this->container['physical_edge'] = $physical_edge;

        return $this;
    }

    /**
     * Gets managed
     * @return bool
     */
    public function getManaged()
    {
        return $this->container['managed'];
    }

    /**
     * Sets managed
     * @param bool $managed
     * @return $this
     */
    public function setManaged($managed)
    {
        $this->container['managed'] = $managed;

        return $this;
    }

    /**
     * Gets edge_deployment_type
     * @return string
     */
    public function getEdgeDeploymentType()
    {
        return $this->container['edge_deployment_type'];
    }

    /**
     * Sets edge_deployment_type
     * @param string $edge_deployment_type
     * @return $this
     */
    public function setEdgeDeploymentType($edge_deployment_type)
    {
        $allowed_values = array('HARDWARE', 'LDM', 'CDM', 'INVALID');
        if (!in_array($edge_deployment_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'edge_deployment_type', must be one of 'HARDWARE', 'LDM', 'CDM', 'INVALID'");
        }
        $this->container['edge_deployment_type'] = $edge_deployment_type;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


