<?php
/**
 * EdgeInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * EdgeInterface Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EdgeInterface implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EdgeInterface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'ip_address' => 'string',
        'name' => 'string',
        'mac_address' => 'string',
        'if_name' => 'string',
        'endpoints' => '\PureCloudSDK\UriReference[]',
        'line_types' => 'string[]',
        'address_family_id' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'ip_address' => 'ipAddress',
        'name' => 'name',
        'mac_address' => 'macAddress',
        'if_name' => 'ifName',
        'endpoints' => 'endpoints',
        'line_types' => 'lineTypes',
        'address_family_id' => 'addressFamilyId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'ip_address' => 'setIpAddress',
        'name' => 'setName',
        'mac_address' => 'setMacAddress',
        'if_name' => 'setIfName',
        'endpoints' => 'setEndpoints',
        'line_types' => 'setLineTypes',
        'address_family_id' => 'setAddressFamilyId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'ip_address' => 'getIpAddress',
        'name' => 'getName',
        'mac_address' => 'getMacAddress',
        'if_name' => 'getIfName',
        'endpoints' => 'getEndpoints',
        'line_types' => 'getLineTypes',
        'address_family_id' => 'getAddressFamilyId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const LINE_TYPES_TIE = 'TIE';
    const LINE_TYPES_NETWORK = 'NETWORK';
    const LINE_TYPES_TRUNK = 'TRUNK';
    const LINE_TYPES_STATION = 'STATION';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLineTypesAllowableValues()
    {
        return [
            self::LINE_TYPES_TIE,
            self::LINE_TYPES_NETWORK,
            self::LINE_TYPES_TRUNK,
            self::LINE_TYPES_STATION,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['ip_address'] = isset($data['ip_address']) ? $data['ip_address'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['mac_address'] = isset($data['mac_address']) ? $data['mac_address'] : null;
        $this->container['if_name'] = isset($data['if_name']) ? $data['if_name'] : null;
        $this->container['endpoints'] = isset($data['endpoints']) ? $data['endpoints'] : null;
        $this->container['line_types'] = isset($data['line_types']) ? $data['line_types'] : null;
        $this->container['address_family_id'] = isset($data['address_family_id']) ? $data['address_family_id'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets ip_address
     * @return string
     */
    public function getIpAddress()
    {
        return $this->container['ip_address'];
    }

    /**
     * Sets ip_address
     * @param string $ip_address
     * @return $this
     */
    public function setIpAddress($ip_address)
    {
        $this->container['ip_address'] = $ip_address;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets mac_address
     * @return string
     */
    public function getMacAddress()
    {
        return $this->container['mac_address'];
    }

    /**
     * Sets mac_address
     * @param string $mac_address
     * @return $this
     */
    public function setMacAddress($mac_address)
    {
        $this->container['mac_address'] = $mac_address;

        return $this;
    }

    /**
     * Gets if_name
     * @return string
     */
    public function getIfName()
    {
        return $this->container['if_name'];
    }

    /**
     * Sets if_name
     * @param string $if_name
     * @return $this
     */
    public function setIfName($if_name)
    {
        $this->container['if_name'] = $if_name;

        return $this;
    }

    /**
     * Gets endpoints
     * @return \PureCloudSDK\UriReference[]
     */
    public function getEndpoints()
    {
        return $this->container['endpoints'];
    }

    /**
     * Sets endpoints
     * @param \PureCloudSDK\UriReference[] $endpoints
     * @return $this
     */
    public function setEndpoints($endpoints)
    {
        $this->container['endpoints'] = $endpoints;

        return $this;
    }

    /**
     * Gets line_types
     * @return string[]
     */
    public function getLineTypes()
    {
        return $this->container['line_types'];
    }

    /**
     * Sets line_types
     * @param string[] $line_types
     * @return $this
     */
    public function setLineTypes($line_types)
    {
        $allowed_values = array('TIE', 'NETWORK', 'TRUNK', 'STATION');
        if (!in_array($line_types, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'line_types', must be one of 'TIE', 'NETWORK', 'TRUNK', 'STATION'");
        }
        $this->container['line_types'] = $line_types;

        return $this;
    }

    /**
     * Gets address_family_id
     * @return string
     */
    public function getAddressFamilyId()
    {
        return $this->container['address_family_id'];
    }

    /**
     * Sets address_family_id
     * @param string $address_family_id
     * @return $this
     */
    public function setAddressFamilyId($address_family_id)
    {
        $this->container['address_family_id'] = $address_family_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


