<?php
/**
 * EdgeOfflineConfigurationInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * EdgeOfflineConfigurationInterface Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EdgeOfflineConfigurationInterface implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EdgeOfflineConfigurationInterface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'routes' => '\PureCloudSDK\DomainNetworkRoute[]',
        'addresses' => '\PureCloudSDK\DomainNetworkAddress[]',
        'ipv4_capabilities' => '\PureCloudSDK\DomainCapabilities',
        'ipv6_capabilities' => '\PureCloudSDK\DomainCapabilities'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'routes' => 'routes',
        'addresses' => 'addresses',
        'ipv4_capabilities' => 'ipv4Capabilities',
        'ipv6_capabilities' => 'ipv6Capabilities'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'routes' => 'setRoutes',
        'addresses' => 'setAddresses',
        'ipv4_capabilities' => 'setIpv4Capabilities',
        'ipv6_capabilities' => 'setIpv6Capabilities'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'routes' => 'getRoutes',
        'addresses' => 'getAddresses',
        'ipv4_capabilities' => 'getIpv4Capabilities',
        'ipv6_capabilities' => 'getIpv6Capabilities'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['routes'] = isset($data['routes']) ? $data['routes'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['ipv4_capabilities'] = isset($data['ipv4_capabilities']) ? $data['ipv4_capabilities'] : null;
        $this->container['ipv6_capabilities'] = isset($data['ipv6_capabilities']) ? $data['ipv6_capabilities'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets routes
     * @return \PureCloudSDK\DomainNetworkRoute[]
     */
    public function getRoutes()
    {
        return $this->container['routes'];
    }

    /**
     * Sets routes
     * @param \PureCloudSDK\DomainNetworkRoute[] $routes The list of routes assigned to this interface.
     * @return $this
     */
    public function setRoutes($routes)
    {
        $this->container['routes'] = $routes;

        return $this;
    }

    /**
     * Gets addresses
     * @return \PureCloudSDK\DomainNetworkAddress[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param \PureCloudSDK\DomainNetworkAddress[] $addresses The list of IP addresses on this interface.  Priority of dns addresses are based on order in the list.
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets ipv4_capabilities
     * @return \PureCloudSDK\DomainCapabilities
     */
    public function getIpv4Capabilities()
    {
        return $this->container['ipv4_capabilities'];
    }

    /**
     * Sets ipv4_capabilities
     * @param \PureCloudSDK\DomainCapabilities $ipv4_capabilities IPv4 interface settings.
     * @return $this
     */
    public function setIpv4Capabilities($ipv4_capabilities)
    {
        $this->container['ipv4_capabilities'] = $ipv4_capabilities;

        return $this;
    }

    /**
     * Gets ipv6_capabilities
     * @return \PureCloudSDK\DomainCapabilities
     */
    public function getIpv6Capabilities()
    {
        return $this->container['ipv6_capabilities'];
    }

    /**
     * Sets ipv6_capabilities
     * @param \PureCloudSDK\DomainCapabilities $ipv6_capabilities IPv6 interface settings.
     * @return $this
     */
    public function setIpv6Capabilities($ipv6_capabilities)
    {
        $this->container['ipv6_capabilities'] = $ipv6_capabilities;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


