<?php
/**
 * Email
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Email Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Email implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Email';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'id' => 'string',
        'held' => 'bool',
        'subject' => 'string',
        'messages_sent' => 'int',
        'segments' => '\PureCloudSDK\Segment[]',
        'direction' => 'string',
        'recording_id' => 'string',
        'error_info' => '\PureCloudSDK\ErrorBody',
        'disconnect_type' => 'string',
        'start_hold_time' => '\DateTime',
        'connected_time' => '\DateTime',
        'disconnected_time' => '\DateTime',
        'provider' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'id' => 'id',
        'held' => 'held',
        'subject' => 'subject',
        'messages_sent' => 'messagesSent',
        'segments' => 'segments',
        'direction' => 'direction',
        'recording_id' => 'recordingId',
        'error_info' => 'errorInfo',
        'disconnect_type' => 'disconnectType',
        'start_hold_time' => 'startHoldTime',
        'connected_time' => 'connectedTime',
        'disconnected_time' => 'disconnectedTime',
        'provider' => 'provider'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'id' => 'setId',
        'held' => 'setHeld',
        'subject' => 'setSubject',
        'messages_sent' => 'setMessagesSent',
        'segments' => 'setSegments',
        'direction' => 'setDirection',
        'recording_id' => 'setRecordingId',
        'error_info' => 'setErrorInfo',
        'disconnect_type' => 'setDisconnectType',
        'start_hold_time' => 'setStartHoldTime',
        'connected_time' => 'setConnectedTime',
        'disconnected_time' => 'setDisconnectedTime',
        'provider' => 'setProvider'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'id' => 'getId',
        'held' => 'getHeld',
        'subject' => 'getSubject',
        'messages_sent' => 'getMessagesSent',
        'segments' => 'getSegments',
        'direction' => 'getDirection',
        'recording_id' => 'getRecordingId',
        'error_info' => 'getErrorInfo',
        'disconnect_type' => 'getDisconnectType',
        'start_hold_time' => 'getStartHoldTime',
        'connected_time' => 'getConnectedTime',
        'disconnected_time' => 'getDisconnectedTime',
        'provider' => 'getProvider'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'ALERTING';
    const STATE_CONNECTED = 'CONNECTED';
    const STATE_DISCONNECTED = 'DISCONNECTED';
    const STATE_NONE = 'NONE';
    const DIRECTION_INBOUND = 'INBOUND';
    const DIRECTION_OUTBOUND = 'OUTBOUND';
    const DISCONNECT_TYPE_ENDPOINT = 'ENDPOINT';
    const DISCONNECT_TYPE_CLIENT = 'CLIENT';
    const DISCONNECT_TYPE_SYSTEM = 'SYSTEM';
    const DISCONNECT_TYPE_TIMEOUT = 'TIMEOUT';
    const DISCONNECT_TYPE_TRANSFER = 'TRANSFER';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'TRANSFER_CONFERENCE';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'TRANSFER_CONSULT';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'TRANSFER_FORWARD';
    const DISCONNECT_TYPE_TRANSFER_NOANSWER = 'TRANSFER_NOANSWER';
    const DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE = 'TRANSFER_NOTAVAILABLE';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'TRANSPORT_FAILURE';
    const DISCONNECT_TYPE_ERROR = 'ERROR';
    const DISCONNECT_TYPE_PEER = 'PEER';
    const DISCONNECT_TYPE_OTHER = 'OTHER';
    const DISCONNECT_TYPE_SPAM = 'SPAM';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSFER_NOANSWER,
            self::DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : false;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['messages_sent'] = isset($data['messages_sent']) ? $data['messages_sent'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['recording_id'] = isset($data['recording_id']) ? $data['recording_id'] : null;
        $this->container['error_info'] = isset($data['error_info']) ? $data['error_info'] : null;
        $this->container['disconnect_type'] = isset($data['disconnect_type']) ? $data['disconnect_type'] : null;
        $this->container['start_hold_time'] = isset($data['start_hold_time']) ? $data['start_hold_time'] : null;
        $this->container['connected_time'] = isset($data['connected_time']) ? $data['connected_time'] : null;
        $this->container['disconnected_time'] = isset($data['disconnected_time']) ? $data['disconnected_time'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ALERTING", "CONNECTED", "DISCONNECTED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnect_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ALERTING", "CONNECTED", "DISCONNECTED", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("INBOUND", "OUTBOUND");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ENDPOINT", "CLIENT", "SYSTEM", "TIMEOUT", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "TRANSFER_NOANSWER", "TRANSFER_NOTAVAILABLE", "TRANSPORT_FAILURE", "ERROR", "PEER", "OTHER", "SPAM");
        if (!in_array($this->container['disconnect_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The connection state of this communication.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('ALERTING', 'CONNECTED', 'DISCONNECTED', 'NONE');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'ALERTING', 'CONNECTED', 'DISCONNECTED', 'NONE'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A globally unique identifier for this communication.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held True if this call is held and the person on this side hears silence.
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets subject
     * @return string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param string $subject The subject for the initial email that started this conversation.
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets messages_sent
     * @return int
     */
    public function getMessagesSent()
    {
        return $this->container['messages_sent'];
    }

    /**
     * Sets messages_sent
     * @param int $messages_sent The number of email messages sent by this participant.
     * @return $this
     */
    public function setMessagesSent($messages_sent)
    {
        $this->container['messages_sent'] = $messages_sent;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\Segment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\Segment[] $segments The time line of the participant's email, divided into activity segments.
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The direction of the email
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('INBOUND', 'OUTBOUND');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'INBOUND', 'OUTBOUND'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets recording_id
     * @return string
     */
    public function getRecordingId()
    {
        return $this->container['recording_id'];
    }

    /**
     * Sets recording_id
     * @param string $recording_id A globally unique identifier for the recording associated with this call.
     * @return $this
     */
    public function setRecordingId($recording_id)
    {
        $this->container['recording_id'] = $recording_id;

        return $this;
    }

    /**
     * Gets error_info
     * @return \PureCloudSDK\ErrorBody
     */
    public function getErrorInfo()
    {
        return $this->container['error_info'];
    }

    /**
     * Sets error_info
     * @param \PureCloudSDK\ErrorBody $error_info
     * @return $this
     */
    public function setErrorInfo($error_info)
    {
        $this->container['error_info'] = $error_info;

        return $this;
    }

    /**
     * Gets disconnect_type
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnect_type'];
    }

    /**
     * Sets disconnect_type
     * @param string $disconnect_type System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.
     * @return $this
     */
    public function setDisconnectType($disconnect_type)
    {
        $allowed_values = array('ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM');
        if (!in_array($disconnect_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnect_type', must be one of 'ENDPOINT', 'CLIENT', 'SYSTEM', 'TIMEOUT', 'TRANSFER', 'TRANSFER_CONFERENCE', 'TRANSFER_CONSULT', 'TRANSFER_FORWARD', 'TRANSFER_NOANSWER', 'TRANSFER_NOTAVAILABLE', 'TRANSPORT_FAILURE', 'ERROR', 'PEER', 'OTHER', 'SPAM'");
        }
        $this->container['disconnect_type'] = $disconnect_type;

        return $this;
    }

    /**
     * Gets start_hold_time
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['start_hold_time'];
    }

    /**
     * Sets start_hold_time
     * @param \DateTime $start_hold_time The timestamp the email was placed on hold in the cloud clock if the email is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartHoldTime($start_hold_time)
    {
        $this->container['start_hold_time'] = $start_hold_time;

        return $this;
    }

    /**
     * Gets connected_time
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connected_time'];
    }

    /**
     * Sets connected_time
     * @param \DateTime $connected_time The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connected_time)
    {
        $this->container['connected_time'] = $connected_time;

        return $this;
    }

    /**
     * Gets disconnected_time
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnected_time'];
    }

    /**
     * Sets disconnected_time
     * @param \DateTime $disconnected_time The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDisconnectedTime($disconnected_time)
    {
        $this->container['disconnected_time'] = $disconnected_time;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the email.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


