<?php
/**
 * Evaluation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Evaluation Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Evaluation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Evaluation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'conversation' => '\PureCloudSDK\Conversation',
        'evaluation_form' => '\PureCloudSDK\EvaluationForm',
        'evaluator' => '\PureCloudSDK\User',
        'agent' => '\PureCloudSDK\User',
        'calibration' => '\PureCloudSDK\Calibration',
        'status' => 'string',
        'answers' => '\PureCloudSDK\EvaluationScoringSet',
        'agent_has_read' => 'bool',
        'release_date' => '\DateTime',
        'assigned_date' => '\DateTime',
        'changed_date' => '\DateTime',
        'queue' => '\PureCloudSDK\Queue',
        'never_release' => 'bool',
        'resource_id' => 'string',
        'resource_type' => 'string',
        'redacted' => 'bool',
        'is_scoring_index' => 'bool',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'conversation' => 'conversation',
        'evaluation_form' => 'evaluationForm',
        'evaluator' => 'evaluator',
        'agent' => 'agent',
        'calibration' => 'calibration',
        'status' => 'status',
        'answers' => 'answers',
        'agent_has_read' => 'agentHasRead',
        'release_date' => 'releaseDate',
        'assigned_date' => 'assignedDate',
        'changed_date' => 'changedDate',
        'queue' => 'queue',
        'never_release' => 'neverRelease',
        'resource_id' => 'resourceId',
        'resource_type' => 'resourceType',
        'redacted' => 'redacted',
        'is_scoring_index' => 'isScoringIndex',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'conversation' => 'setConversation',
        'evaluation_form' => 'setEvaluationForm',
        'evaluator' => 'setEvaluator',
        'agent' => 'setAgent',
        'calibration' => 'setCalibration',
        'status' => 'setStatus',
        'answers' => 'setAnswers',
        'agent_has_read' => 'setAgentHasRead',
        'release_date' => 'setReleaseDate',
        'assigned_date' => 'setAssignedDate',
        'changed_date' => 'setChangedDate',
        'queue' => 'setQueue',
        'never_release' => 'setNeverRelease',
        'resource_id' => 'setResourceId',
        'resource_type' => 'setResourceType',
        'redacted' => 'setRedacted',
        'is_scoring_index' => 'setIsScoringIndex',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'conversation' => 'getConversation',
        'evaluation_form' => 'getEvaluationForm',
        'evaluator' => 'getEvaluator',
        'agent' => 'getAgent',
        'calibration' => 'getCalibration',
        'status' => 'getStatus',
        'answers' => 'getAnswers',
        'agent_has_read' => 'getAgentHasRead',
        'release_date' => 'getReleaseDate',
        'assigned_date' => 'getAssignedDate',
        'changed_date' => 'getChangedDate',
        'queue' => 'getQueue',
        'never_release' => 'getNeverRelease',
        'resource_id' => 'getResourceId',
        'resource_type' => 'getResourceType',
        'redacted' => 'getRedacted',
        'is_scoring_index' => 'getIsScoringIndex',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_PENDING = 'PENDING';
    const STATUS_INPROGRESS = 'INPROGRESS';
    const STATUS_FINISHED = 'FINISHED';
    const RESOURCE_TYPE_EMAIL = 'EMAIL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_PENDING,
            self::STATUS_INPROGRESS,
            self::STATUS_FINISHED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getResourceTypeAllowableValues()
    {
        return [
            self::RESOURCE_TYPE_EMAIL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['evaluation_form'] = isset($data['evaluation_form']) ? $data['evaluation_form'] : null;
        $this->container['evaluator'] = isset($data['evaluator']) ? $data['evaluator'] : null;
        $this->container['agent'] = isset($data['agent']) ? $data['agent'] : null;
        $this->container['calibration'] = isset($data['calibration']) ? $data['calibration'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['answers'] = isset($data['answers']) ? $data['answers'] : null;
        $this->container['agent_has_read'] = isset($data['agent_has_read']) ? $data['agent_has_read'] : false;
        $this->container['release_date'] = isset($data['release_date']) ? $data['release_date'] : null;
        $this->container['assigned_date'] = isset($data['assigned_date']) ? $data['assigned_date'] : null;
        $this->container['changed_date'] = isset($data['changed_date']) ? $data['changed_date'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['never_release'] = isset($data['never_release']) ? $data['never_release'] : false;
        $this->container['resource_id'] = isset($data['resource_id']) ? $data['resource_id'] : null;
        $this->container['resource_type'] = isset($data['resource_type']) ? $data['resource_type'] : null;
        $this->container['redacted'] = isset($data['redacted']) ? $data['redacted'] : false;
        $this->container['is_scoring_index'] = isset($data['is_scoring_index']) ? $data['is_scoring_index'] : false;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("PENDING", "INPROGRESS", "FINISHED");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("EMAIL");
        if (!in_array($this->container['resource_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'resource_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("PENDING", "INPROGRESS", "FINISHED");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("EMAIL");
        if (!in_array($this->container['resource_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets evaluation_form
     * @return \PureCloudSDK\EvaluationForm
     */
    public function getEvaluationForm()
    {
        return $this->container['evaluation_form'];
    }

    /**
     * Sets evaluation_form
     * @param \PureCloudSDK\EvaluationForm $evaluation_form Evaluation form used for evaluation.
     * @return $this
     */
    public function setEvaluationForm($evaluation_form)
    {
        $this->container['evaluation_form'] = $evaluation_form;

        return $this;
    }

    /**
     * Gets evaluator
     * @return \PureCloudSDK\User
     */
    public function getEvaluator()
    {
        return $this->container['evaluator'];
    }

    /**
     * Sets evaluator
     * @param \PureCloudSDK\User $evaluator
     * @return $this
     */
    public function setEvaluator($evaluator)
    {
        $this->container['evaluator'] = $evaluator;

        return $this;
    }

    /**
     * Gets agent
     * @return \PureCloudSDK\User
     */
    public function getAgent()
    {
        return $this->container['agent'];
    }

    /**
     * Sets agent
     * @param \PureCloudSDK\User $agent
     * @return $this
     */
    public function setAgent($agent)
    {
        $this->container['agent'] = $agent;

        return $this;
    }

    /**
     * Gets calibration
     * @return \PureCloudSDK\Calibration
     */
    public function getCalibration()
    {
        return $this->container['calibration'];
    }

    /**
     * Sets calibration
     * @param \PureCloudSDK\Calibration $calibration
     * @return $this
     */
    public function setCalibration($calibration)
    {
        $this->container['calibration'] = $calibration;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('PENDING', 'INPROGRESS', 'FINISHED');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'PENDING', 'INPROGRESS', 'FINISHED'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets answers
     * @return \PureCloudSDK\EvaluationScoringSet
     */
    public function getAnswers()
    {
        return $this->container['answers'];
    }

    /**
     * Sets answers
     * @param \PureCloudSDK\EvaluationScoringSet $answers
     * @return $this
     */
    public function setAnswers($answers)
    {
        $this->container['answers'] = $answers;

        return $this;
    }

    /**
     * Gets agent_has_read
     * @return bool
     */
    public function getAgentHasRead()
    {
        return $this->container['agent_has_read'];
    }

    /**
     * Sets agent_has_read
     * @param bool $agent_has_read
     * @return $this
     */
    public function setAgentHasRead($agent_has_read)
    {
        $this->container['agent_has_read'] = $agent_has_read;

        return $this;
    }

    /**
     * Gets release_date
     * @return \DateTime
     */
    public function getReleaseDate()
    {
        return $this->container['release_date'];
    }

    /**
     * Sets release_date
     * @param \DateTime $release_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setReleaseDate($release_date)
    {
        $this->container['release_date'] = $release_date;

        return $this;
    }

    /**
     * Gets assigned_date
     * @return \DateTime
     */
    public function getAssignedDate()
    {
        return $this->container['assigned_date'];
    }

    /**
     * Sets assigned_date
     * @param \DateTime $assigned_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setAssignedDate($assigned_date)
    {
        $this->container['assigned_date'] = $assigned_date;

        return $this;
    }

    /**
     * Gets changed_date
     * @return \DateTime
     */
    public function getChangedDate()
    {
        return $this->container['changed_date'];
    }

    /**
     * Sets changed_date
     * @param \DateTime $changed_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setChangedDate($changed_date)
    {
        $this->container['changed_date'] = $changed_date;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\Queue
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\Queue $queue
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets never_release
     * @return bool
     */
    public function getNeverRelease()
    {
        return $this->container['never_release'];
    }

    /**
     * Sets never_release
     * @param bool $never_release Signifies if the evaluation is never to be released. This cannot be set true if release date is also set.
     * @return $this
     */
    public function setNeverRelease($never_release)
    {
        $this->container['never_release'] = $never_release;

        return $this;
    }

    /**
     * Gets resource_id
     * @return string
     */
    public function getResourceId()
    {
        return $this->container['resource_id'];
    }

    /**
     * Sets resource_id
     * @param string $resource_id Only used for email evaluations. Will be null for all other evaluations.
     * @return $this
     */
    public function setResourceId($resource_id)
    {
        $this->container['resource_id'] = $resource_id;

        return $this;
    }

    /**
     * Gets resource_type
     * @return string
     */
    public function getResourceType()
    {
        return $this->container['resource_type'];
    }

    /**
     * Sets resource_type
     * @param string $resource_type The type of resource. Only used for email evaluations. Will be null for evaluations on all other resources.
     * @return $this
     */
    public function setResourceType($resource_type)
    {
        $allowed_values = array('EMAIL');
        if (!in_array($resource_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'resource_type', must be one of 'EMAIL'");
        }
        $this->container['resource_type'] = $resource_type;

        return $this;
    }

    /**
     * Gets redacted
     * @return bool
     */
    public function getRedacted()
    {
        return $this->container['redacted'];
    }

    /**
     * Sets redacted
     * @param bool $redacted Is only true when the user making the request does not have sufficient permissions to see evaluation
     * @return $this
     */
    public function setRedacted($redacted)
    {
        $this->container['redacted'] = $redacted;

        return $this;
    }

    /**
     * Gets is_scoring_index
     * @return bool
     */
    public function getIsScoringIndex()
    {
        return $this->container['is_scoring_index'];
    }

    /**
     * Sets is_scoring_index
     * @param bool $is_scoring_index
     * @return $this
     */
    public function setIsScoringIndex($is_scoring_index)
    {
        $this->container['is_scoring_index'] = $is_scoring_index;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


