<?php
/**
 * EvaluationScoringSet
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * EvaluationScoringSet Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EvaluationScoringSet implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EvaluationScoringSet';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'total_score' => 'float',
        'total_critical_score' => 'float',
        'question_group_scores' => '\PureCloudSDK\QuestionGroupScore[]',
        'any_failed_kill_questions' => 'bool',
        'comments' => 'string',
        'agent_comments' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'total_score' => 'totalScore',
        'total_critical_score' => 'totalCriticalScore',
        'question_group_scores' => 'questionGroupScores',
        'any_failed_kill_questions' => 'anyFailedKillQuestions',
        'comments' => 'comments',
        'agent_comments' => 'agentComments'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'total_score' => 'setTotalScore',
        'total_critical_score' => 'setTotalCriticalScore',
        'question_group_scores' => 'setQuestionGroupScores',
        'any_failed_kill_questions' => 'setAnyFailedKillQuestions',
        'comments' => 'setComments',
        'agent_comments' => 'setAgentComments'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'total_score' => 'getTotalScore',
        'total_critical_score' => 'getTotalCriticalScore',
        'question_group_scores' => 'getQuestionGroupScores',
        'any_failed_kill_questions' => 'getAnyFailedKillQuestions',
        'comments' => 'getComments',
        'agent_comments' => 'getAgentComments'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['total_score'] = isset($data['total_score']) ? $data['total_score'] : null;
        $this->container['total_critical_score'] = isset($data['total_critical_score']) ? $data['total_critical_score'] : null;
        $this->container['question_group_scores'] = isset($data['question_group_scores']) ? $data['question_group_scores'] : null;
        $this->container['any_failed_kill_questions'] = isset($data['any_failed_kill_questions']) ? $data['any_failed_kill_questions'] : false;
        $this->container['comments'] = isset($data['comments']) ? $data['comments'] : null;
        $this->container['agent_comments'] = isset($data['agent_comments']) ? $data['agent_comments'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets total_score
     * @return float
     */
    public function getTotalScore()
    {
        return $this->container['total_score'];
    }

    /**
     * Sets total_score
     * @param float $total_score
     * @return $this
     */
    public function setTotalScore($total_score)
    {
        $this->container['total_score'] = $total_score;

        return $this;
    }

    /**
     * Gets total_critical_score
     * @return float
     */
    public function getTotalCriticalScore()
    {
        return $this->container['total_critical_score'];
    }

    /**
     * Sets total_critical_score
     * @param float $total_critical_score
     * @return $this
     */
    public function setTotalCriticalScore($total_critical_score)
    {
        $this->container['total_critical_score'] = $total_critical_score;

        return $this;
    }

    /**
     * Gets question_group_scores
     * @return \PureCloudSDK\QuestionGroupScore[]
     */
    public function getQuestionGroupScores()
    {
        return $this->container['question_group_scores'];
    }

    /**
     * Sets question_group_scores
     * @param \PureCloudSDK\QuestionGroupScore[] $question_group_scores
     * @return $this
     */
    public function setQuestionGroupScores($question_group_scores)
    {
        $this->container['question_group_scores'] = $question_group_scores;

        return $this;
    }

    /**
     * Gets any_failed_kill_questions
     * @return bool
     */
    public function getAnyFailedKillQuestions()
    {
        return $this->container['any_failed_kill_questions'];
    }

    /**
     * Sets any_failed_kill_questions
     * @param bool $any_failed_kill_questions
     * @return $this
     */
    public function setAnyFailedKillQuestions($any_failed_kill_questions)
    {
        $this->container['any_failed_kill_questions'] = $any_failed_kill_questions;

        return $this;
    }

    /**
     * Gets comments
     * @return string
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     * @param string $comments
     * @return $this
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets agent_comments
     * @return string
     */
    public function getAgentComments()
    {
        return $this->container['agent_comments'];
    }

    /**
     * Sets agent_comments
     * @param string $agent_comments
     * @return $this
     */
    public function setAgentComments($agent_comments)
    {
        $this->container['agent_comments'] = $agent_comments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


