<?php
/**
 * EvaluatorActivity
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * EvaluatorActivity Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EvaluatorActivity implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EvaluatorActivity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'evaluator' => '\PureCloudSDK\User',
        'num_evaluations_assigned' => 'int',
        'num_evaluations_started' => 'int',
        'num_evaluations_completed' => 'int',
        'num_calibrations_assigned' => 'int',
        'num_calibrations_started' => 'int',
        'num_calibrations_completed' => 'int',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'evaluator' => 'evaluator',
        'num_evaluations_assigned' => 'numEvaluationsAssigned',
        'num_evaluations_started' => 'numEvaluationsStarted',
        'num_evaluations_completed' => 'numEvaluationsCompleted',
        'num_calibrations_assigned' => 'numCalibrationsAssigned',
        'num_calibrations_started' => 'numCalibrationsStarted',
        'num_calibrations_completed' => 'numCalibrationsCompleted',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'evaluator' => 'setEvaluator',
        'num_evaluations_assigned' => 'setNumEvaluationsAssigned',
        'num_evaluations_started' => 'setNumEvaluationsStarted',
        'num_evaluations_completed' => 'setNumEvaluationsCompleted',
        'num_calibrations_assigned' => 'setNumCalibrationsAssigned',
        'num_calibrations_started' => 'setNumCalibrationsStarted',
        'num_calibrations_completed' => 'setNumCalibrationsCompleted',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'evaluator' => 'getEvaluator',
        'num_evaluations_assigned' => 'getNumEvaluationsAssigned',
        'num_evaluations_started' => 'getNumEvaluationsStarted',
        'num_evaluations_completed' => 'getNumEvaluationsCompleted',
        'num_calibrations_assigned' => 'getNumCalibrationsAssigned',
        'num_calibrations_started' => 'getNumCalibrationsStarted',
        'num_calibrations_completed' => 'getNumCalibrationsCompleted',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['evaluator'] = isset($data['evaluator']) ? $data['evaluator'] : null;
        $this->container['num_evaluations_assigned'] = isset($data['num_evaluations_assigned']) ? $data['num_evaluations_assigned'] : null;
        $this->container['num_evaluations_started'] = isset($data['num_evaluations_started']) ? $data['num_evaluations_started'] : null;
        $this->container['num_evaluations_completed'] = isset($data['num_evaluations_completed']) ? $data['num_evaluations_completed'] : null;
        $this->container['num_calibrations_assigned'] = isset($data['num_calibrations_assigned']) ? $data['num_calibrations_assigned'] : null;
        $this->container['num_calibrations_started'] = isset($data['num_calibrations_started']) ? $data['num_calibrations_started'] : null;
        $this->container['num_calibrations_completed'] = isset($data['num_calibrations_completed']) ? $data['num_calibrations_completed'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets evaluator
     * @return \PureCloudSDK\User
     */
    public function getEvaluator()
    {
        return $this->container['evaluator'];
    }

    /**
     * Sets evaluator
     * @param \PureCloudSDK\User $evaluator
     * @return $this
     */
    public function setEvaluator($evaluator)
    {
        $this->container['evaluator'] = $evaluator;

        return $this;
    }

    /**
     * Gets num_evaluations_assigned
     * @return int
     */
    public function getNumEvaluationsAssigned()
    {
        return $this->container['num_evaluations_assigned'];
    }

    /**
     * Sets num_evaluations_assigned
     * @param int $num_evaluations_assigned
     * @return $this
     */
    public function setNumEvaluationsAssigned($num_evaluations_assigned)
    {
        $this->container['num_evaluations_assigned'] = $num_evaluations_assigned;

        return $this;
    }

    /**
     * Gets num_evaluations_started
     * @return int
     */
    public function getNumEvaluationsStarted()
    {
        return $this->container['num_evaluations_started'];
    }

    /**
     * Sets num_evaluations_started
     * @param int $num_evaluations_started
     * @return $this
     */
    public function setNumEvaluationsStarted($num_evaluations_started)
    {
        $this->container['num_evaluations_started'] = $num_evaluations_started;

        return $this;
    }

    /**
     * Gets num_evaluations_completed
     * @return int
     */
    public function getNumEvaluationsCompleted()
    {
        return $this->container['num_evaluations_completed'];
    }

    /**
     * Sets num_evaluations_completed
     * @param int $num_evaluations_completed
     * @return $this
     */
    public function setNumEvaluationsCompleted($num_evaluations_completed)
    {
        $this->container['num_evaluations_completed'] = $num_evaluations_completed;

        return $this;
    }

    /**
     * Gets num_calibrations_assigned
     * @return int
     */
    public function getNumCalibrationsAssigned()
    {
        return $this->container['num_calibrations_assigned'];
    }

    /**
     * Sets num_calibrations_assigned
     * @param int $num_calibrations_assigned
     * @return $this
     */
    public function setNumCalibrationsAssigned($num_calibrations_assigned)
    {
        $this->container['num_calibrations_assigned'] = $num_calibrations_assigned;

        return $this;
    }

    /**
     * Gets num_calibrations_started
     * @return int
     */
    public function getNumCalibrationsStarted()
    {
        return $this->container['num_calibrations_started'];
    }

    /**
     * Sets num_calibrations_started
     * @param int $num_calibrations_started
     * @return $this
     */
    public function setNumCalibrationsStarted($num_calibrations_started)
    {
        $this->container['num_calibrations_started'] = $num_calibrations_started;

        return $this;
    }

    /**
     * Gets num_calibrations_completed
     * @return int
     */
    public function getNumCalibrationsCompleted()
    {
        return $this->container['num_calibrations_completed'];
    }

    /**
     * Sets num_calibrations_completed
     * @param int $num_calibrations_completed
     * @return $this
     */
    public function setNumCalibrationsCompleted($num_calibrations_completed)
    {
        $this->container['num_calibrations_completed'] = $num_calibrations_completed;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


