<?php
/**
 * FacetStatistics
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FacetStatistics Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FacetStatistics implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FacetStatistics';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'count' => 'int',
        'min' => 'double',
        'max' => 'double',
        'mean' => 'double',
        'std_deviation' => 'double',
        'date_min' => '\DateTime',
        'date_max' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'count' => 'count',
        'min' => 'min',
        'max' => 'max',
        'mean' => 'mean',
        'std_deviation' => 'stdDeviation',
        'date_min' => 'dateMin',
        'date_max' => 'dateMax'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'count' => 'setCount',
        'min' => 'setMin',
        'max' => 'setMax',
        'mean' => 'setMean',
        'std_deviation' => 'setStdDeviation',
        'date_min' => 'setDateMin',
        'date_max' => 'setDateMax'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'count' => 'getCount',
        'min' => 'getMin',
        'max' => 'getMax',
        'mean' => 'getMean',
        'std_deviation' => 'getStdDeviation',
        'date_min' => 'getDateMin',
        'date_max' => 'getDateMax'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['count'] = isset($data['count']) ? $data['count'] : null;
        $this->container['min'] = isset($data['min']) ? $data['min'] : null;
        $this->container['max'] = isset($data['max']) ? $data['max'] : null;
        $this->container['mean'] = isset($data['mean']) ? $data['mean'] : null;
        $this->container['std_deviation'] = isset($data['std_deviation']) ? $data['std_deviation'] : null;
        $this->container['date_min'] = isset($data['date_min']) ? $data['date_min'] : null;
        $this->container['date_max'] = isset($data['date_max']) ? $data['date_max'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets count
     * @return int
     */
    public function getCount()
    {
        return $this->container['count'];
    }

    /**
     * Sets count
     * @param int $count
     * @return $this
     */
    public function setCount($count)
    {
        $this->container['count'] = $count;

        return $this;
    }

    /**
     * Gets min
     * @return double
     */
    public function getMin()
    {
        return $this->container['min'];
    }

    /**
     * Sets min
     * @param double $min
     * @return $this
     */
    public function setMin($min)
    {
        $this->container['min'] = $min;

        return $this;
    }

    /**
     * Gets max
     * @return double
     */
    public function getMax()
    {
        return $this->container['max'];
    }

    /**
     * Sets max
     * @param double $max
     * @return $this
     */
    public function setMax($max)
    {
        $this->container['max'] = $max;

        return $this;
    }

    /**
     * Gets mean
     * @return double
     */
    public function getMean()
    {
        return $this->container['mean'];
    }

    /**
     * Sets mean
     * @param double $mean
     * @return $this
     */
    public function setMean($mean)
    {
        $this->container['mean'] = $mean;

        return $this;
    }

    /**
     * Gets std_deviation
     * @return double
     */
    public function getStdDeviation()
    {
        return $this->container['std_deviation'];
    }

    /**
     * Sets std_deviation
     * @param double $std_deviation
     * @return $this
     */
    public function setStdDeviation($std_deviation)
    {
        $this->container['std_deviation'] = $std_deviation;

        return $this;
    }

    /**
     * Gets date_min
     * @return \DateTime
     */
    public function getDateMin()
    {
        return $this->container['date_min'];
    }

    /**
     * Sets date_min
     * @param \DateTime $date_min Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateMin($date_min)
    {
        $this->container['date_min'] = $date_min;

        return $this;
    }

    /**
     * Gets date_max
     * @return \DateTime
     */
    public function getDateMax()
    {
        return $this->container['date_max'];
    }

    /**
     * Sets date_max
     * @param \DateTime $date_max Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateMax($date_max)
    {
        $this->container['date_max'] = $date_max;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


