<?php
/**
 * FaxDocument
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FaxDocument Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FaxDocument implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FaxDocument';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'date_created' => '\DateTime',
        'date_modified' => '\DateTime',
        'content_uri' => 'string',
        'workspace' => '\PureCloudSDK\UriReference',
        'created_by' => '\PureCloudSDK\UriReference',
        'content_type' => 'string',
        'content_length' => 'int',
        'filename' => 'string',
        'read' => 'bool',
        'page_count' => 'int',
        'caller_address' => 'string',
        'receiver_address' => 'string',
        'thumbnails' => '\PureCloudSDK\DocumentThumbnail[]',
        'sharing_uri' => 'string',
        'download_sharing_uri' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'date_created' => 'dateCreated',
        'date_modified' => 'dateModified',
        'content_uri' => 'contentUri',
        'workspace' => 'workspace',
        'created_by' => 'createdBy',
        'content_type' => 'contentType',
        'content_length' => 'contentLength',
        'filename' => 'filename',
        'read' => 'read',
        'page_count' => 'pageCount',
        'caller_address' => 'callerAddress',
        'receiver_address' => 'receiverAddress',
        'thumbnails' => 'thumbnails',
        'sharing_uri' => 'sharingUri',
        'download_sharing_uri' => 'downloadSharingUri',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'content_uri' => 'setContentUri',
        'workspace' => 'setWorkspace',
        'created_by' => 'setCreatedBy',
        'content_type' => 'setContentType',
        'content_length' => 'setContentLength',
        'filename' => 'setFilename',
        'read' => 'setRead',
        'page_count' => 'setPageCount',
        'caller_address' => 'setCallerAddress',
        'receiver_address' => 'setReceiverAddress',
        'thumbnails' => 'setThumbnails',
        'sharing_uri' => 'setSharingUri',
        'download_sharing_uri' => 'setDownloadSharingUri',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'content_uri' => 'getContentUri',
        'workspace' => 'getWorkspace',
        'created_by' => 'getCreatedBy',
        'content_type' => 'getContentType',
        'content_length' => 'getContentLength',
        'filename' => 'getFilename',
        'read' => 'getRead',
        'page_count' => 'getPageCount',
        'caller_address' => 'getCallerAddress',
        'receiver_address' => 'getReceiverAddress',
        'thumbnails' => 'getThumbnails',
        'sharing_uri' => 'getSharingUri',
        'download_sharing_uri' => 'getDownloadSharingUri',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['date_created'] = isset($data['date_created']) ? $data['date_created'] : null;
        $this->container['date_modified'] = isset($data['date_modified']) ? $data['date_modified'] : null;
        $this->container['content_uri'] = isset($data['content_uri']) ? $data['content_uri'] : null;
        $this->container['workspace'] = isset($data['workspace']) ? $data['workspace'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['content_type'] = isset($data['content_type']) ? $data['content_type'] : null;
        $this->container['content_length'] = isset($data['content_length']) ? $data['content_length'] : null;
        $this->container['filename'] = isset($data['filename']) ? $data['filename'] : null;
        $this->container['read'] = isset($data['read']) ? $data['read'] : false;
        $this->container['page_count'] = isset($data['page_count']) ? $data['page_count'] : null;
        $this->container['caller_address'] = isset($data['caller_address']) ? $data['caller_address'] : null;
        $this->container['receiver_address'] = isset($data['receiver_address']) ? $data['receiver_address'] : null;
        $this->container['thumbnails'] = isset($data['thumbnails']) ? $data['thumbnails'] : null;
        $this->container['sharing_uri'] = isset($data['sharing_uri']) ? $data['sharing_uri'] : null;
        $this->container['download_sharing_uri'] = isset($data['download_sharing_uri']) ? $data['download_sharing_uri'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets content_uri
     * @return string
     */
    public function getContentUri()
    {
        return $this->container['content_uri'];
    }

    /**
     * Sets content_uri
     * @param string $content_uri
     * @return $this
     */
    public function setContentUri($content_uri)
    {
        $this->container['content_uri'] = $content_uri;

        return $this;
    }

    /**
     * Gets workspace
     * @return \PureCloudSDK\UriReference
     */
    public function getWorkspace()
    {
        return $this->container['workspace'];
    }

    /**
     * Sets workspace
     * @param \PureCloudSDK\UriReference $workspace
     * @return $this
     */
    public function setWorkspace($workspace)
    {
        $this->container['workspace'] = $workspace;

        return $this;
    }

    /**
     * Gets created_by
     * @return \PureCloudSDK\UriReference
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param \PureCloudSDK\UriReference $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets content_type
     * @return string
     */
    public function getContentType()
    {
        return $this->container['content_type'];
    }

    /**
     * Sets content_type
     * @param string $content_type
     * @return $this
     */
    public function setContentType($content_type)
    {
        $this->container['content_type'] = $content_type;

        return $this;
    }

    /**
     * Gets content_length
     * @return int
     */
    public function getContentLength()
    {
        return $this->container['content_length'];
    }

    /**
     * Sets content_length
     * @param int $content_length
     * @return $this
     */
    public function setContentLength($content_length)
    {
        $this->container['content_length'] = $content_length;

        return $this;
    }

    /**
     * Gets filename
     * @return string
     */
    public function getFilename()
    {
        return $this->container['filename'];
    }

    /**
     * Sets filename
     * @param string $filename
     * @return $this
     */
    public function setFilename($filename)
    {
        $this->container['filename'] = $filename;

        return $this;
    }

    /**
     * Gets read
     * @return bool
     */
    public function getRead()
    {
        return $this->container['read'];
    }

    /**
     * Sets read
     * @param bool $read
     * @return $this
     */
    public function setRead($read)
    {
        $this->container['read'] = $read;

        return $this;
    }

    /**
     * Gets page_count
     * @return int
     */
    public function getPageCount()
    {
        return $this->container['page_count'];
    }

    /**
     * Sets page_count
     * @param int $page_count
     * @return $this
     */
    public function setPageCount($page_count)
    {
        $this->container['page_count'] = $page_count;

        return $this;
    }

    /**
     * Gets caller_address
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['caller_address'];
    }

    /**
     * Sets caller_address
     * @param string $caller_address
     * @return $this
     */
    public function setCallerAddress($caller_address)
    {
        $this->container['caller_address'] = $caller_address;

        return $this;
    }

    /**
     * Gets receiver_address
     * @return string
     */
    public function getReceiverAddress()
    {
        return $this->container['receiver_address'];
    }

    /**
     * Sets receiver_address
     * @param string $receiver_address
     * @return $this
     */
    public function setReceiverAddress($receiver_address)
    {
        $this->container['receiver_address'] = $receiver_address;

        return $this;
    }

    /**
     * Gets thumbnails
     * @return \PureCloudSDK\DocumentThumbnail[]
     */
    public function getThumbnails()
    {
        return $this->container['thumbnails'];
    }

    /**
     * Sets thumbnails
     * @param \PureCloudSDK\DocumentThumbnail[] $thumbnails
     * @return $this
     */
    public function setThumbnails($thumbnails)
    {
        $this->container['thumbnails'] = $thumbnails;

        return $this;
    }

    /**
     * Gets sharing_uri
     * @return string
     */
    public function getSharingUri()
    {
        return $this->container['sharing_uri'];
    }

    /**
     * Sets sharing_uri
     * @param string $sharing_uri
     * @return $this
     */
    public function setSharingUri($sharing_uri)
    {
        $this->container['sharing_uri'] = $sharing_uri;

        return $this;
    }

    /**
     * Gets download_sharing_uri
     * @return string
     */
    public function getDownloadSharingUri()
    {
        return $this->container['download_sharing_uri'];
    }

    /**
     * Sets download_sharing_uri
     * @param string $download_sharing_uri
     * @return $this
     */
    public function setDownloadSharingUri($download_sharing_uri)
    {
        $this->container['download_sharing_uri'] = $download_sharing_uri;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


