<?php
/**
 * FaxSendRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FaxSendRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FaxSendRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FaxSendRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'addresses' => 'string[]',
        'document_id' => 'string',
        'content_type' => 'string',
        'workspace' => '\PureCloudSDK\Workspace',
        'cover_sheet' => '\PureCloudSDK\CoverSheet',
        'time_zone_offset_minutes' => 'int',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'addresses' => 'addresses',
        'document_id' => 'documentId',
        'content_type' => 'contentType',
        'workspace' => 'workspace',
        'cover_sheet' => 'coverSheet',
        'time_zone_offset_minutes' => 'timeZoneOffsetMinutes',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'addresses' => 'setAddresses',
        'document_id' => 'setDocumentId',
        'content_type' => 'setContentType',
        'workspace' => 'setWorkspace',
        'cover_sheet' => 'setCoverSheet',
        'time_zone_offset_minutes' => 'setTimeZoneOffsetMinutes',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'addresses' => 'getAddresses',
        'document_id' => 'getDocumentId',
        'content_type' => 'getContentType',
        'workspace' => 'getWorkspace',
        'cover_sheet' => 'getCoverSheet',
        'time_zone_offset_minutes' => 'getTimeZoneOffsetMinutes',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const CONTENT_TYPE_APPLICATIONPDF = 'application/pdf';
    const CONTENT_TYPE_IMAGETIFF = 'image/tiff';
    const CONTENT_TYPE_APPLICATIONMSWORD = 'application/msword';
    const CONTENT_TYPE_APPLICATIONVNDOASISOPENDOCUMENTTEXT = 'application/vnd.oasis.opendocument.text';
    const CONTENT_TYPE_APPLICATIONVNDOPENXMLFORMATS_OFFICEDOCUMENTWORDPROCESSINGMLDOCUMENT = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getContentTypeAllowableValues()
    {
        return [
            self::CONTENT_TYPE_APPLICATIONPDF,
            self::CONTENT_TYPE_IMAGETIFF,
            self::CONTENT_TYPE_APPLICATIONMSWORD,
            self::CONTENT_TYPE_APPLICATIONVNDOASISOPENDOCUMENTTEXT,
            self::CONTENT_TYPE_APPLICATIONVNDOPENXMLFORMATS_OFFICEDOCUMENTWORDPROCESSINGMLDOCUMENT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['document_id'] = isset($data['document_id']) ? $data['document_id'] : null;
        $this->container['content_type'] = isset($data['content_type']) ? $data['content_type'] : null;
        $this->container['workspace'] = isset($data['workspace']) ? $data['workspace'] : null;
        $this->container['cover_sheet'] = isset($data['cover_sheet']) ? $data['cover_sheet'] : null;
        $this->container['time_zone_offset_minutes'] = isset($data['time_zone_offset_minutes']) ? $data['time_zone_offset_minutes'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['addresses'] === null) {
            $invalid_properties[] = "'addresses' can't be null";
        }
        $allowed_values = array("application/pdf", "image/tiff", "application/msword", "application/vnd.oasis.opendocument.text", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        if (!in_array($this->container['content_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'content_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['addresses'] === null) {
            return false;
        }
        $allowed_values = array("application/pdf", "image/tiff", "application/msword", "application/vnd.oasis.opendocument.text", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        if (!in_array($this->container['content_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets addresses
     * @return string[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param string[] $addresses A list of outbound fax dialing addresses. E.g. +13175555555 or 3175555555
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets document_id
     * @return string
     */
    public function getDocumentId()
    {
        return $this->container['document_id'];
    }

    /**
     * Sets document_id
     * @param string $document_id DocumentId of Content Management artifact. If Content Management document is not used for faxing, documentId should be null
     * @return $this
     */
    public function setDocumentId($document_id)
    {
        $this->container['document_id'] = $document_id;

        return $this;
    }

    /**
     * Gets content_type
     * @return string
     */
    public function getContentType()
    {
        return $this->container['content_type'];
    }

    /**
     * Sets content_type
     * @param string $content_type The content type that is going to be uploaded. If Content Management document is used for faxing, contentType will be ignored
     * @return $this
     */
    public function setContentType($content_type)
    {
        $allowed_values = array('application/pdf', 'image/tiff', 'application/msword', 'application/vnd.oasis.opendocument.text', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document');
        if (!in_array($content_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'content_type', must be one of 'application/pdf', 'image/tiff', 'application/msword', 'application/vnd.oasis.opendocument.text', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'");
        }
        $this->container['content_type'] = $content_type;

        return $this;
    }

    /**
     * Gets workspace
     * @return \PureCloudSDK\Workspace
     */
    public function getWorkspace()
    {
        return $this->container['workspace'];
    }

    /**
     * Sets workspace
     * @param \PureCloudSDK\Workspace $workspace Workspace in which the document should be stored. If Content Management document is used for faxing, workspace will be ignored
     * @return $this
     */
    public function setWorkspace($workspace)
    {
        $this->container['workspace'] = $workspace;

        return $this;
    }

    /**
     * Gets cover_sheet
     * @return \PureCloudSDK\CoverSheet
     */
    public function getCoverSheet()
    {
        return $this->container['cover_sheet'];
    }

    /**
     * Sets cover_sheet
     * @param \PureCloudSDK\CoverSheet $cover_sheet Data for coversheet generation.
     * @return $this
     */
    public function setCoverSheet($cover_sheet)
    {
        $this->container['cover_sheet'] = $cover_sheet;

        return $this;
    }

    /**
     * Gets time_zone_offset_minutes
     * @return int
     */
    public function getTimeZoneOffsetMinutes()
    {
        return $this->container['time_zone_offset_minutes'];
    }

    /**
     * Sets time_zone_offset_minutes
     * @param int $time_zone_offset_minutes Time zone offset minutes from GMT
     * @return $this
     */
    public function setTimeZoneOffsetMinutes($time_zone_offset_minutes)
    {
        $this->container['time_zone_offset_minutes'] = $time_zone_offset_minutes;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


