<?php
/**
 * ForecastCreation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ForecastCreation Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ForecastCreation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ForecastCreation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'number_of_periods' => 'int',
        'period_frequency' => 'string',
        'description' => 'string',
        'metrics' => 'string[]',
        'management_unit_id' => 'string',
        'copied_forecast_id' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'number_of_periods' => 'numberOfPeriods',
        'period_frequency' => 'periodFrequency',
        'description' => 'description',
        'metrics' => 'metrics',
        'management_unit_id' => 'managementUnitId',
        'copied_forecast_id' => 'copiedForecastId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'number_of_periods' => 'setNumberOfPeriods',
        'period_frequency' => 'setPeriodFrequency',
        'description' => 'setDescription',
        'metrics' => 'setMetrics',
        'management_unit_id' => 'setManagementUnitId',
        'copied_forecast_id' => 'setCopiedForecastId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'number_of_periods' => 'getNumberOfPeriods',
        'period_frequency' => 'getPeriodFrequency',
        'description' => 'getDescription',
        'metrics' => 'getMetrics',
        'management_unit_id' => 'getManagementUnitId',
        'copied_forecast_id' => 'getCopiedForecastId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const PERIOD_FREQUENCY_WEEK = 'WEEK';
    const METRICS_VOLUME = 'VOLUME';
    const METRICS_ATT = 'ATT';
    const METRICS_ACW = 'ACW';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPeriodFrequencyAllowableValues()
    {
        return [
            self::PERIOD_FREQUENCY_WEEK,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_VOLUME,
            self::METRICS_ATT,
            self::METRICS_ACW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['number_of_periods'] = isset($data['number_of_periods']) ? $data['number_of_periods'] : null;
        $this->container['period_frequency'] = isset($data['period_frequency']) ? $data['period_frequency'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['management_unit_id'] = isset($data['management_unit_id']) ? $data['management_unit_id'] : null;
        $this->container['copied_forecast_id'] = isset($data['copied_forecast_id']) ? $data['copied_forecast_id'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['number_of_periods'] === null) {
            $invalid_properties[] = "'number_of_periods' can't be null";
        }
        if ($this->container['period_frequency'] === null) {
            $invalid_properties[] = "'period_frequency' can't be null";
        }
        $allowed_values = array("WEEK");
        if (!in_array($this->container['period_frequency'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'period_frequency', must be one of #{allowed_values}.";
        }

        if ($this->container['description'] === null) {
            $invalid_properties[] = "'description' can't be null";
        }
        if ($this->container['metrics'] === null) {
            $invalid_properties[] = "'metrics' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['number_of_periods'] === null) {
            return false;
        }
        if ($this->container['period_frequency'] === null) {
            return false;
        }
        $allowed_values = array("WEEK");
        if (!in_array($this->container['period_frequency'], $allowed_values)) {
            return false;
        }
        if ($this->container['description'] === null) {
            return false;
        }
        if ($this->container['metrics'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets number_of_periods
     * @return int
     */
    public function getNumberOfPeriods()
    {
        return $this->container['number_of_periods'];
    }

    /**
     * Sets number_of_periods
     * @param int $number_of_periods The number of periods to be forecasted for
     * @return $this
     */
    public function setNumberOfPeriods($number_of_periods)
    {
        $this->container['number_of_periods'] = $number_of_periods;

        return $this;
    }

    /**
     * Gets period_frequency
     * @return string
     */
    public function getPeriodFrequency()
    {
        return $this->container['period_frequency'];
    }

    /**
     * Sets period_frequency
     * @param string $period_frequency The frequency of the period
     * @return $this
     */
    public function setPeriodFrequency($period_frequency)
    {
        $allowed_values = array('WEEK');
        if (!in_array($period_frequency, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'period_frequency', must be one of 'WEEK'");
        }
        $this->container['period_frequency'] = $period_frequency;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of the forecast to be created
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics The metrics the forecast is for
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('VOLUME', 'ATT', 'ACW');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'VOLUME', 'ATT', 'ACW'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets management_unit_id
     * @return string
     */
    public function getManagementUnitId()
    {
        return $this->container['management_unit_id'];
    }

    /**
     * Sets management_unit_id
     * @param string $management_unit_id The id of the management unit to which the new forecast belongs
     * @return $this
     */
    public function setManagementUnitId($management_unit_id)
    {
        $this->container['management_unit_id'] = $management_unit_id;

        return $this;
    }

    /**
     * Gets copied_forecast_id
     * @return string
     */
    public function getCopiedForecastId()
    {
        return $this->container['copied_forecast_id'];
    }

    /**
     * Sets copied_forecast_id
     * @param string $copied_forecast_id The id of forecast the new forecast will copy from
     * @return $this
     */
    public function setCopiedForecastId($copied_forecast_id)
    {
        $this->container['copied_forecast_id'] = $copied_forecast_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


