<?php
/**
 * Greeting
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Greeting Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Greeting implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Greeting';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'type' => 'string',
        'owner_type' => 'string',
        'owner' => '\PureCloudSDK\DomainEntity',
        'audio_file' => '\PureCloudSDK\GreetingAudioFile',
        'audio_tts' => 'string',
        'created_date' => '\DateTime',
        'created_by' => 'string',
        'modified_date' => '\DateTime',
        'modified_by' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'type' => 'type',
        'owner_type' => 'ownerType',
        'owner' => 'owner',
        'audio_file' => 'audioFile',
        'audio_tts' => 'audioTTS',
        'created_date' => 'createdDate',
        'created_by' => 'createdBy',
        'modified_date' => 'modifiedDate',
        'modified_by' => 'modifiedBy',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'type' => 'setType',
        'owner_type' => 'setOwnerType',
        'owner' => 'setOwner',
        'audio_file' => 'setAudioFile',
        'audio_tts' => 'setAudioTts',
        'created_date' => 'setCreatedDate',
        'created_by' => 'setCreatedBy',
        'modified_date' => 'setModifiedDate',
        'modified_by' => 'setModifiedBy',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'type' => 'getType',
        'owner_type' => 'getOwnerType',
        'owner' => 'getOwner',
        'audio_file' => 'getAudioFile',
        'audio_tts' => 'getAudioTts',
        'created_date' => 'getCreatedDate',
        'created_by' => 'getCreatedBy',
        'modified_date' => 'getModifiedDate',
        'modified_by' => 'getModifiedBy',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_STATION = 'STATION';
    const TYPE_VOICEMAIL = 'VOICEMAIL';
    const TYPE_NAME = 'NAME';
    const OWNER_TYPE_USER = 'USER';
    const OWNER_TYPE_ORGANIZATION = 'ORGANIZATION';
    const OWNER_TYPE_GROUP = 'GROUP';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_STATION,
            self::TYPE_VOICEMAIL,
            self::TYPE_NAME,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOwnerTypeAllowableValues()
    {
        return [
            self::OWNER_TYPE_USER,
            self::OWNER_TYPE_ORGANIZATION,
            self::OWNER_TYPE_GROUP,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['owner_type'] = isset($data['owner_type']) ? $data['owner_type'] : null;
        $this->container['owner'] = isset($data['owner']) ? $data['owner'] : null;
        $this->container['audio_file'] = isset($data['audio_file']) ? $data['audio_file'] : null;
        $this->container['audio_tts'] = isset($data['audio_tts']) ? $data['audio_tts'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['created_by'] = isset($data['created_by']) ? $data['created_by'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
        $this->container['modified_by'] = isset($data['modified_by']) ? $data['modified_by'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("STATION", "VOICEMAIL", "NAME");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['owner_type'] === null) {
            $invalid_properties[] = "'owner_type' can't be null";
        }
        $allowed_values = array("USER", "ORGANIZATION", "GROUP");
        if (!in_array($this->container['owner_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'owner_type', must be one of #{allowed_values}.";
        }

        if ($this->container['owner'] === null) {
            $invalid_properties[] = "'owner' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("STATION", "VOICEMAIL", "NAME");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['owner_type'] === null) {
            return false;
        }
        $allowed_values = array("USER", "ORGANIZATION", "GROUP");
        if (!in_array($this->container['owner_type'], $allowed_values)) {
            return false;
        }
        if ($this->container['owner'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Greeting type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('STATION', 'VOICEMAIL', 'NAME');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'STATION', 'VOICEMAIL', 'NAME'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets owner_type
     * @return string
     */
    public function getOwnerType()
    {
        return $this->container['owner_type'];
    }

    /**
     * Sets owner_type
     * @param string $owner_type Greeting owner type
     * @return $this
     */
    public function setOwnerType($owner_type)
    {
        $allowed_values = array('USER', 'ORGANIZATION', 'GROUP');
        if (!in_array($owner_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'owner_type', must be one of 'USER', 'ORGANIZATION', 'GROUP'");
        }
        $this->container['owner_type'] = $owner_type;

        return $this;
    }

    /**
     * Gets owner
     * @return \PureCloudSDK\DomainEntity
     */
    public function getOwner()
    {
        return $this->container['owner'];
    }

    /**
     * Sets owner
     * @param \PureCloudSDK\DomainEntity $owner Greeting owner
     * @return $this
     */
    public function setOwner($owner)
    {
        $this->container['owner'] = $owner;

        return $this;
    }

    /**
     * Gets audio_file
     * @return \PureCloudSDK\GreetingAudioFile
     */
    public function getAudioFile()
    {
        return $this->container['audio_file'];
    }

    /**
     * Sets audio_file
     * @param \PureCloudSDK\GreetingAudioFile $audio_file
     * @return $this
     */
    public function setAudioFile($audio_file)
    {
        $this->container['audio_file'] = $audio_file;

        return $this;
    }

    /**
     * Gets audio_tts
     * @return string
     */
    public function getAudioTts()
    {
        return $this->container['audio_tts'];
    }

    /**
     * Sets audio_tts
     * @param string $audio_tts
     * @return $this
     */
    public function setAudioTts($audio_tts)
    {
        $this->container['audio_tts'] = $audio_tts;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets created_by
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     * @param string $created_by
     * @return $this
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets modified_date
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     * @param \DateTime $modified_date Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets modified_by
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modified_by'];
    }

    /**
     * Sets modified_by
     * @param string $modified_by
     * @return $this
     */
    public function setModifiedBy($modified_by)
    {
        $this->container['modified_by'] = $modified_by;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


