<?php
/**
 * HeartBeatAlert
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * HeartBeatAlert Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HeartBeatAlert implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HeartBeatAlert';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'sender_id' => 'string',
        'heart_beat_timeout_in_minutes' => 'int',
        'rule_id' => 'string',
        'start_date' => '\DateTime',
        'end_date' => '\DateTime',
        'notification_users' => '\PureCloudSDK\User[]',
        'alert_types' => 'string[]',
        'rule_type' => 'string',
        'rule_uri' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'sender_id' => 'senderId',
        'heart_beat_timeout_in_minutes' => 'heartBeatTimeoutInMinutes',
        'rule_id' => 'ruleId',
        'start_date' => 'startDate',
        'end_date' => 'endDate',
        'notification_users' => 'notificationUsers',
        'alert_types' => 'alertTypes',
        'rule_type' => 'ruleType',
        'rule_uri' => 'ruleUri',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'sender_id' => 'setSenderId',
        'heart_beat_timeout_in_minutes' => 'setHeartBeatTimeoutInMinutes',
        'rule_id' => 'setRuleId',
        'start_date' => 'setStartDate',
        'end_date' => 'setEndDate',
        'notification_users' => 'setNotificationUsers',
        'alert_types' => 'setAlertTypes',
        'rule_type' => 'setRuleType',
        'rule_uri' => 'setRuleUri',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'sender_id' => 'getSenderId',
        'heart_beat_timeout_in_minutes' => 'getHeartBeatTimeoutInMinutes',
        'rule_id' => 'getRuleId',
        'start_date' => 'getStartDate',
        'end_date' => 'getEndDate',
        'notification_users' => 'getNotificationUsers',
        'alert_types' => 'getAlertTypes',
        'rule_type' => 'getRuleType',
        'rule_uri' => 'getRuleUri',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ALERT_TYPES_SMS = 'SMS';
    const ALERT_TYPES_DEVICE = 'DEVICE';
    const ALERT_TYPES_EMAIL = 'EMAIL';
    const RULE_TYPE_EDGE = 'EDGE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRuleTypeAllowableValues()
    {
        return [
            self::RULE_TYPE_EDGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['sender_id'] = isset($data['sender_id']) ? $data['sender_id'] : null;
        $this->container['heart_beat_timeout_in_minutes'] = isset($data['heart_beat_timeout_in_minutes']) ? $data['heart_beat_timeout_in_minutes'] : null;
        $this->container['rule_id'] = isset($data['rule_id']) ? $data['rule_id'] : null;
        $this->container['start_date'] = isset($data['start_date']) ? $data['start_date'] : null;
        $this->container['end_date'] = isset($data['end_date']) ? $data['end_date'] : null;
        $this->container['notification_users'] = isset($data['notification_users']) ? $data['notification_users'] : null;
        $this->container['alert_types'] = isset($data['alert_types']) ? $data['alert_types'] : null;
        $this->container['rule_type'] = isset($data['rule_type']) ? $data['rule_type'] : null;
        $this->container['rule_uri'] = isset($data['rule_uri']) ? $data['rule_uri'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['sender_id'] === null) {
            $invalid_properties[] = "'sender_id' can't be null";
        }
        if ($this->container['heart_beat_timeout_in_minutes'] === null) {
            $invalid_properties[] = "'heart_beat_timeout_in_minutes' can't be null";
        }
        if ($this->container['rule_id'] === null) {
            $invalid_properties[] = "'rule_id' can't be null";
        }
        if ($this->container['start_date'] === null) {
            $invalid_properties[] = "'start_date' can't be null";
        }
        if ($this->container['notification_users'] === null) {
            $invalid_properties[] = "'notification_users' can't be null";
        }
        if ($this->container['alert_types'] === null) {
            $invalid_properties[] = "'alert_types' can't be null";
        }
        if ($this->container['rule_type'] === null) {
            $invalid_properties[] = "'rule_type' can't be null";
        }
        $allowed_values = array("EDGE");
        if (!in_array($this->container['rule_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'rule_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['sender_id'] === null) {
            return false;
        }
        if ($this->container['heart_beat_timeout_in_minutes'] === null) {
            return false;
        }
        if ($this->container['rule_id'] === null) {
            return false;
        }
        if ($this->container['start_date'] === null) {
            return false;
        }
        if ($this->container['notification_users'] === null) {
            return false;
        }
        if ($this->container['alert_types'] === null) {
            return false;
        }
        if ($this->container['rule_type'] === null) {
            return false;
        }
        $allowed_values = array("EDGE");
        if (!in_array($this->container['rule_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the rule
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets sender_id
     * @return string
     */
    public function getSenderId()
    {
        return $this->container['sender_id'];
    }

    /**
     * Sets sender_id
     * @param string $sender_id The value that identifies the sender of the heartbeat.
     * @return $this
     */
    public function setSenderId($sender_id)
    {
        $this->container['sender_id'] = $sender_id;

        return $this;
    }

    /**
     * Gets heart_beat_timeout_in_minutes
     * @return int
     */
    public function getHeartBeatTimeoutInMinutes()
    {
        return $this->container['heart_beat_timeout_in_minutes'];
    }

    /**
     * Sets heart_beat_timeout_in_minutes
     * @param int $heart_beat_timeout_in_minutes The number of minutes to wait before alerting missing heartbeats.
     * @return $this
     */
    public function setHeartBeatTimeoutInMinutes($heart_beat_timeout_in_minutes)
    {
        $this->container['heart_beat_timeout_in_minutes'] = $heart_beat_timeout_in_minutes;

        return $this;
    }

    /**
     * Gets rule_id
     * @return string
     */
    public function getRuleId()
    {
        return $this->container['rule_id'];
    }

    /**
     * Sets rule_id
     * @param string $rule_id The id of the rule.
     * @return $this
     */
    public function setRuleId($rule_id)
    {
        $this->container['rule_id'] = $rule_id;

        return $this;
    }

    /**
     * Gets start_date
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['start_date'];
    }

    /**
     * Sets start_date
     * @param \DateTime $start_date The date/time the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($start_date)
    {
        $this->container['start_date'] = $start_date;

        return $this;
    }

    /**
     * Gets end_date
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['end_date'];
    }

    /**
     * Sets end_date
     * @param \DateTime $end_date The date/time the owning rule exiting in alarm status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndDate($end_date)
    {
        $this->container['end_date'] = $end_date;

        return $this;
    }

    /**
     * Gets notification_users
     * @return \PureCloudSDK\User[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notification_users'];
    }

    /**
     * Sets notification_users
     * @param \PureCloudSDK\User[] $notification_users The ids of users who were notified of alarm state change.
     * @return $this
     */
    public function setNotificationUsers($notification_users)
    {
        $this->container['notification_users'] = $notification_users;

        return $this;
    }

    /**
     * Gets alert_types
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alert_types'];
    }

    /**
     * Sets alert_types
     * @param string[] $alert_types A collection of notification methods. = ['SMS', 'DEVICE', 'EMAIL']
     * @return $this
     */
    public function setAlertTypes($alert_types)
    {
        $allowed_values = array('SMS', 'DEVICE', 'EMAIL');
        if (!in_array($alert_types, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alert_types', must be one of 'SMS', 'DEVICE', 'EMAIL'");
        }
        $this->container['alert_types'] = $alert_types;

        return $this;
    }

    /**
     * Gets rule_type
     * @return string
     */
    public function getRuleType()
    {
        return $this->container['rule_type'];
    }

    /**
     * Sets rule_type
     * @param string $rule_type The type of heartbeat rule that generated the alert
     * @return $this
     */
    public function setRuleType($rule_type)
    {
        $allowed_values = array('EDGE');
        if (!in_array($rule_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'rule_type', must be one of 'EDGE'");
        }
        $this->container['rule_type'] = $rule_type;

        return $this;
    }

    /**
     * Gets rule_uri
     * @return string
     */
    public function getRuleUri()
    {
        return $this->container['rule_uri'];
    }

    /**
     * Sets rule_uri
     * @param string $rule_uri
     * @return $this
     */
    public function setRuleUri($rule_uri)
    {
        $this->container['rule_uri'] = $rule_uri;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


