<?php
/**
 * HeartBeatRuleNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * HeartBeatRuleNotification Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HeartBeatRuleNotification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HeartBeatRuleNotification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'sender_id' => 'string',
        'heart_beat_timeout_in_minutes' => 'float',
        'enabled' => 'bool',
        'in_alarm' => 'bool',
        'notification_users' => '\PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]',
        'alert_types' => 'string[]',
        'rule_type' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'sender_id' => 'senderId',
        'heart_beat_timeout_in_minutes' => 'heartBeatTimeoutInMinutes',
        'enabled' => 'enabled',
        'in_alarm' => 'inAlarm',
        'notification_users' => 'notificationUsers',
        'alert_types' => 'alertTypes',
        'rule_type' => 'ruleType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'sender_id' => 'setSenderId',
        'heart_beat_timeout_in_minutes' => 'setHeartBeatTimeoutInMinutes',
        'enabled' => 'setEnabled',
        'in_alarm' => 'setInAlarm',
        'notification_users' => 'setNotificationUsers',
        'alert_types' => 'setAlertTypes',
        'rule_type' => 'setRuleType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'sender_id' => 'getSenderId',
        'heart_beat_timeout_in_minutes' => 'getHeartBeatTimeoutInMinutes',
        'enabled' => 'getEnabled',
        'in_alarm' => 'getInAlarm',
        'notification_users' => 'getNotificationUsers',
        'alert_types' => 'getAlertTypes',
        'rule_type' => 'getRuleType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ALERT_TYPES_SMS = 'SMS';
    const ALERT_TYPES_DEVICE = 'DEVICE';
    const ALERT_TYPES_EMAIL = 'EMAIL';
    const RULE_TYPE_EDGE = 'EDGE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRuleTypeAllowableValues()
    {
        return [
            self::RULE_TYPE_EDGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['sender_id'] = isset($data['sender_id']) ? $data['sender_id'] : null;
        $this->container['heart_beat_timeout_in_minutes'] = isset($data['heart_beat_timeout_in_minutes']) ? $data['heart_beat_timeout_in_minutes'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['in_alarm'] = isset($data['in_alarm']) ? $data['in_alarm'] : null;
        $this->container['notification_users'] = isset($data['notification_users']) ? $data['notification_users'] : null;
        $this->container['alert_types'] = isset($data['alert_types']) ? $data['alert_types'] : null;
        $this->container['rule_type'] = isset($data['rule_type']) ? $data['rule_type'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("EDGE");
        if (!in_array($this->container['rule_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'rule_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("EDGE");
        if (!in_array($this->container['rule_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets sender_id
     * @return string
     */
    public function getSenderId()
    {
        return $this->container['sender_id'];
    }

    /**
     * Sets sender_id
     * @param string $sender_id
     * @return $this
     */
    public function setSenderId($sender_id)
    {
        $this->container['sender_id'] = $sender_id;

        return $this;
    }

    /**
     * Gets heart_beat_timeout_in_minutes
     * @return float
     */
    public function getHeartBeatTimeoutInMinutes()
    {
        return $this->container['heart_beat_timeout_in_minutes'];
    }

    /**
     * Sets heart_beat_timeout_in_minutes
     * @param float $heart_beat_timeout_in_minutes
     * @return $this
     */
    public function setHeartBeatTimeoutInMinutes($heart_beat_timeout_in_minutes)
    {
        $this->container['heart_beat_timeout_in_minutes'] = $heart_beat_timeout_in_minutes;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets in_alarm
     * @return bool
     */
    public function getInAlarm()
    {
        return $this->container['in_alarm'];
    }

    /**
     * Sets in_alarm
     * @param bool $in_alarm
     * @return $this
     */
    public function setInAlarm($in_alarm)
    {
        $this->container['in_alarm'] = $in_alarm;

        return $this;
    }

    /**
     * Gets notification_users
     * @return \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notification_users'];
    }

    /**
     * Sets notification_users
     * @param \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[] $notification_users
     * @return $this
     */
    public function setNotificationUsers($notification_users)
    {
        $this->container['notification_users'] = $notification_users;

        return $this;
    }

    /**
     * Gets alert_types
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alert_types'];
    }

    /**
     * Sets alert_types
     * @param string[] $alert_types
     * @return $this
     */
    public function setAlertTypes($alert_types)
    {
        $allowed_values = array('SMS', 'DEVICE', 'EMAIL');
        if (!in_array($alert_types, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alert_types', must be one of 'SMS', 'DEVICE', 'EMAIL'");
        }
        $this->container['alert_types'] = $alert_types;

        return $this;
    }

    /**
     * Gets rule_type
     * @return string
     */
    public function getRuleType()
    {
        return $this->container['rule_type'];
    }

    /**
     * Sets rule_type
     * @param string $rule_type
     * @return $this
     */
    public function setRuleType($rule_type)
    {
        $allowed_values = array('EDGE');
        if (!in_array($rule_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'rule_type', must be one of 'EDGE'");
        }
        $this->container['rule_type'] = $rule_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


