<?php
/**
 * ImportStatus
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ImportStatus Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ImportStatus implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ImportStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'state' => 'string',
        'total_records' => 'int',
        'completed_records' => 'int',
        'percent_complete' => 'int',
        'failure_reason' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'state' => 'state',
        'total_records' => 'totalRecords',
        'completed_records' => 'completedRecords',
        'percent_complete' => 'percentComplete',
        'failure_reason' => 'failureReason'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'state' => 'setState',
        'total_records' => 'setTotalRecords',
        'completed_records' => 'setCompletedRecords',
        'percent_complete' => 'setPercentComplete',
        'failure_reason' => 'setFailureReason'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'state' => 'getState',
        'total_records' => 'getTotalRecords',
        'completed_records' => 'getCompletedRecords',
        'percent_complete' => 'getPercentComplete',
        'failure_reason' => 'getFailureReason'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_IN_PROGRESS = 'IN_PROGRESS';
    const STATE_FAILED = 'FAILED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_IN_PROGRESS,
            self::STATE_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['total_records'] = isset($data['total_records']) ? $data['total_records'] : null;
        $this->container['completed_records'] = isset($data['completed_records']) ? $data['completed_records'] : null;
        $this->container['percent_complete'] = isset($data['percent_complete']) ? $data['percent_complete'] : null;
        $this->container['failure_reason'] = isset($data['failure_reason']) ? $data['failure_reason'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['state'] === null) {
            $invalid_properties[] = "'state' can't be null";
        }
        $allowed_values = array("IN_PROGRESS", "FAILED");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['total_records'] === null) {
            $invalid_properties[] = "'total_records' can't be null";
        }
        if ($this->container['completed_records'] === null) {
            $invalid_properties[] = "'completed_records' can't be null";
        }
        if ($this->container['percent_complete'] === null) {
            $invalid_properties[] = "'percent_complete' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['state'] === null) {
            return false;
        }
        $allowed_values = array("IN_PROGRESS", "FAILED");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['total_records'] === null) {
            return false;
        }
        if ($this->container['completed_records'] === null) {
            return false;
        }
        if ($this->container['percent_complete'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state current status of the import
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('IN_PROGRESS', 'FAILED');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'IN_PROGRESS', 'FAILED'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets total_records
     * @return int
     */
    public function getTotalRecords()
    {
        return $this->container['total_records'];
    }

    /**
     * Sets total_records
     * @param int $total_records total number of records to be imported
     * @return $this
     */
    public function setTotalRecords($total_records)
    {
        $this->container['total_records'] = $total_records;

        return $this;
    }

    /**
     * Gets completed_records
     * @return int
     */
    public function getCompletedRecords()
    {
        return $this->container['completed_records'];
    }

    /**
     * Sets completed_records
     * @param int $completed_records number of records finished importing
     * @return $this
     */
    public function setCompletedRecords($completed_records)
    {
        $this->container['completed_records'] = $completed_records;

        return $this;
    }

    /**
     * Gets percent_complete
     * @return int
     */
    public function getPercentComplete()
    {
        return $this->container['percent_complete'];
    }

    /**
     * Sets percent_complete
     * @param int $percent_complete percentage of records finished importing
     * @return $this
     */
    public function setPercentComplete($percent_complete)
    {
        $this->container['percent_complete'] = $percent_complete;

        return $this;
    }

    /**
     * Gets failure_reason
     * @return string
     */
    public function getFailureReason()
    {
        return $this->container['failure_reason'];
    }

    /**
     * Sets failure_reason
     * @param string $failure_reason if the import has failed, the reason for the failure
     * @return $this
     */
    public function setFailureReason($failure_reason)
    {
        $this->container['failure_reason'] = $failure_reason;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


