<?php
/**
 * InboundDomain
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * InboundDomain Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class InboundDomain implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'InboundDomain';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'mx_record_status' => 'string',
        'sub_domain' => 'bool',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'mx_record_status' => 'mxRecordStatus',
        'sub_domain' => 'subDomain',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'mx_record_status' => 'setMxRecordStatus',
        'sub_domain' => 'setSubDomain',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'mx_record_status' => 'getMxRecordStatus',
        'sub_domain' => 'getSubDomain',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const MX_RECORD_STATUS_VALID = 'VALID';
    const MX_RECORD_STATUS_INVALID = 'INVALID';
    const MX_RECORD_STATUS_NOT_AVAILABLE = 'NOT_AVAILABLE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMxRecordStatusAllowableValues()
    {
        return [
            self::MX_RECORD_STATUS_VALID,
            self::MX_RECORD_STATUS_INVALID,
            self::MX_RECORD_STATUS_NOT_AVAILABLE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['mx_record_status'] = isset($data['mx_record_status']) ? $data['mx_record_status'] : null;
        $this->container['sub_domain'] = isset($data['sub_domain']) ? $data['sub_domain'] : false;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['mx_record_status'] === null) {
            $invalid_properties[] = "'mx_record_status' can't be null";
        }
        $allowed_values = array("VALID", "INVALID", "NOT_AVAILABLE");
        if (!in_array($this->container['mx_record_status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mx_record_status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['mx_record_status'] === null) {
            return false;
        }
        $allowed_values = array("VALID", "INVALID", "NOT_AVAILABLE");
        if (!in_array($this->container['mx_record_status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets mx_record_status
     * @return string
     */
    public function getMxRecordStatus()
    {
        return $this->container['mx_record_status'];
    }

    /**
     * Sets mx_record_status
     * @param string $mx_record_status Mx Record Status
     * @return $this
     */
    public function setMxRecordStatus($mx_record_status)
    {
        $allowed_values = array('VALID', 'INVALID', 'NOT_AVAILABLE');
        if (!in_array($mx_record_status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mx_record_status', must be one of 'VALID', 'INVALID', 'NOT_AVAILABLE'");
        }
        $this->container['mx_record_status'] = $mx_record_status;

        return $this;
    }

    /**
     * Gets sub_domain
     * @return bool
     */
    public function getSubDomain()
    {
        return $this->container['sub_domain'];
    }

    /**
     * Sets sub_domain
     * @param bool $sub_domain Indicates if this a PureCloud sub-domain.  If true, then the appropriate DNS records are created for sending/receiving email.
     * @return $this
     */
    public function setSubDomain($sub_domain)
    {
        $this->container['sub_domain'] = $sub_domain;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


