<?php
/**
 * InteractionStatRuleNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * InteractionStatRuleNotification Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class InteractionStatRuleNotification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'InteractionStatRuleNotification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dimension' => 'string',
        'dimension_value' => 'string',
        'dimension_value_name' => 'string',
        'metric' => 'string',
        'media_type' => 'string',
        'numeric_range' => 'string',
        'statistic' => 'string',
        'value' => 'float',
        'in_alarm' => 'bool',
        'enabled' => 'bool',
        'notification_users' => '\PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]',
        'alert_types' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dimension' => 'dimension',
        'dimension_value' => 'dimensionValue',
        'dimension_value_name' => 'dimensionValueName',
        'metric' => 'metric',
        'media_type' => 'mediaType',
        'numeric_range' => 'numericRange',
        'statistic' => 'statistic',
        'value' => 'value',
        'in_alarm' => 'inAlarm',
        'enabled' => 'enabled',
        'notification_users' => 'notificationUsers',
        'alert_types' => 'alertTypes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dimension' => 'setDimension',
        'dimension_value' => 'setDimensionValue',
        'dimension_value_name' => 'setDimensionValueName',
        'metric' => 'setMetric',
        'media_type' => 'setMediaType',
        'numeric_range' => 'setNumericRange',
        'statistic' => 'setStatistic',
        'value' => 'setValue',
        'in_alarm' => 'setInAlarm',
        'enabled' => 'setEnabled',
        'notification_users' => 'setNotificationUsers',
        'alert_types' => 'setAlertTypes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dimension' => 'getDimension',
        'dimension_value' => 'getDimensionValue',
        'dimension_value_name' => 'getDimensionValueName',
        'metric' => 'getMetric',
        'media_type' => 'getMediaType',
        'numeric_range' => 'getNumericRange',
        'statistic' => 'getStatistic',
        'value' => 'getValue',
        'in_alarm' => 'getInAlarm',
        'enabled' => 'getEnabled',
        'notification_users' => 'getNotificationUsers',
        'alert_types' => 'getAlertTypes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DIMENSION_QUEUE_ID = 'queueId';
    const DIMENSION_USER_ID = 'userId';
    const METRIC_T_ABANDON = 'tAbandon';
    const METRIC_T_ANSWERED = 'tAnswered';
    const METRIC_T_TALK = 'tTalk';
    const METRIC_N_OFFERED = 'nOffered';
    const METRIC_T_HANDLE = 'tHandle';
    const METRIC_N_TRANSFERRED = 'nTransferred';
    const METRIC_O_SERVICE_LEVEL = 'oServiceLevel';
    const METRIC_T_WAIT = 'tWait';
    const METRIC_T_HELD = 'tHeld';
    const METRIC_T_ACW = 'tAcw';
    const MEDIA_TYPE_VOICE = 'voice';
    const MEDIA_TYPE_CHAT = 'chat';
    const MEDIA_TYPE_EMAIL = 'email';
    const NUMERIC_RANGE_GT = 'gt';
    const NUMERIC_RANGE_GTE = 'gte';
    const NUMERIC_RANGE_LT = 'lt';
    const NUMERIC_RANGE_LTE = 'lte';
    const NUMERIC_RANGE_EQ = 'eq';
    const NUMERIC_RANGE_NE = 'ne';
    const STATISTIC_COUNT = 'count';
    const STATISTIC_MIN = 'min';
    const STATISTIC_RATIO = 'ratio';
    const STATISTIC_MAX = 'max';
    const ALERT_TYPES_SMS = 'SMS';
    const ALERT_TYPES_DEVICE = 'DEVICE';
    const ALERT_TYPES_EMAIL = 'EMAIL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDimensionAllowableValues()
    {
        return [
            self::DIMENSION_QUEUE_ID,
            self::DIMENSION_USER_ID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_ABANDON,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_TALK,
            self::METRIC_N_OFFERED,
            self::METRIC_T_HANDLE,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_O_SERVICE_LEVEL,
            self::METRIC_T_WAIT,
            self::METRIC_T_HELD,
            self::METRIC_T_ACW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getNumericRangeAllowableValues()
    {
        return [
            self::NUMERIC_RANGE_GT,
            self::NUMERIC_RANGE_GTE,
            self::NUMERIC_RANGE_LT,
            self::NUMERIC_RANGE_LTE,
            self::NUMERIC_RANGE_EQ,
            self::NUMERIC_RANGE_NE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatisticAllowableValues()
    {
        return [
            self::STATISTIC_COUNT,
            self::STATISTIC_MIN,
            self::STATISTIC_RATIO,
            self::STATISTIC_MAX,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlertTypesAllowableValues()
    {
        return [
            self::ALERT_TYPES_SMS,
            self::ALERT_TYPES_DEVICE,
            self::ALERT_TYPES_EMAIL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dimension'] = isset($data['dimension']) ? $data['dimension'] : null;
        $this->container['dimension_value'] = isset($data['dimension_value']) ? $data['dimension_value'] : null;
        $this->container['dimension_value_name'] = isset($data['dimension_value_name']) ? $data['dimension_value_name'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['media_type'] = isset($data['media_type']) ? $data['media_type'] : null;
        $this->container['numeric_range'] = isset($data['numeric_range']) ? $data['numeric_range'] : null;
        $this->container['statistic'] = isset($data['statistic']) ? $data['statistic'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['in_alarm'] = isset($data['in_alarm']) ? $data['in_alarm'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['notification_users'] = isset($data['notification_users']) ? $data['notification_users'] : null;
        $this->container['alert_types'] = isset($data['alert_types']) ? $data['alert_types'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("queueId", "userId");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dimension', must be one of #{allowed_values}.";
        }

        $allowed_values = array("tAbandon", "tAnswered", "tTalk", "nOffered", "tHandle", "nTransferred", "oServiceLevel", "tWait", "tHeld", "tAcw");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("voice", "chat", "email");
        if (!in_array($this->container['media_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'media_type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("gt", "gte", "lt", "lte", "eq", "ne");
        if (!in_array($this->container['numeric_range'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'numeric_range', must be one of #{allowed_values}.";
        }

        $allowed_values = array("count", "min", "ratio", "max");
        if (!in_array($this->container['statistic'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'statistic', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("queueId", "userId");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("tAbandon", "tAnswered", "tTalk", "nOffered", "tHandle", "nTransferred", "oServiceLevel", "tWait", "tHeld", "tAcw");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("voice", "chat", "email");
        if (!in_array($this->container['media_type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("gt", "gte", "lt", "lte", "eq", "ne");
        if (!in_array($this->container['numeric_range'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("count", "min", "ratio", "max");
        if (!in_array($this->container['statistic'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dimension
     * @return string
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     * @param string $dimension
     * @return $this
     */
    public function setDimension($dimension)
    {
        $allowed_values = array('queueId', 'userId');
        if (!in_array($dimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dimension', must be one of 'queueId', 'userId'");
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets dimension_value
     * @return string
     */
    public function getDimensionValue()
    {
        return $this->container['dimension_value'];
    }

    /**
     * Sets dimension_value
     * @param string $dimension_value
     * @return $this
     */
    public function setDimensionValue($dimension_value)
    {
        $this->container['dimension_value'] = $dimension_value;

        return $this;
    }

    /**
     * Gets dimension_value_name
     * @return string
     */
    public function getDimensionValueName()
    {
        return $this->container['dimension_value_name'];
    }

    /**
     * Sets dimension_value_name
     * @param string $dimension_value_name
     * @return $this
     */
    public function setDimensionValueName($dimension_value_name)
    {
        $this->container['dimension_value_name'] = $dimension_value_name;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tAbandon', 'tAnswered', 'tTalk', 'nOffered', 'tHandle', 'nTransferred', 'oServiceLevel', 'tWait', 'tHeld', 'tAcw');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tAbandon', 'tAnswered', 'tTalk', 'nOffered', 'tHandle', 'nTransferred', 'oServiceLevel', 'tWait', 'tHeld', 'tAcw'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets media_type
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['media_type'];
    }

    /**
     * Sets media_type
     * @param string $media_type
     * @return $this
     */
    public function setMediaType($media_type)
    {
        $allowed_values = array('voice', 'chat', 'email');
        if (!in_array($media_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'media_type', must be one of 'voice', 'chat', 'email'");
        }
        $this->container['media_type'] = $media_type;

        return $this;
    }

    /**
     * Gets numeric_range
     * @return string
     */
    public function getNumericRange()
    {
        return $this->container['numeric_range'];
    }

    /**
     * Sets numeric_range
     * @param string $numeric_range
     * @return $this
     */
    public function setNumericRange($numeric_range)
    {
        $allowed_values = array('gt', 'gte', 'lt', 'lte', 'eq', 'ne');
        if (!in_array($numeric_range, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'numeric_range', must be one of 'gt', 'gte', 'lt', 'lte', 'eq', 'ne'");
        }
        $this->container['numeric_range'] = $numeric_range;

        return $this;
    }

    /**
     * Gets statistic
     * @return string
     */
    public function getStatistic()
    {
        return $this->container['statistic'];
    }

    /**
     * Sets statistic
     * @param string $statistic
     * @return $this
     */
    public function setStatistic($statistic)
    {
        $allowed_values = array('count', 'min', 'ratio', 'max');
        if (!in_array($statistic, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'statistic', must be one of 'count', 'min', 'ratio', 'max'");
        }
        $this->container['statistic'] = $statistic;

        return $this;
    }

    /**
     * Gets value
     * @return float
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param float $value
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets in_alarm
     * @return bool
     */
    public function getInAlarm()
    {
        return $this->container['in_alarm'];
    }

    /**
     * Sets in_alarm
     * @param bool $in_alarm
     * @return $this
     */
    public function setInAlarm($in_alarm)
    {
        $this->container['in_alarm'] = $in_alarm;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets notification_users
     * @return \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[]
     */
    public function getNotificationUsers()
    {
        return $this->container['notification_users'];
    }

    /**
     * Sets notification_users
     * @param \PureCloudSDK\HeartBeatAlertNotificationNotificationUsers[] $notification_users
     * @return $this
     */
    public function setNotificationUsers($notification_users)
    {
        $this->container['notification_users'] = $notification_users;

        return $this;
    }

    /**
     * Gets alert_types
     * @return string[]
     */
    public function getAlertTypes()
    {
        return $this->container['alert_types'];
    }

    /**
     * Sets alert_types
     * @param string[] $alert_types
     * @return $this
     */
    public function setAlertTypes($alert_types)
    {
        $allowed_values = array('SMS', 'DEVICE', 'EMAIL');
        if (!in_array($alert_types, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alert_types', must be one of 'SMS', 'DEVICE', 'EMAIL'");
        }
        $this->container['alert_types'] = $alert_types;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


