<?php
/**
 * JsonNode
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * JsonNode Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class JsonNode implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'JsonNode';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'array' => 'bool',
        'null' => 'bool',
        'node_type' => 'string',
        'object' => 'bool',
        'boolean' => 'bool',
        'number' => 'bool',
        'float' => 'bool',
        'value_node' => 'bool',
        'container_node' => 'bool',
        'missing_node' => 'bool',
        'integral_number' => 'bool',
        'floating_point_number' => 'bool',
        'short' => 'bool',
        'int' => 'bool',
        'long' => 'bool',
        'double' => 'bool',
        'big_decimal' => 'bool',
        'big_integer' => 'bool',
        'textual' => 'bool',
        'binary' => 'bool',
        'pojo' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'array' => 'array',
        'null' => 'null',
        'node_type' => 'nodeType',
        'object' => 'object',
        'boolean' => 'boolean',
        'number' => 'number',
        'float' => 'float',
        'value_node' => 'valueNode',
        'container_node' => 'containerNode',
        'missing_node' => 'missingNode',
        'integral_number' => 'integralNumber',
        'floating_point_number' => 'floatingPointNumber',
        'short' => 'short',
        'int' => 'int',
        'long' => 'long',
        'double' => 'double',
        'big_decimal' => 'bigDecimal',
        'big_integer' => 'bigInteger',
        'textual' => 'textual',
        'binary' => 'binary',
        'pojo' => 'pojo'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'array' => 'setArray',
        'null' => 'setNull',
        'node_type' => 'setNodeType',
        'object' => 'setObject',
        'boolean' => 'setBoolean',
        'number' => 'setNumber',
        'float' => 'setFloat',
        'value_node' => 'setValueNode',
        'container_node' => 'setContainerNode',
        'missing_node' => 'setMissingNode',
        'integral_number' => 'setIntegralNumber',
        'floating_point_number' => 'setFloatingPointNumber',
        'short' => 'setShort',
        'int' => 'setInt',
        'long' => 'setLong',
        'double' => 'setDouble',
        'big_decimal' => 'setBigDecimal',
        'big_integer' => 'setBigInteger',
        'textual' => 'setTextual',
        'binary' => 'setBinary',
        'pojo' => 'setPojo'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'array' => 'getArray',
        'null' => 'getNull',
        'node_type' => 'getNodeType',
        'object' => 'getObject',
        'boolean' => 'getBoolean',
        'number' => 'getNumber',
        'float' => 'getFloat',
        'value_node' => 'getValueNode',
        'container_node' => 'getContainerNode',
        'missing_node' => 'getMissingNode',
        'integral_number' => 'getIntegralNumber',
        'floating_point_number' => 'getFloatingPointNumber',
        'short' => 'getShort',
        'int' => 'getInt',
        'long' => 'getLong',
        'double' => 'getDouble',
        'big_decimal' => 'getBigDecimal',
        'big_integer' => 'getBigInteger',
        'textual' => 'getTextual',
        'binary' => 'getBinary',
        'pojo' => 'getPojo'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const NODE_TYPE_ARRAY = 'ARRAY';
    const NODE_TYPE_BINARY = 'BINARY';
    const NODE_TYPE_BOOLEAN = 'BOOLEAN';
    const NODE_TYPE_MISSING = 'MISSING';
    const NODE_TYPE_NULL = 'NULL';
    const NODE_TYPE_NUMBER = 'NUMBER';
    const NODE_TYPE_OBJECT = 'OBJECT';
    const NODE_TYPE_POJO = 'POJO';
    const NODE_TYPE_STRING = 'STRING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getNodeTypeAllowableValues()
    {
        return [
            self::NODE_TYPE_ARRAY,
            self::NODE_TYPE_BINARY,
            self::NODE_TYPE_BOOLEAN,
            self::NODE_TYPE_MISSING,
            self::NODE_TYPE_NULL,
            self::NODE_TYPE_NUMBER,
            self::NODE_TYPE_OBJECT,
            self::NODE_TYPE_POJO,
            self::NODE_TYPE_STRING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['array'] = isset($data['array']) ? $data['array'] : false;
        $this->container['null'] = isset($data['null']) ? $data['null'] : false;
        $this->container['node_type'] = isset($data['node_type']) ? $data['node_type'] : null;
        $this->container['object'] = isset($data['object']) ? $data['object'] : false;
        $this->container['boolean'] = isset($data['boolean']) ? $data['boolean'] : false;
        $this->container['number'] = isset($data['number']) ? $data['number'] : false;
        $this->container['float'] = isset($data['float']) ? $data['float'] : false;
        $this->container['value_node'] = isset($data['value_node']) ? $data['value_node'] : false;
        $this->container['container_node'] = isset($data['container_node']) ? $data['container_node'] : false;
        $this->container['missing_node'] = isset($data['missing_node']) ? $data['missing_node'] : false;
        $this->container['integral_number'] = isset($data['integral_number']) ? $data['integral_number'] : false;
        $this->container['floating_point_number'] = isset($data['floating_point_number']) ? $data['floating_point_number'] : false;
        $this->container['short'] = isset($data['short']) ? $data['short'] : false;
        $this->container['int'] = isset($data['int']) ? $data['int'] : false;
        $this->container['long'] = isset($data['long']) ? $data['long'] : false;
        $this->container['double'] = isset($data['double']) ? $data['double'] : false;
        $this->container['big_decimal'] = isset($data['big_decimal']) ? $data['big_decimal'] : false;
        $this->container['big_integer'] = isset($data['big_integer']) ? $data['big_integer'] : false;
        $this->container['textual'] = isset($data['textual']) ? $data['textual'] : false;
        $this->container['binary'] = isset($data['binary']) ? $data['binary'] : false;
        $this->container['pojo'] = isset($data['pojo']) ? $data['pojo'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ARRAY", "BINARY", "BOOLEAN", "MISSING", "NULL", "NUMBER", "OBJECT", "POJO", "STRING");
        if (!in_array($this->container['node_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'node_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ARRAY", "BINARY", "BOOLEAN", "MISSING", "NULL", "NUMBER", "OBJECT", "POJO", "STRING");
        if (!in_array($this->container['node_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets array
     * @return bool
     */
    public function getArray()
    {
        return $this->container['array'];
    }

    /**
     * Sets array
     * @param bool $array
     * @return $this
     */
    public function setArray($array)
    {
        $this->container['array'] = $array;

        return $this;
    }

    /**
     * Gets null
     * @return bool
     */
    public function getNull()
    {
        return $this->container['null'];
    }

    /**
     * Sets null
     * @param bool $null
     * @return $this
     */
    public function setNull($null)
    {
        $this->container['null'] = $null;

        return $this;
    }

    /**
     * Gets node_type
     * @return string
     */
    public function getNodeType()
    {
        return $this->container['node_type'];
    }

    /**
     * Sets node_type
     * @param string $node_type
     * @return $this
     */
    public function setNodeType($node_type)
    {
        $allowed_values = array('ARRAY', 'BINARY', 'BOOLEAN', 'MISSING', 'NULL', 'NUMBER', 'OBJECT', 'POJO', 'STRING');
        if (!in_array($node_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'node_type', must be one of 'ARRAY', 'BINARY', 'BOOLEAN', 'MISSING', 'NULL', 'NUMBER', 'OBJECT', 'POJO', 'STRING'");
        }
        $this->container['node_type'] = $node_type;

        return $this;
    }

    /**
     * Gets object
     * @return bool
     */
    public function getObject()
    {
        return $this->container['object'];
    }

    /**
     * Sets object
     * @param bool $object
     * @return $this
     */
    public function setObject($object)
    {
        $this->container['object'] = $object;

        return $this;
    }

    /**
     * Gets boolean
     * @return bool
     */
    public function getBoolean()
    {
        return $this->container['boolean'];
    }

    /**
     * Sets boolean
     * @param bool $boolean
     * @return $this
     */
    public function setBoolean($boolean)
    {
        $this->container['boolean'] = $boolean;

        return $this;
    }

    /**
     * Gets number
     * @return bool
     */
    public function getNumber()
    {
        return $this->container['number'];
    }

    /**
     * Sets number
     * @param bool $number
     * @return $this
     */
    public function setNumber($number)
    {
        $this->container['number'] = $number;

        return $this;
    }

    /**
     * Gets float
     * @return bool
     */
    public function getFloat()
    {
        return $this->container['float'];
    }

    /**
     * Sets float
     * @param bool $float
     * @return $this
     */
    public function setFloat($float)
    {
        $this->container['float'] = $float;

        return $this;
    }

    /**
     * Gets value_node
     * @return bool
     */
    public function getValueNode()
    {
        return $this->container['value_node'];
    }

    /**
     * Sets value_node
     * @param bool $value_node
     * @return $this
     */
    public function setValueNode($value_node)
    {
        $this->container['value_node'] = $value_node;

        return $this;
    }

    /**
     * Gets container_node
     * @return bool
     */
    public function getContainerNode()
    {
        return $this->container['container_node'];
    }

    /**
     * Sets container_node
     * @param bool $container_node
     * @return $this
     */
    public function setContainerNode($container_node)
    {
        $this->container['container_node'] = $container_node;

        return $this;
    }

    /**
     * Gets missing_node
     * @return bool
     */
    public function getMissingNode()
    {
        return $this->container['missing_node'];
    }

    /**
     * Sets missing_node
     * @param bool $missing_node
     * @return $this
     */
    public function setMissingNode($missing_node)
    {
        $this->container['missing_node'] = $missing_node;

        return $this;
    }

    /**
     * Gets integral_number
     * @return bool
     */
    public function getIntegralNumber()
    {
        return $this->container['integral_number'];
    }

    /**
     * Sets integral_number
     * @param bool $integral_number
     * @return $this
     */
    public function setIntegralNumber($integral_number)
    {
        $this->container['integral_number'] = $integral_number;

        return $this;
    }

    /**
     * Gets floating_point_number
     * @return bool
     */
    public function getFloatingPointNumber()
    {
        return $this->container['floating_point_number'];
    }

    /**
     * Sets floating_point_number
     * @param bool $floating_point_number
     * @return $this
     */
    public function setFloatingPointNumber($floating_point_number)
    {
        $this->container['floating_point_number'] = $floating_point_number;

        return $this;
    }

    /**
     * Gets short
     * @return bool
     */
    public function getShort()
    {
        return $this->container['short'];
    }

    /**
     * Sets short
     * @param bool $short
     * @return $this
     */
    public function setShort($short)
    {
        $this->container['short'] = $short;

        return $this;
    }

    /**
     * Gets int
     * @return bool
     */
    public function getInt()
    {
        return $this->container['int'];
    }

    /**
     * Sets int
     * @param bool $int
     * @return $this
     */
    public function setInt($int)
    {
        $this->container['int'] = $int;

        return $this;
    }

    /**
     * Gets long
     * @return bool
     */
    public function getLong()
    {
        return $this->container['long'];
    }

    /**
     * Sets long
     * @param bool $long
     * @return $this
     */
    public function setLong($long)
    {
        $this->container['long'] = $long;

        return $this;
    }

    /**
     * Gets double
     * @return bool
     */
    public function getDouble()
    {
        return $this->container['double'];
    }

    /**
     * Sets double
     * @param bool $double
     * @return $this
     */
    public function setDouble($double)
    {
        $this->container['double'] = $double;

        return $this;
    }

    /**
     * Gets big_decimal
     * @return bool
     */
    public function getBigDecimal()
    {
        return $this->container['big_decimal'];
    }

    /**
     * Sets big_decimal
     * @param bool $big_decimal
     * @return $this
     */
    public function setBigDecimal($big_decimal)
    {
        $this->container['big_decimal'] = $big_decimal;

        return $this;
    }

    /**
     * Gets big_integer
     * @return bool
     */
    public function getBigInteger()
    {
        return $this->container['big_integer'];
    }

    /**
     * Sets big_integer
     * @param bool $big_integer
     * @return $this
     */
    public function setBigInteger($big_integer)
    {
        $this->container['big_integer'] = $big_integer;

        return $this;
    }

    /**
     * Gets textual
     * @return bool
     */
    public function getTextual()
    {
        return $this->container['textual'];
    }

    /**
     * Sets textual
     * @param bool $textual
     * @return $this
     */
    public function setTextual($textual)
    {
        $this->container['textual'] = $textual;

        return $this;
    }

    /**
     * Gets binary
     * @return bool
     */
    public function getBinary()
    {
        return $this->container['binary'];
    }

    /**
     * Sets binary
     * @param bool $binary
     * @return $this
     */
    public function setBinary($binary)
    {
        $this->container['binary'] = $binary;

        return $this;
    }

    /**
     * Gets pojo
     * @return bool
     */
    public function getPojo()
    {
        return $this->container['pojo'];
    }

    /**
     * Sets pojo
     * @param bool $pojo
     * @return $this
     */
    public function setPojo($pojo)
    {
        $this->container['pojo'] = $pojo;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


