<?php
/**
 * Keyword
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Keyword Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Keyword implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Keyword';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'phrase' => 'string',
        'confidence' => 'int',
        'agent_score_modifier' => 'int',
        'customer_score_modifier' => 'int',
        'alternate_spellings' => 'string[]',
        'pronunciations' => 'string[]',
        'anti_words' => 'string[]',
        'anti_pronunciations' => 'string[]',
        'spotability_index' => 'double',
        'margin_of_error' => 'double',
        'pronunciation' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'phrase' => 'phrase',
        'confidence' => 'confidence',
        'agent_score_modifier' => 'agentScoreModifier',
        'customer_score_modifier' => 'customerScoreModifier',
        'alternate_spellings' => 'alternateSpellings',
        'pronunciations' => 'pronunciations',
        'anti_words' => 'antiWords',
        'anti_pronunciations' => 'antiPronunciations',
        'spotability_index' => 'spotabilityIndex',
        'margin_of_error' => 'marginOfError',
        'pronunciation' => 'pronunciation'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'phrase' => 'setPhrase',
        'confidence' => 'setConfidence',
        'agent_score_modifier' => 'setAgentScoreModifier',
        'customer_score_modifier' => 'setCustomerScoreModifier',
        'alternate_spellings' => 'setAlternateSpellings',
        'pronunciations' => 'setPronunciations',
        'anti_words' => 'setAntiWords',
        'anti_pronunciations' => 'setAntiPronunciations',
        'spotability_index' => 'setSpotabilityIndex',
        'margin_of_error' => 'setMarginOfError',
        'pronunciation' => 'setPronunciation'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'phrase' => 'getPhrase',
        'confidence' => 'getConfidence',
        'agent_score_modifier' => 'getAgentScoreModifier',
        'customer_score_modifier' => 'getCustomerScoreModifier',
        'alternate_spellings' => 'getAlternateSpellings',
        'pronunciations' => 'getPronunciations',
        'anti_words' => 'getAntiWords',
        'anti_pronunciations' => 'getAntiPronunciations',
        'spotability_index' => 'getSpotabilityIndex',
        'margin_of_error' => 'getMarginOfError',
        'pronunciation' => 'getPronunciation'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['phrase'] = isset($data['phrase']) ? $data['phrase'] : null;
        $this->container['confidence'] = isset($data['confidence']) ? $data['confidence'] : null;
        $this->container['agent_score_modifier'] = isset($data['agent_score_modifier']) ? $data['agent_score_modifier'] : null;
        $this->container['customer_score_modifier'] = isset($data['customer_score_modifier']) ? $data['customer_score_modifier'] : null;
        $this->container['alternate_spellings'] = isset($data['alternate_spellings']) ? $data['alternate_spellings'] : null;
        $this->container['pronunciations'] = isset($data['pronunciations']) ? $data['pronunciations'] : null;
        $this->container['anti_words'] = isset($data['anti_words']) ? $data['anti_words'] : null;
        $this->container['anti_pronunciations'] = isset($data['anti_pronunciations']) ? $data['anti_pronunciations'] : null;
        $this->container['spotability_index'] = isset($data['spotability_index']) ? $data['spotability_index'] : null;
        $this->container['margin_of_error'] = isset($data['margin_of_error']) ? $data['margin_of_error'] : null;
        $this->container['pronunciation'] = isset($data['pronunciation']) ? $data['pronunciation'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['phrase'] === null) {
            $invalid_properties[] = "'phrase' can't be null";
        }
        if ($this->container['confidence'] === null) {
            $invalid_properties[] = "'confidence' can't be null";
        }
        if ($this->container['agent_score_modifier'] === null) {
            $invalid_properties[] = "'agent_score_modifier' can't be null";
        }
        if ($this->container['customer_score_modifier'] === null) {
            $invalid_properties[] = "'customer_score_modifier' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['phrase'] === null) {
            return false;
        }
        if ($this->container['confidence'] === null) {
            return false;
        }
        if ($this->container['agent_score_modifier'] === null) {
            return false;
        }
        if ($this->container['customer_score_modifier'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets phrase
     * @return string
     */
    public function getPhrase()
    {
        return $this->container['phrase'];
    }

    /**
     * Sets phrase
     * @param string $phrase The word or phrase which is being looked for with speech recognition.
     * @return $this
     */
    public function setPhrase($phrase)
    {
        $this->container['phrase'] = $phrase;

        return $this;
    }

    /**
     * Gets confidence
     * @return int
     */
    public function getConfidence()
    {
        return $this->container['confidence'];
    }

    /**
     * Sets confidence
     * @param int $confidence A sensitivity threshold that can be increased to lower false positives or decreased to reduce false negatives.
     * @return $this
     */
    public function setConfidence($confidence)
    {
        $this->container['confidence'] = $confidence;

        return $this;
    }

    /**
     * Gets agent_score_modifier
     * @return int
     */
    public function getAgentScoreModifier()
    {
        return $this->container['agent_score_modifier'];
    }

    /**
     * Sets agent_score_modifier
     * @param int $agent_score_modifier A modifier to the evaluation score when the phrase is spotted in the agent channel
     * @return $this
     */
    public function setAgentScoreModifier($agent_score_modifier)
    {
        $this->container['agent_score_modifier'] = $agent_score_modifier;

        return $this;
    }

    /**
     * Gets customer_score_modifier
     * @return int
     */
    public function getCustomerScoreModifier()
    {
        return $this->container['customer_score_modifier'];
    }

    /**
     * Sets customer_score_modifier
     * @param int $customer_score_modifier A modifier to the evaluation score when the phrase is spotted in the customer channel
     * @return $this
     */
    public function setCustomerScoreModifier($customer_score_modifier)
    {
        $this->container['customer_score_modifier'] = $customer_score_modifier;

        return $this;
    }

    /**
     * Gets alternate_spellings
     * @return string[]
     */
    public function getAlternateSpellings()
    {
        return $this->container['alternate_spellings'];
    }

    /**
     * Sets alternate_spellings
     * @param string[] $alternate_spellings Other spellings of the phrase that can be added to reduce missed spots (false negatives).
     * @return $this
     */
    public function setAlternateSpellings($alternate_spellings)
    {
        $this->container['alternate_spellings'] = $alternate_spellings;

        return $this;
    }

    /**
     * Gets pronunciations
     * @return string[]
     */
    public function getPronunciations()
    {
        return $this->container['pronunciations'];
    }

    /**
     * Sets pronunciations
     * @param string[] $pronunciations The phonetic spellings for the phrase and alternate spellings.
     * @return $this
     */
    public function setPronunciations($pronunciations)
    {
        $this->container['pronunciations'] = $pronunciations;

        return $this;
    }

    /**
     * Gets anti_words
     * @return string[]
     */
    public function getAntiWords()
    {
        return $this->container['anti_words'];
    }

    /**
     * Sets anti_words
     * @param string[] $anti_words Words that are similar to the phrase but not desired. Added to reduce incorrect spots (false positives).
     * @return $this
     */
    public function setAntiWords($anti_words)
    {
        $this->container['anti_words'] = $anti_words;

        return $this;
    }

    /**
     * Gets anti_pronunciations
     * @return string[]
     */
    public function getAntiPronunciations()
    {
        return $this->container['anti_pronunciations'];
    }

    /**
     * Sets anti_pronunciations
     * @param string[] $anti_pronunciations The phonetic spellings for the antiWords.
     * @return $this
     */
    public function setAntiPronunciations($anti_pronunciations)
    {
        $this->container['anti_pronunciations'] = $anti_pronunciations;

        return $this;
    }

    /**
     * Gets spotability_index
     * @return double
     */
    public function getSpotabilityIndex()
    {
        return $this->container['spotability_index'];
    }

    /**
     * Sets spotability_index
     * @param double $spotability_index A prediction of how easy it is to unambiguously spot the keyword within its language based on spelling.
     * @return $this
     */
    public function setSpotabilityIndex($spotability_index)
    {
        $this->container['spotability_index'] = $spotability_index;

        return $this;
    }

    /**
     * Gets margin_of_error
     * @return double
     */
    public function getMarginOfError()
    {
        return $this->container['margin_of_error'];
    }

    /**
     * Sets margin_of_error
     * @param double $margin_of_error
     * @return $this
     */
    public function setMarginOfError($margin_of_error)
    {
        $this->container['margin_of_error'] = $margin_of_error;

        return $this;
    }

    /**
     * Gets pronunciation
     * @return string
     */
    public function getPronunciation()
    {
        return $this->container['pronunciation'];
    }

    /**
     * Sets pronunciation
     * @param string $pronunciation
     * @return $this
     */
    public function setPronunciation($pronunciation)
    {
        $this->container['pronunciation'] = $pronunciation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


