<?php
/**
 * LocationSearchRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * LocationSearchRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class LocationSearchRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'LocationSearchRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'sort_order' => 'string',
        'sort_by' => 'string',
        'page_size' => 'int',
        'page_number' => 'int',
        'return_fields' => 'string[]',
        'expand' => 'string[]',
        'query' => '\PureCloudSDK\LocationSearchCriteria[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'sort_order' => 'sortOrder',
        'sort_by' => 'sortBy',
        'page_size' => 'pageSize',
        'page_number' => 'pageNumber',
        'return_fields' => 'returnFields',
        'expand' => 'expand',
        'query' => 'query'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'sort_order' => 'setSortOrder',
        'sort_by' => 'setSortBy',
        'page_size' => 'setPageSize',
        'page_number' => 'setPageNumber',
        'return_fields' => 'setReturnFields',
        'expand' => 'setExpand',
        'query' => 'setQuery'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'sort_order' => 'getSortOrder',
        'sort_by' => 'getSortBy',
        'page_size' => 'getPageSize',
        'page_number' => 'getPageNumber',
        'return_fields' => 'getReturnFields',
        'expand' => 'getExpand',
        'query' => 'getQuery'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const SORT_ORDER_ASC = 'ASC';
    const SORT_ORDER_DESC = 'DESC';
    const SORT_ORDER_SCORE = 'SCORE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSortOrderAllowableValues()
    {
        return [
            self::SORT_ORDER_ASC,
            self::SORT_ORDER_DESC,
            self::SORT_ORDER_SCORE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['sort_order'] = isset($data['sort_order']) ? $data['sort_order'] : null;
        $this->container['sort_by'] = isset($data['sort_by']) ? $data['sort_by'] : null;
        $this->container['page_size'] = isset($data['page_size']) ? $data['page_size'] : null;
        $this->container['page_number'] = isset($data['page_number']) ? $data['page_number'] : null;
        $this->container['return_fields'] = isset($data['return_fields']) ? $data['return_fields'] : null;
        $this->container['expand'] = isset($data['expand']) ? $data['expand'] : null;
        $this->container['query'] = isset($data['query']) ? $data['query'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ASC", "DESC", "SCORE");
        if (!in_array($this->container['sort_order'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'sort_order', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ASC", "DESC", "SCORE");
        if (!in_array($this->container['sort_order'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets sort_order
     * @return string
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     * @param string $sort_order The sort order for results
     * @return $this
     */
    public function setSortOrder($sort_order)
    {
        $allowed_values = array('ASC', 'DESC', 'SCORE');
        if (!in_array($sort_order, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'sort_order', must be one of 'ASC', 'DESC', 'SCORE'");
        }
        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets sort_by
     * @return string
     */
    public function getSortBy()
    {
        return $this->container['sort_by'];
    }

    /**
     * Sets sort_by
     * @param string $sort_by The field in the resource that you want to sort the results by
     * @return $this
     */
    public function setSortBy($sort_by)
    {
        $this->container['sort_by'] = $sort_by;

        return $this;
    }

    /**
     * Gets page_size
     * @return int
     */
    public function getPageSize()
    {
        return $this->container['page_size'];
    }

    /**
     * Sets page_size
     * @param int $page_size The number of results per page
     * @return $this
     */
    public function setPageSize($page_size)
    {
        $this->container['page_size'] = $page_size;

        return $this;
    }

    /**
     * Gets page_number
     * @return int
     */
    public function getPageNumber()
    {
        return $this->container['page_number'];
    }

    /**
     * Sets page_number
     * @param int $page_number The page of resources you want to retrieve
     * @return $this
     */
    public function setPageNumber($page_number)
    {
        $this->container['page_number'] = $page_number;

        return $this;
    }

    /**
     * Gets return_fields
     * @return string[]
     */
    public function getReturnFields()
    {
        return $this->container['return_fields'];
    }

    /**
     * Sets return_fields
     * @param string[] $return_fields A List of strings containing the resource field paths that you want to return
     * @return $this
     */
    public function setReturnFields($return_fields)
    {
        $this->container['return_fields'] = $return_fields;

        return $this;
    }

    /**
     * Gets expand
     * @return string[]
     */
    public function getExpand()
    {
        return $this->container['expand'];
    }

    /**
     * Sets expand
     * @param string[] $expand Provides more details about a specified resource
     * @return $this
     */
    public function setExpand($expand)
    {
        $this->container['expand'] = $expand;

        return $this;
    }

    /**
     * Gets query
     * @return \PureCloudSDK\LocationSearchCriteria[]
     */
    public function getQuery()
    {
        return $this->container['query'];
    }

    /**
     * Sets query
     * @param \PureCloudSDK\LocationSearchCriteria[] $query
     * @return $this
     */
    public function setQuery($query)
    {
        $this->container['query'] = $query;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


