<?php
/**
 * MeteredEvaluationAssignment
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * MeteredEvaluationAssignment Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class MeteredEvaluationAssignment implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'MeteredEvaluationAssignment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'evaluation_context_id' => 'string',
        'evaluators' => '\PureCloudSDK\User[]',
        'max_number_evaluations' => 'int',
        'evaluation_form' => '\PureCloudSDK\EvaluationForm',
        'assign_to_active_user' => 'bool',
        'time_interval' => '\PureCloudSDK\TimeInterval'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'evaluation_context_id' => 'evaluationContextId',
        'evaluators' => 'evaluators',
        'max_number_evaluations' => 'maxNumberEvaluations',
        'evaluation_form' => 'evaluationForm',
        'assign_to_active_user' => 'assignToActiveUser',
        'time_interval' => 'timeInterval'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'evaluation_context_id' => 'setEvaluationContextId',
        'evaluators' => 'setEvaluators',
        'max_number_evaluations' => 'setMaxNumberEvaluations',
        'evaluation_form' => 'setEvaluationForm',
        'assign_to_active_user' => 'setAssignToActiveUser',
        'time_interval' => 'setTimeInterval'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'evaluation_context_id' => 'getEvaluationContextId',
        'evaluators' => 'getEvaluators',
        'max_number_evaluations' => 'getMaxNumberEvaluations',
        'evaluation_form' => 'getEvaluationForm',
        'assign_to_active_user' => 'getAssignToActiveUser',
        'time_interval' => 'getTimeInterval'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['evaluation_context_id'] = isset($data['evaluation_context_id']) ? $data['evaluation_context_id'] : null;
        $this->container['evaluators'] = isset($data['evaluators']) ? $data['evaluators'] : null;
        $this->container['max_number_evaluations'] = isset($data['max_number_evaluations']) ? $data['max_number_evaluations'] : null;
        $this->container['evaluation_form'] = isset($data['evaluation_form']) ? $data['evaluation_form'] : null;
        $this->container['assign_to_active_user'] = isset($data['assign_to_active_user']) ? $data['assign_to_active_user'] : false;
        $this->container['time_interval'] = isset($data['time_interval']) ? $data['time_interval'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets evaluation_context_id
     * @return string
     */
    public function getEvaluationContextId()
    {
        return $this->container['evaluation_context_id'];
    }

    /**
     * Sets evaluation_context_id
     * @param string $evaluation_context_id
     * @return $this
     */
    public function setEvaluationContextId($evaluation_context_id)
    {
        $this->container['evaluation_context_id'] = $evaluation_context_id;

        return $this;
    }

    /**
     * Gets evaluators
     * @return \PureCloudSDK\User[]
     */
    public function getEvaluators()
    {
        return $this->container['evaluators'];
    }

    /**
     * Sets evaluators
     * @param \PureCloudSDK\User[] $evaluators
     * @return $this
     */
    public function setEvaluators($evaluators)
    {
        $this->container['evaluators'] = $evaluators;

        return $this;
    }

    /**
     * Gets max_number_evaluations
     * @return int
     */
    public function getMaxNumberEvaluations()
    {
        return $this->container['max_number_evaluations'];
    }

    /**
     * Sets max_number_evaluations
     * @param int $max_number_evaluations
     * @return $this
     */
    public function setMaxNumberEvaluations($max_number_evaluations)
    {
        $this->container['max_number_evaluations'] = $max_number_evaluations;

        return $this;
    }

    /**
     * Gets evaluation_form
     * @return \PureCloudSDK\EvaluationForm
     */
    public function getEvaluationForm()
    {
        return $this->container['evaluation_form'];
    }

    /**
     * Sets evaluation_form
     * @param \PureCloudSDK\EvaluationForm $evaluation_form
     * @return $this
     */
    public function setEvaluationForm($evaluation_form)
    {
        $this->container['evaluation_form'] = $evaluation_form;

        return $this;
    }

    /**
     * Gets assign_to_active_user
     * @return bool
     */
    public function getAssignToActiveUser()
    {
        return $this->container['assign_to_active_user'];
    }

    /**
     * Sets assign_to_active_user
     * @param bool $assign_to_active_user
     * @return $this
     */
    public function setAssignToActiveUser($assign_to_active_user)
    {
        $this->container['assign_to_active_user'] = $assign_to_active_user;

        return $this;
    }

    /**
     * Gets time_interval
     * @return \PureCloudSDK\TimeInterval
     */
    public function getTimeInterval()
    {
        return $this->container['time_interval'];
    }

    /**
     * Sets time_interval
     * @param \PureCloudSDK\TimeInterval $time_interval
     * @return $this
     */
    public function setTimeInterval($time_interval)
    {
        $this->container['time_interval'] = $time_interval;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


