<?php
/**
 * OAuthClient
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * OAuthClient Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OAuthClient implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'OAuthClient';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'access_token_validity_seconds' => 'int',
        'description' => 'string',
        'registered_redirect_uri' => 'string[]',
        'secret' => 'string',
        'role_ids' => 'string[]',
        'authorized_grant_type' => 'string',
        'self_uri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'access_token_validity_seconds' => 'accessTokenValiditySeconds',
        'description' => 'description',
        'registered_redirect_uri' => 'registeredRedirectUri',
        'secret' => 'secret',
        'role_ids' => 'roleIds',
        'authorized_grant_type' => 'authorizedGrantType',
        'self_uri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'access_token_validity_seconds' => 'setAccessTokenValiditySeconds',
        'description' => 'setDescription',
        'registered_redirect_uri' => 'setRegisteredRedirectUri',
        'secret' => 'setSecret',
        'role_ids' => 'setRoleIds',
        'authorized_grant_type' => 'setAuthorizedGrantType',
        'self_uri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'access_token_validity_seconds' => 'getAccessTokenValiditySeconds',
        'description' => 'getDescription',
        'registered_redirect_uri' => 'getRegisteredRedirectUri',
        'secret' => 'getSecret',
        'role_ids' => 'getRoleIds',
        'authorized_grant_type' => 'getAuthorizedGrantType',
        'self_uri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const AUTHORIZED_GRANT_TYPE_CODE = 'CODE';
    const AUTHORIZED_GRANT_TYPE_TOKEN = 'TOKEN';
    const AUTHORIZED_GRANT_TYPE_SAML2_BEARER = 'SAML2BEARER';
    const AUTHORIZED_GRANT_TYPE_PASSWORD = 'PASSWORD';
    const AUTHORIZED_GRANT_TYPE_CLIENT_CREDENTIALS = 'CLIENT_CREDENTIALS';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAuthorizedGrantTypeAllowableValues()
    {
        return [
            self::AUTHORIZED_GRANT_TYPE_CODE,
            self::AUTHORIZED_GRANT_TYPE_TOKEN,
            self::AUTHORIZED_GRANT_TYPE_SAML2_BEARER,
            self::AUTHORIZED_GRANT_TYPE_PASSWORD,
            self::AUTHORIZED_GRANT_TYPE_CLIENT_CREDENTIALS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['access_token_validity_seconds'] = isset($data['access_token_validity_seconds']) ? $data['access_token_validity_seconds'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['registered_redirect_uri'] = isset($data['registered_redirect_uri']) ? $data['registered_redirect_uri'] : null;
        $this->container['secret'] = isset($data['secret']) ? $data['secret'] : null;
        $this->container['role_ids'] = isset($data['role_ids']) ? $data['role_ids'] : null;
        $this->container['authorized_grant_type'] = isset($data['authorized_grant_type']) ? $data['authorized_grant_type'] : null;
        $this->container['self_uri'] = isset($data['self_uri']) ? $data['self_uri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['registered_redirect_uri'] === null) {
            $invalid_properties[] = "'registered_redirect_uri' can't be null";
        }
        $allowed_values = array("CODE", "TOKEN", "SAML2BEARER", "PASSWORD", "CLIENT_CREDENTIALS");
        if (!in_array($this->container['authorized_grant_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'authorized_grant_type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['registered_redirect_uri'] === null) {
            return false;
        }
        $allowed_values = array("CODE", "TOKEN", "SAML2BEARER", "PASSWORD", "CLIENT_CREDENTIALS");
        if (!in_array($this->container['authorized_grant_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the OAuth client.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets access_token_validity_seconds
     * @return int
     */
    public function getAccessTokenValiditySeconds()
    {
        return $this->container['access_token_validity_seconds'];
    }

    /**
     * Sets access_token_validity_seconds
     * @param int $access_token_validity_seconds The number of seconds, between 5mins and 48hrs, until tokens created with this client expire. If this field is omitted, a default of 24 hours will be applied.
     * @return $this
     */
    public function setAccessTokenValiditySeconds($access_token_validity_seconds)
    {
        $this->container['access_token_validity_seconds'] = $access_token_validity_seconds;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets registered_redirect_uri
     * @return string[]
     */
    public function getRegisteredRedirectUri()
    {
        return $this->container['registered_redirect_uri'];
    }

    /**
     * Sets registered_redirect_uri
     * @param string[] $registered_redirect_uri List of allowed callbacks for this client. For example: https://myap.example.com/auth/callback
     * @return $this
     */
    public function setRegisteredRedirectUri($registered_redirect_uri)
    {
        $this->container['registered_redirect_uri'] = $registered_redirect_uri;

        return $this;
    }

    /**
     * Gets secret
     * @return string
     */
    public function getSecret()
    {
        return $this->container['secret'];
    }

    /**
     * Sets secret
     * @param string $secret System created secret assigned to this client. Secrets are required for code authorization and client credential grants.
     * @return $this
     */
    public function setSecret($secret)
    {
        $this->container['secret'] = $secret;

        return $this;
    }

    /**
     * Gets role_ids
     * @return string[]
     */
    public function getRoleIds()
    {
        return $this->container['role_ids'];
    }

    /**
     * Sets role_ids
     * @param string[] $role_ids Roles assigned to this client. Roles only apply to clients using the client_credential grant
     * @return $this
     */
    public function setRoleIds($role_ids)
    {
        $this->container['role_ids'] = $role_ids;

        return $this;
    }

    /**
     * Gets authorized_grant_type
     * @return string
     */
    public function getAuthorizedGrantType()
    {
        return $this->container['authorized_grant_type'];
    }

    /**
     * Sets authorized_grant_type
     * @param string $authorized_grant_type The OAuth Grant/Client type supported by this client. Code Authorization Grant/Client type - Preferred client type where the Client ID and Secret are required to create tokens. Used where the secret can be secured. Implicit grant type - Client ID only is required to create tokens. Used in browser and mobile apps where the secret can not be secured. SAML2-Bearer extension grant type - SAML2 assertion provider for user authentication at the token endpoint. Client Credential grant type - Used to created access tokens that are tied only to the client.
     * @return $this
     */
    public function setAuthorizedGrantType($authorized_grant_type)
    {
        $allowed_values = array('CODE', 'TOKEN', 'SAML2BEARER', 'PASSWORD', 'CLIENT_CREDENTIALS');
        if (!in_array($authorized_grant_type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'authorized_grant_type', must be one of 'CODE', 'TOKEN', 'SAML2BEARER', 'PASSWORD', 'CLIENT_CREDENTIALS'");
        }
        $this->container['authorized_grant_type'] = $authorized_grant_type;

        return $this;
    }

    /**
     * Gets self_uri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['self_uri'];
    }

    /**
     * Sets self_uri
     * @param string $self_uri The URI for this object
     * @return $this
     */
    public function setSelfUri($self_uri)
    {
        $this->container['self_uri'] = $self_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


