<?php
/**
 * ObservationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ObservationQuery Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ObservationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ObservationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'filter' => '\PureCloudSDK\AnalyticsQueryFilter',
        'metrics' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'filter' => 'filter',
        'metrics' => 'metrics'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'filter' => 'setFilter',
        'metrics' => 'setMetrics'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'filter' => 'getFilter',
        'metrics' => 'getMetrics'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const METRICS_T_SEGMENT_DURATION = 'tSegmentDuration';
    const METRICS_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    const METRICS_O_TOTAL_SCORE = 'oTotalScore';
    const METRICS_N_EVALUATIONS = 'nEvaluations';
    const METRICS_T_ABANDON = 'tAbandon';
    const METRICS_T_IVR = 'tIvr';
    const METRICS_T_ANSWERED = 'tAnswered';
    const METRICS_T_ACD = 'tAcd';
    const METRICS_T_TALK = 'tTalk';
    const METRICS_T_HELD = 'tHeld';
    const METRICS_T_TALK_COMPLETE = 'tTalkComplete';
    const METRICS_T_HELD_COMPLETE = 'tHeldComplete';
    const METRICS_T_ACW = 'tAcw';
    const METRICS_T_HANDLE = 'tHandle';
    const METRICS_T_WAIT = 'tWait';
    const METRICS_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    const METRICS_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    const METRICS_T_SYSTEM_PRESENCE = 'tSystemPresence';
    const METRICS_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    const METRICS_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    const METRICS_N_OFFERED = 'nOffered';
    const METRICS_N_OVER_SLA = 'nOverSla';
    const METRICS_N_TRANSFERRED = 'nTransferred';
    const METRICS_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    const METRICS_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    const METRICS_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    const METRICS_N_ERROR = 'nError';
    const METRICS_O_SERVICE_TARGET = 'oServiceTarget';
    const METRICS_O_SERVICE_LEVEL = 'oServiceLevel';
    const METRICS_T_ACTIVE = 'tActive';
    const METRICS_T_INACTIVE = 'tInactive';
    const METRICS_O_ACTIVE_USERS = 'oActiveUsers';
    const METRICS_O_MEMBER_USERS = 'oMemberUsers';
    const METRICS_O_ACTIVE_QUEUES = 'oActiveQueues';
    const METRICS_O_MEMBER_QUEUES = 'oMemberQueues';
    const METRICS_O_INTERACTING = 'oInteracting';
    const METRICS_O_WAITING = 'oWaiting';
    const METRICS_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    const METRICS_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_T_SEGMENT_DURATION,
            self::METRICS_O_TOTAL_CRITICAL_SCORE,
            self::METRICS_O_TOTAL_SCORE,
            self::METRICS_N_EVALUATIONS,
            self::METRICS_T_ABANDON,
            self::METRICS_T_IVR,
            self::METRICS_T_ANSWERED,
            self::METRICS_T_ACD,
            self::METRICS_T_TALK,
            self::METRICS_T_HELD,
            self::METRICS_T_TALK_COMPLETE,
            self::METRICS_T_HELD_COMPLETE,
            self::METRICS_T_ACW,
            self::METRICS_T_HANDLE,
            self::METRICS_T_WAIT,
            self::METRICS_T_AGENT_ROUTING_STATUS,
            self::METRICS_T_ORGANIZATION_PRESENCE,
            self::METRICS_T_SYSTEM_PRESENCE,
            self::METRICS_T_USER_RESPONSE_TIME,
            self::METRICS_T_AGENT_RESPONSE_TIME,
            self::METRICS_N_OFFERED,
            self::METRICS_N_OVER_SLA,
            self::METRICS_N_TRANSFERRED,
            self::METRICS_N_OUTBOUND_ATTEMPTED,
            self::METRICS_N_OUTBOUND_CONNECTED,
            self::METRICS_N_OUTBOUND_ABANDONED,
            self::METRICS_N_ERROR,
            self::METRICS_O_SERVICE_TARGET,
            self::METRICS_O_SERVICE_LEVEL,
            self::METRICS_T_ACTIVE,
            self::METRICS_T_INACTIVE,
            self::METRICS_O_ACTIVE_USERS,
            self::METRICS_O_MEMBER_USERS,
            self::METRICS_O_ACTIVE_QUEUES,
            self::METRICS_O_MEMBER_QUEUES,
            self::METRICS_O_INTERACTING,
            self::METRICS_O_WAITING,
            self::METRICS_O_ON_QUEUE_USERS,
            self::METRICS_O_OFF_QUEUE_USERS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['filter'] === null) {
            $invalid_properties[] = "'filter' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['filter'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets filter
     * @return \PureCloudSDK\AnalyticsQueryFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\AnalyticsQueryFilter $filter Filter to return a subset of observations. Expresses boolean logical predicates as well as dimensional filters
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('tSegmentDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'nOffered', 'nOverSla', 'nTransferred', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'tSegmentDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'nOffered', 'nOverSla', 'nTransferred', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


