<?php
/**
 * OrgMediaUtilization
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * OrgMediaUtilization Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OrgMediaUtilization implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'OrgMediaUtilization';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'maximum_capacity' => 'int',
        'interruptable_media_types' => 'string[]',
        'include_non_acd' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'maximum_capacity' => 'maximumCapacity',
        'interruptable_media_types' => 'interruptableMediaTypes',
        'include_non_acd' => 'includeNonAcd'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'maximum_capacity' => 'setMaximumCapacity',
        'interruptable_media_types' => 'setInterruptableMediaTypes',
        'include_non_acd' => 'setIncludeNonAcd'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'maximum_capacity' => 'getMaximumCapacity',
        'interruptable_media_types' => 'getInterruptableMediaTypes',
        'include_non_acd' => 'getIncludeNonAcd'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['maximum_capacity'] = isset($data['maximum_capacity']) ? $data['maximum_capacity'] : null;
        $this->container['interruptable_media_types'] = isset($data['interruptable_media_types']) ? $data['interruptable_media_types'] : null;
        $this->container['include_non_acd'] = isset($data['include_non_acd']) ? $data['include_non_acd'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets maximum_capacity
     * @return int
     */
    public function getMaximumCapacity()
    {
        return $this->container['maximum_capacity'];
    }

    /**
     * Sets maximum_capacity
     * @param int $maximum_capacity Defines the maximum number of conversations of this type that an agent can handle at one time.
     * @return $this
     */
    public function setMaximumCapacity($maximum_capacity)
    {
        $this->container['maximum_capacity'] = $maximum_capacity;

        return $this;
    }

    /**
     * Gets interruptable_media_types
     * @return string[]
     */
    public function getInterruptableMediaTypes()
    {
        return $this->container['interruptable_media_types'];
    }

    /**
     * Sets interruptable_media_types
     * @param string[] $interruptable_media_types Defines the list of other media types that can interrupt a conversation of this media type.  Values can be: call, chat, email, or socialExpression
     * @return $this
     */
    public function setInterruptableMediaTypes($interruptable_media_types)
    {
        $this->container['interruptable_media_types'] = $interruptable_media_types;

        return $this;
    }

    /**
     * Gets include_non_acd
     * @return bool
     */
    public function getIncludeNonAcd()
    {
        return $this->container['include_non_acd'];
    }

    /**
     * Sets include_non_acd
     * @param bool $include_non_acd If true, then track non-ACD conversations against utilization
     * @return $this
     */
    public function setIncludeNonAcd($include_non_acd)
    {
        $this->container['include_non_acd'] = $include_non_acd;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


